/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of quick response search.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QuickResponseSearchResultData implements SdkPojo, Serializable,
        ToCopyableBuilder<QuickResponseSearchResultData.Builder, QuickResponseSearchResultData> {
    private static final SdkField<List<String>> ATTRIBUTES_INTERPOLATED_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("attributesInterpolated")
            .getter(getter(QuickResponseSearchResultData::attributesInterpolated))
            .setter(setter(Builder::attributesInterpolated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributesInterpolated").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ATTRIBUTES_NOT_INTERPOLATED_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("attributesNotInterpolated")
            .getter(getter(QuickResponseSearchResultData::attributesNotInterpolated))
            .setter(setter(Builder::attributesNotInterpolated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributesNotInterpolated").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CHANNELS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("channels")
            .getter(getter(QuickResponseSearchResultData::channels))
            .setter(setter(Builder::channels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentType").getter(getter(QuickResponseSearchResultData::contentType))
            .setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentType").build()).build();

    private static final SdkField<QuickResponseContents> CONTENTS_FIELD = SdkField
            .<QuickResponseContents> builder(MarshallingType.SDK_POJO).memberName("contents")
            .getter(getter(QuickResponseSearchResultData::contents)).setter(setter(Builder::contents))
            .constructor(QuickResponseContents::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contents").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdTime")
            .getter(getter(QuickResponseSearchResultData::createdTime))
            .setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(QuickResponseSearchResultData::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<GroupingConfiguration> GROUPING_CONFIGURATION_FIELD = SdkField
            .<GroupingConfiguration> builder(MarshallingType.SDK_POJO).memberName("groupingConfiguration")
            .getter(getter(QuickResponseSearchResultData::groupingConfiguration)).setter(setter(Builder::groupingConfiguration))
            .constructor(GroupingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupingConfiguration").build())
            .build();

    private static final SdkField<Boolean> IS_ACTIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isActive").getter(getter(QuickResponseSearchResultData::isActive)).setter(setter(Builder::isActive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isActive").build()).build();

    private static final SdkField<String> KNOWLEDGE_BASE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseArn").getter(getter(QuickResponseSearchResultData::knowledgeBaseArn))
            .setter(setter(Builder::knowledgeBaseArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseArn").build()).build();

    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(QuickResponseSearchResultData::knowledgeBaseId))
            .setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()).build();

    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("language").getter(getter(QuickResponseSearchResultData::language)).setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("language").build()).build();

    private static final SdkField<String> LAST_MODIFIED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastModifiedBy").getter(getter(QuickResponseSearchResultData::lastModifiedBy))
            .setter(setter(Builder::lastModifiedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedBy").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedTime")
            .getter(getter(QuickResponseSearchResultData::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(QuickResponseSearchResultData::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> QUICK_RESPONSE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("quickResponseArn").getter(getter(QuickResponseSearchResultData::quickResponseArn))
            .setter(setter(Builder::quickResponseArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quickResponseArn").build()).build();

    private static final SdkField<String> QUICK_RESPONSE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("quickResponseId").getter(getter(QuickResponseSearchResultData::quickResponseId))
            .setter(setter(Builder::quickResponseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quickResponseId").build()).build();

    private static final SdkField<String> SHORTCUT_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("shortcutKey").getter(getter(QuickResponseSearchResultData::shortcutKey))
            .setter(setter(Builder::shortcutKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shortcutKey").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(QuickResponseSearchResultData::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(QuickResponseSearchResultData::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_INTERPOLATED_FIELD,
            ATTRIBUTES_NOT_INTERPOLATED_FIELD, CHANNELS_FIELD, CONTENT_TYPE_FIELD, CONTENTS_FIELD, CREATED_TIME_FIELD,
            DESCRIPTION_FIELD, GROUPING_CONFIGURATION_FIELD, IS_ACTIVE_FIELD, KNOWLEDGE_BASE_ARN_FIELD, KNOWLEDGE_BASE_ID_FIELD,
            LANGUAGE_FIELD, LAST_MODIFIED_BY_FIELD, LAST_MODIFIED_TIME_FIELD, NAME_FIELD, QUICK_RESPONSE_ARN_FIELD,
            QUICK_RESPONSE_ID_FIELD, SHORTCUT_KEY_FIELD, STATUS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> attributesInterpolated;

    private final List<String> attributesNotInterpolated;

    private final List<String> channels;

    private final String contentType;

    private final QuickResponseContents contents;

    private final Instant createdTime;

    private final String description;

    private final GroupingConfiguration groupingConfiguration;

    private final Boolean isActive;

    private final String knowledgeBaseArn;

    private final String knowledgeBaseId;

    private final String language;

    private final String lastModifiedBy;

    private final Instant lastModifiedTime;

    private final String name;

    private final String quickResponseArn;

    private final String quickResponseId;

    private final String shortcutKey;

    private final String status;

    private final Map<String, String> tags;

    private QuickResponseSearchResultData(BuilderImpl builder) {
        this.attributesInterpolated = builder.attributesInterpolated;
        this.attributesNotInterpolated = builder.attributesNotInterpolated;
        this.channels = builder.channels;
        this.contentType = builder.contentType;
        this.contents = builder.contents;
        this.createdTime = builder.createdTime;
        this.description = builder.description;
        this.groupingConfiguration = builder.groupingConfiguration;
        this.isActive = builder.isActive;
        this.knowledgeBaseArn = builder.knowledgeBaseArn;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.language = builder.language;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.name = builder.name;
        this.quickResponseArn = builder.quickResponseArn;
        this.quickResponseId = builder.quickResponseId;
        this.shortcutKey = builder.shortcutKey;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttributesInterpolated property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAttributesInterpolated() {
        return attributesInterpolated != null && !(attributesInterpolated instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The user defined contact attributes that are resolved when the search result is returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributesInterpolated} method.
     * </p>
     * 
     * @return The user defined contact attributes that are resolved when the search result is returned.
     */
    public final List<String> attributesInterpolated() {
        return attributesInterpolated;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttributesNotInterpolated property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAttributesNotInterpolated() {
        return attributesNotInterpolated != null && !(attributesNotInterpolated instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The user defined contact attributes that are not resolved when the search result is returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributesNotInterpolated} method.
     * </p>
     * 
     * @return The user defined contact attributes that are not resolved when the search result is returned.
     */
    public final List<String> attributesNotInterpolated() {
        return attributesNotInterpolated;
    }

    /**
     * For responses, this returns true if the service returned a value for the Channels property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasChannels() {
        return channels != null && !(channels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Connect contact channels this quick response applies to. The supported contact channel types include
     * <code>Chat</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChannels} method.
     * </p>
     * 
     * @return The Amazon Connect contact channels this quick response applies to. The supported contact channel types
     *         include <code>Chat</code>.
     */
    public final List<String> channels() {
        return channels;
    }

    /**
     * <p>
     * The media type of the quick response content.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <code>application/x.quickresponse;format=plain</code> for quick response written in plain text.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>application/x.quickresponse;format=markdown</code> for quick response written in richtext.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The media type of the quick response content.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Use <code>application/x.quickresponse;format=plain</code> for quick response written in plain text.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use <code>application/x.quickresponse;format=markdown</code> for quick response written in richtext.
     *         </p>
     *         </li>
     */
    public final String contentType() {
        return contentType;
    }

    /**
     * <p>
     * The contents of the quick response.
     * </p>
     * 
     * @return The contents of the quick response.
     */
    public final QuickResponseContents contents() {
        return contents;
    }

    /**
     * <p>
     * The timestamp when the quick response was created.
     * </p>
     * 
     * @return The timestamp when the quick response was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The description of the quick response.
     * </p>
     * 
     * @return The description of the quick response.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The configuration information of the user groups that the quick response is accessible to.
     * </p>
     * 
     * @return The configuration information of the user groups that the quick response is accessible to.
     */
    public final GroupingConfiguration groupingConfiguration() {
        return groupingConfiguration;
    }

    /**
     * <p>
     * Whether the quick response is active.
     * </p>
     * 
     * @return Whether the quick response is active.
     */
    public final Boolean isActive() {
        return isActive;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the knowledge base.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the knowledge base.
     */
    public final String knowledgeBaseArn() {
        return knowledgeBaseArn;
    }

    /**
     * <p>
     * The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
     * </p>
     * 
     * @return The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * <p>
     * The language code value for the language in which the quick response is written.
     * </p>
     * 
     * @return The language code value for the language in which the quick response is written.
     */
    public final String language() {
        return language;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user who last updated the quick response search result data.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user who last updated the quick response search result data.
     */
    public final String lastModifiedBy() {
        return lastModifiedBy;
    }

    /**
     * <p>
     * The timestamp when the quick response search result data was last modified.
     * </p>
     * 
     * @return The timestamp when the quick response search result data was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The name of the quick response.
     * </p>
     * 
     * @return The name of the quick response.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the quick response.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the quick response.
     */
    public final String quickResponseArn() {
        return quickResponseArn;
    }

    /**
     * <p>
     * The identifier of the quick response.
     * </p>
     * 
     * @return The identifier of the quick response.
     */
    public final String quickResponseId() {
        return quickResponseId;
    }

    /**
     * <p>
     * The shortcut key of the quick response. The value should be unique across the knowledge base.
     * </p>
     * 
     * @return The shortcut key of the quick response. The value should be unique across the knowledge base.
     */
    public final String shortcutKey() {
        return shortcutKey;
    }

    /**
     * <p>
     * The resource status of the quick response.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QuickResponseStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The resource status of the quick response.
     * @see QuickResponseStatus
     */
    public final QuickResponseStatus status() {
        return QuickResponseStatus.fromValue(status);
    }

    /**
     * <p>
     * The resource status of the quick response.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QuickResponseStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The resource status of the quick response.
     * @see QuickResponseStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributesInterpolated() ? attributesInterpolated() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributesNotInterpolated() ? attributesNotInterpolated() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasChannels() ? channels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(contents());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(groupingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(isActive());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseArn());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(language());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(quickResponseArn());
        hashCode = 31 * hashCode + Objects.hashCode(quickResponseId());
        hashCode = 31 * hashCode + Objects.hashCode(shortcutKey());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuickResponseSearchResultData)) {
            return false;
        }
        QuickResponseSearchResultData other = (QuickResponseSearchResultData) obj;
        return hasAttributesInterpolated() == other.hasAttributesInterpolated()
                && Objects.equals(attributesInterpolated(), other.attributesInterpolated())
                && hasAttributesNotInterpolated() == other.hasAttributesNotInterpolated()
                && Objects.equals(attributesNotInterpolated(), other.attributesNotInterpolated())
                && hasChannels() == other.hasChannels() && Objects.equals(channels(), other.channels())
                && Objects.equals(contentType(), other.contentType()) && Objects.equals(contents(), other.contents())
                && Objects.equals(createdTime(), other.createdTime()) && Objects.equals(description(), other.description())
                && Objects.equals(groupingConfiguration(), other.groupingConfiguration())
                && Objects.equals(isActive(), other.isActive()) && Objects.equals(knowledgeBaseArn(), other.knowledgeBaseArn())
                && Objects.equals(knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(language(), other.language())
                && Objects.equals(lastModifiedBy(), other.lastModifiedBy())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(name(), other.name())
                && Objects.equals(quickResponseArn(), other.quickResponseArn())
                && Objects.equals(quickResponseId(), other.quickResponseId())
                && Objects.equals(shortcutKey(), other.shortcutKey()) && Objects.equals(statusAsString(), other.statusAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QuickResponseSearchResultData")
                .add("AttributesInterpolated", attributesInterpolated() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AttributesNotInterpolated", attributesNotInterpolated() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Channels", channels() == null ? null : "*** Sensitive Data Redacted ***").add("ContentType", contentType())
                .add("Contents", contents()).add("CreatedTime", createdTime()).add("Description", description())
                .add("GroupingConfiguration", groupingConfiguration()).add("IsActive", isActive())
                .add("KnowledgeBaseArn", knowledgeBaseArn()).add("KnowledgeBaseId", knowledgeBaseId())
                .add("Language", language()).add("LastModifiedBy", lastModifiedBy()).add("LastModifiedTime", lastModifiedTime())
                .add("Name", name()).add("QuickResponseArn", quickResponseArn()).add("QuickResponseId", quickResponseId())
                .add("ShortcutKey", shortcutKey()).add("Status", statusAsString()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attributesInterpolated":
            return Optional.ofNullable(clazz.cast(attributesInterpolated()));
        case "attributesNotInterpolated":
            return Optional.ofNullable(clazz.cast(attributesNotInterpolated()));
        case "channels":
            return Optional.ofNullable(clazz.cast(channels()));
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "contents":
            return Optional.ofNullable(clazz.cast(contents()));
        case "createdTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "groupingConfiguration":
            return Optional.ofNullable(clazz.cast(groupingConfiguration()));
        case "isActive":
            return Optional.ofNullable(clazz.cast(isActive()));
        case "knowledgeBaseArn":
            return Optional.ofNullable(clazz.cast(knowledgeBaseArn()));
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        case "language":
            return Optional.ofNullable(clazz.cast(language()));
        case "lastModifiedBy":
            return Optional.ofNullable(clazz.cast(lastModifiedBy()));
        case "lastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "quickResponseArn":
            return Optional.ofNullable(clazz.cast(quickResponseArn()));
        case "quickResponseId":
            return Optional.ofNullable(clazz.cast(quickResponseId()));
        case "shortcutKey":
            return Optional.ofNullable(clazz.cast(shortcutKey()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("attributesInterpolated", ATTRIBUTES_INTERPOLATED_FIELD);
        map.put("attributesNotInterpolated", ATTRIBUTES_NOT_INTERPOLATED_FIELD);
        map.put("channels", CHANNELS_FIELD);
        map.put("contentType", CONTENT_TYPE_FIELD);
        map.put("contents", CONTENTS_FIELD);
        map.put("createdTime", CREATED_TIME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("groupingConfiguration", GROUPING_CONFIGURATION_FIELD);
        map.put("isActive", IS_ACTIVE_FIELD);
        map.put("knowledgeBaseArn", KNOWLEDGE_BASE_ARN_FIELD);
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("language", LANGUAGE_FIELD);
        map.put("lastModifiedBy", LAST_MODIFIED_BY_FIELD);
        map.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("name", NAME_FIELD);
        map.put("quickResponseArn", QUICK_RESPONSE_ARN_FIELD);
        map.put("quickResponseId", QUICK_RESPONSE_ID_FIELD);
        map.put("shortcutKey", SHORTCUT_KEY_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QuickResponseSearchResultData, T> g) {
        return obj -> g.apply((QuickResponseSearchResultData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QuickResponseSearchResultData> {
        /**
         * <p>
         * The user defined contact attributes that are resolved when the search result is returned.
         * </p>
         * 
         * @param attributesInterpolated
         *        The user defined contact attributes that are resolved when the search result is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesInterpolated(Collection<String> attributesInterpolated);

        /**
         * <p>
         * The user defined contact attributes that are resolved when the search result is returned.
         * </p>
         * 
         * @param attributesInterpolated
         *        The user defined contact attributes that are resolved when the search result is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesInterpolated(String... attributesInterpolated);

        /**
         * <p>
         * The user defined contact attributes that are not resolved when the search result is returned.
         * </p>
         * 
         * @param attributesNotInterpolated
         *        The user defined contact attributes that are not resolved when the search result is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesNotInterpolated(Collection<String> attributesNotInterpolated);

        /**
         * <p>
         * The user defined contact attributes that are not resolved when the search result is returned.
         * </p>
         * 
         * @param attributesNotInterpolated
         *        The user defined contact attributes that are not resolved when the search result is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesNotInterpolated(String... attributesNotInterpolated);

        /**
         * <p>
         * The Amazon Connect contact channels this quick response applies to. The supported contact channel types
         * include <code>Chat</code>.
         * </p>
         * 
         * @param channels
         *        The Amazon Connect contact channels this quick response applies to. The supported contact channel
         *        types include <code>Chat</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channels(Collection<String> channels);

        /**
         * <p>
         * The Amazon Connect contact channels this quick response applies to. The supported contact channel types
         * include <code>Chat</code>.
         * </p>
         * 
         * @param channels
         *        The Amazon Connect contact channels this quick response applies to. The supported contact channel
         *        types include <code>Chat</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channels(String... channels);

        /**
         * <p>
         * The media type of the quick response content.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Use <code>application/x.quickresponse;format=plain</code> for quick response written in plain text.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use <code>application/x.quickresponse;format=markdown</code> for quick response written in richtext.
         * </p>
         * </li>
         * </ul>
         * 
         * @param contentType
         *        The media type of the quick response content.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Use <code>application/x.quickresponse;format=plain</code> for quick response written in plain text.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use <code>application/x.quickresponse;format=markdown</code> for quick response written in richtext.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * The contents of the quick response.
         * </p>
         * 
         * @param contents
         *        The contents of the quick response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contents(QuickResponseContents contents);

        /**
         * <p>
         * The contents of the quick response.
         * </p>
         * This is a convenience method that creates an instance of the {@link QuickResponseContents.Builder} avoiding
         * the need to create one manually via {@link QuickResponseContents#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QuickResponseContents.Builder#build()} is called immediately and
         * its result is passed to {@link #contents(QuickResponseContents)}.
         * 
         * @param contents
         *        a consumer that will call methods on {@link QuickResponseContents.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contents(QuickResponseContents)
         */
        default Builder contents(Consumer<QuickResponseContents.Builder> contents) {
            return contents(QuickResponseContents.builder().applyMutation(contents).build());
        }

        /**
         * <p>
         * The timestamp when the quick response was created.
         * </p>
         * 
         * @param createdTime
         *        The timestamp when the quick response was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The description of the quick response.
         * </p>
         * 
         * @param description
         *        The description of the quick response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The configuration information of the user groups that the quick response is accessible to.
         * </p>
         * 
         * @param groupingConfiguration
         *        The configuration information of the user groups that the quick response is accessible to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupingConfiguration(GroupingConfiguration groupingConfiguration);

        /**
         * <p>
         * The configuration information of the user groups that the quick response is accessible to.
         * </p>
         * This is a convenience method that creates an instance of the {@link GroupingConfiguration.Builder} avoiding
         * the need to create one manually via {@link GroupingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GroupingConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #groupingConfiguration(GroupingConfiguration)}.
         * 
         * @param groupingConfiguration
         *        a consumer that will call methods on {@link GroupingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupingConfiguration(GroupingConfiguration)
         */
        default Builder groupingConfiguration(Consumer<GroupingConfiguration.Builder> groupingConfiguration) {
            return groupingConfiguration(GroupingConfiguration.builder().applyMutation(groupingConfiguration).build());
        }

        /**
         * <p>
         * Whether the quick response is active.
         * </p>
         * 
         * @param isActive
         *        Whether the quick response is active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isActive(Boolean isActive);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the knowledge base.
         * </p>
         * 
         * @param knowledgeBaseArn
         *        The Amazon Resource Name (ARN) of the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseArn(String knowledgeBaseArn);

        /**
         * <p>
         * The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
         * </p>
         * 
         * @param knowledgeBaseId
         *        The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        /**
         * <p>
         * The language code value for the language in which the quick response is written.
         * </p>
         * 
         * @param language
         *        The language code value for the language in which the quick response is written.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder language(String language);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user who last updated the quick response search result data.
         * </p>
         * 
         * @param lastModifiedBy
         *        The Amazon Resource Name (ARN) of the user who last updated the quick response search result data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBy(String lastModifiedBy);

        /**
         * <p>
         * The timestamp when the quick response search result data was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The timestamp when the quick response search result data was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The name of the quick response.
         * </p>
         * 
         * @param name
         *        The name of the quick response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the quick response.
         * </p>
         * 
         * @param quickResponseArn
         *        The Amazon Resource Name (ARN) of the quick response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quickResponseArn(String quickResponseArn);

        /**
         * <p>
         * The identifier of the quick response.
         * </p>
         * 
         * @param quickResponseId
         *        The identifier of the quick response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quickResponseId(String quickResponseId);

        /**
         * <p>
         * The shortcut key of the quick response. The value should be unique across the knowledge base.
         * </p>
         * 
         * @param shortcutKey
         *        The shortcut key of the quick response. The value should be unique across the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shortcutKey(String shortcutKey);

        /**
         * <p>
         * The resource status of the quick response.
         * </p>
         * 
         * @param status
         *        The resource status of the quick response.
         * @see QuickResponseStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QuickResponseStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The resource status of the quick response.
         * </p>
         * 
         * @param status
         *        The resource status of the quick response.
         * @see QuickResponseStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QuickResponseStatus
         */
        Builder status(QuickResponseStatus status);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private List<String> attributesInterpolated = DefaultSdkAutoConstructList.getInstance();

        private List<String> attributesNotInterpolated = DefaultSdkAutoConstructList.getInstance();

        private List<String> channels = DefaultSdkAutoConstructList.getInstance();

        private String contentType;

        private QuickResponseContents contents;

        private Instant createdTime;

        private String description;

        private GroupingConfiguration groupingConfiguration;

        private Boolean isActive;

        private String knowledgeBaseArn;

        private String knowledgeBaseId;

        private String language;

        private String lastModifiedBy;

        private Instant lastModifiedTime;

        private String name;

        private String quickResponseArn;

        private String quickResponseId;

        private String shortcutKey;

        private String status;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(QuickResponseSearchResultData model) {
            attributesInterpolated(model.attributesInterpolated);
            attributesNotInterpolated(model.attributesNotInterpolated);
            channels(model.channels);
            contentType(model.contentType);
            contents(model.contents);
            createdTime(model.createdTime);
            description(model.description);
            groupingConfiguration(model.groupingConfiguration);
            isActive(model.isActive);
            knowledgeBaseArn(model.knowledgeBaseArn);
            knowledgeBaseId(model.knowledgeBaseId);
            language(model.language);
            lastModifiedBy(model.lastModifiedBy);
            lastModifiedTime(model.lastModifiedTime);
            name(model.name);
            quickResponseArn(model.quickResponseArn);
            quickResponseId(model.quickResponseId);
            shortcutKey(model.shortcutKey);
            status(model.status);
            tags(model.tags);
        }

        public final Collection<String> getAttributesInterpolated() {
            if (attributesInterpolated instanceof SdkAutoConstructList) {
                return null;
            }
            return attributesInterpolated;
        }

        public final void setAttributesInterpolated(Collection<String> attributesInterpolated) {
            this.attributesInterpolated = ContactAttributeKeysCopier.copy(attributesInterpolated);
        }

        @Override
        public final Builder attributesInterpolated(Collection<String> attributesInterpolated) {
            this.attributesInterpolated = ContactAttributeKeysCopier.copy(attributesInterpolated);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesInterpolated(String... attributesInterpolated) {
            attributesInterpolated(Arrays.asList(attributesInterpolated));
            return this;
        }

        public final Collection<String> getAttributesNotInterpolated() {
            if (attributesNotInterpolated instanceof SdkAutoConstructList) {
                return null;
            }
            return attributesNotInterpolated;
        }

        public final void setAttributesNotInterpolated(Collection<String> attributesNotInterpolated) {
            this.attributesNotInterpolated = ContactAttributeKeysCopier.copy(attributesNotInterpolated);
        }

        @Override
        public final Builder attributesNotInterpolated(Collection<String> attributesNotInterpolated) {
            this.attributesNotInterpolated = ContactAttributeKeysCopier.copy(attributesNotInterpolated);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesNotInterpolated(String... attributesNotInterpolated) {
            attributesNotInterpolated(Arrays.asList(attributesNotInterpolated));
            return this;
        }

        public final Collection<String> getChannels() {
            if (channels instanceof SdkAutoConstructList) {
                return null;
            }
            return channels;
        }

        public final void setChannels(Collection<String> channels) {
            this.channels = ChannelsCopier.copy(channels);
        }

        @Override
        public final Builder channels(Collection<String> channels) {
            this.channels = ChannelsCopier.copy(channels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channels(String... channels) {
            channels(Arrays.asList(channels));
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final QuickResponseContents.Builder getContents() {
            return contents != null ? contents.toBuilder() : null;
        }

        public final void setContents(QuickResponseContents.BuilderImpl contents) {
            this.contents = contents != null ? contents.build() : null;
        }

        @Override
        public final Builder contents(QuickResponseContents contents) {
            this.contents = contents;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final GroupingConfiguration.Builder getGroupingConfiguration() {
            return groupingConfiguration != null ? groupingConfiguration.toBuilder() : null;
        }

        public final void setGroupingConfiguration(GroupingConfiguration.BuilderImpl groupingConfiguration) {
            this.groupingConfiguration = groupingConfiguration != null ? groupingConfiguration.build() : null;
        }

        @Override
        public final Builder groupingConfiguration(GroupingConfiguration groupingConfiguration) {
            this.groupingConfiguration = groupingConfiguration;
            return this;
        }

        public final Boolean getIsActive() {
            return isActive;
        }

        public final void setIsActive(Boolean isActive) {
            this.isActive = isActive;
        }

        @Override
        public final Builder isActive(Boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        public final String getKnowledgeBaseArn() {
            return knowledgeBaseArn;
        }

        public final void setKnowledgeBaseArn(String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
        }

        @Override
        public final Builder knowledgeBaseArn(String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getLanguage() {
            return language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final String getLastModifiedBy() {
            return lastModifiedBy;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getQuickResponseArn() {
            return quickResponseArn;
        }

        public final void setQuickResponseArn(String quickResponseArn) {
            this.quickResponseArn = quickResponseArn;
        }

        @Override
        public final Builder quickResponseArn(String quickResponseArn) {
            this.quickResponseArn = quickResponseArn;
            return this;
        }

        public final String getQuickResponseId() {
            return quickResponseId;
        }

        public final void setQuickResponseId(String quickResponseId) {
            this.quickResponseId = quickResponseId;
        }

        @Override
        public final Builder quickResponseId(String quickResponseId) {
            this.quickResponseId = quickResponseId;
            return this;
        }

        public final String getShortcutKey() {
            return shortcutKey;
        }

        public final void setShortcutKey(String shortcutKey) {
            this.shortcutKey = shortcutKey;
        }

        @Override
        public final Builder shortcutKey(String shortcutKey) {
            this.shortcutKey = shortcutKey;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(QuickResponseStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public QuickResponseSearchResultData build() {
            return new QuickResponseSearchResultData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
