/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The system attributes that are used with the message template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SystemAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<SystemAttributes.Builder, SystemAttributes> {
    private static final SdkField<SystemEndpointAttributes> CUSTOMER_ENDPOINT_FIELD = SdkField
            .<SystemEndpointAttributes> builder(MarshallingType.SDK_POJO).memberName("customerEndpoint")
            .getter(getter(SystemAttributes::customerEndpoint)).setter(setter(Builder::customerEndpoint))
            .constructor(SystemEndpointAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerEndpoint").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(SystemAttributes::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<SystemEndpointAttributes> SYSTEM_ENDPOINT_FIELD = SdkField
            .<SystemEndpointAttributes> builder(MarshallingType.SDK_POJO).memberName("systemEndpoint")
            .getter(getter(SystemAttributes::systemEndpoint)).setter(setter(Builder::systemEndpoint))
            .constructor(SystemEndpointAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemEndpoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_ENDPOINT_FIELD,
            NAME_FIELD, SYSTEM_ENDPOINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SystemEndpointAttributes customerEndpoint;

    private final String name;

    private final SystemEndpointAttributes systemEndpoint;

    private SystemAttributes(BuilderImpl builder) {
        this.customerEndpoint = builder.customerEndpoint;
        this.name = builder.name;
        this.systemEndpoint = builder.systemEndpoint;
    }

    /**
     * <p>
     * The CustomerEndpoint attribute.
     * </p>
     * 
     * @return The CustomerEndpoint attribute.
     */
    public final SystemEndpointAttributes customerEndpoint() {
        return customerEndpoint;
    }

    /**
     * <p>
     * The name of the task.
     * </p>
     * 
     * @return The name of the task.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The SystemEndpoint attribute.
     * </p>
     * 
     * @return The SystemEndpoint attribute.
     */
    public final SystemEndpointAttributes systemEndpoint() {
        return systemEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customerEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(systemEndpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SystemAttributes)) {
            return false;
        }
        SystemAttributes other = (SystemAttributes) obj;
        return Objects.equals(customerEndpoint(), other.customerEndpoint()) && Objects.equals(name(), other.name())
                && Objects.equals(systemEndpoint(), other.systemEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SystemAttributes").add("CustomerEndpoint", customerEndpoint())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("SystemEndpoint", systemEndpoint())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "customerEndpoint":
            return Optional.ofNullable(clazz.cast(customerEndpoint()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "systemEndpoint":
            return Optional.ofNullable(clazz.cast(systemEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("customerEndpoint", CUSTOMER_ENDPOINT_FIELD);
        map.put("name", NAME_FIELD);
        map.put("systemEndpoint", SYSTEM_ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SystemAttributes, T> g) {
        return obj -> g.apply((SystemAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SystemAttributes> {
        /**
         * <p>
         * The CustomerEndpoint attribute.
         * </p>
         * 
         * @param customerEndpoint
         *        The CustomerEndpoint attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerEndpoint(SystemEndpointAttributes customerEndpoint);

        /**
         * <p>
         * The CustomerEndpoint attribute.
         * </p>
         * This is a convenience method that creates an instance of the {@link SystemEndpointAttributes.Builder}
         * avoiding the need to create one manually via {@link SystemEndpointAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SystemEndpointAttributes.Builder#build()} is called immediately
         * and its result is passed to {@link #customerEndpoint(SystemEndpointAttributes)}.
         * 
         * @param customerEndpoint
         *        a consumer that will call methods on {@link SystemEndpointAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customerEndpoint(SystemEndpointAttributes)
         */
        default Builder customerEndpoint(Consumer<SystemEndpointAttributes.Builder> customerEndpoint) {
            return customerEndpoint(SystemEndpointAttributes.builder().applyMutation(customerEndpoint).build());
        }

        /**
         * <p>
         * The name of the task.
         * </p>
         * 
         * @param name
         *        The name of the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The SystemEndpoint attribute.
         * </p>
         * 
         * @param systemEndpoint
         *        The SystemEndpoint attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemEndpoint(SystemEndpointAttributes systemEndpoint);

        /**
         * <p>
         * The SystemEndpoint attribute.
         * </p>
         * This is a convenience method that creates an instance of the {@link SystemEndpointAttributes.Builder}
         * avoiding the need to create one manually via {@link SystemEndpointAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SystemEndpointAttributes.Builder#build()} is called immediately
         * and its result is passed to {@link #systemEndpoint(SystemEndpointAttributes)}.
         * 
         * @param systemEndpoint
         *        a consumer that will call methods on {@link SystemEndpointAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #systemEndpoint(SystemEndpointAttributes)
         */
        default Builder systemEndpoint(Consumer<SystemEndpointAttributes.Builder> systemEndpoint) {
            return systemEndpoint(SystemEndpointAttributes.builder().applyMutation(systemEndpoint).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SystemEndpointAttributes customerEndpoint;

        private String name;

        private SystemEndpointAttributes systemEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(SystemAttributes model) {
            customerEndpoint(model.customerEndpoint);
            name(model.name);
            systemEndpoint(model.systemEndpoint);
        }

        public final SystemEndpointAttributes.Builder getCustomerEndpoint() {
            return customerEndpoint != null ? customerEndpoint.toBuilder() : null;
        }

        public final void setCustomerEndpoint(SystemEndpointAttributes.BuilderImpl customerEndpoint) {
            this.customerEndpoint = customerEndpoint != null ? customerEndpoint.build() : null;
        }

        @Override
        public final Builder customerEndpoint(SystemEndpointAttributes customerEndpoint) {
            this.customerEndpoint = customerEndpoint;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final SystemEndpointAttributes.Builder getSystemEndpoint() {
            return systemEndpoint != null ? systemEndpoint.toBuilder() : null;
        }

        public final void setSystemEndpoint(SystemEndpointAttributes.BuilderImpl systemEndpoint) {
            this.systemEndpoint = systemEndpoint != null ? systemEndpoint.build() : null;
        }

        @Override
        public final Builder systemEndpoint(SystemEndpointAttributes systemEndpoint) {
            this.systemEndpoint = systemEndpoint;
            return this;
        }

        @Override
        public SystemAttributes build() {
            return new SystemAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
