/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of the URL/URLs for the web content that you want to crawl. You should be authorized to crawl the
 * URLs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UrlConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<UrlConfiguration.Builder, UrlConfiguration> {
    private static final SdkField<List<SeedUrl>> SEED_URLS_FIELD = SdkField
            .<List<SeedUrl>> builder(MarshallingType.LIST)
            .memberName("seedUrls")
            .getter(getter(UrlConfiguration::seedUrls))
            .setter(setter(Builder::seedUrls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("seedUrls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SeedUrl> builder(MarshallingType.SDK_POJO)
                                            .constructor(SeedUrl::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEED_URLS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<SeedUrl> seedUrls;

    private UrlConfiguration(BuilderImpl builder) {
        this.seedUrls = builder.seedUrls;
    }

    /**
     * For responses, this returns true if the service returned a value for the SeedUrls property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSeedUrls() {
        return seedUrls != null && !(seedUrls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of URLs for crawling.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSeedUrls} method.
     * </p>
     * 
     * @return List of URLs for crawling.
     */
    public final List<SeedUrl> seedUrls() {
        return seedUrls;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSeedUrls() ? seedUrls() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UrlConfiguration)) {
            return false;
        }
        UrlConfiguration other = (UrlConfiguration) obj;
        return hasSeedUrls() == other.hasSeedUrls() && Objects.equals(seedUrls(), other.seedUrls());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UrlConfiguration").add("SeedUrls", hasSeedUrls() ? seedUrls() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "seedUrls":
            return Optional.ofNullable(clazz.cast(seedUrls()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("seedUrls", SEED_URLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UrlConfiguration, T> g) {
        return obj -> g.apply((UrlConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UrlConfiguration> {
        /**
         * <p>
         * List of URLs for crawling.
         * </p>
         * 
         * @param seedUrls
         *        List of URLs for crawling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder seedUrls(Collection<SeedUrl> seedUrls);

        /**
         * <p>
         * List of URLs for crawling.
         * </p>
         * 
         * @param seedUrls
         *        List of URLs for crawling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder seedUrls(SeedUrl... seedUrls);

        /**
         * <p>
         * List of URLs for crawling.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.SeedUrl.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.qconnect.model.SeedUrl#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.SeedUrl.Builder#build()} is called immediately and its
         * result is passed to {@link #seedUrls(List<SeedUrl>)}.
         * 
         * @param seedUrls
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.SeedUrl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #seedUrls(java.util.Collection<SeedUrl>)
         */
        Builder seedUrls(Consumer<SeedUrl.Builder>... seedUrls);
    }

    static final class BuilderImpl implements Builder {
        private List<SeedUrl> seedUrls = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UrlConfiguration model) {
            seedUrls(model.seedUrls);
        }

        public final List<SeedUrl.Builder> getSeedUrls() {
            List<SeedUrl.Builder> result = SeedUrlsCopier.copyToBuilder(this.seedUrls);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSeedUrls(Collection<SeedUrl.BuilderImpl> seedUrls) {
            this.seedUrls = SeedUrlsCopier.copyFromBuilder(seedUrls);
        }

        @Override
        public final Builder seedUrls(Collection<SeedUrl> seedUrls) {
            this.seedUrls = SeedUrlsCopier.copy(seedUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder seedUrls(SeedUrl... seedUrls) {
            seedUrls(Arrays.asList(seedUrls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder seedUrls(Consumer<SeedUrl.Builder>... seedUrls) {
            seedUrls(Stream.of(seedUrls).map(c -> SeedUrl.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public UrlConfiguration build() {
            return new UrlConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
