/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qconnect.model.NotifyRecommendationsReceivedError;
import software.amazon.awssdk.services.qconnect.model.NotifyRecommendationsReceivedErrorListCopier;
import software.amazon.awssdk.services.qconnect.model.QConnectResponse;
import software.amazon.awssdk.services.qconnect.model.RecommendationIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NotifyRecommendationsReceivedResponse
extends QConnectResponse
implements ToCopyableBuilder<Builder, NotifyRecommendationsReceivedResponse> {
    private static final SdkField<List<NotifyRecommendationsReceivedError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(NotifyRecommendationsReceivedResponse.getter(NotifyRecommendationsReceivedResponse::errors)).setter(NotifyRecommendationsReceivedResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NotifyRecommendationsReceivedError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RECOMMENDATION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("recommendationIds").getter(NotifyRecommendationsReceivedResponse.getter(NotifyRecommendationsReceivedResponse::recommendationIds)).setter(NotifyRecommendationsReceivedResponse.setter(Builder::recommendationIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERRORS_FIELD, RECOMMENDATION_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NotifyRecommendationsReceivedResponse.memberNameToFieldInitializer();
    private final List<NotifyRecommendationsReceivedError> errors;
    private final List<String> recommendationIds;

    private NotifyRecommendationsReceivedResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
        this.recommendationIds = builder.recommendationIds;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<NotifyRecommendationsReceivedError> errors() {
        return this.errors;
    }

    public final boolean hasRecommendationIds() {
        return this.recommendationIds != null && !(this.recommendationIds instanceof SdkAutoConstructList);
    }

    public final List<String> recommendationIds() {
        return this.recommendationIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecommendationIds() ? this.recommendationIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotifyRecommendationsReceivedResponse)) {
            return false;
        }
        NotifyRecommendationsReceivedResponse other = (NotifyRecommendationsReceivedResponse)((Object)obj);
        return this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors()) && this.hasRecommendationIds() == other.hasRecommendationIds() && Objects.equals(this.recommendationIds(), other.recommendationIds());
    }

    public final String toString() {
        return ToString.builder((String)"NotifyRecommendationsReceivedResponse").add("Errors", this.hasErrors() ? this.errors() : null).add("RecommendationIds", this.hasRecommendationIds() ? this.recommendationIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
            case "recommendationIds": {
                return Optional.ofNullable(clazz.cast(this.recommendationIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("errors", ERRORS_FIELD);
        map.put("recommendationIds", RECOMMENDATION_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NotifyRecommendationsReceivedResponse, T> g) {
        return obj -> g.apply((NotifyRecommendationsReceivedResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QConnectResponse.BuilderImpl
    implements Builder {
        private List<NotifyRecommendationsReceivedError> errors = DefaultSdkAutoConstructList.getInstance();
        private List<String> recommendationIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NotifyRecommendationsReceivedResponse model) {
            super(model);
            this.errors(model.errors);
            this.recommendationIds(model.recommendationIds);
        }

        public final List<NotifyRecommendationsReceivedError.Builder> getErrors() {
            List<NotifyRecommendationsReceivedError.Builder> result = NotifyRecommendationsReceivedErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<NotifyRecommendationsReceivedError.BuilderImpl> errors) {
            this.errors = NotifyRecommendationsReceivedErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<NotifyRecommendationsReceivedError> errors) {
            this.errors = NotifyRecommendationsReceivedErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(NotifyRecommendationsReceivedError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<NotifyRecommendationsReceivedError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (NotifyRecommendationsReceivedError)((NotifyRecommendationsReceivedError.Builder)NotifyRecommendationsReceivedError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getRecommendationIds() {
            if (this.recommendationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.recommendationIds;
        }

        public final void setRecommendationIds(Collection<String> recommendationIds) {
            this.recommendationIds = RecommendationIdListCopier.copy(recommendationIds);
        }

        @Override
        public final Builder recommendationIds(Collection<String> recommendationIds) {
            this.recommendationIds = RecommendationIdListCopier.copy(recommendationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationIds(String ... recommendationIds) {
            this.recommendationIds(Arrays.asList(recommendationIds));
            return this;
        }

        @Override
        public NotifyRecommendationsReceivedResponse build() {
            return new NotifyRecommendationsReceivedResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, NotifyRecommendationsReceivedResponse> {
        public Builder errors(Collection<NotifyRecommendationsReceivedError> var1);

        public Builder errors(NotifyRecommendationsReceivedError ... var1);

        public Builder errors(Consumer<NotifyRecommendationsReceivedError.Builder> ... var1);

        public Builder recommendationIds(Collection<String> var1);

        public Builder recommendationIds(String ... var1);
    }
}

