/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qconnect.model.MessageTemplateSearchResultData;
import software.amazon.awssdk.services.qconnect.model.MessageTemplateSearchResultsListCopier;
import software.amazon.awssdk.services.qconnect.model.QConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchMessageTemplatesResponse
extends QConnectResponse
implements ToCopyableBuilder<Builder, SearchMessageTemplatesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(SearchMessageTemplatesResponse.getter(SearchMessageTemplatesResponse::nextToken)).setter(SearchMessageTemplatesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<MessageTemplateSearchResultData>> RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("results").getter(SearchMessageTemplatesResponse.getter(SearchMessageTemplatesResponse::results)).setter(SearchMessageTemplatesResponse.setter(Builder::results)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("results").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MessageTemplateSearchResultData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchMessageTemplatesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<MessageTemplateSearchResultData> results;

    private SearchMessageTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.results = builder.results;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasResults() {
        return this.results != null && !(this.results instanceof SdkAutoConstructList);
    }

    public final List<MessageTemplateSearchResultData> results() {
        return this.results;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResults() ? this.results() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchMessageTemplatesResponse)) {
            return false;
        }
        SearchMessageTemplatesResponse other = (SearchMessageTemplatesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasResults() == other.hasResults() && Objects.equals(this.results(), other.results());
    }

    public final String toString() {
        return ToString.builder((String)"SearchMessageTemplatesResponse").add("NextToken", (Object)this.nextToken()).add("Results", this.hasResults() ? this.results() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "results": {
                return Optional.ofNullable(clazz.cast(this.results()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("results", RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchMessageTemplatesResponse, T> g) {
        return obj -> g.apply((SearchMessageTemplatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QConnectResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<MessageTemplateSearchResultData> results = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchMessageTemplatesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.results(model.results);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<MessageTemplateSearchResultData.Builder> getResults() {
            List<MessageTemplateSearchResultData.Builder> result = MessageTemplateSearchResultsListCopier.copyToBuilder(this.results);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResults(Collection<MessageTemplateSearchResultData.BuilderImpl> results) {
            this.results = MessageTemplateSearchResultsListCopier.copyFromBuilder(results);
        }

        @Override
        public final Builder results(Collection<MessageTemplateSearchResultData> results) {
            this.results = MessageTemplateSearchResultsListCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(MessageTemplateSearchResultData ... results) {
            this.results(Arrays.asList(results));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(Consumer<MessageTemplateSearchResultData.Builder> ... results) {
            this.results(Stream.of(results).map(c -> (MessageTemplateSearchResultData)((MessageTemplateSearchResultData.Builder)MessageTemplateSearchResultData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SearchMessageTemplatesResponse build() {
            return new SearchMessageTemplatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchMessageTemplatesResponse> {
        public Builder nextToken(String var1);

        public Builder results(Collection<MessageTemplateSearchResultData> var1);

        public Builder results(MessageTemplateSearchResultData ... var1);

        public Builder results(Consumer<MessageTemplateSearchResultData.Builder> ... var1);
    }
}

