/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qconnect.model.AIGuardrailContentPolicyConfig;
import software.amazon.awssdk.services.qconnect.model.AIGuardrailContextualGroundingPolicyConfig;
import software.amazon.awssdk.services.qconnect.model.AIGuardrailSensitiveInformationPolicyConfig;
import software.amazon.awssdk.services.qconnect.model.AIGuardrailTopicPolicyConfig;
import software.amazon.awssdk.services.qconnect.model.AIGuardrailWordPolicyConfig;
import software.amazon.awssdk.services.qconnect.model.QConnectRequest;
import software.amazon.awssdk.services.qconnect.model.VisibilityStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAiGuardrailRequest
extends QConnectRequest
implements ToCopyableBuilder<Builder, UpdateAiGuardrailRequest> {
    private static final SdkField<String> AI_GUARDRAIL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aiGuardrailId").getter(UpdateAiGuardrailRequest.getter(UpdateAiGuardrailRequest::aiGuardrailId)).setter(UpdateAiGuardrailRequest.setter(Builder::aiGuardrailId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("aiGuardrailId").build()}).build();
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assistantId").getter(UpdateAiGuardrailRequest.getter(UpdateAiGuardrailRequest::assistantId)).setter(UpdateAiGuardrailRequest.setter(Builder::assistantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assistantId").build()}).build();
    private static final SdkField<String> BLOCKED_INPUT_MESSAGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blockedInputMessaging").getter(UpdateAiGuardrailRequest.getter(UpdateAiGuardrailRequest::blockedInputMessaging)).setter(UpdateAiGuardrailRequest.setter(Builder::blockedInputMessaging)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedInputMessaging").build()}).build();
    private static final SdkField<String> BLOCKED_OUTPUTS_MESSAGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blockedOutputsMessaging").getter(UpdateAiGuardrailRequest.getter(UpdateAiGuardrailRequest::blockedOutputsMessaging)).setter(UpdateAiGuardrailRequest.setter(Builder::blockedOutputsMessaging)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedOutputsMessaging").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateAiGuardrailRequest.getter(UpdateAiGuardrailRequest::clientToken)).setter(UpdateAiGuardrailRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<AIGuardrailContentPolicyConfig> CONTENT_POLICY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("contentPolicyConfig").getter(UpdateAiGuardrailRequest.getter(UpdateAiGuardrailRequest::contentPolicyConfig)).setter(UpdateAiGuardrailRequest.setter(Builder::contentPolicyConfig)).constructor(AIGuardrailContentPolicyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentPolicyConfig").build()}).build();
    private static final SdkField<AIGuardrailContextualGroundingPolicyConfig> CONTEXTUAL_GROUNDING_POLICY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("contextualGroundingPolicyConfig").getter(UpdateAiGuardrailRequest.getter(UpdateAiGuardrailRequest::contextualGroundingPolicyConfig)).setter(UpdateAiGuardrailRequest.setter(Builder::contextualGroundingPolicyConfig)).constructor(AIGuardrailContextualGroundingPolicyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contextualGroundingPolicyConfig").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateAiGuardrailRequest.getter(UpdateAiGuardrailRequest::description)).setter(UpdateAiGuardrailRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<AIGuardrailSensitiveInformationPolicyConfig> SENSITIVE_INFORMATION_POLICY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sensitiveInformationPolicyConfig").getter(UpdateAiGuardrailRequest.getter(UpdateAiGuardrailRequest::sensitiveInformationPolicyConfig)).setter(UpdateAiGuardrailRequest.setter(Builder::sensitiveInformationPolicyConfig)).constructor(AIGuardrailSensitiveInformationPolicyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sensitiveInformationPolicyConfig").build()}).build();
    private static final SdkField<AIGuardrailTopicPolicyConfig> TOPIC_POLICY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("topicPolicyConfig").getter(UpdateAiGuardrailRequest.getter(UpdateAiGuardrailRequest::topicPolicyConfig)).setter(UpdateAiGuardrailRequest.setter(Builder::topicPolicyConfig)).constructor(AIGuardrailTopicPolicyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicPolicyConfig").build()}).build();
    private static final SdkField<String> VISIBILITY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("visibilityStatus").getter(UpdateAiGuardrailRequest.getter(UpdateAiGuardrailRequest::visibilityStatusAsString)).setter(UpdateAiGuardrailRequest.setter(Builder::visibilityStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("visibilityStatus").build()}).build();
    private static final SdkField<AIGuardrailWordPolicyConfig> WORD_POLICY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("wordPolicyConfig").getter(UpdateAiGuardrailRequest.getter(UpdateAiGuardrailRequest::wordPolicyConfig)).setter(UpdateAiGuardrailRequest.setter(Builder::wordPolicyConfig)).constructor(AIGuardrailWordPolicyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("wordPolicyConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AI_GUARDRAIL_ID_FIELD, ASSISTANT_ID_FIELD, BLOCKED_INPUT_MESSAGING_FIELD, BLOCKED_OUTPUTS_MESSAGING_FIELD, CLIENT_TOKEN_FIELD, CONTENT_POLICY_CONFIG_FIELD, CONTEXTUAL_GROUNDING_POLICY_CONFIG_FIELD, DESCRIPTION_FIELD, SENSITIVE_INFORMATION_POLICY_CONFIG_FIELD, TOPIC_POLICY_CONFIG_FIELD, VISIBILITY_STATUS_FIELD, WORD_POLICY_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAiGuardrailRequest.memberNameToFieldInitializer();
    private final String aiGuardrailId;
    private final String assistantId;
    private final String blockedInputMessaging;
    private final String blockedOutputsMessaging;
    private final String clientToken;
    private final AIGuardrailContentPolicyConfig contentPolicyConfig;
    private final AIGuardrailContextualGroundingPolicyConfig contextualGroundingPolicyConfig;
    private final String description;
    private final AIGuardrailSensitiveInformationPolicyConfig sensitiveInformationPolicyConfig;
    private final AIGuardrailTopicPolicyConfig topicPolicyConfig;
    private final String visibilityStatus;
    private final AIGuardrailWordPolicyConfig wordPolicyConfig;

    private UpdateAiGuardrailRequest(BuilderImpl builder) {
        super(builder);
        this.aiGuardrailId = builder.aiGuardrailId;
        this.assistantId = builder.assistantId;
        this.blockedInputMessaging = builder.blockedInputMessaging;
        this.blockedOutputsMessaging = builder.blockedOutputsMessaging;
        this.clientToken = builder.clientToken;
        this.contentPolicyConfig = builder.contentPolicyConfig;
        this.contextualGroundingPolicyConfig = builder.contextualGroundingPolicyConfig;
        this.description = builder.description;
        this.sensitiveInformationPolicyConfig = builder.sensitiveInformationPolicyConfig;
        this.topicPolicyConfig = builder.topicPolicyConfig;
        this.visibilityStatus = builder.visibilityStatus;
        this.wordPolicyConfig = builder.wordPolicyConfig;
    }

    public final String aiGuardrailId() {
        return this.aiGuardrailId;
    }

    public final String assistantId() {
        return this.assistantId;
    }

    public final String blockedInputMessaging() {
        return this.blockedInputMessaging;
    }

    public final String blockedOutputsMessaging() {
        return this.blockedOutputsMessaging;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final AIGuardrailContentPolicyConfig contentPolicyConfig() {
        return this.contentPolicyConfig;
    }

    public final AIGuardrailContextualGroundingPolicyConfig contextualGroundingPolicyConfig() {
        return this.contextualGroundingPolicyConfig;
    }

    public final String description() {
        return this.description;
    }

    public final AIGuardrailSensitiveInformationPolicyConfig sensitiveInformationPolicyConfig() {
        return this.sensitiveInformationPolicyConfig;
    }

    public final AIGuardrailTopicPolicyConfig topicPolicyConfig() {
        return this.topicPolicyConfig;
    }

    public final VisibilityStatus visibilityStatus() {
        return VisibilityStatus.fromValue(this.visibilityStatus);
    }

    public final String visibilityStatusAsString() {
        return this.visibilityStatus;
    }

    public final AIGuardrailWordPolicyConfig wordPolicyConfig() {
        return this.wordPolicyConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.aiGuardrailId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockedInputMessaging());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockedOutputsMessaging());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentPolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.contextualGroundingPolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.sensitiveInformationPolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicPolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.wordPolicyConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAiGuardrailRequest)) {
            return false;
        }
        UpdateAiGuardrailRequest other = (UpdateAiGuardrailRequest)((Object)obj);
        return Objects.equals(this.aiGuardrailId(), other.aiGuardrailId()) && Objects.equals(this.assistantId(), other.assistantId()) && Objects.equals(this.blockedInputMessaging(), other.blockedInputMessaging()) && Objects.equals(this.blockedOutputsMessaging(), other.blockedOutputsMessaging()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.contentPolicyConfig(), other.contentPolicyConfig()) && Objects.equals(this.contextualGroundingPolicyConfig(), other.contextualGroundingPolicyConfig()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.sensitiveInformationPolicyConfig(), other.sensitiveInformationPolicyConfig()) && Objects.equals(this.topicPolicyConfig(), other.topicPolicyConfig()) && Objects.equals(this.visibilityStatusAsString(), other.visibilityStatusAsString()) && Objects.equals(this.wordPolicyConfig(), other.wordPolicyConfig());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAiGuardrailRequest").add("AiGuardrailId", (Object)this.aiGuardrailId()).add("AssistantId", (Object)this.assistantId()).add("BlockedInputMessaging", (Object)(this.blockedInputMessaging() == null ? null : "*** Sensitive Data Redacted ***")).add("BlockedOutputsMessaging", (Object)(this.blockedOutputsMessaging() == null ? null : "*** Sensitive Data Redacted ***")).add("ClientToken", (Object)this.clientToken()).add("ContentPolicyConfig", (Object)this.contentPolicyConfig()).add("ContextualGroundingPolicyConfig", (Object)this.contextualGroundingPolicyConfig()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("SensitiveInformationPolicyConfig", (Object)this.sensitiveInformationPolicyConfig()).add("TopicPolicyConfig", (Object)this.topicPolicyConfig()).add("VisibilityStatus", (Object)this.visibilityStatusAsString()).add("WordPolicyConfig", (Object)this.wordPolicyConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "aiGuardrailId": {
                return Optional.ofNullable(clazz.cast(this.aiGuardrailId()));
            }
            case "assistantId": {
                return Optional.ofNullable(clazz.cast(this.assistantId()));
            }
            case "blockedInputMessaging": {
                return Optional.ofNullable(clazz.cast(this.blockedInputMessaging()));
            }
            case "blockedOutputsMessaging": {
                return Optional.ofNullable(clazz.cast(this.blockedOutputsMessaging()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "contentPolicyConfig": {
                return Optional.ofNullable(clazz.cast(this.contentPolicyConfig()));
            }
            case "contextualGroundingPolicyConfig": {
                return Optional.ofNullable(clazz.cast(this.contextualGroundingPolicyConfig()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "sensitiveInformationPolicyConfig": {
                return Optional.ofNullable(clazz.cast(this.sensitiveInformationPolicyConfig()));
            }
            case "topicPolicyConfig": {
                return Optional.ofNullable(clazz.cast(this.topicPolicyConfig()));
            }
            case "visibilityStatus": {
                return Optional.ofNullable(clazz.cast(this.visibilityStatusAsString()));
            }
            case "wordPolicyConfig": {
                return Optional.ofNullable(clazz.cast(this.wordPolicyConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("aiGuardrailId", AI_GUARDRAIL_ID_FIELD);
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("blockedInputMessaging", BLOCKED_INPUT_MESSAGING_FIELD);
        map.put("blockedOutputsMessaging", BLOCKED_OUTPUTS_MESSAGING_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("contentPolicyConfig", CONTENT_POLICY_CONFIG_FIELD);
        map.put("contextualGroundingPolicyConfig", CONTEXTUAL_GROUNDING_POLICY_CONFIG_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("sensitiveInformationPolicyConfig", SENSITIVE_INFORMATION_POLICY_CONFIG_FIELD);
        map.put("topicPolicyConfig", TOPIC_POLICY_CONFIG_FIELD);
        map.put("visibilityStatus", VISIBILITY_STATUS_FIELD);
        map.put("wordPolicyConfig", WORD_POLICY_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAiGuardrailRequest, T> g) {
        return obj -> g.apply((UpdateAiGuardrailRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QConnectRequest.BuilderImpl
    implements Builder {
        private String aiGuardrailId;
        private String assistantId;
        private String blockedInputMessaging;
        private String blockedOutputsMessaging;
        private String clientToken;
        private AIGuardrailContentPolicyConfig contentPolicyConfig;
        private AIGuardrailContextualGroundingPolicyConfig contextualGroundingPolicyConfig;
        private String description;
        private AIGuardrailSensitiveInformationPolicyConfig sensitiveInformationPolicyConfig;
        private AIGuardrailTopicPolicyConfig topicPolicyConfig;
        private String visibilityStatus;
        private AIGuardrailWordPolicyConfig wordPolicyConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAiGuardrailRequest model) {
            super(model);
            this.aiGuardrailId(model.aiGuardrailId);
            this.assistantId(model.assistantId);
            this.blockedInputMessaging(model.blockedInputMessaging);
            this.blockedOutputsMessaging(model.blockedOutputsMessaging);
            this.clientToken(model.clientToken);
            this.contentPolicyConfig(model.contentPolicyConfig);
            this.contextualGroundingPolicyConfig(model.contextualGroundingPolicyConfig);
            this.description(model.description);
            this.sensitiveInformationPolicyConfig(model.sensitiveInformationPolicyConfig);
            this.topicPolicyConfig(model.topicPolicyConfig);
            this.visibilityStatus(model.visibilityStatus);
            this.wordPolicyConfig(model.wordPolicyConfig);
        }

        public final String getAiGuardrailId() {
            return this.aiGuardrailId;
        }

        public final void setAiGuardrailId(String aiGuardrailId) {
            this.aiGuardrailId = aiGuardrailId;
        }

        @Override
        public final Builder aiGuardrailId(String aiGuardrailId) {
            this.aiGuardrailId = aiGuardrailId;
            return this;
        }

        public final String getAssistantId() {
            return this.assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getBlockedInputMessaging() {
            return this.blockedInputMessaging;
        }

        public final void setBlockedInputMessaging(String blockedInputMessaging) {
            this.blockedInputMessaging = blockedInputMessaging;
        }

        @Override
        public final Builder blockedInputMessaging(String blockedInputMessaging) {
            this.blockedInputMessaging = blockedInputMessaging;
            return this;
        }

        public final String getBlockedOutputsMessaging() {
            return this.blockedOutputsMessaging;
        }

        public final void setBlockedOutputsMessaging(String blockedOutputsMessaging) {
            this.blockedOutputsMessaging = blockedOutputsMessaging;
        }

        @Override
        public final Builder blockedOutputsMessaging(String blockedOutputsMessaging) {
            this.blockedOutputsMessaging = blockedOutputsMessaging;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final AIGuardrailContentPolicyConfig.Builder getContentPolicyConfig() {
            return this.contentPolicyConfig != null ? this.contentPolicyConfig.toBuilder() : null;
        }

        public final void setContentPolicyConfig(AIGuardrailContentPolicyConfig.BuilderImpl contentPolicyConfig) {
            this.contentPolicyConfig = contentPolicyConfig != null ? contentPolicyConfig.build() : null;
        }

        @Override
        public final Builder contentPolicyConfig(AIGuardrailContentPolicyConfig contentPolicyConfig) {
            this.contentPolicyConfig = contentPolicyConfig;
            return this;
        }

        public final AIGuardrailContextualGroundingPolicyConfig.Builder getContextualGroundingPolicyConfig() {
            return this.contextualGroundingPolicyConfig != null ? this.contextualGroundingPolicyConfig.toBuilder() : null;
        }

        public final void setContextualGroundingPolicyConfig(AIGuardrailContextualGroundingPolicyConfig.BuilderImpl contextualGroundingPolicyConfig) {
            this.contextualGroundingPolicyConfig = contextualGroundingPolicyConfig != null ? contextualGroundingPolicyConfig.build() : null;
        }

        @Override
        public final Builder contextualGroundingPolicyConfig(AIGuardrailContextualGroundingPolicyConfig contextualGroundingPolicyConfig) {
            this.contextualGroundingPolicyConfig = contextualGroundingPolicyConfig;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final AIGuardrailSensitiveInformationPolicyConfig.Builder getSensitiveInformationPolicyConfig() {
            return this.sensitiveInformationPolicyConfig != null ? this.sensitiveInformationPolicyConfig.toBuilder() : null;
        }

        public final void setSensitiveInformationPolicyConfig(AIGuardrailSensitiveInformationPolicyConfig.BuilderImpl sensitiveInformationPolicyConfig) {
            this.sensitiveInformationPolicyConfig = sensitiveInformationPolicyConfig != null ? sensitiveInformationPolicyConfig.build() : null;
        }

        @Override
        public final Builder sensitiveInformationPolicyConfig(AIGuardrailSensitiveInformationPolicyConfig sensitiveInformationPolicyConfig) {
            this.sensitiveInformationPolicyConfig = sensitiveInformationPolicyConfig;
            return this;
        }

        public final AIGuardrailTopicPolicyConfig.Builder getTopicPolicyConfig() {
            return this.topicPolicyConfig != null ? this.topicPolicyConfig.toBuilder() : null;
        }

        public final void setTopicPolicyConfig(AIGuardrailTopicPolicyConfig.BuilderImpl topicPolicyConfig) {
            this.topicPolicyConfig = topicPolicyConfig != null ? topicPolicyConfig.build() : null;
        }

        @Override
        public final Builder topicPolicyConfig(AIGuardrailTopicPolicyConfig topicPolicyConfig) {
            this.topicPolicyConfig = topicPolicyConfig;
            return this;
        }

        public final String getVisibilityStatus() {
            return this.visibilityStatus;
        }

        public final void setVisibilityStatus(String visibilityStatus) {
            this.visibilityStatus = visibilityStatus;
        }

        @Override
        public final Builder visibilityStatus(String visibilityStatus) {
            this.visibilityStatus = visibilityStatus;
            return this;
        }

        @Override
        public final Builder visibilityStatus(VisibilityStatus visibilityStatus) {
            this.visibilityStatus(visibilityStatus == null ? null : visibilityStatus.toString());
            return this;
        }

        public final AIGuardrailWordPolicyConfig.Builder getWordPolicyConfig() {
            return this.wordPolicyConfig != null ? this.wordPolicyConfig.toBuilder() : null;
        }

        public final void setWordPolicyConfig(AIGuardrailWordPolicyConfig.BuilderImpl wordPolicyConfig) {
            this.wordPolicyConfig = wordPolicyConfig != null ? wordPolicyConfig.build() : null;
        }

        @Override
        public final Builder wordPolicyConfig(AIGuardrailWordPolicyConfig wordPolicyConfig) {
            this.wordPolicyConfig = wordPolicyConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAiGuardrailRequest build() {
            return new UpdateAiGuardrailRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAiGuardrailRequest> {
        public Builder aiGuardrailId(String var1);

        public Builder assistantId(String var1);

        public Builder blockedInputMessaging(String var1);

        public Builder blockedOutputsMessaging(String var1);

        public Builder clientToken(String var1);

        public Builder contentPolicyConfig(AIGuardrailContentPolicyConfig var1);

        default public Builder contentPolicyConfig(Consumer<AIGuardrailContentPolicyConfig.Builder> contentPolicyConfig) {
            return this.contentPolicyConfig((AIGuardrailContentPolicyConfig)((AIGuardrailContentPolicyConfig.Builder)AIGuardrailContentPolicyConfig.builder().applyMutation(contentPolicyConfig)).build());
        }

        public Builder contextualGroundingPolicyConfig(AIGuardrailContextualGroundingPolicyConfig var1);

        default public Builder contextualGroundingPolicyConfig(Consumer<AIGuardrailContextualGroundingPolicyConfig.Builder> contextualGroundingPolicyConfig) {
            return this.contextualGroundingPolicyConfig((AIGuardrailContextualGroundingPolicyConfig)((AIGuardrailContextualGroundingPolicyConfig.Builder)AIGuardrailContextualGroundingPolicyConfig.builder().applyMutation(contextualGroundingPolicyConfig)).build());
        }

        public Builder description(String var1);

        public Builder sensitiveInformationPolicyConfig(AIGuardrailSensitiveInformationPolicyConfig var1);

        default public Builder sensitiveInformationPolicyConfig(Consumer<AIGuardrailSensitiveInformationPolicyConfig.Builder> sensitiveInformationPolicyConfig) {
            return this.sensitiveInformationPolicyConfig((AIGuardrailSensitiveInformationPolicyConfig)((AIGuardrailSensitiveInformationPolicyConfig.Builder)AIGuardrailSensitiveInformationPolicyConfig.builder().applyMutation(sensitiveInformationPolicyConfig)).build());
        }

        public Builder topicPolicyConfig(AIGuardrailTopicPolicyConfig var1);

        default public Builder topicPolicyConfig(Consumer<AIGuardrailTopicPolicyConfig.Builder> topicPolicyConfig) {
            return this.topicPolicyConfig((AIGuardrailTopicPolicyConfig)((AIGuardrailTopicPolicyConfig.Builder)AIGuardrailTopicPolicyConfig.builder().applyMutation(topicPolicyConfig)).build());
        }

        public Builder visibilityStatus(String var1);

        public Builder visibilityStatus(VisibilityStatus var1);

        public Builder wordPolicyConfig(AIGuardrailWordPolicyConfig var1);

        default public Builder wordPolicyConfig(Consumer<AIGuardrailWordPolicyConfig.Builder> wordPolicyConfig) {
            return this.wordPolicyConfig((AIGuardrailWordPolicyConfig)((AIGuardrailWordPolicyConfig.Builder)AIGuardrailWordPolicyConfig.builder().applyMutation(wordPolicyConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

