/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qconnect.model.ReferenceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContentReference
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContentReference> {
    private static final SdkField<String> CONTENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentArn").getter(ContentReference.getter(ContentReference::contentArn)).setter(ContentReference.setter(Builder::contentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentArn").build()}).build();
    private static final SdkField<String> CONTENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentId").getter(ContentReference.getter(ContentReference::contentId)).setter(ContentReference.setter(Builder::contentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentId").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseArn").getter(ContentReference.getter(ContentReference::knowledgeBaseArn)).setter(ContentReference.setter(Builder::knowledgeBaseArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseArn").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(ContentReference.getter(ContentReference::knowledgeBaseId)).setter(ContentReference.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()}).build();
    private static final SdkField<String> REFERENCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("referenceType").getter(ContentReference.getter(ContentReference::referenceTypeAsString)).setter(ContentReference.setter(Builder::referenceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceType").build()}).build();
    private static final SdkField<String> SOURCE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceURL").getter(ContentReference.getter(ContentReference::sourceURL)).setter(ContentReference.setter(Builder::sourceURL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceURL").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_ARN_FIELD, CONTENT_ID_FIELD, KNOWLEDGE_BASE_ARN_FIELD, KNOWLEDGE_BASE_ID_FIELD, REFERENCE_TYPE_FIELD, SOURCE_URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ContentReference.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String contentArn;
    private final String contentId;
    private final String knowledgeBaseArn;
    private final String knowledgeBaseId;
    private final String referenceType;
    private final String sourceURL;

    private ContentReference(BuilderImpl builder) {
        this.contentArn = builder.contentArn;
        this.contentId = builder.contentId;
        this.knowledgeBaseArn = builder.knowledgeBaseArn;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.referenceType = builder.referenceType;
        this.sourceURL = builder.sourceURL;
    }

    public final String contentArn() {
        return this.contentArn;
    }

    public final String contentId() {
        return this.contentId;
    }

    public final String knowledgeBaseArn() {
        return this.knowledgeBaseArn;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final ReferenceType referenceType() {
        return ReferenceType.fromValue(this.referenceType);
    }

    public final String referenceTypeAsString() {
        return this.referenceType;
    }

    public final String sourceURL() {
        return this.sourceURL;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceURL());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentReference)) {
            return false;
        }
        ContentReference other = (ContentReference)obj;
        return Objects.equals(this.contentArn(), other.contentArn()) && Objects.equals(this.contentId(), other.contentId()) && Objects.equals(this.knowledgeBaseArn(), other.knowledgeBaseArn()) && Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(this.referenceTypeAsString(), other.referenceTypeAsString()) && Objects.equals(this.sourceURL(), other.sourceURL());
    }

    public final String toString() {
        return ToString.builder((String)"ContentReference").add("ContentArn", (Object)this.contentArn()).add("ContentId", (Object)this.contentId()).add("KnowledgeBaseArn", (Object)this.knowledgeBaseArn()).add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("ReferenceType", (Object)this.referenceTypeAsString()).add("SourceURL", (Object)this.sourceURL()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contentArn": {
                return Optional.ofNullable(clazz.cast(this.contentArn()));
            }
            case "contentId": {
                return Optional.ofNullable(clazz.cast(this.contentId()));
            }
            case "knowledgeBaseArn": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseArn()));
            }
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "referenceType": {
                return Optional.ofNullable(clazz.cast(this.referenceTypeAsString()));
            }
            case "sourceURL": {
                return Optional.ofNullable(clazz.cast(this.sourceURL()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("contentArn", CONTENT_ARN_FIELD);
        map.put("contentId", CONTENT_ID_FIELD);
        map.put("knowledgeBaseArn", KNOWLEDGE_BASE_ARN_FIELD);
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("referenceType", REFERENCE_TYPE_FIELD);
        map.put("sourceURL", SOURCE_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContentReference, T> g) {
        return obj -> g.apply((ContentReference)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String contentArn;
        private String contentId;
        private String knowledgeBaseArn;
        private String knowledgeBaseId;
        private String referenceType;
        private String sourceURL;

        private BuilderImpl() {
        }

        private BuilderImpl(ContentReference model) {
            this.contentArn(model.contentArn);
            this.contentId(model.contentId);
            this.knowledgeBaseArn(model.knowledgeBaseArn);
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.referenceType(model.referenceType);
            this.sourceURL(model.sourceURL);
        }

        public final String getContentArn() {
            return this.contentArn;
        }

        public final void setContentArn(String contentArn) {
            this.contentArn = contentArn;
        }

        @Override
        public final Builder contentArn(String contentArn) {
            this.contentArn = contentArn;
            return this;
        }

        public final String getContentId() {
            return this.contentId;
        }

        public final void setContentId(String contentId) {
            this.contentId = contentId;
        }

        @Override
        public final Builder contentId(String contentId) {
            this.contentId = contentId;
            return this;
        }

        public final String getKnowledgeBaseArn() {
            return this.knowledgeBaseArn;
        }

        public final void setKnowledgeBaseArn(String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
        }

        @Override
        public final Builder knowledgeBaseArn(String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getReferenceType() {
            return this.referenceType;
        }

        public final void setReferenceType(String referenceType) {
            this.referenceType = referenceType;
        }

        @Override
        public final Builder referenceType(String referenceType) {
            this.referenceType = referenceType;
            return this;
        }

        @Override
        public final Builder referenceType(ReferenceType referenceType) {
            this.referenceType(referenceType == null ? null : referenceType.toString());
            return this;
        }

        public final String getSourceURL() {
            return this.sourceURL;
        }

        public final void setSourceURL(String sourceURL) {
            this.sourceURL = sourceURL;
        }

        @Override
        public final Builder sourceURL(String sourceURL) {
            this.sourceURL = sourceURL;
            return this;
        }

        public ContentReference build() {
            return new ContentReference(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContentReference> {
        public Builder contentArn(String var1);

        public Builder contentId(String var1);

        public Builder knowledgeBaseArn(String var1);

        public Builder knowledgeBaseId(String var1);

        public Builder referenceType(String var1);

        public Builder referenceType(ReferenceType var1);

        public Builder sourceURL(String var1);
    }
}

