/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qconnect.model.ChannelsCopier;
import software.amazon.awssdk.services.qconnect.model.GroupingConfiguration;
import software.amazon.awssdk.services.qconnect.model.QConnectRequest;
import software.amazon.awssdk.services.qconnect.model.QuickResponseDataProvider;
import software.amazon.awssdk.services.qconnect.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateQuickResponseRequest
extends QConnectRequest
implements ToCopyableBuilder<Builder, CreateQuickResponseRequest> {
    private static final SdkField<List<String>> CHANNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("channels").getter(CreateQuickResponseRequest.getter(CreateQuickResponseRequest::channels)).setter(CreateQuickResponseRequest.setter(Builder::channels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateQuickResponseRequest.getter(CreateQuickResponseRequest::clientToken)).setter(CreateQuickResponseRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<QuickResponseDataProvider> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("content").getter(CreateQuickResponseRequest.getter(CreateQuickResponseRequest::content)).setter(CreateQuickResponseRequest.setter(Builder::content)).constructor(QuickResponseDataProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentType").getter(CreateQuickResponseRequest.getter(CreateQuickResponseRequest::contentType)).setter(CreateQuickResponseRequest.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentType").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateQuickResponseRequest.getter(CreateQuickResponseRequest::description)).setter(CreateQuickResponseRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<GroupingConfiguration> GROUPING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("groupingConfiguration").getter(CreateQuickResponseRequest.getter(CreateQuickResponseRequest::groupingConfiguration)).setter(CreateQuickResponseRequest.setter(Builder::groupingConfiguration)).constructor(GroupingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupingConfiguration").build()}).build();
    private static final SdkField<Boolean> IS_ACTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isActive").getter(CreateQuickResponseRequest.getter(CreateQuickResponseRequest::isActive)).setter(CreateQuickResponseRequest.setter(Builder::isActive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isActive").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(CreateQuickResponseRequest.getter(CreateQuickResponseRequest::knowledgeBaseId)).setter(CreateQuickResponseRequest.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("knowledgeBaseId").build()}).build();
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("language").getter(CreateQuickResponseRequest.getter(CreateQuickResponseRequest::language)).setter(CreateQuickResponseRequest.setter(Builder::language)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("language").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateQuickResponseRequest.getter(CreateQuickResponseRequest::name)).setter(CreateQuickResponseRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> SHORTCUT_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("shortcutKey").getter(CreateQuickResponseRequest.getter(CreateQuickResponseRequest::shortcutKey)).setter(CreateQuickResponseRequest.setter(Builder::shortcutKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shortcutKey").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateQuickResponseRequest.getter(CreateQuickResponseRequest::tags)).setter(CreateQuickResponseRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNELS_FIELD, CLIENT_TOKEN_FIELD, CONTENT_FIELD, CONTENT_TYPE_FIELD, DESCRIPTION_FIELD, GROUPING_CONFIGURATION_FIELD, IS_ACTIVE_FIELD, KNOWLEDGE_BASE_ID_FIELD, LANGUAGE_FIELD, NAME_FIELD, SHORTCUT_KEY_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateQuickResponseRequest.memberNameToFieldInitializer();
    private final List<String> channels;
    private final String clientToken;
    private final QuickResponseDataProvider content;
    private final String contentType;
    private final String description;
    private final GroupingConfiguration groupingConfiguration;
    private final Boolean isActive;
    private final String knowledgeBaseId;
    private final String language;
    private final String name;
    private final String shortcutKey;
    private final Map<String, String> tags;

    private CreateQuickResponseRequest(BuilderImpl builder) {
        super(builder);
        this.channels = builder.channels;
        this.clientToken = builder.clientToken;
        this.content = builder.content;
        this.contentType = builder.contentType;
        this.description = builder.description;
        this.groupingConfiguration = builder.groupingConfiguration;
        this.isActive = builder.isActive;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.language = builder.language;
        this.name = builder.name;
        this.shortcutKey = builder.shortcutKey;
        this.tags = builder.tags;
    }

    public final boolean hasChannels() {
        return this.channels != null && !(this.channels instanceof SdkAutoConstructList);
    }

    public final List<String> channels() {
        return this.channels;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final QuickResponseDataProvider content() {
        return this.content;
    }

    public final String contentType() {
        return this.contentType;
    }

    public final String description() {
        return this.description;
    }

    public final GroupingConfiguration groupingConfiguration() {
        return this.groupingConfiguration;
    }

    public final Boolean isActive() {
        return this.isActive;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final String language() {
        return this.language;
    }

    public final String name() {
        return this.name;
    }

    public final String shortcutKey() {
        return this.shortcutKey;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChannels() ? this.channels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.isActive());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.language());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.shortcutKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateQuickResponseRequest)) {
            return false;
        }
        CreateQuickResponseRequest other = (CreateQuickResponseRequest)((Object)obj);
        return this.hasChannels() == other.hasChannels() && Objects.equals(this.channels(), other.channels()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.groupingConfiguration(), other.groupingConfiguration()) && Objects.equals(this.isActive(), other.isActive()) && Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(this.language(), other.language()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.shortcutKey(), other.shortcutKey()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateQuickResponseRequest").add("Channels", (Object)(this.channels() == null ? null : "*** Sensitive Data Redacted ***")).add("ClientToken", (Object)this.clientToken()).add("Content", (Object)this.content()).add("ContentType", (Object)this.contentType()).add("Description", (Object)this.description()).add("GroupingConfiguration", (Object)this.groupingConfiguration()).add("IsActive", (Object)this.isActive()).add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("Language", (Object)this.language()).add("Name", (Object)this.name()).add("ShortcutKey", (Object)this.shortcutKey()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "channels": {
                return Optional.ofNullable(clazz.cast(this.channels()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "contentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "groupingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.groupingConfiguration()));
            }
            case "isActive": {
                return Optional.ofNullable(clazz.cast(this.isActive()));
            }
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "language": {
                return Optional.ofNullable(clazz.cast(this.language()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "shortcutKey": {
                return Optional.ofNullable(clazz.cast(this.shortcutKey()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channels", CHANNELS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("content", CONTENT_FIELD);
        map.put("contentType", CONTENT_TYPE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("groupingConfiguration", GROUPING_CONFIGURATION_FIELD);
        map.put("isActive", IS_ACTIVE_FIELD);
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("language", LANGUAGE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("shortcutKey", SHORTCUT_KEY_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateQuickResponseRequest, T> g) {
        return obj -> g.apply((CreateQuickResponseRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QConnectRequest.BuilderImpl
    implements Builder {
        private List<String> channels = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;
        private QuickResponseDataProvider content;
        private String contentType;
        private String description;
        private GroupingConfiguration groupingConfiguration;
        private Boolean isActive;
        private String knowledgeBaseId;
        private String language;
        private String name;
        private String shortcutKey;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateQuickResponseRequest model) {
            super(model);
            this.channels(model.channels);
            this.clientToken(model.clientToken);
            this.content(model.content);
            this.contentType(model.contentType);
            this.description(model.description);
            this.groupingConfiguration(model.groupingConfiguration);
            this.isActive(model.isActive);
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.language(model.language);
            this.name(model.name);
            this.shortcutKey(model.shortcutKey);
            this.tags(model.tags);
        }

        public final Collection<String> getChannels() {
            if (this.channels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.channels;
        }

        public final void setChannels(Collection<String> channels) {
            this.channels = ChannelsCopier.copy(channels);
        }

        @Override
        public final Builder channels(Collection<String> channels) {
            this.channels = ChannelsCopier.copy(channels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channels(String ... channels) {
            this.channels(Arrays.asList(channels));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final QuickResponseDataProvider.Builder getContent() {
            return this.content != null ? this.content.toBuilder() : null;
        }

        public final void setContent(QuickResponseDataProvider.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(QuickResponseDataProvider content) {
            this.content = content;
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final GroupingConfiguration.Builder getGroupingConfiguration() {
            return this.groupingConfiguration != null ? this.groupingConfiguration.toBuilder() : null;
        }

        public final void setGroupingConfiguration(GroupingConfiguration.BuilderImpl groupingConfiguration) {
            this.groupingConfiguration = groupingConfiguration != null ? groupingConfiguration.build() : null;
        }

        @Override
        public final Builder groupingConfiguration(GroupingConfiguration groupingConfiguration) {
            this.groupingConfiguration = groupingConfiguration;
            return this;
        }

        public final Boolean getIsActive() {
            return this.isActive;
        }

        public final void setIsActive(Boolean isActive) {
            this.isActive = isActive;
        }

        @Override
        public final Builder isActive(Boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getLanguage() {
            return this.language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getShortcutKey() {
            return this.shortcutKey;
        }

        public final void setShortcutKey(String shortcutKey) {
            this.shortcutKey = shortcutKey;
        }

        @Override
        public final Builder shortcutKey(String shortcutKey) {
            this.shortcutKey = shortcutKey;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateQuickResponseRequest build() {
            return new CreateQuickResponseRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateQuickResponseRequest> {
        public Builder channels(Collection<String> var1);

        public Builder channels(String ... var1);

        public Builder clientToken(String var1);

        public Builder content(QuickResponseDataProvider var1);

        default public Builder content(Consumer<QuickResponseDataProvider.Builder> content) {
            return this.content((QuickResponseDataProvider)((QuickResponseDataProvider.Builder)QuickResponseDataProvider.builder().applyMutation(content)).build());
        }

        public Builder contentType(String var1);

        public Builder description(String var1);

        public Builder groupingConfiguration(GroupingConfiguration var1);

        default public Builder groupingConfiguration(Consumer<GroupingConfiguration.Builder> groupingConfiguration) {
            return this.groupingConfiguration((GroupingConfiguration)((GroupingConfiguration.Builder)GroupingConfiguration.builder().applyMutation(groupingConfiguration)).build());
        }

        public Builder isActive(Boolean var1);

        public Builder knowledgeBaseId(String var1);

        public Builder language(String var1);

        public Builder name(String var1);

        public Builder shortcutKey(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

