/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qconnect.model.QConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteAiPromptVersionRequest
extends QConnectRequest
implements ToCopyableBuilder<Builder, DeleteAiPromptVersionRequest> {
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assistantId").getter(DeleteAiPromptVersionRequest.getter(DeleteAiPromptVersionRequest::assistantId)).setter(DeleteAiPromptVersionRequest.setter(Builder::assistantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assistantId").build()}).build();
    private static final SdkField<String> AI_PROMPT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aiPromptId").getter(DeleteAiPromptVersionRequest.getter(DeleteAiPromptVersionRequest::aiPromptId)).setter(DeleteAiPromptVersionRequest.setter(Builder::aiPromptId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("aiPromptId").build()}).build();
    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("versionNumber").getter(DeleteAiPromptVersionRequest.getter(DeleteAiPromptVersionRequest::versionNumber)).setter(DeleteAiPromptVersionRequest.setter(Builder::versionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("versionNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSISTANT_ID_FIELD, AI_PROMPT_ID_FIELD, VERSION_NUMBER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteAiPromptVersionRequest.memberNameToFieldInitializer();
    private final String assistantId;
    private final String aiPromptId;
    private final Long versionNumber;

    private DeleteAiPromptVersionRequest(BuilderImpl builder) {
        super(builder);
        this.assistantId = builder.assistantId;
        this.aiPromptId = builder.aiPromptId;
        this.versionNumber = builder.versionNumber;
    }

    public final String assistantId() {
        return this.assistantId;
    }

    public final String aiPromptId() {
        return this.aiPromptId;
    }

    public final Long versionNumber() {
        return this.versionNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.aiPromptId());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionNumber());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAiPromptVersionRequest)) {
            return false;
        }
        DeleteAiPromptVersionRequest other = (DeleteAiPromptVersionRequest)((Object)obj);
        return Objects.equals(this.assistantId(), other.assistantId()) && Objects.equals(this.aiPromptId(), other.aiPromptId()) && Objects.equals(this.versionNumber(), other.versionNumber());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteAiPromptVersionRequest").add("AssistantId", (Object)this.assistantId()).add("AiPromptId", (Object)this.aiPromptId()).add("VersionNumber", (Object)this.versionNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assistantId": {
                return Optional.ofNullable(clazz.cast(this.assistantId()));
            }
            case "aiPromptId": {
                return Optional.ofNullable(clazz.cast(this.aiPromptId()));
            }
            case "versionNumber": {
                return Optional.ofNullable(clazz.cast(this.versionNumber()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("aiPromptId", AI_PROMPT_ID_FIELD);
        map.put("versionNumber", VERSION_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteAiPromptVersionRequest, T> g) {
        return obj -> g.apply((DeleteAiPromptVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QConnectRequest.BuilderImpl
    implements Builder {
        private String assistantId;
        private String aiPromptId;
        private Long versionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAiPromptVersionRequest model) {
            super(model);
            this.assistantId(model.assistantId);
            this.aiPromptId(model.aiPromptId);
            this.versionNumber(model.versionNumber);
        }

        public final String getAssistantId() {
            return this.assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getAiPromptId() {
            return this.aiPromptId;
        }

        public final void setAiPromptId(String aiPromptId) {
            this.aiPromptId = aiPromptId;
        }

        @Override
        public final Builder aiPromptId(String aiPromptId) {
            this.aiPromptId = aiPromptId;
            return this;
        }

        public final Long getVersionNumber() {
            return this.versionNumber;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAiPromptVersionRequest build() {
            return new DeleteAiPromptVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteAiPromptVersionRequest> {
        public Builder assistantId(String var1);

        public Builder aiPromptId(String var1);

        public Builder versionNumber(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

