/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum QueryResultType {
    KNOWLEDGE_CONTENT("KNOWLEDGE_CONTENT"),
    INTENT_ANSWER("INTENT_ANSWER"),
    GENERATIVE_ANSWER("GENERATIVE_ANSWER"),
    GENERATIVE_ANSWER_CHUNK("GENERATIVE_ANSWER_CHUNK"),
    BLOCKED_GENERATIVE_ANSWER_CHUNK("BLOCKED_GENERATIVE_ANSWER_CHUNK"),
    INTENT_ANSWER_CHUNK("INTENT_ANSWER_CHUNK"),
    BLOCKED_INTENT_ANSWER_CHUNK("BLOCKED_INTENT_ANSWER_CHUNK"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, QueryResultType> VALUE_MAP;
    private final String value;

    private QueryResultType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static QueryResultType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<QueryResultType> knownValues() {
        EnumSet<QueryResultType> knownValues = EnumSet.allOf(QueryResultType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(QueryResultType.class, QueryResultType::toString);
    }
}

