/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qconnect.model.QConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAiAgentVersionRequest
extends QConnectRequest
implements ToCopyableBuilder<Builder, CreateAiAgentVersionRequest> {
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assistantId").getter(CreateAiAgentVersionRequest.getter(CreateAiAgentVersionRequest::assistantId)).setter(CreateAiAgentVersionRequest.setter(Builder::assistantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assistantId").build()}).build();
    private static final SdkField<String> AI_AGENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aiAgentId").getter(CreateAiAgentVersionRequest.getter(CreateAiAgentVersionRequest::aiAgentId)).setter(CreateAiAgentVersionRequest.setter(Builder::aiAgentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("aiAgentId").build()}).build();
    private static final SdkField<Instant> MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("modifiedTime").getter(CreateAiAgentVersionRequest.getter(CreateAiAgentVersionRequest::modifiedTime)).setter(CreateAiAgentVersionRequest.setter(Builder::modifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedTime").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateAiAgentVersionRequest.getter(CreateAiAgentVersionRequest::clientToken)).setter(CreateAiAgentVersionRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSISTANT_ID_FIELD, AI_AGENT_ID_FIELD, MODIFIED_TIME_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAiAgentVersionRequest.memberNameToFieldInitializer();
    private final String assistantId;
    private final String aiAgentId;
    private final Instant modifiedTime;
    private final String clientToken;

    private CreateAiAgentVersionRequest(BuilderImpl builder) {
        super(builder);
        this.assistantId = builder.assistantId;
        this.aiAgentId = builder.aiAgentId;
        this.modifiedTime = builder.modifiedTime;
        this.clientToken = builder.clientToken;
    }

    public final String assistantId() {
        return this.assistantId;
    }

    public final String aiAgentId() {
        return this.aiAgentId;
    }

    public final Instant modifiedTime() {
        return this.modifiedTime;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.aiAgentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAiAgentVersionRequest)) {
            return false;
        }
        CreateAiAgentVersionRequest other = (CreateAiAgentVersionRequest)((Object)obj);
        return Objects.equals(this.assistantId(), other.assistantId()) && Objects.equals(this.aiAgentId(), other.aiAgentId()) && Objects.equals(this.modifiedTime(), other.modifiedTime()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAiAgentVersionRequest").add("AssistantId", (Object)this.assistantId()).add("AiAgentId", (Object)this.aiAgentId()).add("ModifiedTime", (Object)this.modifiedTime()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assistantId": {
                return Optional.ofNullable(clazz.cast(this.assistantId()));
            }
            case "aiAgentId": {
                return Optional.ofNullable(clazz.cast(this.aiAgentId()));
            }
            case "modifiedTime": {
                return Optional.ofNullable(clazz.cast(this.modifiedTime()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("aiAgentId", AI_AGENT_ID_FIELD);
        map.put("modifiedTime", MODIFIED_TIME_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAiAgentVersionRequest, T> g) {
        return obj -> g.apply((CreateAiAgentVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QConnectRequest.BuilderImpl
    implements Builder {
        private String assistantId;
        private String aiAgentId;
        private Instant modifiedTime;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAiAgentVersionRequest model) {
            super(model);
            this.assistantId(model.assistantId);
            this.aiAgentId(model.aiAgentId);
            this.modifiedTime(model.modifiedTime);
            this.clientToken(model.clientToken);
        }

        public final String getAssistantId() {
            return this.assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getAiAgentId() {
            return this.aiAgentId;
        }

        public final void setAiAgentId(String aiAgentId) {
            this.aiAgentId = aiAgentId;
        }

        @Override
        public final Builder aiAgentId(String aiAgentId) {
            this.aiAgentId = aiAgentId;
            return this;
        }

        public final Instant getModifiedTime() {
            return this.modifiedTime;
        }

        public final void setModifiedTime(Instant modifiedTime) {
            this.modifiedTime = modifiedTime;
        }

        @Override
        public final Builder modifiedTime(Instant modifiedTime) {
            this.modifiedTime = modifiedTime;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAiAgentVersionRequest build() {
            return new CreateAiAgentVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAiAgentVersionRequest> {
        public Builder assistantId(String var1);

        public Builder aiAgentId(String var1);

        public Builder modifiedTime(Instant var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

