/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qconnect.model.AIAgentConfigurationData;
import software.amazon.awssdk.services.qconnect.model.AIAgentConfigurationMapCopier;
import software.amazon.awssdk.services.qconnect.model.AIAgentType;
import software.amazon.awssdk.services.qconnect.model.Origin;
import software.amazon.awssdk.services.qconnect.model.SessionIntegrationConfiguration;
import software.amazon.awssdk.services.qconnect.model.TagFilter;
import software.amazon.awssdk.services.qconnect.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SessionData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SessionData> {
    private static final SdkField<String> SESSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionArn").getter(SessionData.getter(SessionData::sessionArn)).setter(SessionData.setter(Builder::sessionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionArn").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(SessionData.getter(SessionData::sessionId)).setter(SessionData.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(SessionData.getter(SessionData::name)).setter(SessionData.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(SessionData.getter(SessionData::description)).setter(SessionData.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(SessionData.getter(SessionData::tags)).setter(SessionData.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<SessionIntegrationConfiguration> INTEGRATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("integrationConfiguration").getter(SessionData.getter(SessionData::integrationConfiguration)).setter(SessionData.setter(Builder::integrationConfiguration)).constructor(SessionIntegrationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationConfiguration").build()}).build();
    private static final SdkField<TagFilter> TAG_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tagFilter").getter(SessionData.getter(SessionData::tagFilter)).setter(SessionData.setter(Builder::tagFilter)).constructor(TagFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagFilter").build()}).build();
    private static final SdkField<Map<String, AIAgentConfigurationData>> AI_AGENT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("aiAgentConfiguration").getter(SessionData.getter(SessionData::aiAgentConfigurationAsStrings)).setter(SessionData.setter(Builder::aiAgentConfigurationWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiAgentConfiguration").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AIAgentConfigurationData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ORIGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("origin").getter(SessionData.getter(SessionData::originAsString)).setter(SessionData.setter(Builder::origin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("origin").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ARN_FIELD, SESSION_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, TAGS_FIELD, INTEGRATION_CONFIGURATION_FIELD, TAG_FILTER_FIELD, AI_AGENT_CONFIGURATION_FIELD, ORIGIN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SessionData.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sessionArn;
    private final String sessionId;
    private final String name;
    private final String description;
    private final Map<String, String> tags;
    private final SessionIntegrationConfiguration integrationConfiguration;
    private final TagFilter tagFilter;
    private final Map<String, AIAgentConfigurationData> aiAgentConfiguration;
    private final String origin;

    private SessionData(BuilderImpl builder) {
        this.sessionArn = builder.sessionArn;
        this.sessionId = builder.sessionId;
        this.name = builder.name;
        this.description = builder.description;
        this.tags = builder.tags;
        this.integrationConfiguration = builder.integrationConfiguration;
        this.tagFilter = builder.tagFilter;
        this.aiAgentConfiguration = builder.aiAgentConfiguration;
        this.origin = builder.origin;
    }

    public final String sessionArn() {
        return this.sessionArn;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final SessionIntegrationConfiguration integrationConfiguration() {
        return this.integrationConfiguration;
    }

    public final TagFilter tagFilter() {
        return this.tagFilter;
    }

    public final Map<AIAgentType, AIAgentConfigurationData> aiAgentConfiguration() {
        return AIAgentConfigurationMapCopier.copyStringToEnum(this.aiAgentConfiguration);
    }

    public final boolean hasAiAgentConfiguration() {
        return this.aiAgentConfiguration != null && !(this.aiAgentConfiguration instanceof SdkAutoConstructMap);
    }

    public final Map<String, AIAgentConfigurationData> aiAgentConfigurationAsStrings() {
        return this.aiAgentConfiguration;
    }

    public final Origin origin() {
        return Origin.fromValue(this.origin);
    }

    public final String originAsString() {
        return this.origin;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAiAgentConfiguration() ? this.aiAgentConfigurationAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.originAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionData)) {
            return false;
        }
        SessionData other = (SessionData)obj;
        return Objects.equals(this.sessionArn(), other.sessionArn()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.integrationConfiguration(), other.integrationConfiguration()) && Objects.equals(this.tagFilter(), other.tagFilter()) && this.hasAiAgentConfiguration() == other.hasAiAgentConfiguration() && Objects.equals(this.aiAgentConfigurationAsStrings(), other.aiAgentConfigurationAsStrings()) && Objects.equals(this.originAsString(), other.originAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SessionData").add("SessionArn", (Object)this.sessionArn()).add("SessionId", (Object)this.sessionId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).add("IntegrationConfiguration", (Object)this.integrationConfiguration()).add("TagFilter", (Object)this.tagFilter()).add("AiAgentConfiguration", this.hasAiAgentConfiguration() ? this.aiAgentConfigurationAsStrings() : null).add("Origin", (Object)this.originAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sessionArn": {
                return Optional.ofNullable(clazz.cast(this.sessionArn()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "integrationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.integrationConfiguration()));
            }
            case "tagFilter": {
                return Optional.ofNullable(clazz.cast(this.tagFilter()));
            }
            case "aiAgentConfiguration": {
                return Optional.ofNullable(clazz.cast(this.aiAgentConfigurationAsStrings()));
            }
            case "origin": {
                return Optional.ofNullable(clazz.cast(this.originAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sessionArn", SESSION_ARN_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("integrationConfiguration", INTEGRATION_CONFIGURATION_FIELD);
        map.put("tagFilter", TAG_FILTER_FIELD);
        map.put("aiAgentConfiguration", AI_AGENT_CONFIGURATION_FIELD);
        map.put("origin", ORIGIN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SessionData, T> g) {
        return obj -> g.apply((SessionData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sessionArn;
        private String sessionId;
        private String name;
        private String description;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private SessionIntegrationConfiguration integrationConfiguration;
        private TagFilter tagFilter;
        private Map<String, AIAgentConfigurationData> aiAgentConfiguration = DefaultSdkAutoConstructMap.getInstance();
        private String origin;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionData model) {
            this.sessionArn(model.sessionArn);
            this.sessionId(model.sessionId);
            this.name(model.name);
            this.description(model.description);
            this.tags(model.tags);
            this.integrationConfiguration(model.integrationConfiguration);
            this.tagFilter(model.tagFilter);
            this.aiAgentConfigurationWithStrings(model.aiAgentConfiguration);
            this.origin(model.origin);
        }

        public final String getSessionArn() {
            return this.sessionArn;
        }

        public final void setSessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
        }

        @Override
        public final Builder sessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final SessionIntegrationConfiguration.Builder getIntegrationConfiguration() {
            return this.integrationConfiguration != null ? this.integrationConfiguration.toBuilder() : null;
        }

        public final void setIntegrationConfiguration(SessionIntegrationConfiguration.BuilderImpl integrationConfiguration) {
            this.integrationConfiguration = integrationConfiguration != null ? integrationConfiguration.build() : null;
        }

        @Override
        public final Builder integrationConfiguration(SessionIntegrationConfiguration integrationConfiguration) {
            this.integrationConfiguration = integrationConfiguration;
            return this;
        }

        public final TagFilter.Builder getTagFilter() {
            return this.tagFilter != null ? this.tagFilter.toBuilder() : null;
        }

        public final void setTagFilter(TagFilter.BuilderImpl tagFilter) {
            this.tagFilter = tagFilter != null ? tagFilter.build() : null;
        }

        @Override
        public final Builder tagFilter(TagFilter tagFilter) {
            this.tagFilter = tagFilter;
            return this;
        }

        public final Map<String, AIAgentConfigurationData.Builder> getAiAgentConfiguration() {
            Map<String, AIAgentConfigurationData.Builder> result = AIAgentConfigurationMapCopier.copyToBuilder(this.aiAgentConfiguration);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAiAgentConfiguration(Map<String, AIAgentConfigurationData.BuilderImpl> aiAgentConfiguration) {
            this.aiAgentConfiguration = AIAgentConfigurationMapCopier.copyFromBuilder(aiAgentConfiguration);
        }

        @Override
        public final Builder aiAgentConfigurationWithStrings(Map<String, AIAgentConfigurationData> aiAgentConfiguration) {
            this.aiAgentConfiguration = AIAgentConfigurationMapCopier.copy(aiAgentConfiguration);
            return this;
        }

        @Override
        public final Builder aiAgentConfiguration(Map<AIAgentType, AIAgentConfigurationData> aiAgentConfiguration) {
            this.aiAgentConfiguration = AIAgentConfigurationMapCopier.copyEnumToString(aiAgentConfiguration);
            return this;
        }

        public final String getOrigin() {
            return this.origin;
        }

        public final void setOrigin(String origin) {
            this.origin = origin;
        }

        @Override
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        @Override
        public final Builder origin(Origin origin) {
            this.origin(origin == null ? null : origin.toString());
            return this;
        }

        public SessionData build() {
            return new SessionData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SessionData> {
        public Builder sessionArn(String var1);

        public Builder sessionId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder integrationConfiguration(SessionIntegrationConfiguration var1);

        default public Builder integrationConfiguration(Consumer<SessionIntegrationConfiguration.Builder> integrationConfiguration) {
            return this.integrationConfiguration((SessionIntegrationConfiguration)((SessionIntegrationConfiguration.Builder)SessionIntegrationConfiguration.builder().applyMutation(integrationConfiguration)).build());
        }

        public Builder tagFilter(TagFilter var1);

        default public Builder tagFilter(Consumer<TagFilter.Builder> tagFilter) {
            return this.tagFilter((TagFilter)((TagFilter.Builder)TagFilter.builder().applyMutation(tagFilter)).build());
        }

        public Builder aiAgentConfigurationWithStrings(Map<String, AIAgentConfigurationData> var1);

        public Builder aiAgentConfiguration(Map<AIAgentType, AIAgentConfigurationData> var1);

        public Builder origin(String var1);

        public Builder origin(Origin var1);
    }
}

