/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qconnect.model.ContentReference;
import software.amazon.awssdk.services.qconnect.model.GenerativeReference;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataReference
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataReference> {
    private static final SdkField<ContentReference> CONTENT_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("contentReference").getter(DataReference.getter(DataReference::contentReference)).setter(DataReference.setter(Builder::contentReference)).constructor(ContentReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentReference").build()}).build();
    private static final SdkField<GenerativeReference> GENERATIVE_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("generativeReference").getter(DataReference.getter(DataReference::generativeReference)).setter(DataReference.setter(Builder::generativeReference)).constructor(GenerativeReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generativeReference").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_REFERENCE_FIELD, GENERATIVE_REFERENCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataReference.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ContentReference contentReference;
    private final GenerativeReference generativeReference;
    private final Type type;

    private DataReference(BuilderImpl builder) {
        this.contentReference = builder.contentReference;
        this.generativeReference = builder.generativeReference;
        this.type = builder.type;
    }

    public final ContentReference contentReference() {
        return this.contentReference;
    }

    public final GenerativeReference generativeReference() {
        return this.generativeReference;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contentReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.generativeReference());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataReference)) {
            return false;
        }
        DataReference other = (DataReference)obj;
        return Objects.equals(this.contentReference(), other.contentReference()) && Objects.equals(this.generativeReference(), other.generativeReference());
    }

    public final String toString() {
        return ToString.builder((String)"DataReference").add("ContentReference", (Object)this.contentReference()).add("GenerativeReference", (Object)this.generativeReference()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contentReference": {
                return Optional.ofNullable(clazz.cast(this.contentReference()));
            }
            case "generativeReference": {
                return Optional.ofNullable(clazz.cast(this.generativeReference()));
            }
        }
        return Optional.empty();
    }

    public static DataReference fromContentReference(ContentReference contentReference) {
        return (DataReference)DataReference.builder().contentReference(contentReference).build();
    }

    public static DataReference fromContentReference(Consumer<ContentReference.Builder> contentReference) {
        ContentReference.Builder builder = ContentReference.builder();
        contentReference.accept(builder);
        return DataReference.fromContentReference((ContentReference)builder.build());
    }

    public static DataReference fromGenerativeReference(GenerativeReference generativeReference) {
        return (DataReference)DataReference.builder().generativeReference(generativeReference).build();
    }

    public static DataReference fromGenerativeReference(Consumer<GenerativeReference.Builder> generativeReference) {
        GenerativeReference.Builder builder = GenerativeReference.builder();
        generativeReference.accept(builder);
        return DataReference.fromGenerativeReference((GenerativeReference)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contentReference", CONTENT_REFERENCE_FIELD);
        map.put("generativeReference", GENERATIVE_REFERENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataReference, T> g) {
        return obj -> g.apply((DataReference)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        CONTENT_REFERENCE,
        GENERATIVE_REFERENCE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ContentReference contentReference;
        private GenerativeReference generativeReference;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DataReference model) {
            this.contentReference(model.contentReference);
            this.generativeReference(model.generativeReference);
        }

        public final ContentReference.Builder getContentReference() {
            return this.contentReference != null ? this.contentReference.toBuilder() : null;
        }

        public final void setContentReference(ContentReference.BuilderImpl contentReference) {
            ContentReference oldValue = this.contentReference;
            this.contentReference = contentReference != null ? contentReference.build() : null;
            this.handleUnionValueChange(Type.CONTENT_REFERENCE, oldValue, this.contentReference);
        }

        @Override
        public final Builder contentReference(ContentReference contentReference) {
            ContentReference oldValue = this.contentReference;
            this.contentReference = contentReference;
            this.handleUnionValueChange(Type.CONTENT_REFERENCE, oldValue, this.contentReference);
            return this;
        }

        public final GenerativeReference.Builder getGenerativeReference() {
            return this.generativeReference != null ? this.generativeReference.toBuilder() : null;
        }

        public final void setGenerativeReference(GenerativeReference.BuilderImpl generativeReference) {
            GenerativeReference oldValue = this.generativeReference;
            this.generativeReference = generativeReference != null ? generativeReference.build() : null;
            this.handleUnionValueChange(Type.GENERATIVE_REFERENCE, oldValue, this.generativeReference);
        }

        @Override
        public final Builder generativeReference(GenerativeReference generativeReference) {
            GenerativeReference oldValue = this.generativeReference;
            this.generativeReference = generativeReference;
            this.handleUnionValueChange(Type.GENERATIVE_REFERENCE, oldValue, this.generativeReference);
            return this;
        }

        public DataReference build() {
            return new DataReference(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataReference> {
        public Builder contentReference(ContentReference var1);

        default public Builder contentReference(Consumer<ContentReference.Builder> contentReference) {
            return this.contentReference((ContentReference)((ContentReference.Builder)ContentReference.builder().applyMutation(contentReference)).build());
        }

        public Builder generativeReference(GenerativeReference var1);

        default public Builder generativeReference(Consumer<GenerativeReference.Builder> generativeReference) {
            return this.generativeReference((GenerativeReference)((GenerativeReference.Builder)GenerativeReference.builder().applyMutation(generativeReference)).build());
        }
    }
}

