/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qconnect.model.KnowledgeBaseStatus;
import software.amazon.awssdk.services.qconnect.model.KnowledgeBaseType;
import software.amazon.awssdk.services.qconnect.model.RenderingConfiguration;
import software.amazon.awssdk.services.qconnect.model.ServerSideEncryptionConfiguration;
import software.amazon.awssdk.services.qconnect.model.SourceConfiguration;
import software.amazon.awssdk.services.qconnect.model.TagsCopier;
import software.amazon.awssdk.services.qconnect.model.VectorIngestionConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KnowledgeBaseSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KnowledgeBaseSummary> {
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(KnowledgeBaseSummary.getter(KnowledgeBaseSummary::knowledgeBaseId)).setter(KnowledgeBaseSummary.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseArn").getter(KnowledgeBaseSummary.getter(KnowledgeBaseSummary::knowledgeBaseArn)).setter(KnowledgeBaseSummary.setter(Builder::knowledgeBaseArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(KnowledgeBaseSummary.getter(KnowledgeBaseSummary::name)).setter(KnowledgeBaseSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseType").getter(KnowledgeBaseSummary.getter(KnowledgeBaseSummary::knowledgeBaseTypeAsString)).setter(KnowledgeBaseSummary.setter(Builder::knowledgeBaseType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(KnowledgeBaseSummary.getter(KnowledgeBaseSummary::statusAsString)).setter(KnowledgeBaseSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<SourceConfiguration> SOURCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sourceConfiguration").getter(KnowledgeBaseSummary.getter(KnowledgeBaseSummary::sourceConfiguration)).setter(KnowledgeBaseSummary.setter(Builder::sourceConfiguration)).constructor(SourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceConfiguration").build()}).build();
    private static final SdkField<VectorIngestionConfiguration> VECTOR_INGESTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vectorIngestionConfiguration").getter(KnowledgeBaseSummary.getter(KnowledgeBaseSummary::vectorIngestionConfiguration)).setter(KnowledgeBaseSummary.setter(Builder::vectorIngestionConfiguration)).constructor(VectorIngestionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorIngestionConfiguration").build()}).build();
    private static final SdkField<RenderingConfiguration> RENDERING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("renderingConfiguration").getter(KnowledgeBaseSummary.getter(KnowledgeBaseSummary::renderingConfiguration)).setter(KnowledgeBaseSummary.setter(Builder::renderingConfiguration)).constructor(RenderingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renderingConfiguration").build()}).build();
    private static final SdkField<ServerSideEncryptionConfiguration> SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("serverSideEncryptionConfiguration").getter(KnowledgeBaseSummary.getter(KnowledgeBaseSummary::serverSideEncryptionConfiguration)).setter(KnowledgeBaseSummary.setter(Builder::serverSideEncryptionConfiguration)).constructor(ServerSideEncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverSideEncryptionConfiguration").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(KnowledgeBaseSummary.getter(KnowledgeBaseSummary::description)).setter(KnowledgeBaseSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(KnowledgeBaseSummary.getter(KnowledgeBaseSummary::tags)).setter(KnowledgeBaseSummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWLEDGE_BASE_ID_FIELD, KNOWLEDGE_BASE_ARN_FIELD, NAME_FIELD, KNOWLEDGE_BASE_TYPE_FIELD, STATUS_FIELD, SOURCE_CONFIGURATION_FIELD, VECTOR_INGESTION_CONFIGURATION_FIELD, RENDERING_CONFIGURATION_FIELD, SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD, DESCRIPTION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KnowledgeBaseSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String knowledgeBaseId;
    private final String knowledgeBaseArn;
    private final String name;
    private final String knowledgeBaseType;
    private final String status;
    private final SourceConfiguration sourceConfiguration;
    private final VectorIngestionConfiguration vectorIngestionConfiguration;
    private final RenderingConfiguration renderingConfiguration;
    private final ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;
    private final String description;
    private final Map<String, String> tags;

    private KnowledgeBaseSummary(BuilderImpl builder) {
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.knowledgeBaseArn = builder.knowledgeBaseArn;
        this.name = builder.name;
        this.knowledgeBaseType = builder.knowledgeBaseType;
        this.status = builder.status;
        this.sourceConfiguration = builder.sourceConfiguration;
        this.vectorIngestionConfiguration = builder.vectorIngestionConfiguration;
        this.renderingConfiguration = builder.renderingConfiguration;
        this.serverSideEncryptionConfiguration = builder.serverSideEncryptionConfiguration;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final String knowledgeBaseArn() {
        return this.knowledgeBaseArn;
    }

    public final String name() {
        return this.name;
    }

    public final KnowledgeBaseType knowledgeBaseType() {
        return KnowledgeBaseType.fromValue(this.knowledgeBaseType);
    }

    public final String knowledgeBaseTypeAsString() {
        return this.knowledgeBaseType;
    }

    public final KnowledgeBaseStatus status() {
        return KnowledgeBaseStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final SourceConfiguration sourceConfiguration() {
        return this.sourceConfiguration;
    }

    public final VectorIngestionConfiguration vectorIngestionConfiguration() {
        return this.vectorIngestionConfiguration;
    }

    public final RenderingConfiguration renderingConfiguration() {
        return this.renderingConfiguration;
    }

    public final ServerSideEncryptionConfiguration serverSideEncryptionConfiguration() {
        return this.serverSideEncryptionConfiguration;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.vectorIngestionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.renderingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverSideEncryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KnowledgeBaseSummary)) {
            return false;
        }
        KnowledgeBaseSummary other = (KnowledgeBaseSummary)obj;
        return Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(this.knowledgeBaseArn(), other.knowledgeBaseArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.knowledgeBaseTypeAsString(), other.knowledgeBaseTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.sourceConfiguration(), other.sourceConfiguration()) && Objects.equals(this.vectorIngestionConfiguration(), other.vectorIngestionConfiguration()) && Objects.equals(this.renderingConfiguration(), other.renderingConfiguration()) && Objects.equals(this.serverSideEncryptionConfiguration(), other.serverSideEncryptionConfiguration()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"KnowledgeBaseSummary").add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("KnowledgeBaseArn", (Object)this.knowledgeBaseArn()).add("Name", (Object)this.name()).add("KnowledgeBaseType", (Object)this.knowledgeBaseTypeAsString()).add("Status", (Object)this.statusAsString()).add("SourceConfiguration", (Object)this.sourceConfiguration()).add("VectorIngestionConfiguration", (Object)this.vectorIngestionConfiguration()).add("RenderingConfiguration", (Object)this.renderingConfiguration()).add("ServerSideEncryptionConfiguration", (Object)this.serverSideEncryptionConfiguration()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "knowledgeBaseArn": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "knowledgeBaseType": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseTypeAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "sourceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sourceConfiguration()));
            }
            case "vectorIngestionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.vectorIngestionConfiguration()));
            }
            case "renderingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.renderingConfiguration()));
            }
            case "serverSideEncryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.serverSideEncryptionConfiguration()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("knowledgeBaseArn", KNOWLEDGE_BASE_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("knowledgeBaseType", KNOWLEDGE_BASE_TYPE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("sourceConfiguration", SOURCE_CONFIGURATION_FIELD);
        map.put("vectorIngestionConfiguration", VECTOR_INGESTION_CONFIGURATION_FIELD);
        map.put("renderingConfiguration", RENDERING_CONFIGURATION_FIELD);
        map.put("serverSideEncryptionConfiguration", SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KnowledgeBaseSummary, T> g) {
        return obj -> g.apply((KnowledgeBaseSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String knowledgeBaseId;
        private String knowledgeBaseArn;
        private String name;
        private String knowledgeBaseType;
        private String status;
        private SourceConfiguration sourceConfiguration;
        private VectorIngestionConfiguration vectorIngestionConfiguration;
        private RenderingConfiguration renderingConfiguration;
        private ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;
        private String description;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(KnowledgeBaseSummary model) {
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.knowledgeBaseArn(model.knowledgeBaseArn);
            this.name(model.name);
            this.knowledgeBaseType(model.knowledgeBaseType);
            this.status(model.status);
            this.sourceConfiguration(model.sourceConfiguration);
            this.vectorIngestionConfiguration(model.vectorIngestionConfiguration);
            this.renderingConfiguration(model.renderingConfiguration);
            this.serverSideEncryptionConfiguration(model.serverSideEncryptionConfiguration);
            this.description(model.description);
            this.tags(model.tags);
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getKnowledgeBaseArn() {
            return this.knowledgeBaseArn;
        }

        public final void setKnowledgeBaseArn(String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
        }

        @Override
        public final Builder knowledgeBaseArn(String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getKnowledgeBaseType() {
            return this.knowledgeBaseType;
        }

        public final void setKnowledgeBaseType(String knowledgeBaseType) {
            this.knowledgeBaseType = knowledgeBaseType;
        }

        @Override
        public final Builder knowledgeBaseType(String knowledgeBaseType) {
            this.knowledgeBaseType = knowledgeBaseType;
            return this;
        }

        @Override
        public final Builder knowledgeBaseType(KnowledgeBaseType knowledgeBaseType) {
            this.knowledgeBaseType(knowledgeBaseType == null ? null : knowledgeBaseType.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(KnowledgeBaseStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final SourceConfiguration.Builder getSourceConfiguration() {
            return this.sourceConfiguration != null ? this.sourceConfiguration.toBuilder() : null;
        }

        public final void setSourceConfiguration(SourceConfiguration.BuilderImpl sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration != null ? sourceConfiguration.build() : null;
        }

        @Override
        public final Builder sourceConfiguration(SourceConfiguration sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration;
            return this;
        }

        public final VectorIngestionConfiguration.Builder getVectorIngestionConfiguration() {
            return this.vectorIngestionConfiguration != null ? this.vectorIngestionConfiguration.toBuilder() : null;
        }

        public final void setVectorIngestionConfiguration(VectorIngestionConfiguration.BuilderImpl vectorIngestionConfiguration) {
            this.vectorIngestionConfiguration = vectorIngestionConfiguration != null ? vectorIngestionConfiguration.build() : null;
        }

        @Override
        public final Builder vectorIngestionConfiguration(VectorIngestionConfiguration vectorIngestionConfiguration) {
            this.vectorIngestionConfiguration = vectorIngestionConfiguration;
            return this;
        }

        public final RenderingConfiguration.Builder getRenderingConfiguration() {
            return this.renderingConfiguration != null ? this.renderingConfiguration.toBuilder() : null;
        }

        public final void setRenderingConfiguration(RenderingConfiguration.BuilderImpl renderingConfiguration) {
            this.renderingConfiguration = renderingConfiguration != null ? renderingConfiguration.build() : null;
        }

        @Override
        public final Builder renderingConfiguration(RenderingConfiguration renderingConfiguration) {
            this.renderingConfiguration = renderingConfiguration;
            return this;
        }

        public final ServerSideEncryptionConfiguration.Builder getServerSideEncryptionConfiguration() {
            return this.serverSideEncryptionConfiguration != null ? this.serverSideEncryptionConfiguration.toBuilder() : null;
        }

        public final void setServerSideEncryptionConfiguration(ServerSideEncryptionConfiguration.BuilderImpl serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration != null ? serverSideEncryptionConfiguration.build() : null;
        }

        @Override
        public final Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public KnowledgeBaseSummary build() {
            return new KnowledgeBaseSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KnowledgeBaseSummary> {
        public Builder knowledgeBaseId(String var1);

        public Builder knowledgeBaseArn(String var1);

        public Builder name(String var1);

        public Builder knowledgeBaseType(String var1);

        public Builder knowledgeBaseType(KnowledgeBaseType var1);

        public Builder status(String var1);

        public Builder status(KnowledgeBaseStatus var1);

        public Builder sourceConfiguration(SourceConfiguration var1);

        default public Builder sourceConfiguration(Consumer<SourceConfiguration.Builder> sourceConfiguration) {
            return this.sourceConfiguration((SourceConfiguration)((SourceConfiguration.Builder)SourceConfiguration.builder().applyMutation(sourceConfiguration)).build());
        }

        public Builder vectorIngestionConfiguration(VectorIngestionConfiguration var1);

        default public Builder vectorIngestionConfiguration(Consumer<VectorIngestionConfiguration.Builder> vectorIngestionConfiguration) {
            return this.vectorIngestionConfiguration((VectorIngestionConfiguration)((VectorIngestionConfiguration.Builder)VectorIngestionConfiguration.builder().applyMutation(vectorIngestionConfiguration)).build());
        }

        public Builder renderingConfiguration(RenderingConfiguration var1);

        default public Builder renderingConfiguration(Consumer<RenderingConfiguration.Builder> renderingConfiguration) {
            return this.renderingConfiguration((RenderingConfiguration)((RenderingConfiguration.Builder)RenderingConfiguration.builder().applyMutation(renderingConfiguration)).build());
        }

        public Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration var1);

        default public Builder serverSideEncryptionConfiguration(Consumer<ServerSideEncryptionConfiguration.Builder> serverSideEncryptionConfiguration) {
            return this.serverSideEncryptionConfiguration((ServerSideEncryptionConfiguration)((ServerSideEncryptionConfiguration.Builder)ServerSideEncryptionConfiguration.builder().applyMutation(serverSideEncryptionConfiguration)).build());
        }

        public Builder description(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

