/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qconnect.model.BedrockFoundationModelConfigurationForParsing;
import software.amazon.awssdk.services.qconnect.model.ParsingStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParsingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParsingConfiguration> {
    private static final SdkField<String> PARSING_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parsingStrategy").getter(ParsingConfiguration.getter(ParsingConfiguration::parsingStrategyAsString)).setter(ParsingConfiguration.setter(Builder::parsingStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parsingStrategy").build()}).build();
    private static final SdkField<BedrockFoundationModelConfigurationForParsing> BEDROCK_FOUNDATION_MODEL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("bedrockFoundationModelConfiguration").getter(ParsingConfiguration.getter(ParsingConfiguration::bedrockFoundationModelConfiguration)).setter(ParsingConfiguration.setter(Builder::bedrockFoundationModelConfiguration)).constructor(BedrockFoundationModelConfigurationForParsing::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bedrockFoundationModelConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARSING_STRATEGY_FIELD, BEDROCK_FOUNDATION_MODEL_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ParsingConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String parsingStrategy;
    private final BedrockFoundationModelConfigurationForParsing bedrockFoundationModelConfiguration;

    private ParsingConfiguration(BuilderImpl builder) {
        this.parsingStrategy = builder.parsingStrategy;
        this.bedrockFoundationModelConfiguration = builder.bedrockFoundationModelConfiguration;
    }

    public final ParsingStrategy parsingStrategy() {
        return ParsingStrategy.fromValue(this.parsingStrategy);
    }

    public final String parsingStrategyAsString() {
        return this.parsingStrategy;
    }

    public final BedrockFoundationModelConfigurationForParsing bedrockFoundationModelConfiguration() {
        return this.bedrockFoundationModelConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parsingStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bedrockFoundationModelConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParsingConfiguration)) {
            return false;
        }
        ParsingConfiguration other = (ParsingConfiguration)obj;
        return Objects.equals(this.parsingStrategyAsString(), other.parsingStrategyAsString()) && Objects.equals(this.bedrockFoundationModelConfiguration(), other.bedrockFoundationModelConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ParsingConfiguration").add("ParsingStrategy", (Object)this.parsingStrategyAsString()).add("BedrockFoundationModelConfiguration", (Object)this.bedrockFoundationModelConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "parsingStrategy": {
                return Optional.ofNullable(clazz.cast(this.parsingStrategyAsString()));
            }
            case "bedrockFoundationModelConfiguration": {
                return Optional.ofNullable(clazz.cast(this.bedrockFoundationModelConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("parsingStrategy", PARSING_STRATEGY_FIELD);
        map.put("bedrockFoundationModelConfiguration", BEDROCK_FOUNDATION_MODEL_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParsingConfiguration, T> g) {
        return obj -> g.apply((ParsingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String parsingStrategy;
        private BedrockFoundationModelConfigurationForParsing bedrockFoundationModelConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ParsingConfiguration model) {
            this.parsingStrategy(model.parsingStrategy);
            this.bedrockFoundationModelConfiguration(model.bedrockFoundationModelConfiguration);
        }

        public final String getParsingStrategy() {
            return this.parsingStrategy;
        }

        public final void setParsingStrategy(String parsingStrategy) {
            this.parsingStrategy = parsingStrategy;
        }

        @Override
        public final Builder parsingStrategy(String parsingStrategy) {
            this.parsingStrategy = parsingStrategy;
            return this;
        }

        @Override
        public final Builder parsingStrategy(ParsingStrategy parsingStrategy) {
            this.parsingStrategy(parsingStrategy == null ? null : parsingStrategy.toString());
            return this;
        }

        public final BedrockFoundationModelConfigurationForParsing.Builder getBedrockFoundationModelConfiguration() {
            return this.bedrockFoundationModelConfiguration != null ? this.bedrockFoundationModelConfiguration.toBuilder() : null;
        }

        public final void setBedrockFoundationModelConfiguration(BedrockFoundationModelConfigurationForParsing.BuilderImpl bedrockFoundationModelConfiguration) {
            this.bedrockFoundationModelConfiguration = bedrockFoundationModelConfiguration != null ? bedrockFoundationModelConfiguration.build() : null;
        }

        @Override
        public final Builder bedrockFoundationModelConfiguration(BedrockFoundationModelConfigurationForParsing bedrockFoundationModelConfiguration) {
            this.bedrockFoundationModelConfiguration = bedrockFoundationModelConfiguration;
            return this;
        }

        public ParsingConfiguration build() {
            return new ParsingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParsingConfiguration> {
        public Builder parsingStrategy(String var1);

        public Builder parsingStrategy(ParsingStrategy var1);

        public Builder bedrockFoundationModelConfiguration(BedrockFoundationModelConfigurationForParsing var1);

        default public Builder bedrockFoundationModelConfiguration(Consumer<BedrockFoundationModelConfigurationForParsing.Builder> bedrockFoundationModelConfiguration) {
            return this.bedrockFoundationModelConfiguration((BedrockFoundationModelConfigurationForParsing)((BedrockFoundationModelConfigurationForParsing.Builder)BedrockFoundationModelConfigurationForParsing.builder().applyMutation(bedrockFoundationModelConfiguration)).build());
        }
    }
}

