/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qconnect.model.ContactAttributesCopier;
import software.amazon.awssdk.services.qconnect.model.QConnectRequest;
import software.amazon.awssdk.services.qconnect.model.QuickResponseSearchExpression;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchQuickResponsesRequest
extends QConnectRequest
implements ToCopyableBuilder<Builder, SearchQuickResponsesRequest> {
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(SearchQuickResponsesRequest.getter(SearchQuickResponsesRequest::knowledgeBaseId)).setter(SearchQuickResponsesRequest.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("knowledgeBaseId").build()}).build();
    private static final SdkField<QuickResponseSearchExpression> SEARCH_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("searchExpression").getter(SearchQuickResponsesRequest.getter(SearchQuickResponsesRequest::searchExpression)).setter(SearchQuickResponsesRequest.setter(Builder::searchExpression)).constructor(QuickResponseSearchExpression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchExpression").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(SearchQuickResponsesRequest.getter(SearchQuickResponsesRequest::nextToken)).setter(SearchQuickResponsesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(SearchQuickResponsesRequest.getter(SearchQuickResponsesRequest::maxResults)).setter(SearchQuickResponsesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("attributes").getter(SearchQuickResponsesRequest.getter(SearchQuickResponsesRequest::attributes)).setter(SearchQuickResponsesRequest.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWLEDGE_BASE_ID_FIELD, SEARCH_EXPRESSION_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchQuickResponsesRequest.memberNameToFieldInitializer();
    private final String knowledgeBaseId;
    private final QuickResponseSearchExpression searchExpression;
    private final String nextToken;
    private final Integer maxResults;
    private final Map<String, String> attributes;

    private SearchQuickResponsesRequest(BuilderImpl builder) {
        super(builder);
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.searchExpression = builder.searchExpression;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.attributes = builder.attributes;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final QuickResponseSearchExpression searchExpression() {
        return this.searchExpression;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchQuickResponsesRequest)) {
            return false;
        }
        SearchQuickResponsesRequest other = (SearchQuickResponsesRequest)((Object)obj);
        return Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(this.searchExpression(), other.searchExpression()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes());
    }

    public final String toString() {
        return ToString.builder((String)"SearchQuickResponsesRequest").add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("SearchExpression", (Object)this.searchExpression()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("Attributes", (Object)(this.attributes() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "searchExpression": {
                return Optional.ofNullable(clazz.cast(this.searchExpression()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("searchExpression", SEARCH_EXPRESSION_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("attributes", ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchQuickResponsesRequest, T> g) {
        return obj -> g.apply((SearchQuickResponsesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QConnectRequest.BuilderImpl
    implements Builder {
        private String knowledgeBaseId;
        private QuickResponseSearchExpression searchExpression;
        private String nextToken;
        private Integer maxResults;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchQuickResponsesRequest model) {
            super(model);
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.searchExpression(model.searchExpression);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.attributes(model.attributes);
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final QuickResponseSearchExpression.Builder getSearchExpression() {
            return this.searchExpression != null ? this.searchExpression.toBuilder() : null;
        }

        public final void setSearchExpression(QuickResponseSearchExpression.BuilderImpl searchExpression) {
            this.searchExpression = searchExpression != null ? searchExpression.build() : null;
        }

        @Override
        public final Builder searchExpression(QuickResponseSearchExpression searchExpression) {
            this.searchExpression = searchExpression;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = ContactAttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = ContactAttributesCopier.copy(attributes);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchQuickResponsesRequest build() {
            return new SearchQuickResponsesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchQuickResponsesRequest> {
        public Builder knowledgeBaseId(String var1);

        public Builder searchExpression(QuickResponseSearchExpression var1);

        default public Builder searchExpression(Consumer<QuickResponseSearchExpression.Builder> searchExpression) {
            return this.searchExpression((QuickResponseSearchExpression)((QuickResponseSearchExpression.Builder)QuickResponseSearchExpression.builder().applyMutation(searchExpression)).build());
        }

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder attributes(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

