/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qconnect.QConnectAsyncClient;
import software.amazon.awssdk.services.qconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.qconnect.model.AIGuardrailSummary;
import software.amazon.awssdk.services.qconnect.model.ListAiGuardrailsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAiGuardrailsResponse;

public class ListAIGuardrailsPublisher
implements SdkPublisher<ListAiGuardrailsResponse> {
    private final QConnectAsyncClient client;
    private final ListAiGuardrailsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAIGuardrailsPublisher(QConnectAsyncClient client, ListAiGuardrailsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAIGuardrailsPublisher(QConnectAsyncClient client, ListAiGuardrailsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAiGuardrailsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAiGuardrailsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AIGuardrailSummary> aiGuardrailSummaries() {
        Function<ListAiGuardrailsResponse, Iterator> getIterator = response -> {
            if (response != null && response.aiGuardrailSummaries() != null) {
                return response.aiGuardrailSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAiGuardrailsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAiGuardrailsResponseFetcher
    implements AsyncPageFetcher<ListAiGuardrailsResponse> {
        private ListAiGuardrailsResponseFetcher() {
        }

        public boolean hasNextPage(ListAiGuardrailsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAiGuardrailsResponse> nextPage(ListAiGuardrailsResponse previousPage) {
            if (previousPage == null) {
                return ListAIGuardrailsPublisher.this.client.listAIGuardrails(ListAIGuardrailsPublisher.this.firstRequest);
            }
            return ListAIGuardrailsPublisher.this.client.listAIGuardrails((ListAiGuardrailsRequest)((Object)ListAIGuardrailsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

