/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qconnect.model.ChannelSubtype;
import software.amazon.awssdk.services.qconnect.model.GroupingConfiguration;
import software.amazon.awssdk.services.qconnect.model.MessageTemplateAttributes;
import software.amazon.awssdk.services.qconnect.model.MessageTemplateContentProvider;
import software.amazon.awssdk.services.qconnect.model.QConnectRequest;
import software.amazon.awssdk.services.qconnect.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMessageTemplateRequest
extends QConnectRequest
implements ToCopyableBuilder<Builder, CreateMessageTemplateRequest> {
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(CreateMessageTemplateRequest.getter(CreateMessageTemplateRequest::knowledgeBaseId)).setter(CreateMessageTemplateRequest.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("knowledgeBaseId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateMessageTemplateRequest.getter(CreateMessageTemplateRequest::name)).setter(CreateMessageTemplateRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<MessageTemplateContentProvider> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("content").getter(CreateMessageTemplateRequest.getter(CreateMessageTemplateRequest::content)).setter(CreateMessageTemplateRequest.setter(Builder::content)).constructor(MessageTemplateContentProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateMessageTemplateRequest.getter(CreateMessageTemplateRequest::description)).setter(CreateMessageTemplateRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> CHANNEL_SUBTYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("channelSubtype").getter(CreateMessageTemplateRequest.getter(CreateMessageTemplateRequest::channelSubtypeAsString)).setter(CreateMessageTemplateRequest.setter(Builder::channelSubtype)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelSubtype").build()}).build();
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("language").getter(CreateMessageTemplateRequest.getter(CreateMessageTemplateRequest::language)).setter(CreateMessageTemplateRequest.setter(Builder::language)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("language").build()}).build();
    private static final SdkField<MessageTemplateAttributes> DEFAULT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("defaultAttributes").getter(CreateMessageTemplateRequest.getter(CreateMessageTemplateRequest::defaultAttributes)).setter(CreateMessageTemplateRequest.setter(Builder::defaultAttributes)).constructor(MessageTemplateAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultAttributes").build()}).build();
    private static final SdkField<GroupingConfiguration> GROUPING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("groupingConfiguration").getter(CreateMessageTemplateRequest.getter(CreateMessageTemplateRequest::groupingConfiguration)).setter(CreateMessageTemplateRequest.setter(Builder::groupingConfiguration)).constructor(GroupingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupingConfiguration").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateMessageTemplateRequest.getter(CreateMessageTemplateRequest::clientToken)).setter(CreateMessageTemplateRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateMessageTemplateRequest.getter(CreateMessageTemplateRequest::tags)).setter(CreateMessageTemplateRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWLEDGE_BASE_ID_FIELD, NAME_FIELD, CONTENT_FIELD, DESCRIPTION_FIELD, CHANNEL_SUBTYPE_FIELD, LANGUAGE_FIELD, DEFAULT_ATTRIBUTES_FIELD, GROUPING_CONFIGURATION_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateMessageTemplateRequest.memberNameToFieldInitializer();
    private final String knowledgeBaseId;
    private final String name;
    private final MessageTemplateContentProvider content;
    private final String description;
    private final String channelSubtype;
    private final String language;
    private final MessageTemplateAttributes defaultAttributes;
    private final GroupingConfiguration groupingConfiguration;
    private final String clientToken;
    private final Map<String, String> tags;

    private CreateMessageTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.name = builder.name;
        this.content = builder.content;
        this.description = builder.description;
        this.channelSubtype = builder.channelSubtype;
        this.language = builder.language;
        this.defaultAttributes = builder.defaultAttributes;
        this.groupingConfiguration = builder.groupingConfiguration;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final String name() {
        return this.name;
    }

    public final MessageTemplateContentProvider content() {
        return this.content;
    }

    public final String description() {
        return this.description;
    }

    public final ChannelSubtype channelSubtype() {
        return ChannelSubtype.fromValue(this.channelSubtype);
    }

    public final String channelSubtypeAsString() {
        return this.channelSubtype;
    }

    public final String language() {
        return this.language;
    }

    public final MessageTemplateAttributes defaultAttributes() {
        return this.defaultAttributes;
    }

    public final GroupingConfiguration groupingConfiguration() {
        return this.groupingConfiguration;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelSubtypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.language());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMessageTemplateRequest)) {
            return false;
        }
        CreateMessageTemplateRequest other = (CreateMessageTemplateRequest)((Object)obj);
        return Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.channelSubtypeAsString(), other.channelSubtypeAsString()) && Objects.equals(this.language(), other.language()) && Objects.equals(this.defaultAttributes(), other.defaultAttributes()) && Objects.equals(this.groupingConfiguration(), other.groupingConfiguration()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMessageTemplateRequest").add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("Name", (Object)this.name()).add("Content", (Object)this.content()).add("Description", (Object)this.description()).add("ChannelSubtype", (Object)this.channelSubtypeAsString()).add("Language", (Object)this.language()).add("DefaultAttributes", (Object)this.defaultAttributes()).add("GroupingConfiguration", (Object)this.groupingConfiguration()).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "channelSubtype": {
                return Optional.ofNullable(clazz.cast(this.channelSubtypeAsString()));
            }
            case "language": {
                return Optional.ofNullable(clazz.cast(this.language()));
            }
            case "defaultAttributes": {
                return Optional.ofNullable(clazz.cast(this.defaultAttributes()));
            }
            case "groupingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.groupingConfiguration()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("content", CONTENT_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("channelSubtype", CHANNEL_SUBTYPE_FIELD);
        map.put("language", LANGUAGE_FIELD);
        map.put("defaultAttributes", DEFAULT_ATTRIBUTES_FIELD);
        map.put("groupingConfiguration", GROUPING_CONFIGURATION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMessageTemplateRequest, T> g) {
        return obj -> g.apply((CreateMessageTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QConnectRequest.BuilderImpl
    implements Builder {
        private String knowledgeBaseId;
        private String name;
        private MessageTemplateContentProvider content;
        private String description;
        private String channelSubtype;
        private String language;
        private MessageTemplateAttributes defaultAttributes;
        private GroupingConfiguration groupingConfiguration;
        private String clientToken;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMessageTemplateRequest model) {
            super(model);
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.name(model.name);
            this.content(model.content);
            this.description(model.description);
            this.channelSubtype(model.channelSubtype);
            this.language(model.language);
            this.defaultAttributes(model.defaultAttributes);
            this.groupingConfiguration(model.groupingConfiguration);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final MessageTemplateContentProvider.Builder getContent() {
            return this.content != null ? this.content.toBuilder() : null;
        }

        public final void setContent(MessageTemplateContentProvider.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(MessageTemplateContentProvider content) {
            this.content = content;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getChannelSubtype() {
            return this.channelSubtype;
        }

        public final void setChannelSubtype(String channelSubtype) {
            this.channelSubtype = channelSubtype;
        }

        @Override
        public final Builder channelSubtype(String channelSubtype) {
            this.channelSubtype = channelSubtype;
            return this;
        }

        @Override
        public final Builder channelSubtype(ChannelSubtype channelSubtype) {
            this.channelSubtype(channelSubtype == null ? null : channelSubtype.toString());
            return this;
        }

        public final String getLanguage() {
            return this.language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final MessageTemplateAttributes.Builder getDefaultAttributes() {
            return this.defaultAttributes != null ? this.defaultAttributes.toBuilder() : null;
        }

        public final void setDefaultAttributes(MessageTemplateAttributes.BuilderImpl defaultAttributes) {
            this.defaultAttributes = defaultAttributes != null ? defaultAttributes.build() : null;
        }

        @Override
        public final Builder defaultAttributes(MessageTemplateAttributes defaultAttributes) {
            this.defaultAttributes = defaultAttributes;
            return this;
        }

        public final GroupingConfiguration.Builder getGroupingConfiguration() {
            return this.groupingConfiguration != null ? this.groupingConfiguration.toBuilder() : null;
        }

        public final void setGroupingConfiguration(GroupingConfiguration.BuilderImpl groupingConfiguration) {
            this.groupingConfiguration = groupingConfiguration != null ? groupingConfiguration.build() : null;
        }

        @Override
        public final Builder groupingConfiguration(GroupingConfiguration groupingConfiguration) {
            this.groupingConfiguration = groupingConfiguration;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMessageTemplateRequest build() {
            return new CreateMessageTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMessageTemplateRequest> {
        public Builder knowledgeBaseId(String var1);

        public Builder name(String var1);

        public Builder content(MessageTemplateContentProvider var1);

        default public Builder content(Consumer<MessageTemplateContentProvider.Builder> content) {
            return this.content((MessageTemplateContentProvider)((MessageTemplateContentProvider.Builder)MessageTemplateContentProvider.builder().applyMutation(content)).build());
        }

        public Builder description(String var1);

        public Builder channelSubtype(String var1);

        public Builder channelSubtype(ChannelSubtype var1);

        public Builder language(String var1);

        public Builder defaultAttributes(MessageTemplateAttributes var1);

        default public Builder defaultAttributes(Consumer<MessageTemplateAttributes.Builder> defaultAttributes) {
            return this.defaultAttributes((MessageTemplateAttributes)((MessageTemplateAttributes.Builder)MessageTemplateAttributes.builder().applyMutation(defaultAttributes)).build());
        }

        public Builder groupingConfiguration(GroupingConfiguration var1);

        default public Builder groupingConfiguration(Consumer<GroupingConfiguration.Builder> groupingConfiguration) {
            return this.groupingConfiguration((GroupingConfiguration)((GroupingConfiguration.Builder)GroupingConfiguration.builder().applyMutation(groupingConfiguration)).build());
        }

        public Builder clientToken(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

