/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qconnect.model.AIAgentVersionSummariesListCopier;
import software.amazon.awssdk.services.qconnect.model.AIAgentVersionSummary;
import software.amazon.awssdk.services.qconnect.model.QConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAiAgentVersionsResponse
extends QConnectResponse
implements ToCopyableBuilder<Builder, ListAiAgentVersionsResponse> {
    private static final SdkField<List<AIAgentVersionSummary>> AI_AGENT_VERSION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("aiAgentVersionSummaries").getter(ListAiAgentVersionsResponse.getter(ListAiAgentVersionsResponse::aiAgentVersionSummaries)).setter(ListAiAgentVersionsResponse.setter(Builder::aiAgentVersionSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiAgentVersionSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AIAgentVersionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAiAgentVersionsResponse.getter(ListAiAgentVersionsResponse::nextToken)).setter(ListAiAgentVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AI_AGENT_VERSION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAiAgentVersionsResponse.memberNameToFieldInitializer();
    private final List<AIAgentVersionSummary> aiAgentVersionSummaries;
    private final String nextToken;

    private ListAiAgentVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.aiAgentVersionSummaries = builder.aiAgentVersionSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAiAgentVersionSummaries() {
        return this.aiAgentVersionSummaries != null && !(this.aiAgentVersionSummaries instanceof SdkAutoConstructList);
    }

    public final List<AIAgentVersionSummary> aiAgentVersionSummaries() {
        return this.aiAgentVersionSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAiAgentVersionSummaries() ? this.aiAgentVersionSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAiAgentVersionsResponse)) {
            return false;
        }
        ListAiAgentVersionsResponse other = (ListAiAgentVersionsResponse)((Object)obj);
        return this.hasAiAgentVersionSummaries() == other.hasAiAgentVersionSummaries() && Objects.equals(this.aiAgentVersionSummaries(), other.aiAgentVersionSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAiAgentVersionsResponse").add("AiAgentVersionSummaries", this.hasAiAgentVersionSummaries() ? this.aiAgentVersionSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "aiAgentVersionSummaries": {
                return Optional.ofNullable(clazz.cast(this.aiAgentVersionSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("aiAgentVersionSummaries", AI_AGENT_VERSION_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAiAgentVersionsResponse, T> g) {
        return obj -> g.apply((ListAiAgentVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QConnectResponse.BuilderImpl
    implements Builder {
        private List<AIAgentVersionSummary> aiAgentVersionSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAiAgentVersionsResponse model) {
            super(model);
            this.aiAgentVersionSummaries(model.aiAgentVersionSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<AIAgentVersionSummary.Builder> getAiAgentVersionSummaries() {
            List<AIAgentVersionSummary.Builder> result = AIAgentVersionSummariesListCopier.copyToBuilder(this.aiAgentVersionSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAiAgentVersionSummaries(Collection<AIAgentVersionSummary.BuilderImpl> aiAgentVersionSummaries) {
            this.aiAgentVersionSummaries = AIAgentVersionSummariesListCopier.copyFromBuilder(aiAgentVersionSummaries);
        }

        @Override
        public final Builder aiAgentVersionSummaries(Collection<AIAgentVersionSummary> aiAgentVersionSummaries) {
            this.aiAgentVersionSummaries = AIAgentVersionSummariesListCopier.copy(aiAgentVersionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aiAgentVersionSummaries(AIAgentVersionSummary ... aiAgentVersionSummaries) {
            this.aiAgentVersionSummaries(Arrays.asList(aiAgentVersionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aiAgentVersionSummaries(Consumer<AIAgentVersionSummary.Builder> ... aiAgentVersionSummaries) {
            this.aiAgentVersionSummaries(Stream.of(aiAgentVersionSummaries).map(c -> (AIAgentVersionSummary)((AIAgentVersionSummary.Builder)AIAgentVersionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAiAgentVersionsResponse build() {
            return new ListAiAgentVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAiAgentVersionsResponse> {
        public Builder aiAgentVersionSummaries(Collection<AIAgentVersionSummary> var1);

        public Builder aiAgentVersionSummaries(AIAgentVersionSummary ... var1);

        public Builder aiAgentVersionSummaries(Consumer<AIAgentVersionSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

