/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qconnect.model.QueryConditionComparisonOperator;
import software.amazon.awssdk.services.qconnect.model.QueryConditionFieldName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryConditionItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueryConditionItem> {
    private static final SdkField<String> FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("field").getter(QueryConditionItem.getter(QueryConditionItem::fieldAsString)).setter(QueryConditionItem.setter(Builder::field)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("field").build()}).build();
    private static final SdkField<String> COMPARATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("comparator").getter(QueryConditionItem.getter(QueryConditionItem::comparatorAsString)).setter(QueryConditionItem.setter(Builder::comparator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comparator").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("value").getter(QueryConditionItem.getter(QueryConditionItem::value)).setter(QueryConditionItem.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_FIELD, COMPARATOR_FIELD, VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = QueryConditionItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String field;
    private final String comparator;
    private final String value;

    private QueryConditionItem(BuilderImpl builder) {
        this.field = builder.field;
        this.comparator = builder.comparator;
        this.value = builder.value;
    }

    public final QueryConditionFieldName field() {
        return QueryConditionFieldName.fromValue(this.field);
    }

    public final String fieldAsString() {
        return this.field;
    }

    public final QueryConditionComparisonOperator comparator() {
        return QueryConditionComparisonOperator.fromValue(this.comparator);
    }

    public final String comparatorAsString() {
        return this.comparator;
    }

    public final String value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.comparatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryConditionItem)) {
            return false;
        }
        QueryConditionItem other = (QueryConditionItem)obj;
        return Objects.equals(this.fieldAsString(), other.fieldAsString()) && Objects.equals(this.comparatorAsString(), other.comparatorAsString()) && Objects.equals(this.value(), other.value());
    }

    public final String toString() {
        return ToString.builder((String)"QueryConditionItem").add("Field", (Object)this.fieldAsString()).add("Comparator", (Object)this.comparatorAsString()).add("Value", (Object)this.value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "field": {
                return Optional.ofNullable(clazz.cast(this.fieldAsString()));
            }
            case "comparator": {
                return Optional.ofNullable(clazz.cast(this.comparatorAsString()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("field", FIELD_FIELD);
        map.put("comparator", COMPARATOR_FIELD);
        map.put("value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryConditionItem, T> g) {
        return obj -> g.apply((QueryConditionItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String field;
        private String comparator;
        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryConditionItem model) {
            this.field(model.field);
            this.comparator(model.comparator);
            this.value(model.value);
        }

        public final String getField() {
            return this.field;
        }

        public final void setField(String field) {
            this.field = field;
        }

        @Override
        public final Builder field(String field) {
            this.field = field;
            return this;
        }

        @Override
        public final Builder field(QueryConditionFieldName field) {
            this.field(field == null ? null : field.toString());
            return this;
        }

        public final String getComparator() {
            return this.comparator;
        }

        public final void setComparator(String comparator) {
            this.comparator = comparator;
        }

        @Override
        public final Builder comparator(String comparator) {
            this.comparator = comparator;
            return this;
        }

        @Override
        public final Builder comparator(QueryConditionComparisonOperator comparator) {
            this.comparator(comparator == null ? null : comparator.toString());
            return this;
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public QueryConditionItem build() {
            return new QueryConditionItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueryConditionItem> {
        public Builder field(String var1);

        public Builder field(QueryConditionFieldName var1);

        public Builder comparator(String var1);

        public Builder comparator(QueryConditionComparisonOperator var1);

        public Builder value(String var1);
    }
}

