/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qconnect.QConnectClient;
import software.amazon.awssdk.services.qconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.qconnect.model.ContentAssociationSummary;
import software.amazon.awssdk.services.qconnect.model.ListContentAssociationsRequest;
import software.amazon.awssdk.services.qconnect.model.ListContentAssociationsResponse;

public class ListContentAssociationsIterable
implements SdkIterable<ListContentAssociationsResponse> {
    private final QConnectClient client;
    private final ListContentAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListContentAssociationsIterable(QConnectClient client, ListContentAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListContentAssociationsResponseFetcher();
    }

    public Iterator<ListContentAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ContentAssociationSummary> contentAssociationSummaries() {
        Function<ListContentAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.contentAssociationSummaries() != null) {
                return response.contentAssociationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListContentAssociationsResponseFetcher
    implements SyncPageFetcher<ListContentAssociationsResponse> {
        private ListContentAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListContentAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListContentAssociationsResponse nextPage(ListContentAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListContentAssociationsIterable.this.client.listContentAssociations(ListContentAssociationsIterable.this.firstRequest);
            }
            return ListContentAssociationsIterable.this.client.listContentAssociations((ListContentAssociationsRequest)((Object)ListContentAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

