/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qconnect.model.ChunkingConfiguration;
import software.amazon.awssdk.services.qconnect.model.ParsingConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VectorIngestionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VectorIngestionConfiguration> {
    private static final SdkField<ChunkingConfiguration> CHUNKING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("chunkingConfiguration").getter(VectorIngestionConfiguration.getter(VectorIngestionConfiguration::chunkingConfiguration)).setter(VectorIngestionConfiguration.setter(Builder::chunkingConfiguration)).constructor(ChunkingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chunkingConfiguration").build()}).build();
    private static final SdkField<ParsingConfiguration> PARSING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("parsingConfiguration").getter(VectorIngestionConfiguration.getter(VectorIngestionConfiguration::parsingConfiguration)).setter(VectorIngestionConfiguration.setter(Builder::parsingConfiguration)).constructor(ParsingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parsingConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHUNKING_CONFIGURATION_FIELD, PARSING_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VectorIngestionConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ChunkingConfiguration chunkingConfiguration;
    private final ParsingConfiguration parsingConfiguration;

    private VectorIngestionConfiguration(BuilderImpl builder) {
        this.chunkingConfiguration = builder.chunkingConfiguration;
        this.parsingConfiguration = builder.parsingConfiguration;
    }

    public final ChunkingConfiguration chunkingConfiguration() {
        return this.chunkingConfiguration;
    }

    public final ParsingConfiguration parsingConfiguration() {
        return this.parsingConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.chunkingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.parsingConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VectorIngestionConfiguration)) {
            return false;
        }
        VectorIngestionConfiguration other = (VectorIngestionConfiguration)obj;
        return Objects.equals(this.chunkingConfiguration(), other.chunkingConfiguration()) && Objects.equals(this.parsingConfiguration(), other.parsingConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"VectorIngestionConfiguration").add("ChunkingConfiguration", (Object)this.chunkingConfiguration()).add("ParsingConfiguration", (Object)this.parsingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "chunkingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.chunkingConfiguration()));
            }
            case "parsingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.parsingConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("chunkingConfiguration", CHUNKING_CONFIGURATION_FIELD);
        map.put("parsingConfiguration", PARSING_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VectorIngestionConfiguration, T> g) {
        return obj -> g.apply((VectorIngestionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ChunkingConfiguration chunkingConfiguration;
        private ParsingConfiguration parsingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(VectorIngestionConfiguration model) {
            this.chunkingConfiguration(model.chunkingConfiguration);
            this.parsingConfiguration(model.parsingConfiguration);
        }

        public final ChunkingConfiguration.Builder getChunkingConfiguration() {
            return this.chunkingConfiguration != null ? this.chunkingConfiguration.toBuilder() : null;
        }

        public final void setChunkingConfiguration(ChunkingConfiguration.BuilderImpl chunkingConfiguration) {
            this.chunkingConfiguration = chunkingConfiguration != null ? chunkingConfiguration.build() : null;
        }

        @Override
        public final Builder chunkingConfiguration(ChunkingConfiguration chunkingConfiguration) {
            this.chunkingConfiguration = chunkingConfiguration;
            return this;
        }

        public final ParsingConfiguration.Builder getParsingConfiguration() {
            return this.parsingConfiguration != null ? this.parsingConfiguration.toBuilder() : null;
        }

        public final void setParsingConfiguration(ParsingConfiguration.BuilderImpl parsingConfiguration) {
            this.parsingConfiguration = parsingConfiguration != null ? parsingConfiguration.build() : null;
        }

        @Override
        public final Builder parsingConfiguration(ParsingConfiguration parsingConfiguration) {
            this.parsingConfiguration = parsingConfiguration;
            return this;
        }

        public VectorIngestionConfiguration build() {
            return new VectorIngestionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VectorIngestionConfiguration> {
        public Builder chunkingConfiguration(ChunkingConfiguration var1);

        default public Builder chunkingConfiguration(Consumer<ChunkingConfiguration.Builder> chunkingConfiguration) {
            return this.chunkingConfiguration((ChunkingConfiguration)((ChunkingConfiguration.Builder)ChunkingConfiguration.builder().applyMutation(chunkingConfiguration)).build());
        }

        public Builder parsingConfiguration(ParsingConfiguration var1);

        default public Builder parsingConfiguration(Consumer<ParsingConfiguration.Builder> parsingConfiguration) {
            return this.parsingConfiguration((ParsingConfiguration)((ParsingConfiguration.Builder)ParsingConfiguration.builder().applyMutation(parsingConfiguration)).build());
        }
    }
}

