/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data for the AI Agent.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AIAgentData implements SdkPojo, Serializable, ToCopyableBuilder<AIAgentData.Builder, AIAgentData> {
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistantId").getter(getter(AIAgentData::assistantId)).setter(setter(Builder::assistantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantId").build()).build();

    private static final SdkField<String> ASSISTANT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistantArn").getter(getter(AIAgentData::assistantArn)).setter(setter(Builder::assistantArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantArn").build()).build();

    private static final SdkField<String> AI_AGENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aiAgentId").getter(getter(AIAgentData::aiAgentId)).setter(setter(Builder::aiAgentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiAgentId").build()).build();

    private static final SdkField<String> AI_AGENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aiAgentArn").getter(getter(AIAgentData::aiAgentArn)).setter(setter(Builder::aiAgentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiAgentArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AIAgentData::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(AIAgentData::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<AIAgentConfiguration> CONFIGURATION_FIELD = SdkField
            .<AIAgentConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(AIAgentData::configuration)).setter(setter(Builder::configuration))
            .constructor(AIAgentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<Instant> MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("modifiedTime").getter(getter(AIAgentData::modifiedTime)).setter(setter(Builder::modifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedTime").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AIAgentData::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> VISIBILITY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("visibilityStatus").getter(getter(AIAgentData::visibilityStatusAsString))
            .setter(setter(Builder::visibilityStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("visibilityStatus").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(AIAgentData::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ORIGIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("origin")
            .getter(getter(AIAgentData::originAsString)).setter(setter(Builder::origin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("origin").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(AIAgentData::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSISTANT_ID_FIELD,
            ASSISTANT_ARN_FIELD, AI_AGENT_ID_FIELD, AI_AGENT_ARN_FIELD, NAME_FIELD, TYPE_FIELD, CONFIGURATION_FIELD,
            MODIFIED_TIME_FIELD, DESCRIPTION_FIELD, VISIBILITY_STATUS_FIELD, TAGS_FIELD, ORIGIN_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String assistantId;

    private final String assistantArn;

    private final String aiAgentId;

    private final String aiAgentArn;

    private final String name;

    private final String type;

    private final AIAgentConfiguration configuration;

    private final Instant modifiedTime;

    private final String description;

    private final String visibilityStatus;

    private final Map<String, String> tags;

    private final String origin;

    private final String status;

    private AIAgentData(BuilderImpl builder) {
        this.assistantId = builder.assistantId;
        this.assistantArn = builder.assistantArn;
        this.aiAgentId = builder.aiAgentId;
        this.aiAgentArn = builder.aiAgentArn;
        this.name = builder.name;
        this.type = builder.type;
        this.configuration = builder.configuration;
        this.modifiedTime = builder.modifiedTime;
        this.description = builder.description;
        this.visibilityStatus = builder.visibilityStatus;
        this.tags = builder.tags;
        this.origin = builder.origin;
        this.status = builder.status;
    }

    /**
     * <p>
     * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the
     * ARN.
     * </p>
     * 
     * @return The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain
     *         the ARN.
     */
    public final String assistantId() {
        return assistantId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
     */
    public final String assistantArn() {
        return assistantArn;
    }

    /**
     * <p>
     * The identifier of the AI Agent.
     * </p>
     * 
     * @return The identifier of the AI Agent.
     */
    public final String aiAgentId() {
        return aiAgentId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AI agent.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AI agent.
     */
    public final String aiAgentArn() {
        return aiAgentArn;
    }

    /**
     * <p>
     * The name of the AI Agent.
     * </p>
     * 
     * @return The name of the AI Agent.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of the AI Agent.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AIAgentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the AI Agent.
     * @see AIAgentType
     */
    public final AIAgentType type() {
        return AIAgentType.fromValue(type);
    }

    /**
     * <p>
     * The type of the AI Agent.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AIAgentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the AI Agent.
     * @see AIAgentType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Configuration for the AI Agent.
     * </p>
     * 
     * @return Configuration for the AI Agent.
     */
    public final AIAgentConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * The time the AI Agent was last modified.
     * </p>
     * 
     * @return The time the AI Agent was last modified.
     */
    public final Instant modifiedTime() {
        return modifiedTime;
    }

    /**
     * <p>
     * The description of the AI Agent.
     * </p>
     * 
     * @return The description of the AI Agent.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The visibility status of the AI Agent.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibilityStatus}
     * will return {@link VisibilityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #visibilityStatusAsString}.
     * </p>
     * 
     * @return The visibility status of the AI Agent.
     * @see VisibilityStatus
     */
    public final VisibilityStatus visibilityStatus() {
        return VisibilityStatus.fromValue(visibilityStatus);
    }

    /**
     * <p>
     * The visibility status of the AI Agent.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibilityStatus}
     * will return {@link VisibilityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #visibilityStatusAsString}.
     * </p>
     * 
     * @return The visibility status of the AI Agent.
     * @see VisibilityStatus
     */
    public final String visibilityStatusAsString() {
        return visibilityStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Specifies the origin of the AI Agent. <code>SYSTEM</code> for a default AI Agent created by Q in Connect or
     * <code>CUSTOMER</code> for an AI Agent created by calling AI Agent creation APIs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #origin} will
     * return {@link Origin#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #originAsString}.
     * </p>
     * 
     * @return Specifies the origin of the AI Agent. <code>SYSTEM</code> for a default AI Agent created by Q in Connect
     *         or <code>CUSTOMER</code> for an AI Agent created by calling AI Agent creation APIs.
     * @see Origin
     */
    public final Origin origin() {
        return Origin.fromValue(origin);
    }

    /**
     * <p>
     * Specifies the origin of the AI Agent. <code>SYSTEM</code> for a default AI Agent created by Q in Connect or
     * <code>CUSTOMER</code> for an AI Agent created by calling AI Agent creation APIs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #origin} will
     * return {@link Origin#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #originAsString}.
     * </p>
     * 
     * @return Specifies the origin of the AI Agent. <code>SYSTEM</code> for a default AI Agent created by Q in Connect
     *         or <code>CUSTOMER</code> for an AI Agent created by calling AI Agent creation APIs.
     * @see Origin
     */
    public final String originAsString() {
        return origin;
    }

    /**
     * <p>
     * The status of the AI Agent.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the AI Agent.
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * The status of the AI Agent.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the AI Agent.
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(assistantArn());
        hashCode = 31 * hashCode + Objects.hashCode(aiAgentId());
        hashCode = 31 * hashCode + Objects.hashCode(aiAgentArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(visibilityStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(originAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AIAgentData)) {
            return false;
        }
        AIAgentData other = (AIAgentData) obj;
        return Objects.equals(assistantId(), other.assistantId()) && Objects.equals(assistantArn(), other.assistantArn())
                && Objects.equals(aiAgentId(), other.aiAgentId()) && Objects.equals(aiAgentArn(), other.aiAgentArn())
                && Objects.equals(name(), other.name()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(configuration(), other.configuration()) && Objects.equals(modifiedTime(), other.modifiedTime())
                && Objects.equals(description(), other.description())
                && Objects.equals(visibilityStatusAsString(), other.visibilityStatusAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(originAsString(), other.originAsString())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AIAgentData").add("AssistantId", assistantId()).add("AssistantArn", assistantArn())
                .add("AiAgentId", aiAgentId()).add("AiAgentArn", aiAgentArn()).add("Name", name()).add("Type", typeAsString())
                .add("Configuration", configuration()).add("ModifiedTime", modifiedTime()).add("Description", description())
                .add("VisibilityStatus", visibilityStatusAsString()).add("Tags", hasTags() ? tags() : null)
                .add("Origin", originAsString()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assistantId":
            return Optional.ofNullable(clazz.cast(assistantId()));
        case "assistantArn":
            return Optional.ofNullable(clazz.cast(assistantArn()));
        case "aiAgentId":
            return Optional.ofNullable(clazz.cast(aiAgentId()));
        case "aiAgentArn":
            return Optional.ofNullable(clazz.cast(aiAgentArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "modifiedTime":
            return Optional.ofNullable(clazz.cast(modifiedTime()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "visibilityStatus":
            return Optional.ofNullable(clazz.cast(visibilityStatusAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "origin":
            return Optional.ofNullable(clazz.cast(originAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("assistantArn", ASSISTANT_ARN_FIELD);
        map.put("aiAgentId", AI_AGENT_ID_FIELD);
        map.put("aiAgentArn", AI_AGENT_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("modifiedTime", MODIFIED_TIME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("visibilityStatus", VISIBILITY_STATUS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("origin", ORIGIN_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AIAgentData, T> g) {
        return obj -> g.apply((AIAgentData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AIAgentData> {
        /**
         * <p>
         * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the
         * ARN.
         * </p>
         * 
         * @param assistantId
         *        The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot
         *        contain the ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantId(String assistantId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
         * </p>
         * 
         * @param assistantArn
         *        The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantArn(String assistantArn);

        /**
         * <p>
         * The identifier of the AI Agent.
         * </p>
         * 
         * @param aiAgentId
         *        The identifier of the AI Agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiAgentId(String aiAgentId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AI agent.
         * </p>
         * 
         * @param aiAgentArn
         *        The Amazon Resource Name (ARN) of the AI agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiAgentArn(String aiAgentArn);

        /**
         * <p>
         * The name of the AI Agent.
         * </p>
         * 
         * @param name
         *        The name of the AI Agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of the AI Agent.
         * </p>
         * 
         * @param type
         *        The type of the AI Agent.
         * @see AIAgentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AIAgentType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the AI Agent.
         * </p>
         * 
         * @param type
         *        The type of the AI Agent.
         * @see AIAgentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AIAgentType
         */
        Builder type(AIAgentType type);

        /**
         * <p>
         * Configuration for the AI Agent.
         * </p>
         * 
         * @param configuration
         *        Configuration for the AI Agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(AIAgentConfiguration configuration);

        /**
         * <p>
         * Configuration for the AI Agent.
         * </p>
         * This is a convenience method that creates an instance of the {@link AIAgentConfiguration.Builder} avoiding
         * the need to create one manually via {@link AIAgentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AIAgentConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #configuration(AIAgentConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link AIAgentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(AIAgentConfiguration)
         */
        default Builder configuration(Consumer<AIAgentConfiguration.Builder> configuration) {
            return configuration(AIAgentConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * The time the AI Agent was last modified.
         * </p>
         * 
         * @param modifiedTime
         *        The time the AI Agent was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedTime(Instant modifiedTime);

        /**
         * <p>
         * The description of the AI Agent.
         * </p>
         * 
         * @param description
         *        The description of the AI Agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The visibility status of the AI Agent.
         * </p>
         * 
         * @param visibilityStatus
         *        The visibility status of the AI Agent.
         * @see VisibilityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VisibilityStatus
         */
        Builder visibilityStatus(String visibilityStatus);

        /**
         * <p>
         * The visibility status of the AI Agent.
         * </p>
         * 
         * @param visibilityStatus
         *        The visibility status of the AI Agent.
         * @see VisibilityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VisibilityStatus
         */
        Builder visibilityStatus(VisibilityStatus visibilityStatus);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Specifies the origin of the AI Agent. <code>SYSTEM</code> for a default AI Agent created by Q in Connect or
         * <code>CUSTOMER</code> for an AI Agent created by calling AI Agent creation APIs.
         * </p>
         * 
         * @param origin
         *        Specifies the origin of the AI Agent. <code>SYSTEM</code> for a default AI Agent created by Q in
         *        Connect or <code>CUSTOMER</code> for an AI Agent created by calling AI Agent creation APIs.
         * @see Origin
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Origin
         */
        Builder origin(String origin);

        /**
         * <p>
         * Specifies the origin of the AI Agent. <code>SYSTEM</code> for a default AI Agent created by Q in Connect or
         * <code>CUSTOMER</code> for an AI Agent created by calling AI Agent creation APIs.
         * </p>
         * 
         * @param origin
         *        Specifies the origin of the AI Agent. <code>SYSTEM</code> for a default AI Agent created by Q in
         *        Connect or <code>CUSTOMER</code> for an AI Agent created by calling AI Agent creation APIs.
         * @see Origin
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Origin
         */
        Builder origin(Origin origin);

        /**
         * <p>
         * The status of the AI Agent.
         * </p>
         * 
         * @param status
         *        The status of the AI Agent.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the AI Agent.
         * </p>
         * 
         * @param status
         *        The status of the AI Agent.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);
    }

    static final class BuilderImpl implements Builder {
        private String assistantId;

        private String assistantArn;

        private String aiAgentId;

        private String aiAgentArn;

        private String name;

        private String type;

        private AIAgentConfiguration configuration;

        private Instant modifiedTime;

        private String description;

        private String visibilityStatus;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String origin;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(AIAgentData model) {
            assistantId(model.assistantId);
            assistantArn(model.assistantArn);
            aiAgentId(model.aiAgentId);
            aiAgentArn(model.aiAgentArn);
            name(model.name);
            type(model.type);
            configuration(model.configuration);
            modifiedTime(model.modifiedTime);
            description(model.description);
            visibilityStatus(model.visibilityStatus);
            tags(model.tags);
            origin(model.origin);
            status(model.status);
        }

        public final String getAssistantId() {
            return assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getAssistantArn() {
            return assistantArn;
        }

        public final void setAssistantArn(String assistantArn) {
            this.assistantArn = assistantArn;
        }

        @Override
        public final Builder assistantArn(String assistantArn) {
            this.assistantArn = assistantArn;
            return this;
        }

        public final String getAiAgentId() {
            return aiAgentId;
        }

        public final void setAiAgentId(String aiAgentId) {
            this.aiAgentId = aiAgentId;
        }

        @Override
        public final Builder aiAgentId(String aiAgentId) {
            this.aiAgentId = aiAgentId;
            return this;
        }

        public final String getAiAgentArn() {
            return aiAgentArn;
        }

        public final void setAiAgentArn(String aiAgentArn) {
            this.aiAgentArn = aiAgentArn;
        }

        @Override
        public final Builder aiAgentArn(String aiAgentArn) {
            this.aiAgentArn = aiAgentArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AIAgentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final AIAgentConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(AIAgentConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(AIAgentConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final Instant getModifiedTime() {
            return modifiedTime;
        }

        public final void setModifiedTime(Instant modifiedTime) {
            this.modifiedTime = modifiedTime;
        }

        @Override
        public final Builder modifiedTime(Instant modifiedTime) {
            this.modifiedTime = modifiedTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getVisibilityStatus() {
            return visibilityStatus;
        }

        public final void setVisibilityStatus(String visibilityStatus) {
            this.visibilityStatus = visibilityStatus;
        }

        @Override
        public final Builder visibilityStatus(String visibilityStatus) {
            this.visibilityStatus = visibilityStatus;
            return this;
        }

        @Override
        public final Builder visibilityStatus(VisibilityStatus visibilityStatus) {
            this.visibilityStatus(visibilityStatus == null ? null : visibilityStatus.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getOrigin() {
            return origin;
        }

        public final void setOrigin(String origin) {
            this.origin = origin;
        }

        @Override
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        @Override
        public final Builder origin(Origin origin) {
            this.origin(origin == null ? null : origin.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public AIAgentData build() {
            return new AIAgentData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
