/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about how to handle harmful content.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AIGuardrailContentPolicyConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AIGuardrailContentPolicyConfig.Builder, AIGuardrailContentPolicyConfig> {
    private static final SdkField<List<GuardrailContentFilterConfig>> FILTERS_CONFIG_FIELD = SdkField
            .<List<GuardrailContentFilterConfig>> builder(MarshallingType.LIST)
            .memberName("filtersConfig")
            .getter(getter(AIGuardrailContentPolicyConfig::filtersConfig))
            .setter(setter(Builder::filtersConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filtersConfig").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GuardrailContentFilterConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(GuardrailContentFilterConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<GuardrailContentFilterConfig> filtersConfig;

    private AIGuardrailContentPolicyConfig(BuilderImpl builder) {
        this.filtersConfig = builder.filtersConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the FiltersConfig property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFiltersConfig() {
        return filtersConfig != null && !(filtersConfig instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains the type of the content filter and how strongly it should apply to prompts and model responses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFiltersConfig} method.
     * </p>
     * 
     * @return Contains the type of the content filter and how strongly it should apply to prompts and model responses.
     */
    public final List<GuardrailContentFilterConfig> filtersConfig() {
        return filtersConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasFiltersConfig() ? filtersConfig() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AIGuardrailContentPolicyConfig)) {
            return false;
        }
        AIGuardrailContentPolicyConfig other = (AIGuardrailContentPolicyConfig) obj;
        return hasFiltersConfig() == other.hasFiltersConfig() && Objects.equals(filtersConfig(), other.filtersConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AIGuardrailContentPolicyConfig")
                .add("FiltersConfig", hasFiltersConfig() ? filtersConfig() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filtersConfig":
            return Optional.ofNullable(clazz.cast(filtersConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("filtersConfig", FILTERS_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AIGuardrailContentPolicyConfig, T> g) {
        return obj -> g.apply((AIGuardrailContentPolicyConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AIGuardrailContentPolicyConfig> {
        /**
         * <p>
         * Contains the type of the content filter and how strongly it should apply to prompts and model responses.
         * </p>
         * 
         * @param filtersConfig
         *        Contains the type of the content filter and how strongly it should apply to prompts and model
         *        responses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filtersConfig(Collection<GuardrailContentFilterConfig> filtersConfig);

        /**
         * <p>
         * Contains the type of the content filter and how strongly it should apply to prompts and model responses.
         * </p>
         * 
         * @param filtersConfig
         *        Contains the type of the content filter and how strongly it should apply to prompts and model
         *        responses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filtersConfig(GuardrailContentFilterConfig... filtersConfig);

        /**
         * <p>
         * Contains the type of the content filter and how strongly it should apply to prompts and model responses.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.GuardrailContentFilterConfig.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.qconnect.model.GuardrailContentFilterConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.GuardrailContentFilterConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #filtersConfig(List<GuardrailContentFilterConfig>)}.
         * 
         * @param filtersConfig
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.GuardrailContentFilterConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filtersConfig(java.util.Collection<GuardrailContentFilterConfig>)
         */
        Builder filtersConfig(Consumer<GuardrailContentFilterConfig.Builder>... filtersConfig);
    }

    static final class BuilderImpl implements Builder {
        private List<GuardrailContentFilterConfig> filtersConfig = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AIGuardrailContentPolicyConfig model) {
            filtersConfig(model.filtersConfig);
        }

        public final List<GuardrailContentFilterConfig.Builder> getFiltersConfig() {
            List<GuardrailContentFilterConfig.Builder> result = GuardrailContentFiltersConfigCopier
                    .copyToBuilder(this.filtersConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFiltersConfig(Collection<GuardrailContentFilterConfig.BuilderImpl> filtersConfig) {
            this.filtersConfig = GuardrailContentFiltersConfigCopier.copyFromBuilder(filtersConfig);
        }

        @Override
        public final Builder filtersConfig(Collection<GuardrailContentFilterConfig> filtersConfig) {
            this.filtersConfig = GuardrailContentFiltersConfigCopier.copy(filtersConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filtersConfig(GuardrailContentFilterConfig... filtersConfig) {
            filtersConfig(Arrays.asList(filtersConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filtersConfig(Consumer<GuardrailContentFilterConfig.Builder>... filtersConfig) {
            filtersConfig(Stream.of(filtersConfig).map(c -> GuardrailContentFilterConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AIGuardrailContentPolicyConfig build() {
            return new AIGuardrailContentPolicyConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
