/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of the AI Prompt.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AIPromptSummary implements SdkPojo, Serializable, ToCopyableBuilder<AIPromptSummary.Builder, AIPromptSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AIPromptSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistantId").getter(getter(AIPromptSummary::assistantId)).setter(setter(Builder::assistantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantId").build()).build();

    private static final SdkField<String> ASSISTANT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistantArn").getter(getter(AIPromptSummary::assistantArn)).setter(setter(Builder::assistantArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantArn").build()).build();

    private static final SdkField<String> AI_PROMPT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aiPromptId").getter(getter(AIPromptSummary::aiPromptId)).setter(setter(Builder::aiPromptId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiPromptId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(AIPromptSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> AI_PROMPT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aiPromptArn").getter(getter(AIPromptSummary::aiPromptArn)).setter(setter(Builder::aiPromptArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiPromptArn").build()).build();

    private static final SdkField<Instant> MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("modifiedTime").getter(getter(AIPromptSummary::modifiedTime)).setter(setter(Builder::modifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedTime").build()).build();

    private static final SdkField<String> TEMPLATE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateType").getter(getter(AIPromptSummary::templateTypeAsString))
            .setter(setter(Builder::templateType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateType").build()).build();

    private static final SdkField<String> MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelId").getter(getter(AIPromptSummary::modelId)).setter(setter(Builder::modelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()).build();

    private static final SdkField<String> API_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("apiFormat").getter(getter(AIPromptSummary::apiFormatAsString)).setter(setter(Builder::apiFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiFormat").build()).build();

    private static final SdkField<String> VISIBILITY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("visibilityStatus").getter(getter(AIPromptSummary::visibilityStatusAsString))
            .setter(setter(Builder::visibilityStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("visibilityStatus").build()).build();

    private static final SdkField<String> ORIGIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("origin")
            .getter(getter(AIPromptSummary::originAsString)).setter(setter(Builder::origin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("origin").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AIPromptSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(AIPromptSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(AIPromptSummary::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            ASSISTANT_ID_FIELD, ASSISTANT_ARN_FIELD, AI_PROMPT_ID_FIELD, TYPE_FIELD, AI_PROMPT_ARN_FIELD, MODIFIED_TIME_FIELD,
            TEMPLATE_TYPE_FIELD, MODEL_ID_FIELD, API_FORMAT_FIELD, VISIBILITY_STATUS_FIELD, ORIGIN_FIELD, DESCRIPTION_FIELD,
            STATUS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String assistantId;

    private final String assistantArn;

    private final String aiPromptId;

    private final String type;

    private final String aiPromptArn;

    private final Instant modifiedTime;

    private final String templateType;

    private final String modelId;

    private final String apiFormat;

    private final String visibilityStatus;

    private final String origin;

    private final String description;

    private final String status;

    private final Map<String, String> tags;

    private AIPromptSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.assistantId = builder.assistantId;
        this.assistantArn = builder.assistantArn;
        this.aiPromptId = builder.aiPromptId;
        this.type = builder.type;
        this.aiPromptArn = builder.aiPromptArn;
        this.modifiedTime = builder.modifiedTime;
        this.templateType = builder.templateType;
        this.modelId = builder.modelId;
        this.apiFormat = builder.apiFormat;
        this.visibilityStatus = builder.visibilityStatus;
        this.origin = builder.origin;
        this.description = builder.description;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the AI Prompt.
     * </p>
     * 
     * @return The name of the AI Prompt.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the
     * ARN.
     * </p>
     * 
     * @return The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain
     *         the ARN.
     */
    public final String assistantId() {
        return assistantId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
     */
    public final String assistantArn() {
        return assistantArn;
    }

    /**
     * <p>
     * The identifier of the Amazon Q in Connect AI prompt.
     * </p>
     * 
     * @return The identifier of the Amazon Q in Connect AI prompt.
     */
    public final String aiPromptId() {
        return aiPromptId;
    }

    /**
     * <p>
     * The type of this AI Prompt.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AIPromptType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of this AI Prompt.
     * @see AIPromptType
     */
    public final AIPromptType type() {
        return AIPromptType.fromValue(type);
    }

    /**
     * <p>
     * The type of this AI Prompt.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AIPromptType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of this AI Prompt.
     * @see AIPromptType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AI Prompt.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AI Prompt.
     */
    public final String aiPromptArn() {
        return aiPromptArn;
    }

    /**
     * <p>
     * The time the AI Prompt was last modified.
     * </p>
     * 
     * @return The time the AI Prompt was last modified.
     */
    public final Instant modifiedTime() {
        return modifiedTime;
    }

    /**
     * <p>
     * The type of the prompt template for this AI Prompt.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #templateType} will
     * return {@link AIPromptTemplateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #templateTypeAsString}.
     * </p>
     * 
     * @return The type of the prompt template for this AI Prompt.
     * @see AIPromptTemplateType
     */
    public final AIPromptTemplateType templateType() {
        return AIPromptTemplateType.fromValue(templateType);
    }

    /**
     * <p>
     * The type of the prompt template for this AI Prompt.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #templateType} will
     * return {@link AIPromptTemplateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #templateTypeAsString}.
     * </p>
     * 
     * @return The type of the prompt template for this AI Prompt.
     * @see AIPromptTemplateType
     */
    public final String templateTypeAsString() {
        return templateType;
    }

    /**
     * <p>
     * The identifier of the model used for this AI Prompt. Model Ids supported are:
     * <code>anthropic.claude-3-haiku-20240307-v1:0</code>.
     * </p>
     * 
     * @return The identifier of the model used for this AI Prompt. Model Ids supported are:
     *         <code>anthropic.claude-3-haiku-20240307-v1:0</code>.
     */
    public final String modelId() {
        return modelId;
    }

    /**
     * <p>
     * The API format used for this AI Prompt.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #apiFormat} will
     * return {@link AIPromptAPIFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #apiFormatAsString}.
     * </p>
     * 
     * @return The API format used for this AI Prompt.
     * @see AIPromptAPIFormat
     */
    public final AIPromptAPIFormat apiFormat() {
        return AIPromptAPIFormat.fromValue(apiFormat);
    }

    /**
     * <p>
     * The API format used for this AI Prompt.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #apiFormat} will
     * return {@link AIPromptAPIFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #apiFormatAsString}.
     * </p>
     * 
     * @return The API format used for this AI Prompt.
     * @see AIPromptAPIFormat
     */
    public final String apiFormatAsString() {
        return apiFormat;
    }

    /**
     * <p>
     * The visibility status of the AI Prompt.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibilityStatus}
     * will return {@link VisibilityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #visibilityStatusAsString}.
     * </p>
     * 
     * @return The visibility status of the AI Prompt.
     * @see VisibilityStatus
     */
    public final VisibilityStatus visibilityStatus() {
        return VisibilityStatus.fromValue(visibilityStatus);
    }

    /**
     * <p>
     * The visibility status of the AI Prompt.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibilityStatus}
     * will return {@link VisibilityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #visibilityStatusAsString}.
     * </p>
     * 
     * @return The visibility status of the AI Prompt.
     * @see VisibilityStatus
     */
    public final String visibilityStatusAsString() {
        return visibilityStatus;
    }

    /**
     * <p>
     * The origin of the AI Prompt. <code>SYSTEM</code> for a default AI Prompt created by Q in Connect or
     * <code>CUSTOMER</code> for an AI Prompt created by calling AI Prompt creation APIs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #origin} will
     * return {@link Origin#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #originAsString}.
     * </p>
     * 
     * @return The origin of the AI Prompt. <code>SYSTEM</code> for a default AI Prompt created by Q in Connect or
     *         <code>CUSTOMER</code> for an AI Prompt created by calling AI Prompt creation APIs.
     * @see Origin
     */
    public final Origin origin() {
        return Origin.fromValue(origin);
    }

    /**
     * <p>
     * The origin of the AI Prompt. <code>SYSTEM</code> for a default AI Prompt created by Q in Connect or
     * <code>CUSTOMER</code> for an AI Prompt created by calling AI Prompt creation APIs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #origin} will
     * return {@link Origin#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #originAsString}.
     * </p>
     * 
     * @return The origin of the AI Prompt. <code>SYSTEM</code> for a default AI Prompt created by Q in Connect or
     *         <code>CUSTOMER</code> for an AI Prompt created by calling AI Prompt creation APIs.
     * @see Origin
     */
    public final String originAsString() {
        return origin;
    }

    /**
     * <p>
     * The description of the AI Prompt.
     * </p>
     * 
     * @return The description of the AI Prompt.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The status of the AI Prompt.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the AI Prompt.
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * The status of the AI Prompt.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the AI Prompt.
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(assistantArn());
        hashCode = 31 * hashCode + Objects.hashCode(aiPromptId());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(aiPromptArn());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(templateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(modelId());
        hashCode = 31 * hashCode + Objects.hashCode(apiFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(visibilityStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(originAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AIPromptSummary)) {
            return false;
        }
        AIPromptSummary other = (AIPromptSummary) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(assistantId(), other.assistantId())
                && Objects.equals(assistantArn(), other.assistantArn()) && Objects.equals(aiPromptId(), other.aiPromptId())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(aiPromptArn(), other.aiPromptArn())
                && Objects.equals(modifiedTime(), other.modifiedTime())
                && Objects.equals(templateTypeAsString(), other.templateTypeAsString())
                && Objects.equals(modelId(), other.modelId()) && Objects.equals(apiFormatAsString(), other.apiFormatAsString())
                && Objects.equals(visibilityStatusAsString(), other.visibilityStatusAsString())
                && Objects.equals(originAsString(), other.originAsString()) && Objects.equals(description(), other.description())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AIPromptSummary").add("Name", name()).add("AssistantId", assistantId())
                .add("AssistantArn", assistantArn()).add("AiPromptId", aiPromptId()).add("Type", typeAsString())
                .add("AiPromptArn", aiPromptArn()).add("ModifiedTime", modifiedTime())
                .add("TemplateType", templateTypeAsString()).add("ModelId", modelId()).add("ApiFormat", apiFormatAsString())
                .add("VisibilityStatus", visibilityStatusAsString()).add("Origin", originAsString())
                .add("Description", description()).add("Status", statusAsString()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "assistantId":
            return Optional.ofNullable(clazz.cast(assistantId()));
        case "assistantArn":
            return Optional.ofNullable(clazz.cast(assistantArn()));
        case "aiPromptId":
            return Optional.ofNullable(clazz.cast(aiPromptId()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "aiPromptArn":
            return Optional.ofNullable(clazz.cast(aiPromptArn()));
        case "modifiedTime":
            return Optional.ofNullable(clazz.cast(modifiedTime()));
        case "templateType":
            return Optional.ofNullable(clazz.cast(templateTypeAsString()));
        case "modelId":
            return Optional.ofNullable(clazz.cast(modelId()));
        case "apiFormat":
            return Optional.ofNullable(clazz.cast(apiFormatAsString()));
        case "visibilityStatus":
            return Optional.ofNullable(clazz.cast(visibilityStatusAsString()));
        case "origin":
            return Optional.ofNullable(clazz.cast(originAsString()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("assistantArn", ASSISTANT_ARN_FIELD);
        map.put("aiPromptId", AI_PROMPT_ID_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("aiPromptArn", AI_PROMPT_ARN_FIELD);
        map.put("modifiedTime", MODIFIED_TIME_FIELD);
        map.put("templateType", TEMPLATE_TYPE_FIELD);
        map.put("modelId", MODEL_ID_FIELD);
        map.put("apiFormat", API_FORMAT_FIELD);
        map.put("visibilityStatus", VISIBILITY_STATUS_FIELD);
        map.put("origin", ORIGIN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AIPromptSummary, T> g) {
        return obj -> g.apply((AIPromptSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AIPromptSummary> {
        /**
         * <p>
         * The name of the AI Prompt.
         * </p>
         * 
         * @param name
         *        The name of the AI Prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the
         * ARN.
         * </p>
         * 
         * @param assistantId
         *        The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot
         *        contain the ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantId(String assistantId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
         * </p>
         * 
         * @param assistantArn
         *        The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantArn(String assistantArn);

        /**
         * <p>
         * The identifier of the Amazon Q in Connect AI prompt.
         * </p>
         * 
         * @param aiPromptId
         *        The identifier of the Amazon Q in Connect AI prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiPromptId(String aiPromptId);

        /**
         * <p>
         * The type of this AI Prompt.
         * </p>
         * 
         * @param type
         *        The type of this AI Prompt.
         * @see AIPromptType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AIPromptType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of this AI Prompt.
         * </p>
         * 
         * @param type
         *        The type of this AI Prompt.
         * @see AIPromptType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AIPromptType
         */
        Builder type(AIPromptType type);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AI Prompt.
         * </p>
         * 
         * @param aiPromptArn
         *        The Amazon Resource Name (ARN) of the AI Prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiPromptArn(String aiPromptArn);

        /**
         * <p>
         * The time the AI Prompt was last modified.
         * </p>
         * 
         * @param modifiedTime
         *        The time the AI Prompt was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedTime(Instant modifiedTime);

        /**
         * <p>
         * The type of the prompt template for this AI Prompt.
         * </p>
         * 
         * @param templateType
         *        The type of the prompt template for this AI Prompt.
         * @see AIPromptTemplateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AIPromptTemplateType
         */
        Builder templateType(String templateType);

        /**
         * <p>
         * The type of the prompt template for this AI Prompt.
         * </p>
         * 
         * @param templateType
         *        The type of the prompt template for this AI Prompt.
         * @see AIPromptTemplateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AIPromptTemplateType
         */
        Builder templateType(AIPromptTemplateType templateType);

        /**
         * <p>
         * The identifier of the model used for this AI Prompt. Model Ids supported are:
         * <code>anthropic.claude-3-haiku-20240307-v1:0</code>.
         * </p>
         * 
         * @param modelId
         *        The identifier of the model used for this AI Prompt. Model Ids supported are:
         *        <code>anthropic.claude-3-haiku-20240307-v1:0</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelId(String modelId);

        /**
         * <p>
         * The API format used for this AI Prompt.
         * </p>
         * 
         * @param apiFormat
         *        The API format used for this AI Prompt.
         * @see AIPromptAPIFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AIPromptAPIFormat
         */
        Builder apiFormat(String apiFormat);

        /**
         * <p>
         * The API format used for this AI Prompt.
         * </p>
         * 
         * @param apiFormat
         *        The API format used for this AI Prompt.
         * @see AIPromptAPIFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AIPromptAPIFormat
         */
        Builder apiFormat(AIPromptAPIFormat apiFormat);

        /**
         * <p>
         * The visibility status of the AI Prompt.
         * </p>
         * 
         * @param visibilityStatus
         *        The visibility status of the AI Prompt.
         * @see VisibilityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VisibilityStatus
         */
        Builder visibilityStatus(String visibilityStatus);

        /**
         * <p>
         * The visibility status of the AI Prompt.
         * </p>
         * 
         * @param visibilityStatus
         *        The visibility status of the AI Prompt.
         * @see VisibilityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VisibilityStatus
         */
        Builder visibilityStatus(VisibilityStatus visibilityStatus);

        /**
         * <p>
         * The origin of the AI Prompt. <code>SYSTEM</code> for a default AI Prompt created by Q in Connect or
         * <code>CUSTOMER</code> for an AI Prompt created by calling AI Prompt creation APIs.
         * </p>
         * 
         * @param origin
         *        The origin of the AI Prompt. <code>SYSTEM</code> for a default AI Prompt created by Q in Connect or
         *        <code>CUSTOMER</code> for an AI Prompt created by calling AI Prompt creation APIs.
         * @see Origin
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Origin
         */
        Builder origin(String origin);

        /**
         * <p>
         * The origin of the AI Prompt. <code>SYSTEM</code> for a default AI Prompt created by Q in Connect or
         * <code>CUSTOMER</code> for an AI Prompt created by calling AI Prompt creation APIs.
         * </p>
         * 
         * @param origin
         *        The origin of the AI Prompt. <code>SYSTEM</code> for a default AI Prompt created by Q in Connect or
         *        <code>CUSTOMER</code> for an AI Prompt created by calling AI Prompt creation APIs.
         * @see Origin
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Origin
         */
        Builder origin(Origin origin);

        /**
         * <p>
         * The description of the AI Prompt.
         * </p>
         * 
         * @param description
         *        The description of the AI Prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The status of the AI Prompt.
         * </p>
         * 
         * @param status
         *        The status of the AI Prompt.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the AI Prompt.
         * </p>
         * 
         * @param status
         *        The status of the AI Prompt.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String assistantId;

        private String assistantArn;

        private String aiPromptId;

        private String type;

        private String aiPromptArn;

        private Instant modifiedTime;

        private String templateType;

        private String modelId;

        private String apiFormat;

        private String visibilityStatus;

        private String origin;

        private String description;

        private String status;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AIPromptSummary model) {
            name(model.name);
            assistantId(model.assistantId);
            assistantArn(model.assistantArn);
            aiPromptId(model.aiPromptId);
            type(model.type);
            aiPromptArn(model.aiPromptArn);
            modifiedTime(model.modifiedTime);
            templateType(model.templateType);
            modelId(model.modelId);
            apiFormat(model.apiFormat);
            visibilityStatus(model.visibilityStatus);
            origin(model.origin);
            description(model.description);
            status(model.status);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAssistantId() {
            return assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getAssistantArn() {
            return assistantArn;
        }

        public final void setAssistantArn(String assistantArn) {
            this.assistantArn = assistantArn;
        }

        @Override
        public final Builder assistantArn(String assistantArn) {
            this.assistantArn = assistantArn;
            return this;
        }

        public final String getAiPromptId() {
            return aiPromptId;
        }

        public final void setAiPromptId(String aiPromptId) {
            this.aiPromptId = aiPromptId;
        }

        @Override
        public final Builder aiPromptId(String aiPromptId) {
            this.aiPromptId = aiPromptId;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AIPromptType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getAiPromptArn() {
            return aiPromptArn;
        }

        public final void setAiPromptArn(String aiPromptArn) {
            this.aiPromptArn = aiPromptArn;
        }

        @Override
        public final Builder aiPromptArn(String aiPromptArn) {
            this.aiPromptArn = aiPromptArn;
            return this;
        }

        public final Instant getModifiedTime() {
            return modifiedTime;
        }

        public final void setModifiedTime(Instant modifiedTime) {
            this.modifiedTime = modifiedTime;
        }

        @Override
        public final Builder modifiedTime(Instant modifiedTime) {
            this.modifiedTime = modifiedTime;
            return this;
        }

        public final String getTemplateType() {
            return templateType;
        }

        public final void setTemplateType(String templateType) {
            this.templateType = templateType;
        }

        @Override
        public final Builder templateType(String templateType) {
            this.templateType = templateType;
            return this;
        }

        @Override
        public final Builder templateType(AIPromptTemplateType templateType) {
            this.templateType(templateType == null ? null : templateType.toString());
            return this;
        }

        public final String getModelId() {
            return modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final String getApiFormat() {
            return apiFormat;
        }

        public final void setApiFormat(String apiFormat) {
            this.apiFormat = apiFormat;
        }

        @Override
        public final Builder apiFormat(String apiFormat) {
            this.apiFormat = apiFormat;
            return this;
        }

        @Override
        public final Builder apiFormat(AIPromptAPIFormat apiFormat) {
            this.apiFormat(apiFormat == null ? null : apiFormat.toString());
            return this;
        }

        public final String getVisibilityStatus() {
            return visibilityStatus;
        }

        public final void setVisibilityStatus(String visibilityStatus) {
            this.visibilityStatus = visibilityStatus;
        }

        @Override
        public final Builder visibilityStatus(String visibilityStatus) {
            this.visibilityStatus = visibilityStatus;
            return this;
        }

        @Override
        public final Builder visibilityStatus(VisibilityStatus visibilityStatus) {
            this.visibilityStatus(visibilityStatus == null ? null : visibilityStatus.toString());
            return this;
        }

        public final String getOrigin() {
            return origin;
        }

        public final void setOrigin(String origin) {
            this.origin = origin;
        }

        @Override
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        @Override
        public final Builder origin(Origin origin) {
            this.origin(origin == null ? null : origin.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public AIPromptSummary build() {
            return new AIPromptSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
