/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the assistant association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssistantAssociationData implements SdkPojo, Serializable,
        ToCopyableBuilder<AssistantAssociationData.Builder, AssistantAssociationData> {
    private static final SdkField<String> ASSISTANT_ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistantAssociationId").getter(getter(AssistantAssociationData::assistantAssociationId))
            .setter(setter(Builder::assistantAssociationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantAssociationId").build())
            .build();

    private static final SdkField<String> ASSISTANT_ASSOCIATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistantAssociationArn").getter(getter(AssistantAssociationData::assistantAssociationArn))
            .setter(setter(Builder::assistantAssociationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantAssociationArn").build())
            .build();

    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistantId").getter(getter(AssistantAssociationData::assistantId)).setter(setter(Builder::assistantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantId").build()).build();

    private static final SdkField<String> ASSISTANT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistantArn").getter(getter(AssistantAssociationData::assistantArn))
            .setter(setter(Builder::assistantArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantArn").build()).build();

    private static final SdkField<String> ASSOCIATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("associationType").getter(getter(AssistantAssociationData::associationTypeAsString))
            .setter(setter(Builder::associationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationType").build()).build();

    private static final SdkField<AssistantAssociationOutputData> ASSOCIATION_DATA_FIELD = SdkField
            .<AssistantAssociationOutputData> builder(MarshallingType.SDK_POJO).memberName("associationData")
            .getter(getter(AssistantAssociationData::associationData)).setter(setter(Builder::associationData))
            .constructor(AssistantAssociationOutputData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationData").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(AssistantAssociationData::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ASSISTANT_ASSOCIATION_ID_FIELD, ASSISTANT_ASSOCIATION_ARN_FIELD, ASSISTANT_ID_FIELD, ASSISTANT_ARN_FIELD,
            ASSOCIATION_TYPE_FIELD, ASSOCIATION_DATA_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String assistantAssociationId;

    private final String assistantAssociationArn;

    private final String assistantId;

    private final String assistantArn;

    private final String associationType;

    private final AssistantAssociationOutputData associationData;

    private final Map<String, String> tags;

    private AssistantAssociationData(BuilderImpl builder) {
        this.assistantAssociationId = builder.assistantAssociationId;
        this.assistantAssociationArn = builder.assistantAssociationArn;
        this.assistantId = builder.assistantId;
        this.assistantArn = builder.assistantArn;
        this.associationType = builder.associationType;
        this.associationData = builder.associationData;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The identifier of the assistant association.
     * </p>
     * 
     * @return The identifier of the assistant association.
     */
    public final String assistantAssociationId() {
        return assistantAssociationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the assistant association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the assistant association.
     */
    public final String assistantAssociationArn() {
        return assistantAssociationArn;
    }

    /**
     * <p>
     * The identifier of the Amazon Q in Connect assistant.
     * </p>
     * 
     * @return The identifier of the Amazon Q in Connect assistant.
     */
    public final String assistantId() {
        return assistantId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
     */
    public final String assistantArn() {
        return assistantArn;
    }

    /**
     * <p>
     * The type of association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationType}
     * will return {@link AssociationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #associationTypeAsString}.
     * </p>
     * 
     * @return The type of association.
     * @see AssociationType
     */
    public final AssociationType associationType() {
        return AssociationType.fromValue(associationType);
    }

    /**
     * <p>
     * The type of association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationType}
     * will return {@link AssociationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #associationTypeAsString}.
     * </p>
     * 
     * @return The type of association.
     * @see AssociationType
     */
    public final String associationTypeAsString() {
        return associationType;
    }

    /**
     * <p>
     * A union type that currently has a single argument, the knowledge base ID.
     * </p>
     * 
     * @return A union type that currently has a single argument, the knowledge base ID.
     */
    public final AssistantAssociationOutputData associationData() {
        return associationData;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assistantAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(assistantAssociationArn());
        hashCode = 31 * hashCode + Objects.hashCode(assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(assistantArn());
        hashCode = 31 * hashCode + Objects.hashCode(associationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(associationData());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssistantAssociationData)) {
            return false;
        }
        AssistantAssociationData other = (AssistantAssociationData) obj;
        return Objects.equals(assistantAssociationId(), other.assistantAssociationId())
                && Objects.equals(assistantAssociationArn(), other.assistantAssociationArn())
                && Objects.equals(assistantId(), other.assistantId()) && Objects.equals(assistantArn(), other.assistantArn())
                && Objects.equals(associationTypeAsString(), other.associationTypeAsString())
                && Objects.equals(associationData(), other.associationData()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssistantAssociationData").add("AssistantAssociationId", assistantAssociationId())
                .add("AssistantAssociationArn", assistantAssociationArn()).add("AssistantId", assistantId())
                .add("AssistantArn", assistantArn()).add("AssociationType", associationTypeAsString())
                .add("AssociationData", associationData()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assistantAssociationId":
            return Optional.ofNullable(clazz.cast(assistantAssociationId()));
        case "assistantAssociationArn":
            return Optional.ofNullable(clazz.cast(assistantAssociationArn()));
        case "assistantId":
            return Optional.ofNullable(clazz.cast(assistantId()));
        case "assistantArn":
            return Optional.ofNullable(clazz.cast(assistantArn()));
        case "associationType":
            return Optional.ofNullable(clazz.cast(associationTypeAsString()));
        case "associationData":
            return Optional.ofNullable(clazz.cast(associationData()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assistantAssociationId", ASSISTANT_ASSOCIATION_ID_FIELD);
        map.put("assistantAssociationArn", ASSISTANT_ASSOCIATION_ARN_FIELD);
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("assistantArn", ASSISTANT_ARN_FIELD);
        map.put("associationType", ASSOCIATION_TYPE_FIELD);
        map.put("associationData", ASSOCIATION_DATA_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssistantAssociationData, T> g) {
        return obj -> g.apply((AssistantAssociationData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssistantAssociationData> {
        /**
         * <p>
         * The identifier of the assistant association.
         * </p>
         * 
         * @param assistantAssociationId
         *        The identifier of the assistant association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantAssociationId(String assistantAssociationId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the assistant association.
         * </p>
         * 
         * @param assistantAssociationArn
         *        The Amazon Resource Name (ARN) of the assistant association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantAssociationArn(String assistantAssociationArn);

        /**
         * <p>
         * The identifier of the Amazon Q in Connect assistant.
         * </p>
         * 
         * @param assistantId
         *        The identifier of the Amazon Q in Connect assistant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantId(String assistantId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
         * </p>
         * 
         * @param assistantArn
         *        The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantArn(String assistantArn);

        /**
         * <p>
         * The type of association.
         * </p>
         * 
         * @param associationType
         *        The type of association.
         * @see AssociationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationType
         */
        Builder associationType(String associationType);

        /**
         * <p>
         * The type of association.
         * </p>
         * 
         * @param associationType
         *        The type of association.
         * @see AssociationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationType
         */
        Builder associationType(AssociationType associationType);

        /**
         * <p>
         * A union type that currently has a single argument, the knowledge base ID.
         * </p>
         * 
         * @param associationData
         *        A union type that currently has a single argument, the knowledge base ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationData(AssistantAssociationOutputData associationData);

        /**
         * <p>
         * A union type that currently has a single argument, the knowledge base ID.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssistantAssociationOutputData.Builder}
         * avoiding the need to create one manually via {@link AssistantAssociationOutputData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssistantAssociationOutputData.Builder#build()} is called
         * immediately and its result is passed to {@link #associationData(AssistantAssociationOutputData)}.
         * 
         * @param associationData
         *        a consumer that will call methods on {@link AssistantAssociationOutputData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associationData(AssistantAssociationOutputData)
         */
        default Builder associationData(Consumer<AssistantAssociationOutputData.Builder> associationData) {
            return associationData(AssistantAssociationOutputData.builder().applyMutation(associationData).build());
        }

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String assistantAssociationId;

        private String assistantAssociationArn;

        private String assistantId;

        private String assistantArn;

        private String associationType;

        private AssistantAssociationOutputData associationData;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssistantAssociationData model) {
            assistantAssociationId(model.assistantAssociationId);
            assistantAssociationArn(model.assistantAssociationArn);
            assistantId(model.assistantId);
            assistantArn(model.assistantArn);
            associationType(model.associationType);
            associationData(model.associationData);
            tags(model.tags);
        }

        public final String getAssistantAssociationId() {
            return assistantAssociationId;
        }

        public final void setAssistantAssociationId(String assistantAssociationId) {
            this.assistantAssociationId = assistantAssociationId;
        }

        @Override
        public final Builder assistantAssociationId(String assistantAssociationId) {
            this.assistantAssociationId = assistantAssociationId;
            return this;
        }

        public final String getAssistantAssociationArn() {
            return assistantAssociationArn;
        }

        public final void setAssistantAssociationArn(String assistantAssociationArn) {
            this.assistantAssociationArn = assistantAssociationArn;
        }

        @Override
        public final Builder assistantAssociationArn(String assistantAssociationArn) {
            this.assistantAssociationArn = assistantAssociationArn;
            return this;
        }

        public final String getAssistantId() {
            return assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getAssistantArn() {
            return assistantArn;
        }

        public final void setAssistantArn(String assistantArn) {
            this.assistantArn = assistantArn;
        }

        @Override
        public final Builder assistantArn(String assistantArn) {
            this.assistantArn = assistantArn;
            return this;
        }

        public final String getAssociationType() {
            return associationType;
        }

        public final void setAssociationType(String associationType) {
            this.associationType = associationType;
        }

        @Override
        public final Builder associationType(String associationType) {
            this.associationType = associationType;
            return this;
        }

        @Override
        public final Builder associationType(AssociationType associationType) {
            this.associationType(associationType == null ? null : associationType.toString());
            return this;
        }

        public final AssistantAssociationOutputData.Builder getAssociationData() {
            return associationData != null ? associationData.toBuilder() : null;
        }

        public final void setAssociationData(AssistantAssociationOutputData.BuilderImpl associationData) {
            this.associationData = associationData != null ? associationData.build() : null;
        }

        @Override
        public final Builder associationData(AssistantAssociationOutputData associationData) {
            this.associationData = associationData;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public AssistantAssociationData build() {
            return new AssistantAssociationData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
