/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A typed union of the data of the configuration for an Amazon Q in Connect Assistant Association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociationConfigurationData implements SdkPojo, Serializable,
        ToCopyableBuilder<AssociationConfigurationData.Builder, AssociationConfigurationData> {
    private static final SdkField<KnowledgeBaseAssociationConfigurationData> KNOWLEDGE_BASE_ASSOCIATION_CONFIGURATION_DATA_FIELD = SdkField
            .<KnowledgeBaseAssociationConfigurationData> builder(MarshallingType.SDK_POJO)
            .memberName("knowledgeBaseAssociationConfigurationData")
            .getter(getter(AssociationConfigurationData::knowledgeBaseAssociationConfigurationData))
            .setter(setter(Builder::knowledgeBaseAssociationConfigurationData))
            .constructor(KnowledgeBaseAssociationConfigurationData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("knowledgeBaseAssociationConfigurationData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(KNOWLEDGE_BASE_ASSOCIATION_CONFIGURATION_DATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final KnowledgeBaseAssociationConfigurationData knowledgeBaseAssociationConfigurationData;

    private final Type type;

    private AssociationConfigurationData(BuilderImpl builder) {
        this.knowledgeBaseAssociationConfigurationData = builder.knowledgeBaseAssociationConfigurationData;
        this.type = builder.type;
    }

    /**
     * <p>
     * The data of the configuration for a <code>KNOWLEDGE_BASE</code> type Amazon Q in Connect Assistant Association.
     * </p>
     * 
     * @return The data of the configuration for a <code>KNOWLEDGE_BASE</code> type Amazon Q in Connect Assistant
     *         Association.
     */
    public final KnowledgeBaseAssociationConfigurationData knowledgeBaseAssociationConfigurationData() {
        return knowledgeBaseAssociationConfigurationData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseAssociationConfigurationData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociationConfigurationData)) {
            return false;
        }
        AssociationConfigurationData other = (AssociationConfigurationData) obj;
        return Objects.equals(knowledgeBaseAssociationConfigurationData(), other.knowledgeBaseAssociationConfigurationData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociationConfigurationData")
                .add("KnowledgeBaseAssociationConfigurationData", knowledgeBaseAssociationConfigurationData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "knowledgeBaseAssociationConfigurationData":
            return Optional.ofNullable(clazz.cast(knowledgeBaseAssociationConfigurationData()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #knowledgeBaseAssociationConfigurationData()} initialized to the
     * given value.
     *
     * <p>
     * The data of the configuration for a <code>KNOWLEDGE_BASE</code> type Amazon Q in Connect Assistant Association.
     * </p>
     * 
     * @param knowledgeBaseAssociationConfigurationData
     *        The data of the configuration for a <code>KNOWLEDGE_BASE</code> type Amazon Q in Connect Assistant
     *        Association.
     */
    public static AssociationConfigurationData fromKnowledgeBaseAssociationConfigurationData(
            KnowledgeBaseAssociationConfigurationData knowledgeBaseAssociationConfigurationData) {
        return builder().knowledgeBaseAssociationConfigurationData(knowledgeBaseAssociationConfigurationData).build();
    }

    /**
     * Create an instance of this class with {@link #knowledgeBaseAssociationConfigurationData()} initialized to the
     * given value.
     *
     * <p>
     * The data of the configuration for a <code>KNOWLEDGE_BASE</code> type Amazon Q in Connect Assistant Association.
     * </p>
     * 
     * @param knowledgeBaseAssociationConfigurationData
     *        The data of the configuration for a <code>KNOWLEDGE_BASE</code> type Amazon Q in Connect Assistant
     *        Association.
     */
    public static AssociationConfigurationData fromKnowledgeBaseAssociationConfigurationData(
            Consumer<KnowledgeBaseAssociationConfigurationData.Builder> knowledgeBaseAssociationConfigurationData) {
        KnowledgeBaseAssociationConfigurationData.Builder builder = KnowledgeBaseAssociationConfigurationData.builder();
        knowledgeBaseAssociationConfigurationData.accept(builder);
        return fromKnowledgeBaseAssociationConfigurationData(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("knowledgeBaseAssociationConfigurationData", KNOWLEDGE_BASE_ASSOCIATION_CONFIGURATION_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociationConfigurationData, T> g) {
        return obj -> g.apply((AssociationConfigurationData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssociationConfigurationData> {
        /**
         * <p>
         * The data of the configuration for a <code>KNOWLEDGE_BASE</code> type Amazon Q in Connect Assistant
         * Association.
         * </p>
         * 
         * @param knowledgeBaseAssociationConfigurationData
         *        The data of the configuration for a <code>KNOWLEDGE_BASE</code> type Amazon Q in Connect Assistant
         *        Association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseAssociationConfigurationData(
                KnowledgeBaseAssociationConfigurationData knowledgeBaseAssociationConfigurationData);

        /**
         * <p>
         * The data of the configuration for a <code>KNOWLEDGE_BASE</code> type Amazon Q in Connect Assistant
         * Association.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link KnowledgeBaseAssociationConfigurationData.Builder} avoiding the need to create one manually via
         * {@link KnowledgeBaseAssociationConfigurationData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KnowledgeBaseAssociationConfigurationData.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #knowledgeBaseAssociationConfigurationData(KnowledgeBaseAssociationConfigurationData)}.
         * 
         * @param knowledgeBaseAssociationConfigurationData
         *        a consumer that will call methods on {@link KnowledgeBaseAssociationConfigurationData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #knowledgeBaseAssociationConfigurationData(KnowledgeBaseAssociationConfigurationData)
         */
        default Builder knowledgeBaseAssociationConfigurationData(
                Consumer<KnowledgeBaseAssociationConfigurationData.Builder> knowledgeBaseAssociationConfigurationData) {
            return knowledgeBaseAssociationConfigurationData(KnowledgeBaseAssociationConfigurationData.builder()
                    .applyMutation(knowledgeBaseAssociationConfigurationData).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private KnowledgeBaseAssociationConfigurationData knowledgeBaseAssociationConfigurationData;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AssociationConfigurationData model) {
            knowledgeBaseAssociationConfigurationData(model.knowledgeBaseAssociationConfigurationData);
        }

        public final KnowledgeBaseAssociationConfigurationData.Builder getKnowledgeBaseAssociationConfigurationData() {
            return knowledgeBaseAssociationConfigurationData != null ? knowledgeBaseAssociationConfigurationData.toBuilder()
                    : null;
        }

        public final void setKnowledgeBaseAssociationConfigurationData(
                KnowledgeBaseAssociationConfigurationData.BuilderImpl knowledgeBaseAssociationConfigurationData) {
            Object oldValue = this.knowledgeBaseAssociationConfigurationData;
            this.knowledgeBaseAssociationConfigurationData = knowledgeBaseAssociationConfigurationData != null ? knowledgeBaseAssociationConfigurationData
                    .build() : null;
            handleUnionValueChange(Type.KNOWLEDGE_BASE_ASSOCIATION_CONFIGURATION_DATA, oldValue,
                    this.knowledgeBaseAssociationConfigurationData);
        }

        @Override
        public final Builder knowledgeBaseAssociationConfigurationData(
                KnowledgeBaseAssociationConfigurationData knowledgeBaseAssociationConfigurationData) {
            Object oldValue = this.knowledgeBaseAssociationConfigurationData;
            this.knowledgeBaseAssociationConfigurationData = knowledgeBaseAssociationConfigurationData;
            handleUnionValueChange(Type.KNOWLEDGE_BASE_ASSOCIATION_CONFIGURATION_DATA, oldValue,
                    this.knowledgeBaseAssociationConfigurationData);
            return this;
        }

        @Override
        public AssociationConfigurationData build() {
            return new AssociationConfigurationData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AssociationConfigurationData#type()
     */
    public enum Type {
        KNOWLEDGE_BASE_ASSOCIATION_CONFIGURATION_DATA,

        UNKNOWN_TO_SDK_VERSION
    }
}
