/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The contents of a content association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContentAssociationContents implements SdkPojo, Serializable,
        ToCopyableBuilder<ContentAssociationContents.Builder, ContentAssociationContents> {
    private static final SdkField<AmazonConnectGuideAssociationData> AMAZON_CONNECT_GUIDE_ASSOCIATION_FIELD = SdkField
            .<AmazonConnectGuideAssociationData> builder(MarshallingType.SDK_POJO)
            .memberName("amazonConnectGuideAssociation")
            .getter(getter(ContentAssociationContents::amazonConnectGuideAssociation))
            .setter(setter(Builder::amazonConnectGuideAssociation))
            .constructor(AmazonConnectGuideAssociationData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amazonConnectGuideAssociation")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(AMAZON_CONNECT_GUIDE_ASSOCIATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AmazonConnectGuideAssociationData amazonConnectGuideAssociation;

    private final Type type;

    private ContentAssociationContents(BuilderImpl builder) {
        this.amazonConnectGuideAssociation = builder.amazonConnectGuideAssociation;
        this.type = builder.type;
    }

    /**
     * <p>
     * The data of the step-by-step guide association.
     * </p>
     * 
     * @return The data of the step-by-step guide association.
     */
    public final AmazonConnectGuideAssociationData amazonConnectGuideAssociation() {
        return amazonConnectGuideAssociation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amazonConnectGuideAssociation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentAssociationContents)) {
            return false;
        }
        ContentAssociationContents other = (ContentAssociationContents) obj;
        return Objects.equals(amazonConnectGuideAssociation(), other.amazonConnectGuideAssociation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContentAssociationContents")
                .add("AmazonConnectGuideAssociation", amazonConnectGuideAssociation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "amazonConnectGuideAssociation":
            return Optional.ofNullable(clazz.cast(amazonConnectGuideAssociation()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #amazonConnectGuideAssociation()} initialized to the given value.
     *
     * <p>
     * The data of the step-by-step guide association.
     * </p>
     * 
     * @param amazonConnectGuideAssociation
     *        The data of the step-by-step guide association.
     */
    public static ContentAssociationContents fromAmazonConnectGuideAssociation(
            AmazonConnectGuideAssociationData amazonConnectGuideAssociation) {
        return builder().amazonConnectGuideAssociation(amazonConnectGuideAssociation).build();
    }

    /**
     * Create an instance of this class with {@link #amazonConnectGuideAssociation()} initialized to the given value.
     *
     * <p>
     * The data of the step-by-step guide association.
     * </p>
     * 
     * @param amazonConnectGuideAssociation
     *        The data of the step-by-step guide association.
     */
    public static ContentAssociationContents fromAmazonConnectGuideAssociation(
            Consumer<AmazonConnectGuideAssociationData.Builder> amazonConnectGuideAssociation) {
        AmazonConnectGuideAssociationData.Builder builder = AmazonConnectGuideAssociationData.builder();
        amazonConnectGuideAssociation.accept(builder);
        return fromAmazonConnectGuideAssociation(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("amazonConnectGuideAssociation", AMAZON_CONNECT_GUIDE_ASSOCIATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContentAssociationContents, T> g) {
        return obj -> g.apply((ContentAssociationContents) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContentAssociationContents> {
        /**
         * <p>
         * The data of the step-by-step guide association.
         * </p>
         * 
         * @param amazonConnectGuideAssociation
         *        The data of the step-by-step guide association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonConnectGuideAssociation(AmazonConnectGuideAssociationData amazonConnectGuideAssociation);

        /**
         * <p>
         * The data of the step-by-step guide association.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AmazonConnectGuideAssociationData.Builder} avoiding the need to create one manually via
         * {@link AmazonConnectGuideAssociationData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AmazonConnectGuideAssociationData.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #amazonConnectGuideAssociation(AmazonConnectGuideAssociationData)}.
         * 
         * @param amazonConnectGuideAssociation
         *        a consumer that will call methods on {@link AmazonConnectGuideAssociationData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amazonConnectGuideAssociation(AmazonConnectGuideAssociationData)
         */
        default Builder amazonConnectGuideAssociation(
                Consumer<AmazonConnectGuideAssociationData.Builder> amazonConnectGuideAssociation) {
            return amazonConnectGuideAssociation(AmazonConnectGuideAssociationData.builder()
                    .applyMutation(amazonConnectGuideAssociation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AmazonConnectGuideAssociationData amazonConnectGuideAssociation;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ContentAssociationContents model) {
            amazonConnectGuideAssociation(model.amazonConnectGuideAssociation);
        }

        public final AmazonConnectGuideAssociationData.Builder getAmazonConnectGuideAssociation() {
            return amazonConnectGuideAssociation != null ? amazonConnectGuideAssociation.toBuilder() : null;
        }

        public final void setAmazonConnectGuideAssociation(
                AmazonConnectGuideAssociationData.BuilderImpl amazonConnectGuideAssociation) {
            Object oldValue = this.amazonConnectGuideAssociation;
            this.amazonConnectGuideAssociation = amazonConnectGuideAssociation != null ? amazonConnectGuideAssociation.build()
                    : null;
            handleUnionValueChange(Type.AMAZON_CONNECT_GUIDE_ASSOCIATION, oldValue, this.amazonConnectGuideAssociation);
        }

        @Override
        public final Builder amazonConnectGuideAssociation(AmazonConnectGuideAssociationData amazonConnectGuideAssociation) {
            Object oldValue = this.amazonConnectGuideAssociation;
            this.amazonConnectGuideAssociation = amazonConnectGuideAssociation;
            handleUnionValueChange(Type.AMAZON_CONNECT_GUIDE_ASSOCIATION, oldValue, this.amazonConnectGuideAssociation);
            return this;
        }

        @Override
        public ContentAssociationContents build() {
            return new ContentAssociationContents(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ContentAssociationContents#type()
     */
    public enum Type {
        AMAZON_CONNECT_GUIDE_ASSOCIATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
