/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the content data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContentDataDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ContentDataDetails.Builder, ContentDataDetails> {
    private static final SdkField<TextData> TEXT_DATA_FIELD = SdkField.<TextData> builder(MarshallingType.SDK_POJO)
            .memberName("textData").getter(getter(ContentDataDetails::textData)).setter(setter(Builder::textData))
            .constructor(TextData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textData").build()).build();

    private static final SdkField<RankingData> RANKING_DATA_FIELD = SdkField.<RankingData> builder(MarshallingType.SDK_POJO)
            .memberName("rankingData").getter(getter(ContentDataDetails::rankingData)).setter(setter(Builder::rankingData))
            .constructor(RankingData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rankingData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_DATA_FIELD,
            RANKING_DATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TextData textData;

    private final RankingData rankingData;

    private ContentDataDetails(BuilderImpl builder) {
        this.textData = builder.textData;
        this.rankingData = builder.rankingData;
    }

    /**
     * <p>
     * Details about the content text data.
     * </p>
     * 
     * @return Details about the content text data.
     */
    public final TextData textData() {
        return textData;
    }

    /**
     * <p>
     * Details about the content ranking data.
     * </p>
     * 
     * @return Details about the content ranking data.
     */
    public final RankingData rankingData() {
        return rankingData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(textData());
        hashCode = 31 * hashCode + Objects.hashCode(rankingData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentDataDetails)) {
            return false;
        }
        ContentDataDetails other = (ContentDataDetails) obj;
        return Objects.equals(textData(), other.textData()) && Objects.equals(rankingData(), other.rankingData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContentDataDetails").add("TextData", textData()).add("RankingData", rankingData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "textData":
            return Optional.ofNullable(clazz.cast(textData()));
        case "rankingData":
            return Optional.ofNullable(clazz.cast(rankingData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("textData", TEXT_DATA_FIELD);
        map.put("rankingData", RANKING_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContentDataDetails, T> g) {
        return obj -> g.apply((ContentDataDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContentDataDetails> {
        /**
         * <p>
         * Details about the content text data.
         * </p>
         * 
         * @param textData
         *        Details about the content text data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textData(TextData textData);

        /**
         * <p>
         * Details about the content text data.
         * </p>
         * This is a convenience method that creates an instance of the {@link TextData.Builder} avoiding the need to
         * create one manually via {@link TextData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TextData.Builder#build()} is called immediately and its result is
         * passed to {@link #textData(TextData)}.
         * 
         * @param textData
         *        a consumer that will call methods on {@link TextData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textData(TextData)
         */
        default Builder textData(Consumer<TextData.Builder> textData) {
            return textData(TextData.builder().applyMutation(textData).build());
        }

        /**
         * <p>
         * Details about the content ranking data.
         * </p>
         * 
         * @param rankingData
         *        Details about the content ranking data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rankingData(RankingData rankingData);

        /**
         * <p>
         * Details about the content ranking data.
         * </p>
         * This is a convenience method that creates an instance of the {@link RankingData.Builder} avoiding the need to
         * create one manually via {@link RankingData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RankingData.Builder#build()} is called immediately and its result
         * is passed to {@link #rankingData(RankingData)}.
         * 
         * @param rankingData
         *        a consumer that will call methods on {@link RankingData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rankingData(RankingData)
         */
        default Builder rankingData(Consumer<RankingData.Builder> rankingData) {
            return rankingData(RankingData.builder().applyMutation(rankingData).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TextData textData;

        private RankingData rankingData;

        private BuilderImpl() {
        }

        private BuilderImpl(ContentDataDetails model) {
            textData(model.textData);
            rankingData(model.rankingData);
        }

        public final TextData.Builder getTextData() {
            return textData != null ? textData.toBuilder() : null;
        }

        public final void setTextData(TextData.BuilderImpl textData) {
            this.textData = textData != null ? textData.build() : null;
        }

        @Override
        public final Builder textData(TextData textData) {
            this.textData = textData;
            return this;
        }

        public final RankingData.Builder getRankingData() {
            return rankingData != null ? rankingData.toBuilder() : null;
        }

        public final void setRankingData(RankingData.BuilderImpl rankingData) {
            this.rankingData = rankingData != null ? rankingData.build() : null;
        }

        @Override
        public final Builder rankingData(RankingData rankingData) {
            this.rankingData = rankingData;
            return this;
        }

        @Override
        public ContentDataDetails build() {
            return new ContentDataDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
