/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The conversation context to include in SendMessage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConversationContext implements SdkPojo, Serializable,
        ToCopyableBuilder<ConversationContext.Builder, ConversationContext> {
    private static final SdkField<List<SelfServiceConversationHistory>> SELF_SERVICE_CONVERSATION_HISTORY_FIELD = SdkField
            .<List<SelfServiceConversationHistory>> builder(MarshallingType.LIST)
            .memberName("selfServiceConversationHistory")
            .getter(getter(ConversationContext::selfServiceConversationHistory))
            .setter(setter(Builder::selfServiceConversationHistory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selfServiceConversationHistory")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SelfServiceConversationHistory> builder(MarshallingType.SDK_POJO)
                                            .constructor(SelfServiceConversationHistory::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SELF_SERVICE_CONVERSATION_HISTORY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<SelfServiceConversationHistory> selfServiceConversationHistory;

    private ConversationContext(BuilderImpl builder) {
        this.selfServiceConversationHistory = builder.selfServiceConversationHistory;
    }

    /**
     * For responses, this returns true if the service returned a value for the SelfServiceConversationHistory property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSelfServiceConversationHistory() {
        return selfServiceConversationHistory != null && !(selfServiceConversationHistory instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The self service conversation history before the Amazon Q in Connect session.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSelfServiceConversationHistory} method.
     * </p>
     * 
     * @return The self service conversation history before the Amazon Q in Connect session.
     */
    public final List<SelfServiceConversationHistory> selfServiceConversationHistory() {
        return selfServiceConversationHistory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode
                + Objects.hashCode(hasSelfServiceConversationHistory() ? selfServiceConversationHistory() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConversationContext)) {
            return false;
        }
        ConversationContext other = (ConversationContext) obj;
        return hasSelfServiceConversationHistory() == other.hasSelfServiceConversationHistory()
                && Objects.equals(selfServiceConversationHistory(), other.selfServiceConversationHistory());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ConversationContext")
                .add("SelfServiceConversationHistory",
                        hasSelfServiceConversationHistory() ? selfServiceConversationHistory() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "selfServiceConversationHistory":
            return Optional.ofNullable(clazz.cast(selfServiceConversationHistory()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("selfServiceConversationHistory", SELF_SERVICE_CONVERSATION_HISTORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConversationContext, T> g) {
        return obj -> g.apply((ConversationContext) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConversationContext> {
        /**
         * <p>
         * The self service conversation history before the Amazon Q in Connect session.
         * </p>
         * 
         * @param selfServiceConversationHistory
         *        The self service conversation history before the Amazon Q in Connect session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selfServiceConversationHistory(Collection<SelfServiceConversationHistory> selfServiceConversationHistory);

        /**
         * <p>
         * The self service conversation history before the Amazon Q in Connect session.
         * </p>
         * 
         * @param selfServiceConversationHistory
         *        The self service conversation history before the Amazon Q in Connect session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selfServiceConversationHistory(SelfServiceConversationHistory... selfServiceConversationHistory);

        /**
         * <p>
         * The self service conversation history before the Amazon Q in Connect session.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.SelfServiceConversationHistory.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.qconnect.model.SelfServiceConversationHistory#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.SelfServiceConversationHistory.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #selfServiceConversationHistory(List<SelfServiceConversationHistory>)}.
         * 
         * @param selfServiceConversationHistory
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.SelfServiceConversationHistory.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selfServiceConversationHistory(java.util.Collection<SelfServiceConversationHistory>)
         */
        Builder selfServiceConversationHistory(Consumer<SelfServiceConversationHistory.Builder>... selfServiceConversationHistory);
    }

    static final class BuilderImpl implements Builder {
        private List<SelfServiceConversationHistory> selfServiceConversationHistory = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConversationContext model) {
            selfServiceConversationHistory(model.selfServiceConversationHistory);
        }

        public final List<SelfServiceConversationHistory.Builder> getSelfServiceConversationHistory() {
            List<SelfServiceConversationHistory.Builder> result = SelfServiceConversationHistoryListCopier
                    .copyToBuilder(this.selfServiceConversationHistory);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSelfServiceConversationHistory(
                Collection<SelfServiceConversationHistory.BuilderImpl> selfServiceConversationHistory) {
            this.selfServiceConversationHistory = SelfServiceConversationHistoryListCopier
                    .copyFromBuilder(selfServiceConversationHistory);
        }

        @Override
        public final Builder selfServiceConversationHistory(
                Collection<SelfServiceConversationHistory> selfServiceConversationHistory) {
            this.selfServiceConversationHistory = SelfServiceConversationHistoryListCopier.copy(selfServiceConversationHistory);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selfServiceConversationHistory(SelfServiceConversationHistory... selfServiceConversationHistory) {
            selfServiceConversationHistory(Arrays.asList(selfServiceConversationHistory));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selfServiceConversationHistory(
                Consumer<SelfServiceConversationHistory.Builder>... selfServiceConversationHistory) {
            selfServiceConversationHistory(Stream.of(selfServiceConversationHistory)
                    .map(c -> SelfServiceConversationHistory.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ConversationContext build() {
            return new ConversationContext(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
