/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the generative chunk data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GenerativeChunkDataDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<GenerativeChunkDataDetails.Builder, GenerativeChunkDataDetails> {
    private static final SdkField<String> COMPLETION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("completion").getter(getter(GenerativeChunkDataDetails::completion)).setter(setter(Builder::completion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completion").build()).build();

    private static final SdkField<List<DataSummary>> REFERENCES_FIELD = SdkField
            .<List<DataSummary>> builder(MarshallingType.LIST)
            .memberName("references")
            .getter(getter(GenerativeChunkDataDetails::references))
            .setter(setter(Builder::references))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("references").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_CHUNK_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextChunkToken").getter(getter(GenerativeChunkDataDetails::nextChunkToken))
            .setter(setter(Builder::nextChunkToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextChunkToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLETION_FIELD,
            REFERENCES_FIELD, NEXT_CHUNK_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String completion;

    private final List<DataSummary> references;

    private final String nextChunkToken;

    private GenerativeChunkDataDetails(BuilderImpl builder) {
        this.completion = builder.completion;
        this.references = builder.references;
        this.nextChunkToken = builder.nextChunkToken;
    }

    /**
     * <p>
     * A chunk of the LLM response.
     * </p>
     * 
     * @return A chunk of the LLM response.
     */
    public final String completion() {
        return completion;
    }

    /**
     * For responses, this returns true if the service returned a value for the References property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasReferences() {
        return references != null && !(references instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The references used to generate the LLM response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReferences} method.
     * </p>
     * 
     * @return The references used to generate the LLM response.
     */
    public final List<DataSummary> references() {
        return references;
    }

    /**
     * <p>
     * The token for the next set of chunks. Use the value returned in the previous response in the next request to
     * retrieve the next set of chunks.
     * </p>
     * 
     * @return The token for the next set of chunks. Use the value returned in the previous response in the next request
     *         to retrieve the next set of chunks.
     */
    public final String nextChunkToken() {
        return nextChunkToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(completion());
        hashCode = 31 * hashCode + Objects.hashCode(hasReferences() ? references() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextChunkToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerativeChunkDataDetails)) {
            return false;
        }
        GenerativeChunkDataDetails other = (GenerativeChunkDataDetails) obj;
        return Objects.equals(completion(), other.completion()) && hasReferences() == other.hasReferences()
                && Objects.equals(references(), other.references()) && Objects.equals(nextChunkToken(), other.nextChunkToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GenerativeChunkDataDetails")
                .add("Completion", completion() == null ? null : "*** Sensitive Data Redacted ***")
                .add("References", hasReferences() ? references() : null).add("NextChunkToken", nextChunkToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "completion":
            return Optional.ofNullable(clazz.cast(completion()));
        case "references":
            return Optional.ofNullable(clazz.cast(references()));
        case "nextChunkToken":
            return Optional.ofNullable(clazz.cast(nextChunkToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("completion", COMPLETION_FIELD);
        map.put("references", REFERENCES_FIELD);
        map.put("nextChunkToken", NEXT_CHUNK_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GenerativeChunkDataDetails, T> g) {
        return obj -> g.apply((GenerativeChunkDataDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GenerativeChunkDataDetails> {
        /**
         * <p>
         * A chunk of the LLM response.
         * </p>
         * 
         * @param completion
         *        A chunk of the LLM response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completion(String completion);

        /**
         * <p>
         * The references used to generate the LLM response.
         * </p>
         * 
         * @param references
         *        The references used to generate the LLM response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder references(Collection<DataSummary> references);

        /**
         * <p>
         * The references used to generate the LLM response.
         * </p>
         * 
         * @param references
         *        The references used to generate the LLM response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder references(DataSummary... references);

        /**
         * <p>
         * The references used to generate the LLM response.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.DataSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.qconnect.model.DataSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.DataSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #references(List<DataSummary>)}.
         * 
         * @param references
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.DataSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #references(java.util.Collection<DataSummary>)
         */
        Builder references(Consumer<DataSummary.Builder>... references);

        /**
         * <p>
         * The token for the next set of chunks. Use the value returned in the previous response in the next request to
         * retrieve the next set of chunks.
         * </p>
         * 
         * @param nextChunkToken
         *        The token for the next set of chunks. Use the value returned in the previous response in the next
         *        request to retrieve the next set of chunks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextChunkToken(String nextChunkToken);
    }

    static final class BuilderImpl implements Builder {
        private String completion;

        private List<DataSummary> references = DefaultSdkAutoConstructList.getInstance();

        private String nextChunkToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerativeChunkDataDetails model) {
            completion(model.completion);
            references(model.references);
            nextChunkToken(model.nextChunkToken);
        }

        public final String getCompletion() {
            return completion;
        }

        public final void setCompletion(String completion) {
            this.completion = completion;
        }

        @Override
        public final Builder completion(String completion) {
            this.completion = completion;
            return this;
        }

        public final List<DataSummary.Builder> getReferences() {
            List<DataSummary.Builder> result = DataSummaryListCopier.copyToBuilder(this.references);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReferences(Collection<DataSummary.BuilderImpl> references) {
            this.references = DataSummaryListCopier.copyFromBuilder(references);
        }

        @Override
        public final Builder references(Collection<DataSummary> references) {
            this.references = DataSummaryListCopier.copy(references);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder references(DataSummary... references) {
            references(Arrays.asList(references));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder references(Consumer<DataSummary.Builder>... references) {
            references(Stream.of(references).map(c -> DataSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextChunkToken() {
            return nextChunkToken;
        }

        public final void setNextChunkToken(String nextChunkToken) {
            this.nextChunkToken = nextChunkToken;
        }

        @Override
        public final Builder nextChunkToken(String nextChunkToken) {
            this.nextChunkToken = nextChunkToken;
            return this;
        }

        @Override
        public GenerativeChunkDataDetails build() {
            return new GenerativeChunkDataDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
