/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetNextMessageRequest extends QConnectRequest implements
        ToCopyableBuilder<GetNextMessageRequest.Builder, GetNextMessageRequest> {
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistantId").getter(getter(GetNextMessageRequest::assistantId)).setter(setter(Builder::assistantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assistantId").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(GetNextMessageRequest::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sessionId").build()).build();

    private static final SdkField<String> NEXT_MESSAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextMessageToken").getter(getter(GetNextMessageRequest::nextMessageToken))
            .setter(setter(Builder::nextMessageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextMessageToken").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSISTANT_ID_FIELD,
            SESSION_ID_FIELD, NEXT_MESSAGE_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String assistantId;

    private final String sessionId;

    private final String nextMessageToken;

    private GetNextMessageRequest(BuilderImpl builder) {
        super(builder);
        this.assistantId = builder.assistantId;
        this.sessionId = builder.sessionId;
        this.nextMessageToken = builder.nextMessageToken;
    }

    /**
     * <p>
     * The identifier of the Amazon Q in Connect assistant.
     * </p>
     * 
     * @return The identifier of the Amazon Q in Connect assistant.
     */
    public final String assistantId() {
        return assistantId;
    }

    /**
     * <p>
     * The identifier of the Amazon Q in Connect session.
     * </p>
     * 
     * @return The identifier of the Amazon Q in Connect session.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The token for the next message. Use the value returned in the SendMessage or previous response in the next
     * request to retrieve the next message.
     * </p>
     * 
     * @return The token for the next message. Use the value returned in the SendMessage or previous response in the
     *         next request to retrieve the next message.
     */
    public final String nextMessageToken() {
        return nextMessageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(nextMessageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetNextMessageRequest)) {
            return false;
        }
        GetNextMessageRequest other = (GetNextMessageRequest) obj;
        return Objects.equals(assistantId(), other.assistantId()) && Objects.equals(sessionId(), other.sessionId())
                && Objects.equals(nextMessageToken(), other.nextMessageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetNextMessageRequest").add("AssistantId", assistantId()).add("SessionId", sessionId())
                .add("NextMessageToken", nextMessageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assistantId":
            return Optional.ofNullable(clazz.cast(assistantId()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "nextMessageToken":
            return Optional.ofNullable(clazz.cast(nextMessageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("nextMessageToken", NEXT_MESSAGE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetNextMessageRequest, T> g) {
        return obj -> g.apply((GetNextMessageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetNextMessageRequest> {
        /**
         * <p>
         * The identifier of the Amazon Q in Connect assistant.
         * </p>
         * 
         * @param assistantId
         *        The identifier of the Amazon Q in Connect assistant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantId(String assistantId);

        /**
         * <p>
         * The identifier of the Amazon Q in Connect session.
         * </p>
         * 
         * @param sessionId
         *        The identifier of the Amazon Q in Connect session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The token for the next message. Use the value returned in the SendMessage or previous response in the next
         * request to retrieve the next message.
         * </p>
         * 
         * @param nextMessageToken
         *        The token for the next message. Use the value returned in the SendMessage or previous response in the
         *        next request to retrieve the next message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMessageToken(String nextMessageToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QConnectRequest.BuilderImpl implements Builder {
        private String assistantId;

        private String sessionId;

        private String nextMessageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetNextMessageRequest model) {
            super(model);
            assistantId(model.assistantId);
            sessionId(model.sessionId);
            nextMessageToken(model.nextMessageToken);
        }

        public final String getAssistantId() {
            return assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getNextMessageToken() {
            return nextMessageToken;
        }

        public final void setNextMessageToken(String nextMessageToken) {
            this.nextMessageToken = nextMessageToken;
        }

        @Override
        public final Builder nextMessageToken(String nextMessageToken) {
            this.nextMessageToken = nextMessageToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetNextMessageRequest build() {
            return new GetNextMessageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
