/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about the import job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportJobData implements SdkPojo, Serializable, ToCopyableBuilder<ImportJobData.Builder, ImportJobData> {
    private static final SdkField<String> IMPORT_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("importJobId").getter(getter(ImportJobData::importJobId)).setter(setter(Builder::importJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importJobId").build()).build();

    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(ImportJobData::knowledgeBaseId))
            .setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()).build();

    private static final SdkField<String> UPLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("uploadId").getter(getter(ImportJobData::uploadId)).setter(setter(Builder::uploadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadId").build()).build();

    private static final SdkField<String> KNOWLEDGE_BASE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseArn").getter(getter(ImportJobData::knowledgeBaseArn))
            .setter(setter(Builder::knowledgeBaseArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseArn").build()).build();

    private static final SdkField<String> IMPORT_JOB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("importJobType").getter(getter(ImportJobData::importJobTypeAsString))
            .setter(setter(Builder::importJobType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importJobType").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ImportJobData::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("url")
            .getter(getter(ImportJobData::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()).build();

    private static final SdkField<String> FAILED_RECORD_REPORT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failedRecordReport").getter(getter(ImportJobData::failedRecordReport))
            .setter(setter(Builder::failedRecordReport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedRecordReport").build())
            .build();

    private static final SdkField<Instant> URL_EXPIRY_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("urlExpiry")
            .getter(getter(ImportJobData::urlExpiry))
            .setter(setter(Builder::urlExpiry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("urlExpiry").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdTime")
            .getter(getter(ImportJobData::createdTime))
            .setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedTime")
            .getter(getter(ImportJobData::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final SdkField<Map<String, String>> METADATA_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("metadata")
            .getter(getter(ImportJobData::metadata))
            .setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<ExternalSourceConfiguration> EXTERNAL_SOURCE_CONFIGURATION_FIELD = SdkField
            .<ExternalSourceConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("externalSourceConfiguration")
            .getter(getter(ImportJobData::externalSourceConfiguration))
            .setter(setter(Builder::externalSourceConfiguration))
            .constructor(ExternalSourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalSourceConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_JOB_ID_FIELD,
            KNOWLEDGE_BASE_ID_FIELD, UPLOAD_ID_FIELD, KNOWLEDGE_BASE_ARN_FIELD, IMPORT_JOB_TYPE_FIELD, STATUS_FIELD, URL_FIELD,
            FAILED_RECORD_REPORT_FIELD, URL_EXPIRY_FIELD, CREATED_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, METADATA_FIELD,
            EXTERNAL_SOURCE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String importJobId;

    private final String knowledgeBaseId;

    private final String uploadId;

    private final String knowledgeBaseArn;

    private final String importJobType;

    private final String status;

    private final String url;

    private final String failedRecordReport;

    private final Instant urlExpiry;

    private final Instant createdTime;

    private final Instant lastModifiedTime;

    private final Map<String, String> metadata;

    private final ExternalSourceConfiguration externalSourceConfiguration;

    private ImportJobData(BuilderImpl builder) {
        this.importJobId = builder.importJobId;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.uploadId = builder.uploadId;
        this.knowledgeBaseArn = builder.knowledgeBaseArn;
        this.importJobType = builder.importJobType;
        this.status = builder.status;
        this.url = builder.url;
        this.failedRecordReport = builder.failedRecordReport;
        this.urlExpiry = builder.urlExpiry;
        this.createdTime = builder.createdTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.metadata = builder.metadata;
        this.externalSourceConfiguration = builder.externalSourceConfiguration;
    }

    /**
     * <p>
     * The identifier of the import job.
     * </p>
     * 
     * @return The identifier of the import job.
     */
    public final String importJobId() {
        return importJobId;
    }

    /**
     * <p>
     * The identifier of the knowledge base.
     * </p>
     * 
     * @return The identifier of the knowledge base.
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * <p>
     * A pointer to the uploaded asset. This value is returned by <a
     * href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html">StartContentUpload</a>.
     * </p>
     * 
     * @return A pointer to the uploaded asset. This value is returned by <a
     *         href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html"
     *         >StartContentUpload</a>.
     */
    public final String uploadId() {
        return uploadId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the knowledge base.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the knowledge base.
     */
    public final String knowledgeBaseArn() {
        return knowledgeBaseArn;
    }

    /**
     * <p>
     * The type of the import job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importJobType}
     * will return {@link ImportJobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #importJobTypeAsString}.
     * </p>
     * 
     * @return The type of the import job.
     * @see ImportJobType
     */
    public final ImportJobType importJobType() {
        return ImportJobType.fromValue(importJobType);
    }

    /**
     * <p>
     * The type of the import job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importJobType}
     * will return {@link ImportJobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #importJobTypeAsString}.
     * </p>
     * 
     * @return The type of the import job.
     * @see ImportJobType
     */
    public final String importJobTypeAsString() {
        return importJobType;
    }

    /**
     * <p>
     * The status of the import job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ImportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the import job.
     * @see ImportJobStatus
     */
    public final ImportJobStatus status() {
        return ImportJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the import job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ImportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the import job.
     * @see ImportJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The download link to the resource file that is uploaded to the import job.
     * </p>
     * 
     * @return The download link to the resource file that is uploaded to the import job.
     */
    public final String url() {
        return url;
    }

    /**
     * <p>
     * The link to download the information of resource data that failed to be imported.
     * </p>
     * 
     * @return The link to download the information of resource data that failed to be imported.
     */
    public final String failedRecordReport() {
        return failedRecordReport;
    }

    /**
     * <p>
     * The expiration time of the URL as an epoch timestamp.
     * </p>
     * 
     * @return The expiration time of the URL as an epoch timestamp.
     */
    public final Instant urlExpiry() {
        return urlExpiry;
    }

    /**
     * <p>
     * The timestamp when the import job was created.
     * </p>
     * 
     * @return The timestamp when the import job was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The timestamp when the import job data was last modified.
     * </p>
     * 
     * @return The timestamp when the import job data was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Metadata property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetadata() {
        return metadata != null && !(metadata instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The metadata fields of the imported Amazon Q in Connect resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetadata} method.
     * </p>
     * 
     * @return The metadata fields of the imported Amazon Q in Connect resources.
     */
    public final Map<String, String> metadata() {
        return metadata;
    }

    /**
     * Returns the value of the ExternalSourceConfiguration property for this object.
     * 
     * @return The value of the ExternalSourceConfiguration property for this object.
     */
    public final ExternalSourceConfiguration externalSourceConfiguration() {
        return externalSourceConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(importJobId());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(uploadId());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseArn());
        hashCode = 31 * hashCode + Objects.hashCode(importJobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(failedRecordReport());
        hashCode = 31 * hashCode + Objects.hashCode(urlExpiry());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetadata() ? metadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(externalSourceConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportJobData)) {
            return false;
        }
        ImportJobData other = (ImportJobData) obj;
        return Objects.equals(importJobId(), other.importJobId()) && Objects.equals(knowledgeBaseId(), other.knowledgeBaseId())
                && Objects.equals(uploadId(), other.uploadId()) && Objects.equals(knowledgeBaseArn(), other.knowledgeBaseArn())
                && Objects.equals(importJobTypeAsString(), other.importJobTypeAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(url(), other.url())
                && Objects.equals(failedRecordReport(), other.failedRecordReport())
                && Objects.equals(urlExpiry(), other.urlExpiry()) && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime()) && hasMetadata() == other.hasMetadata()
                && Objects.equals(metadata(), other.metadata())
                && Objects.equals(externalSourceConfiguration(), other.externalSourceConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportJobData").add("ImportJobId", importJobId()).add("KnowledgeBaseId", knowledgeBaseId())
                .add("UploadId", uploadId()).add("KnowledgeBaseArn", knowledgeBaseArn())
                .add("ImportJobType", importJobTypeAsString()).add("Status", statusAsString())
                .add("Url", url() == null ? null : "*** Sensitive Data Redacted ***")
                .add("FailedRecordReport", failedRecordReport() == null ? null : "*** Sensitive Data Redacted ***")
                .add("UrlExpiry", urlExpiry()).add("CreatedTime", createdTime()).add("LastModifiedTime", lastModifiedTime())
                .add("Metadata", hasMetadata() ? metadata() : null)
                .add("ExternalSourceConfiguration", externalSourceConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "importJobId":
            return Optional.ofNullable(clazz.cast(importJobId()));
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        case "uploadId":
            return Optional.ofNullable(clazz.cast(uploadId()));
        case "knowledgeBaseArn":
            return Optional.ofNullable(clazz.cast(knowledgeBaseArn()));
        case "importJobType":
            return Optional.ofNullable(clazz.cast(importJobTypeAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "url":
            return Optional.ofNullable(clazz.cast(url()));
        case "failedRecordReport":
            return Optional.ofNullable(clazz.cast(failedRecordReport()));
        case "urlExpiry":
            return Optional.ofNullable(clazz.cast(urlExpiry()));
        case "createdTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "lastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "externalSourceConfiguration":
            return Optional.ofNullable(clazz.cast(externalSourceConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("importJobId", IMPORT_JOB_ID_FIELD);
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("uploadId", UPLOAD_ID_FIELD);
        map.put("knowledgeBaseArn", KNOWLEDGE_BASE_ARN_FIELD);
        map.put("importJobType", IMPORT_JOB_TYPE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("url", URL_FIELD);
        map.put("failedRecordReport", FAILED_RECORD_REPORT_FIELD);
        map.put("urlExpiry", URL_EXPIRY_FIELD);
        map.put("createdTime", CREATED_TIME_FIELD);
        map.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("metadata", METADATA_FIELD);
        map.put("externalSourceConfiguration", EXTERNAL_SOURCE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportJobData, T> g) {
        return obj -> g.apply((ImportJobData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImportJobData> {
        /**
         * <p>
         * The identifier of the import job.
         * </p>
         * 
         * @param importJobId
         *        The identifier of the import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importJobId(String importJobId);

        /**
         * <p>
         * The identifier of the knowledge base.
         * </p>
         * 
         * @param knowledgeBaseId
         *        The identifier of the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        /**
         * <p>
         * A pointer to the uploaded asset. This value is returned by <a
         * href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html"
         * >StartContentUpload</a>.
         * </p>
         * 
         * @param uploadId
         *        A pointer to the uploaded asset. This value is returned by <a
         *        href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html"
         *        >StartContentUpload</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadId(String uploadId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the knowledge base.
         * </p>
         * 
         * @param knowledgeBaseArn
         *        The Amazon Resource Name (ARN) of the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseArn(String knowledgeBaseArn);

        /**
         * <p>
         * The type of the import job.
         * </p>
         * 
         * @param importJobType
         *        The type of the import job.
         * @see ImportJobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportJobType
         */
        Builder importJobType(String importJobType);

        /**
         * <p>
         * The type of the import job.
         * </p>
         * 
         * @param importJobType
         *        The type of the import job.
         * @see ImportJobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportJobType
         */
        Builder importJobType(ImportJobType importJobType);

        /**
         * <p>
         * The status of the import job.
         * </p>
         * 
         * @param status
         *        The status of the import job.
         * @see ImportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the import job.
         * </p>
         * 
         * @param status
         *        The status of the import job.
         * @see ImportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportJobStatus
         */
        Builder status(ImportJobStatus status);

        /**
         * <p>
         * The download link to the resource file that is uploaded to the import job.
         * </p>
         * 
         * @param url
         *        The download link to the resource file that is uploaded to the import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * The link to download the information of resource data that failed to be imported.
         * </p>
         * 
         * @param failedRecordReport
         *        The link to download the information of resource data that failed to be imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedRecordReport(String failedRecordReport);

        /**
         * <p>
         * The expiration time of the URL as an epoch timestamp.
         * </p>
         * 
         * @param urlExpiry
         *        The expiration time of the URL as an epoch timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder urlExpiry(Instant urlExpiry);

        /**
         * <p>
         * The timestamp when the import job was created.
         * </p>
         * 
         * @param createdTime
         *        The timestamp when the import job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The timestamp when the import job data was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The timestamp when the import job data was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The metadata fields of the imported Amazon Q in Connect resources.
         * </p>
         * 
         * @param metadata
         *        The metadata fields of the imported Amazon Q in Connect resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(Map<String, String> metadata);

        /**
         * Sets the value of the ExternalSourceConfiguration property for this object.
         *
         * @param externalSourceConfiguration
         *        The new value for the ExternalSourceConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalSourceConfiguration(ExternalSourceConfiguration externalSourceConfiguration);

        /**
         * Sets the value of the ExternalSourceConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ExternalSourceConfiguration.Builder}
         * avoiding the need to create one manually via {@link ExternalSourceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExternalSourceConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #externalSourceConfiguration(ExternalSourceConfiguration)}.
         * 
         * @param externalSourceConfiguration
         *        a consumer that will call methods on {@link ExternalSourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #externalSourceConfiguration(ExternalSourceConfiguration)
         */
        default Builder externalSourceConfiguration(Consumer<ExternalSourceConfiguration.Builder> externalSourceConfiguration) {
            return externalSourceConfiguration(ExternalSourceConfiguration.builder().applyMutation(externalSourceConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String importJobId;

        private String knowledgeBaseId;

        private String uploadId;

        private String knowledgeBaseArn;

        private String importJobType;

        private String status;

        private String url;

        private String failedRecordReport;

        private Instant urlExpiry;

        private Instant createdTime;

        private Instant lastModifiedTime;

        private Map<String, String> metadata = DefaultSdkAutoConstructMap.getInstance();

        private ExternalSourceConfiguration externalSourceConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportJobData model) {
            importJobId(model.importJobId);
            knowledgeBaseId(model.knowledgeBaseId);
            uploadId(model.uploadId);
            knowledgeBaseArn(model.knowledgeBaseArn);
            importJobType(model.importJobType);
            status(model.status);
            url(model.url);
            failedRecordReport(model.failedRecordReport);
            urlExpiry(model.urlExpiry);
            createdTime(model.createdTime);
            lastModifiedTime(model.lastModifiedTime);
            metadata(model.metadata);
            externalSourceConfiguration(model.externalSourceConfiguration);
        }

        public final String getImportJobId() {
            return importJobId;
        }

        public final void setImportJobId(String importJobId) {
            this.importJobId = importJobId;
        }

        @Override
        public final Builder importJobId(String importJobId) {
            this.importJobId = importJobId;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getUploadId() {
            return uploadId;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final String getKnowledgeBaseArn() {
            return knowledgeBaseArn;
        }

        public final void setKnowledgeBaseArn(String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
        }

        @Override
        public final Builder knowledgeBaseArn(String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
            return this;
        }

        public final String getImportJobType() {
            return importJobType;
        }

        public final void setImportJobType(String importJobType) {
            this.importJobType = importJobType;
        }

        @Override
        public final Builder importJobType(String importJobType) {
            this.importJobType = importJobType;
            return this;
        }

        @Override
        public final Builder importJobType(ImportJobType importJobType) {
            this.importJobType(importJobType == null ? null : importJobType.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ImportJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getFailedRecordReport() {
            return failedRecordReport;
        }

        public final void setFailedRecordReport(String failedRecordReport) {
            this.failedRecordReport = failedRecordReport;
        }

        @Override
        public final Builder failedRecordReport(String failedRecordReport) {
            this.failedRecordReport = failedRecordReport;
            return this;
        }

        public final Instant getUrlExpiry() {
            return urlExpiry;
        }

        public final void setUrlExpiry(Instant urlExpiry) {
            this.urlExpiry = urlExpiry;
        }

        @Override
        public final Builder urlExpiry(Instant urlExpiry) {
            this.urlExpiry = urlExpiry;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Map<String, String> getMetadata() {
            if (metadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return metadata;
        }

        public final void setMetadata(Map<String, String> metadata) {
            this.metadata = ContentMetadataCopier.copy(metadata);
        }

        @Override
        public final Builder metadata(Map<String, String> metadata) {
            this.metadata = ContentMetadataCopier.copy(metadata);
            return this;
        }

        public final ExternalSourceConfiguration.Builder getExternalSourceConfiguration() {
            return externalSourceConfiguration != null ? externalSourceConfiguration.toBuilder() : null;
        }

        public final void setExternalSourceConfiguration(ExternalSourceConfiguration.BuilderImpl externalSourceConfiguration) {
            this.externalSourceConfiguration = externalSourceConfiguration != null ? externalSourceConfiguration.build() : null;
        }

        @Override
        public final Builder externalSourceConfiguration(ExternalSourceConfiguration externalSourceConfiguration) {
            this.externalSourceConfiguration = externalSourceConfiguration;
            return this;
        }

        @Override
        public ImportJobData build() {
            return new ImportJobData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
