/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for a <a
 * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_amazon-q-connect_SendMessage.html">SendMessage</a>
 * request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MessageConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MessageConfiguration.Builder, MessageConfiguration> {
    private static final SdkField<Boolean> GENERATE_FILLER_MESSAGE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("generateFillerMessage").getter(getter(MessageConfiguration::generateFillerMessage))
            .setter(setter(Builder::generateFillerMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generateFillerMessage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(GENERATE_FILLER_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean generateFillerMessage;

    private MessageConfiguration(BuilderImpl builder) {
        this.generateFillerMessage = builder.generateFillerMessage;
    }

    /**
     * <p>
     * Generates a filler response when tool selection is <code>QUESTION</code>.
     * </p>
     * 
     * @return Generates a filler response when tool selection is <code>QUESTION</code>.
     */
    public final Boolean generateFillerMessage() {
        return generateFillerMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(generateFillerMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageConfiguration)) {
            return false;
        }
        MessageConfiguration other = (MessageConfiguration) obj;
        return Objects.equals(generateFillerMessage(), other.generateFillerMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MessageConfiguration").add("GenerateFillerMessage", generateFillerMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "generateFillerMessage":
            return Optional.ofNullable(clazz.cast(generateFillerMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("generateFillerMessage", GENERATE_FILLER_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MessageConfiguration, T> g) {
        return obj -> g.apply((MessageConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MessageConfiguration> {
        /**
         * <p>
         * Generates a filler response when tool selection is <code>QUESTION</code>.
         * </p>
         * 
         * @param generateFillerMessage
         *        Generates a filler response when tool selection is <code>QUESTION</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generateFillerMessage(Boolean generateFillerMessage);
    }

    static final class BuilderImpl implements Builder {
        private Boolean generateFillerMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageConfiguration model) {
            generateFillerMessage(model.generateFillerMessage);
        }

        public final Boolean getGenerateFillerMessage() {
            return generateFillerMessage;
        }

        public final void setGenerateFillerMessage(Boolean generateFillerMessage) {
            this.generateFillerMessage = generateFillerMessage;
        }

        @Override
        public final Builder generateFillerMessage(Boolean generateFillerMessage) {
            this.generateFillerMessage = generateFillerMessage;
            return this;
        }

        @Override
        public MessageConfiguration build() {
            return new MessageConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
