/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The attributes that are used with the message template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MessageTemplateAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<MessageTemplateAttributes.Builder, MessageTemplateAttributes> {
    private static final SdkField<SystemAttributes> SYSTEM_ATTRIBUTES_FIELD = SdkField
            .<SystemAttributes> builder(MarshallingType.SDK_POJO).memberName("systemAttributes")
            .getter(getter(MessageTemplateAttributes::systemAttributes)).setter(setter(Builder::systemAttributes))
            .constructor(SystemAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemAttributes").build()).build();

    private static final SdkField<AgentAttributes> AGENT_ATTRIBUTES_FIELD = SdkField
            .<AgentAttributes> builder(MarshallingType.SDK_POJO).memberName("agentAttributes")
            .getter(getter(MessageTemplateAttributes::agentAttributes)).setter(setter(Builder::agentAttributes))
            .constructor(AgentAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentAttributes").build()).build();

    private static final SdkField<CustomerProfileAttributes> CUSTOMER_PROFILE_ATTRIBUTES_FIELD = SdkField
            .<CustomerProfileAttributes> builder(MarshallingType.SDK_POJO).memberName("customerProfileAttributes")
            .getter(getter(MessageTemplateAttributes::customerProfileAttributes))
            .setter(setter(Builder::customerProfileAttributes)).constructor(CustomerProfileAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerProfileAttributes").build())
            .build();

    private static final SdkField<Map<String, String>> CUSTOM_ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("customAttributes")
            .getter(getter(MessageTemplateAttributes::customAttributes))
            .setter(setter(Builder::customAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SYSTEM_ATTRIBUTES_FIELD,
            AGENT_ATTRIBUTES_FIELD, CUSTOMER_PROFILE_ATTRIBUTES_FIELD, CUSTOM_ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SystemAttributes systemAttributes;

    private final AgentAttributes agentAttributes;

    private final CustomerProfileAttributes customerProfileAttributes;

    private final Map<String, String> customAttributes;

    private MessageTemplateAttributes(BuilderImpl builder) {
        this.systemAttributes = builder.systemAttributes;
        this.agentAttributes = builder.agentAttributes;
        this.customerProfileAttributes = builder.customerProfileAttributes;
        this.customAttributes = builder.customAttributes;
    }

    /**
     * <p>
     * The system attributes that are used with the message template.
     * </p>
     * 
     * @return The system attributes that are used with the message template.
     */
    public final SystemAttributes systemAttributes() {
        return systemAttributes;
    }

    /**
     * <p>
     * The agent attributes that are used with the message template.
     * </p>
     * 
     * @return The agent attributes that are used with the message template.
     */
    public final AgentAttributes agentAttributes() {
        return agentAttributes;
    }

    /**
     * <p>
     * The customer profile attributes that are used with the message template.
     * </p>
     * 
     * @return The customer profile attributes that are used with the message template.
     */
    public final CustomerProfileAttributes customerProfileAttributes() {
        return customerProfileAttributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomAttributes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomAttributes() {
        return customAttributes != null && !(customAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The custom attributes that are used with the message template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomAttributes} method.
     * </p>
     * 
     * @return The custom attributes that are used with the message template.
     */
    public final Map<String, String> customAttributes() {
        return customAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(systemAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(agentAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(customerProfileAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomAttributes() ? customAttributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageTemplateAttributes)) {
            return false;
        }
        MessageTemplateAttributes other = (MessageTemplateAttributes) obj;
        return Objects.equals(systemAttributes(), other.systemAttributes())
                && Objects.equals(agentAttributes(), other.agentAttributes())
                && Objects.equals(customerProfileAttributes(), other.customerProfileAttributes())
                && hasCustomAttributes() == other.hasCustomAttributes()
                && Objects.equals(customAttributes(), other.customAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MessageTemplateAttributes").add("SystemAttributes", systemAttributes())
                .add("AgentAttributes", agentAttributes()).add("CustomerProfileAttributes", customerProfileAttributes())
                .add("CustomAttributes", customAttributes() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "systemAttributes":
            return Optional.ofNullable(clazz.cast(systemAttributes()));
        case "agentAttributes":
            return Optional.ofNullable(clazz.cast(agentAttributes()));
        case "customerProfileAttributes":
            return Optional.ofNullable(clazz.cast(customerProfileAttributes()));
        case "customAttributes":
            return Optional.ofNullable(clazz.cast(customAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("systemAttributes", SYSTEM_ATTRIBUTES_FIELD);
        map.put("agentAttributes", AGENT_ATTRIBUTES_FIELD);
        map.put("customerProfileAttributes", CUSTOMER_PROFILE_ATTRIBUTES_FIELD);
        map.put("customAttributes", CUSTOM_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MessageTemplateAttributes, T> g) {
        return obj -> g.apply((MessageTemplateAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MessageTemplateAttributes> {
        /**
         * <p>
         * The system attributes that are used with the message template.
         * </p>
         * 
         * @param systemAttributes
         *        The system attributes that are used with the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemAttributes(SystemAttributes systemAttributes);

        /**
         * <p>
         * The system attributes that are used with the message template.
         * </p>
         * This is a convenience method that creates an instance of the {@link SystemAttributes.Builder} avoiding the
         * need to create one manually via {@link SystemAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SystemAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #systemAttributes(SystemAttributes)}.
         * 
         * @param systemAttributes
         *        a consumer that will call methods on {@link SystemAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #systemAttributes(SystemAttributes)
         */
        default Builder systemAttributes(Consumer<SystemAttributes.Builder> systemAttributes) {
            return systemAttributes(SystemAttributes.builder().applyMutation(systemAttributes).build());
        }

        /**
         * <p>
         * The agent attributes that are used with the message template.
         * </p>
         * 
         * @param agentAttributes
         *        The agent attributes that are used with the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentAttributes(AgentAttributes agentAttributes);

        /**
         * <p>
         * The agent attributes that are used with the message template.
         * </p>
         * This is a convenience method that creates an instance of the {@link AgentAttributes.Builder} avoiding the
         * need to create one manually via {@link AgentAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AgentAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #agentAttributes(AgentAttributes)}.
         * 
         * @param agentAttributes
         *        a consumer that will call methods on {@link AgentAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentAttributes(AgentAttributes)
         */
        default Builder agentAttributes(Consumer<AgentAttributes.Builder> agentAttributes) {
            return agentAttributes(AgentAttributes.builder().applyMutation(agentAttributes).build());
        }

        /**
         * <p>
         * The customer profile attributes that are used with the message template.
         * </p>
         * 
         * @param customerProfileAttributes
         *        The customer profile attributes that are used with the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerProfileAttributes(CustomerProfileAttributes customerProfileAttributes);

        /**
         * <p>
         * The customer profile attributes that are used with the message template.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomerProfileAttributes.Builder}
         * avoiding the need to create one manually via {@link CustomerProfileAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomerProfileAttributes.Builder#build()} is called immediately
         * and its result is passed to {@link #customerProfileAttributes(CustomerProfileAttributes)}.
         * 
         * @param customerProfileAttributes
         *        a consumer that will call methods on {@link CustomerProfileAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customerProfileAttributes(CustomerProfileAttributes)
         */
        default Builder customerProfileAttributes(Consumer<CustomerProfileAttributes.Builder> customerProfileAttributes) {
            return customerProfileAttributes(CustomerProfileAttributes.builder().applyMutation(customerProfileAttributes).build());
        }

        /**
         * <p>
         * The custom attributes that are used with the message template.
         * </p>
         * 
         * @param customAttributes
         *        The custom attributes that are used with the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAttributes(Map<String, String> customAttributes);
    }

    static final class BuilderImpl implements Builder {
        private SystemAttributes systemAttributes;

        private AgentAttributes agentAttributes;

        private CustomerProfileAttributes customerProfileAttributes;

        private Map<String, String> customAttributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MessageTemplateAttributes model) {
            systemAttributes(model.systemAttributes);
            agentAttributes(model.agentAttributes);
            customerProfileAttributes(model.customerProfileAttributes);
            customAttributes(model.customAttributes);
        }

        public final SystemAttributes.Builder getSystemAttributes() {
            return systemAttributes != null ? systemAttributes.toBuilder() : null;
        }

        public final void setSystemAttributes(SystemAttributes.BuilderImpl systemAttributes) {
            this.systemAttributes = systemAttributes != null ? systemAttributes.build() : null;
        }

        @Override
        public final Builder systemAttributes(SystemAttributes systemAttributes) {
            this.systemAttributes = systemAttributes;
            return this;
        }

        public final AgentAttributes.Builder getAgentAttributes() {
            return agentAttributes != null ? agentAttributes.toBuilder() : null;
        }

        public final void setAgentAttributes(AgentAttributes.BuilderImpl agentAttributes) {
            this.agentAttributes = agentAttributes != null ? agentAttributes.build() : null;
        }

        @Override
        public final Builder agentAttributes(AgentAttributes agentAttributes) {
            this.agentAttributes = agentAttributes;
            return this;
        }

        public final CustomerProfileAttributes.Builder getCustomerProfileAttributes() {
            return customerProfileAttributes != null ? customerProfileAttributes.toBuilder() : null;
        }

        public final void setCustomerProfileAttributes(CustomerProfileAttributes.BuilderImpl customerProfileAttributes) {
            this.customerProfileAttributes = customerProfileAttributes != null ? customerProfileAttributes.build() : null;
        }

        @Override
        public final Builder customerProfileAttributes(CustomerProfileAttributes customerProfileAttributes) {
            this.customerProfileAttributes = customerProfileAttributes;
            return this;
        }

        public final Map<String, String> getCustomAttributes() {
            if (customAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return customAttributes;
        }

        public final void setCustomAttributes(Map<String, String> customAttributes) {
            this.customAttributes = CustomAttributesCopier.copy(customAttributes);
        }

        @Override
        public final Builder customAttributes(Map<String, String> customAttributes) {
            this.customAttributes = CustomAttributesCopier.copy(customAttributes);
            return this;
        }

        @Override
        public MessageTemplateAttributes build() {
            return new MessageTemplateAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
