/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The container of message template content.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MessageTemplateContentProvider implements SdkPojo, Serializable,
        ToCopyableBuilder<MessageTemplateContentProvider.Builder, MessageTemplateContentProvider> {
    private static final SdkField<EmailMessageTemplateContent> EMAIL_FIELD = SdkField
            .<EmailMessageTemplateContent> builder(MarshallingType.SDK_POJO).memberName("email")
            .getter(getter(MessageTemplateContentProvider::email)).setter(setter(Builder::email))
            .constructor(EmailMessageTemplateContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("email").build()).build();

    private static final SdkField<SMSMessageTemplateContent> SMS_FIELD = SdkField
            .<SMSMessageTemplateContent> builder(MarshallingType.SDK_POJO).memberName("sms")
            .getter(getter(MessageTemplateContentProvider::sms)).setter(setter(Builder::sms))
            .constructor(SMSMessageTemplateContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sms").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_FIELD, SMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final EmailMessageTemplateContent email;

    private final SMSMessageTemplateContent sms;

    private final Type type;

    private MessageTemplateContentProvider(BuilderImpl builder) {
        this.email = builder.email;
        this.sms = builder.sms;
        this.type = builder.type;
    }

    /**
     * <p>
     * The content of the message template that applies to the email channel subtype.
     * </p>
     * 
     * @return The content of the message template that applies to the email channel subtype.
     */
    public final EmailMessageTemplateContent email() {
        return email;
    }

    /**
     * <p>
     * The content of the message template that applies to the SMS channel subtype.
     * </p>
     * 
     * @return The content of the message template that applies to the SMS channel subtype.
     */
    public final SMSMessageTemplateContent sms() {
        return sms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(email());
        hashCode = 31 * hashCode + Objects.hashCode(sms());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageTemplateContentProvider)) {
            return false;
        }
        MessageTemplateContentProvider other = (MessageTemplateContentProvider) obj;
        return Objects.equals(email(), other.email()) && Objects.equals(sms(), other.sms());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MessageTemplateContentProvider").add("Email", email()).add("Sms", sms()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "email":
            return Optional.ofNullable(clazz.cast(email()));
        case "sms":
            return Optional.ofNullable(clazz.cast(sms()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #email()} initialized to the given value.
     *
     * <p>
     * The content of the message template that applies to the email channel subtype.
     * </p>
     * 
     * @param email
     *        The content of the message template that applies to the email channel subtype.
     */
    public static MessageTemplateContentProvider fromEmail(EmailMessageTemplateContent email) {
        return builder().email(email).build();
    }

    /**
     * Create an instance of this class with {@link #email()} initialized to the given value.
     *
     * <p>
     * The content of the message template that applies to the email channel subtype.
     * </p>
     * 
     * @param email
     *        The content of the message template that applies to the email channel subtype.
     */
    public static MessageTemplateContentProvider fromEmail(Consumer<EmailMessageTemplateContent.Builder> email) {
        EmailMessageTemplateContent.Builder builder = EmailMessageTemplateContent.builder();
        email.accept(builder);
        return fromEmail(builder.build());
    }

    /**
     * Create an instance of this class with {@link #sms()} initialized to the given value.
     *
     * <p>
     * The content of the message template that applies to the SMS channel subtype.
     * </p>
     * 
     * @param sms
     *        The content of the message template that applies to the SMS channel subtype.
     */
    public static MessageTemplateContentProvider fromSms(SMSMessageTemplateContent sms) {
        return builder().sms(sms).build();
    }

    /**
     * Create an instance of this class with {@link #sms()} initialized to the given value.
     *
     * <p>
     * The content of the message template that applies to the SMS channel subtype.
     * </p>
     * 
     * @param sms
     *        The content of the message template that applies to the SMS channel subtype.
     */
    public static MessageTemplateContentProvider fromSms(Consumer<SMSMessageTemplateContent.Builder> sms) {
        SMSMessageTemplateContent.Builder builder = SMSMessageTemplateContent.builder();
        sms.accept(builder);
        return fromSms(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("email", EMAIL_FIELD);
        map.put("sms", SMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MessageTemplateContentProvider, T> g) {
        return obj -> g.apply((MessageTemplateContentProvider) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MessageTemplateContentProvider> {
        /**
         * <p>
         * The content of the message template that applies to the email channel subtype.
         * </p>
         * 
         * @param email
         *        The content of the message template that applies to the email channel subtype.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(EmailMessageTemplateContent email);

        /**
         * <p>
         * The content of the message template that applies to the email channel subtype.
         * </p>
         * This is a convenience method that creates an instance of the {@link EmailMessageTemplateContent.Builder}
         * avoiding the need to create one manually via {@link EmailMessageTemplateContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmailMessageTemplateContent.Builder#build()} is called
         * immediately and its result is passed to {@link #email(EmailMessageTemplateContent)}.
         * 
         * @param email
         *        a consumer that will call methods on {@link EmailMessageTemplateContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #email(EmailMessageTemplateContent)
         */
        default Builder email(Consumer<EmailMessageTemplateContent.Builder> email) {
            return email(EmailMessageTemplateContent.builder().applyMutation(email).build());
        }

        /**
         * <p>
         * The content of the message template that applies to the SMS channel subtype.
         * </p>
         * 
         * @param sms
         *        The content of the message template that applies to the SMS channel subtype.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sms(SMSMessageTemplateContent sms);

        /**
         * <p>
         * The content of the message template that applies to the SMS channel subtype.
         * </p>
         * This is a convenience method that creates an instance of the {@link SMSMessageTemplateContent.Builder}
         * avoiding the need to create one manually via {@link SMSMessageTemplateContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SMSMessageTemplateContent.Builder#build()} is called immediately
         * and its result is passed to {@link #sms(SMSMessageTemplateContent)}.
         * 
         * @param sms
         *        a consumer that will call methods on {@link SMSMessageTemplateContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sms(SMSMessageTemplateContent)
         */
        default Builder sms(Consumer<SMSMessageTemplateContent.Builder> sms) {
            return sms(SMSMessageTemplateContent.builder().applyMutation(sms).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EmailMessageTemplateContent email;

        private SMSMessageTemplateContent sms;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(MessageTemplateContentProvider model) {
            email(model.email);
            sms(model.sms);
        }

        public final EmailMessageTemplateContent.Builder getEmail() {
            return email != null ? email.toBuilder() : null;
        }

        public final void setEmail(EmailMessageTemplateContent.BuilderImpl email) {
            Object oldValue = this.email;
            this.email = email != null ? email.build() : null;
            handleUnionValueChange(Type.EMAIL, oldValue, this.email);
        }

        @Override
        public final Builder email(EmailMessageTemplateContent email) {
            Object oldValue = this.email;
            this.email = email;
            handleUnionValueChange(Type.EMAIL, oldValue, this.email);
            return this;
        }

        public final SMSMessageTemplateContent.Builder getSms() {
            return sms != null ? sms.toBuilder() : null;
        }

        public final void setSms(SMSMessageTemplateContent.BuilderImpl sms) {
            Object oldValue = this.sms;
            this.sms = sms != null ? sms.build() : null;
            handleUnionValueChange(Type.SMS, oldValue, this.sms);
        }

        @Override
        public final Builder sms(SMSMessageTemplateContent sms) {
            Object oldValue = this.sms;
            this.sms = sms;
            handleUnionValueChange(Type.SMS, oldValue, this.sms);
            return this;
        }

        @Override
        public MessageTemplateContentProvider build() {
            return new MessageTemplateContentProvider(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see MessageTemplateContentProvider#type()
     */
    public enum Type {
        EMAIL,

        SMS,

        UNKNOWN_TO_SDK_VERSION
    }
}
