/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryAssistantRequest extends QConnectRequest implements
        ToCopyableBuilder<QueryAssistantRequest.Builder, QueryAssistantRequest> {
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistantId").getter(getter(QueryAssistantRequest::assistantId)).setter(setter(Builder::assistantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assistantId").build()).build();

    private static final SdkField<String> QUERY_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queryText").getter(getter(QueryAssistantRequest::queryText)).setter(setter(Builder::queryText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryText").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(QueryAssistantRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(QueryAssistantRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(QueryAssistantRequest::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final SdkField<List<QueryCondition>> QUERY_CONDITION_FIELD = SdkField
            .<List<QueryCondition>> builder(MarshallingType.LIST)
            .memberName("queryCondition")
            .getter(getter(QueryAssistantRequest::queryCondition))
            .setter(setter(Builder::queryCondition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryCondition").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<QueryCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(QueryCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<QueryInputData> QUERY_INPUT_DATA_FIELD = SdkField
            .<QueryInputData> builder(MarshallingType.SDK_POJO).memberName("queryInputData")
            .getter(getter(QueryAssistantRequest::queryInputData)).setter(setter(Builder::queryInputData))
            .constructor(QueryInputData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryInputData").build()).build();

    private static final SdkField<String> OVERRIDE_KNOWLEDGE_BASE_SEARCH_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("overrideKnowledgeBaseSearchType")
            .getter(getter(QueryAssistantRequest::overrideKnowledgeBaseSearchTypeAsString))
            .setter(setter(Builder::overrideKnowledgeBaseSearchType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideKnowledgeBaseSearchType")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSISTANT_ID_FIELD,
            QUERY_TEXT_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, SESSION_ID_FIELD, QUERY_CONDITION_FIELD,
            QUERY_INPUT_DATA_FIELD, OVERRIDE_KNOWLEDGE_BASE_SEARCH_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String assistantId;

    private final String queryText;

    private final String nextToken;

    private final Integer maxResults;

    private final String sessionId;

    private final List<QueryCondition> queryCondition;

    private final QueryInputData queryInputData;

    private final String overrideKnowledgeBaseSearchType;

    private QueryAssistantRequest(BuilderImpl builder) {
        super(builder);
        this.assistantId = builder.assistantId;
        this.queryText = builder.queryText;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.sessionId = builder.sessionId;
        this.queryCondition = builder.queryCondition;
        this.queryInputData = builder.queryInputData;
        this.overrideKnowledgeBaseSearchType = builder.overrideKnowledgeBaseSearchType;
    }

    /**
     * <p>
     * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the
     * ARN.
     * </p>
     * 
     * @return The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain
     *         the ARN.
     */
    public final String assistantId() {
        return assistantId;
    }

    /**
     * <p>
     * The text to search for.
     * </p>
     * 
     * @return The text to search for.
     */
    public final String queryText() {
        return queryText;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @return The token for the next set of results. Use the value returned in the previous response in the next
     *         request to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return per page.
     * </p>
     * 
     * @return The maximum number of results to return per page.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The identifier of the Amazon Q in Connect session. Can be either the ID or the ARN. URLs cannot contain the ARN.
     * </p>
     * 
     * @return The identifier of the Amazon Q in Connect session. Can be either the ID or the ARN. URLs cannot contain
     *         the ARN.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * For responses, this returns true if the service returned a value for the QueryCondition property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasQueryCondition() {
        return queryCondition != null && !(queryCondition instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about how to query content.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueryCondition} method.
     * </p>
     * 
     * @return Information about how to query content.
     */
    public final List<QueryCondition> queryCondition() {
        return queryCondition;
    }

    /**
     * <p>
     * Information about the query.
     * </p>
     * 
     * @return Information about the query.
     */
    public final QueryInputData queryInputData() {
        return queryInputData;
    }

    /**
     * <p>
     * The search type to be used against the Knowledge Base for this request. The values can be <code>SEMANTIC</code>
     * which uses vector embeddings or <code>HYBRID</code> which use vector embeddings and raw text.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #overrideKnowledgeBaseSearchType} will return {@link KnowledgeBaseSearchType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #overrideKnowledgeBaseSearchTypeAsString}.
     * </p>
     * 
     * @return The search type to be used against the Knowledge Base for this request. The values can be
     *         <code>SEMANTIC</code> which uses vector embeddings or <code>HYBRID</code> which use vector embeddings and
     *         raw text.
     * @see KnowledgeBaseSearchType
     */
    public final KnowledgeBaseSearchType overrideKnowledgeBaseSearchType() {
        return KnowledgeBaseSearchType.fromValue(overrideKnowledgeBaseSearchType);
    }

    /**
     * <p>
     * The search type to be used against the Knowledge Base for this request. The values can be <code>SEMANTIC</code>
     * which uses vector embeddings or <code>HYBRID</code> which use vector embeddings and raw text.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #overrideKnowledgeBaseSearchType} will return {@link KnowledgeBaseSearchType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #overrideKnowledgeBaseSearchTypeAsString}.
     * </p>
     * 
     * @return The search type to be used against the Knowledge Base for this request. The values can be
     *         <code>SEMANTIC</code> which uses vector embeddings or <code>HYBRID</code> which use vector embeddings and
     *         raw text.
     * @see KnowledgeBaseSearchType
     */
    public final String overrideKnowledgeBaseSearchTypeAsString() {
        return overrideKnowledgeBaseSearchType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(queryText());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(hasQueryCondition() ? queryCondition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(queryInputData());
        hashCode = 31 * hashCode + Objects.hashCode(overrideKnowledgeBaseSearchTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryAssistantRequest)) {
            return false;
        }
        QueryAssistantRequest other = (QueryAssistantRequest) obj;
        return Objects.equals(assistantId(), other.assistantId()) && Objects.equals(queryText(), other.queryText())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(sessionId(), other.sessionId()) && hasQueryCondition() == other.hasQueryCondition()
                && Objects.equals(queryCondition(), other.queryCondition())
                && Objects.equals(queryInputData(), other.queryInputData())
                && Objects.equals(overrideKnowledgeBaseSearchTypeAsString(), other.overrideKnowledgeBaseSearchTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryAssistantRequest").add("AssistantId", assistantId())
                .add("QueryText", queryText() == null ? null : "*** Sensitive Data Redacted ***").add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("SessionId", sessionId())
                .add("QueryCondition", hasQueryCondition() ? queryCondition() : null).add("QueryInputData", queryInputData())
                .add("OverrideKnowledgeBaseSearchType", overrideKnowledgeBaseSearchTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assistantId":
            return Optional.ofNullable(clazz.cast(assistantId()));
        case "queryText":
            return Optional.ofNullable(clazz.cast(queryText()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "queryCondition":
            return Optional.ofNullable(clazz.cast(queryCondition()));
        case "queryInputData":
            return Optional.ofNullable(clazz.cast(queryInputData()));
        case "overrideKnowledgeBaseSearchType":
            return Optional.ofNullable(clazz.cast(overrideKnowledgeBaseSearchTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("queryText", QUERY_TEXT_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("queryCondition", QUERY_CONDITION_FIELD);
        map.put("queryInputData", QUERY_INPUT_DATA_FIELD);
        map.put("overrideKnowledgeBaseSearchType", OVERRIDE_KNOWLEDGE_BASE_SEARCH_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryAssistantRequest, T> g) {
        return obj -> g.apply((QueryAssistantRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, QueryAssistantRequest> {
        /**
         * <p>
         * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the
         * ARN.
         * </p>
         * 
         * @param assistantId
         *        The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot
         *        contain the ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantId(String assistantId);

        /**
         * <p>
         * The text to search for.
         * </p>
         * 
         * @param queryText
         *        The text to search for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryText(String queryText);

        /**
         * <p>
         * The token for the next set of results. Use the value returned in the previous response in the next request to
         * retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. Use the value returned in the previous response in the next
         *        request to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return per page.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return per page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The identifier of the Amazon Q in Connect session. Can be either the ID or the ARN. URLs cannot contain the
         * ARN.
         * </p>
         * 
         * @param sessionId
         *        The identifier of the Amazon Q in Connect session. Can be either the ID or the ARN. URLs cannot
         *        contain the ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * Information about how to query content.
         * </p>
         * 
         * @param queryCondition
         *        Information about how to query content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryCondition(Collection<QueryCondition> queryCondition);

        /**
         * <p>
         * Information about how to query content.
         * </p>
         * 
         * @param queryCondition
         *        Information about how to query content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryCondition(QueryCondition... queryCondition);

        /**
         * <p>
         * Information about how to query content.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.QueryCondition.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.qconnect.model.QueryCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.QueryCondition.Builder#build()} is called immediately
         * and its result is passed to {@link #queryCondition(List<QueryCondition>)}.
         * 
         * @param queryCondition
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.QueryCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryCondition(java.util.Collection<QueryCondition>)
         */
        Builder queryCondition(Consumer<QueryCondition.Builder>... queryCondition);

        /**
         * <p>
         * Information about the query.
         * </p>
         * 
         * @param queryInputData
         *        Information about the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryInputData(QueryInputData queryInputData);

        /**
         * <p>
         * Information about the query.
         * </p>
         * This is a convenience method that creates an instance of the {@link QueryInputData.Builder} avoiding the need
         * to create one manually via {@link QueryInputData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QueryInputData.Builder#build()} is called immediately and its
         * result is passed to {@link #queryInputData(QueryInputData)}.
         * 
         * @param queryInputData
         *        a consumer that will call methods on {@link QueryInputData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryInputData(QueryInputData)
         */
        default Builder queryInputData(Consumer<QueryInputData.Builder> queryInputData) {
            return queryInputData(QueryInputData.builder().applyMutation(queryInputData).build());
        }

        /**
         * <p>
         * The search type to be used against the Knowledge Base for this request. The values can be
         * <code>SEMANTIC</code> which uses vector embeddings or <code>HYBRID</code> which use vector embeddings and raw
         * text.
         * </p>
         * 
         * @param overrideKnowledgeBaseSearchType
         *        The search type to be used against the Knowledge Base for this request. The values can be
         *        <code>SEMANTIC</code> which uses vector embeddings or <code>HYBRID</code> which use vector embeddings
         *        and raw text.
         * @see KnowledgeBaseSearchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KnowledgeBaseSearchType
         */
        Builder overrideKnowledgeBaseSearchType(String overrideKnowledgeBaseSearchType);

        /**
         * <p>
         * The search type to be used against the Knowledge Base for this request. The values can be
         * <code>SEMANTIC</code> which uses vector embeddings or <code>HYBRID</code> which use vector embeddings and raw
         * text.
         * </p>
         * 
         * @param overrideKnowledgeBaseSearchType
         *        The search type to be used against the Knowledge Base for this request. The values can be
         *        <code>SEMANTIC</code> which uses vector embeddings or <code>HYBRID</code> which use vector embeddings
         *        and raw text.
         * @see KnowledgeBaseSearchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KnowledgeBaseSearchType
         */
        Builder overrideKnowledgeBaseSearchType(KnowledgeBaseSearchType overrideKnowledgeBaseSearchType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QConnectRequest.BuilderImpl implements Builder {
        private String assistantId;

        private String queryText;

        private String nextToken;

        private Integer maxResults;

        private String sessionId;

        private List<QueryCondition> queryCondition = DefaultSdkAutoConstructList.getInstance();

        private QueryInputData queryInputData;

        private String overrideKnowledgeBaseSearchType;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryAssistantRequest model) {
            super(model);
            assistantId(model.assistantId);
            queryText(model.queryText);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            sessionId(model.sessionId);
            queryCondition(model.queryCondition);
            queryInputData(model.queryInputData);
            overrideKnowledgeBaseSearchType(model.overrideKnowledgeBaseSearchType);
        }

        public final String getAssistantId() {
            return assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getQueryText() {
            return queryText;
        }

        public final void setQueryText(String queryText) {
            this.queryText = queryText;
        }

        @Override
        public final Builder queryText(String queryText) {
            this.queryText = queryText;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final List<QueryCondition.Builder> getQueryCondition() {
            List<QueryCondition.Builder> result = QueryConditionExpressionCopier.copyToBuilder(this.queryCondition);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueryCondition(Collection<QueryCondition.BuilderImpl> queryCondition) {
            this.queryCondition = QueryConditionExpressionCopier.copyFromBuilder(queryCondition);
        }

        @Override
        public final Builder queryCondition(Collection<QueryCondition> queryCondition) {
            this.queryCondition = QueryConditionExpressionCopier.copy(queryCondition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryCondition(QueryCondition... queryCondition) {
            queryCondition(Arrays.asList(queryCondition));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryCondition(Consumer<QueryCondition.Builder>... queryCondition) {
            queryCondition(Stream.of(queryCondition).map(c -> QueryCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final QueryInputData.Builder getQueryInputData() {
            return queryInputData != null ? queryInputData.toBuilder() : null;
        }

        public final void setQueryInputData(QueryInputData.BuilderImpl queryInputData) {
            this.queryInputData = queryInputData != null ? queryInputData.build() : null;
        }

        @Override
        public final Builder queryInputData(QueryInputData queryInputData) {
            this.queryInputData = queryInputData;
            return this;
        }

        public final String getOverrideKnowledgeBaseSearchType() {
            return overrideKnowledgeBaseSearchType;
        }

        public final void setOverrideKnowledgeBaseSearchType(String overrideKnowledgeBaseSearchType) {
            this.overrideKnowledgeBaseSearchType = overrideKnowledgeBaseSearchType;
        }

        @Override
        public final Builder overrideKnowledgeBaseSearchType(String overrideKnowledgeBaseSearchType) {
            this.overrideKnowledgeBaseSearchType = overrideKnowledgeBaseSearchType;
            return this;
        }

        @Override
        public final Builder overrideKnowledgeBaseSearchType(KnowledgeBaseSearchType overrideKnowledgeBaseSearchType) {
            this.overrideKnowledgeBaseSearchType(overrideKnowledgeBaseSearchType == null ? null : overrideKnowledgeBaseSearchType
                    .toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public QueryAssistantRequest build() {
            return new QueryAssistantRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
