/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The content of the quick response stored in different media types.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QuickResponseContents implements SdkPojo, Serializable,
        ToCopyableBuilder<QuickResponseContents.Builder, QuickResponseContents> {
    private static final SdkField<QuickResponseContentProvider> PLAIN_TEXT_FIELD = SdkField
            .<QuickResponseContentProvider> builder(MarshallingType.SDK_POJO).memberName("plainText")
            .getter(getter(QuickResponseContents::plainText)).setter(setter(Builder::plainText))
            .constructor(QuickResponseContentProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("plainText").build()).build();

    private static final SdkField<QuickResponseContentProvider> MARKDOWN_FIELD = SdkField
            .<QuickResponseContentProvider> builder(MarshallingType.SDK_POJO).memberName("markdown")
            .getter(getter(QuickResponseContents::markdown)).setter(setter(Builder::markdown))
            .constructor(QuickResponseContentProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("markdown").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLAIN_TEXT_FIELD,
            MARKDOWN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final QuickResponseContentProvider plainText;

    private final QuickResponseContentProvider markdown;

    private QuickResponseContents(BuilderImpl builder) {
        this.plainText = builder.plainText;
        this.markdown = builder.markdown;
    }

    /**
     * Returns the value of the PlainText property for this object.
     * 
     * @return The value of the PlainText property for this object.
     */
    public final QuickResponseContentProvider plainText() {
        return plainText;
    }

    /**
     * Returns the value of the Markdown property for this object.
     * 
     * @return The value of the Markdown property for this object.
     */
    public final QuickResponseContentProvider markdown() {
        return markdown;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(plainText());
        hashCode = 31 * hashCode + Objects.hashCode(markdown());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuickResponseContents)) {
            return false;
        }
        QuickResponseContents other = (QuickResponseContents) obj;
        return Objects.equals(plainText(), other.plainText()) && Objects.equals(markdown(), other.markdown());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QuickResponseContents").add("PlainText", plainText()).add("Markdown", markdown()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "plainText":
            return Optional.ofNullable(clazz.cast(plainText()));
        case "markdown":
            return Optional.ofNullable(clazz.cast(markdown()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("plainText", PLAIN_TEXT_FIELD);
        map.put("markdown", MARKDOWN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QuickResponseContents, T> g) {
        return obj -> g.apply((QuickResponseContents) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QuickResponseContents> {
        /**
         * Sets the value of the PlainText property for this object.
         *
         * @param plainText
         *        The new value for the PlainText property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder plainText(QuickResponseContentProvider plainText);

        /**
         * Sets the value of the PlainText property for this object.
         *
         * This is a convenience method that creates an instance of the {@link QuickResponseContentProvider.Builder}
         * avoiding the need to create one manually via {@link QuickResponseContentProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QuickResponseContentProvider.Builder#build()} is called
         * immediately and its result is passed to {@link #plainText(QuickResponseContentProvider)}.
         * 
         * @param plainText
         *        a consumer that will call methods on {@link QuickResponseContentProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #plainText(QuickResponseContentProvider)
         */
        default Builder plainText(Consumer<QuickResponseContentProvider.Builder> plainText) {
            return plainText(QuickResponseContentProvider.builder().applyMutation(plainText).build());
        }

        /**
         * Sets the value of the Markdown property for this object.
         *
         * @param markdown
         *        The new value for the Markdown property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder markdown(QuickResponseContentProvider markdown);

        /**
         * Sets the value of the Markdown property for this object.
         *
         * This is a convenience method that creates an instance of the {@link QuickResponseContentProvider.Builder}
         * avoiding the need to create one manually via {@link QuickResponseContentProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QuickResponseContentProvider.Builder#build()} is called
         * immediately and its result is passed to {@link #markdown(QuickResponseContentProvider)}.
         * 
         * @param markdown
         *        a consumer that will call methods on {@link QuickResponseContentProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #markdown(QuickResponseContentProvider)
         */
        default Builder markdown(Consumer<QuickResponseContentProvider.Builder> markdown) {
            return markdown(QuickResponseContentProvider.builder().applyMutation(markdown).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private QuickResponseContentProvider plainText;

        private QuickResponseContentProvider markdown;

        private BuilderImpl() {
        }

        private BuilderImpl(QuickResponseContents model) {
            plainText(model.plainText);
            markdown(model.markdown);
        }

        public final QuickResponseContentProvider.Builder getPlainText() {
            return plainText != null ? plainText.toBuilder() : null;
        }

        public final void setPlainText(QuickResponseContentProvider.BuilderImpl plainText) {
            this.plainText = plainText != null ? plainText.build() : null;
        }

        @Override
        public final Builder plainText(QuickResponseContentProvider plainText) {
            this.plainText = plainText;
            return this;
        }

        public final QuickResponseContentProvider.Builder getMarkdown() {
            return markdown != null ? markdown.toBuilder() : null;
        }

        public final void setMarkdown(QuickResponseContentProvider.BuilderImpl markdown) {
            this.markdown = markdown != null ? markdown.build() : null;
        }

        @Override
        public final Builder markdown(QuickResponseContentProvider markdown) {
            this.markdown = markdown;
            return this;
        }

        @Override
        public QuickResponseContents build() {
            return new QuickResponseContents(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
