/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The content of the message template that applies to the SMS channel subtype.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SMSMessageTemplateContent implements SdkPojo, Serializable,
        ToCopyableBuilder<SMSMessageTemplateContent.Builder, SMSMessageTemplateContent> {
    private static final SdkField<SMSMessageTemplateContentBody> BODY_FIELD = SdkField
            .<SMSMessageTemplateContentBody> builder(MarshallingType.SDK_POJO).memberName("body")
            .getter(getter(SMSMessageTemplateContent::body)).setter(setter(Builder::body))
            .constructor(SMSMessageTemplateContentBody::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SMSMessageTemplateContentBody body;

    private SMSMessageTemplateContent(BuilderImpl builder) {
        this.body = builder.body;
    }

    /**
     * <p>
     * The body to use in SMS messages.
     * </p>
     * 
     * @return The body to use in SMS messages.
     */
    public final SMSMessageTemplateContentBody body() {
        return body;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(body());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SMSMessageTemplateContent)) {
            return false;
        }
        SMSMessageTemplateContent other = (SMSMessageTemplateContent) obj;
        return Objects.equals(body(), other.body());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SMSMessageTemplateContent").add("Body", body()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "body":
            return Optional.ofNullable(clazz.cast(body()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("body", BODY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SMSMessageTemplateContent, T> g) {
        return obj -> g.apply((SMSMessageTemplateContent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SMSMessageTemplateContent> {
        /**
         * <p>
         * The body to use in SMS messages.
         * </p>
         * 
         * @param body
         *        The body to use in SMS messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(SMSMessageTemplateContentBody body);

        /**
         * <p>
         * The body to use in SMS messages.
         * </p>
         * This is a convenience method that creates an instance of the {@link SMSMessageTemplateContentBody.Builder}
         * avoiding the need to create one manually via {@link SMSMessageTemplateContentBody#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SMSMessageTemplateContentBody.Builder#build()} is called
         * immediately and its result is passed to {@link #body(SMSMessageTemplateContentBody)}.
         * 
         * @param body
         *        a consumer that will call methods on {@link SMSMessageTemplateContentBody.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #body(SMSMessageTemplateContentBody)
         */
        default Builder body(Consumer<SMSMessageTemplateContentBody.Builder> body) {
            return body(SMSMessageTemplateContentBody.builder().applyMutation(body).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SMSMessageTemplateContentBody body;

        private BuilderImpl() {
        }

        private BuilderImpl(SMSMessageTemplateContent model) {
            body(model.body);
        }

        public final SMSMessageTemplateContentBody.Builder getBody() {
            return body != null ? body.toBuilder() : null;
        }

        public final void setBody(SMSMessageTemplateContentBody.BuilderImpl body) {
            this.body = body != null ? body.build() : null;
        }

        @Override
        public final Builder body(SMSMessageTemplateContentBody body) {
            this.body = body;
            return this;
        }

        @Override
        public SMSMessageTemplateContent build() {
            return new SMSMessageTemplateContent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
