/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMessageTemplateRequest extends QConnectRequest implements
        ToCopyableBuilder<UpdateMessageTemplateRequest.Builder, UpdateMessageTemplateRequest> {
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(UpdateMessageTemplateRequest::knowledgeBaseId))
            .setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("knowledgeBaseId").build()).build();

    private static final SdkField<String> MESSAGE_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("messageTemplateId").getter(getter(UpdateMessageTemplateRequest::messageTemplateId))
            .setter(setter(Builder::messageTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("messageTemplateId").build()).build();

    private static final SdkField<MessageTemplateContentProvider> CONTENT_FIELD = SdkField
            .<MessageTemplateContentProvider> builder(MarshallingType.SDK_POJO).memberName("content")
            .getter(getter(UpdateMessageTemplateRequest::content)).setter(setter(Builder::content))
            .constructor(MessageTemplateContentProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("language").getter(getter(UpdateMessageTemplateRequest::language)).setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("language").build()).build();

    private static final SdkField<MessageTemplateAttributes> DEFAULT_ATTRIBUTES_FIELD = SdkField
            .<MessageTemplateAttributes> builder(MarshallingType.SDK_POJO).memberName("defaultAttributes")
            .getter(getter(UpdateMessageTemplateRequest::defaultAttributes)).setter(setter(Builder::defaultAttributes))
            .constructor(MessageTemplateAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultAttributes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWLEDGE_BASE_ID_FIELD,
            MESSAGE_TEMPLATE_ID_FIELD, CONTENT_FIELD, LANGUAGE_FIELD, DEFAULT_ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String knowledgeBaseId;

    private final String messageTemplateId;

    private final MessageTemplateContentProvider content;

    private final String language;

    private final MessageTemplateAttributes defaultAttributes;

    private UpdateMessageTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.messageTemplateId = builder.messageTemplateId;
        this.content = builder.content;
        this.language = builder.language;
        this.defaultAttributes = builder.defaultAttributes;
    }

    /**
     * <p>
     * The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
     * </p>
     * 
     * @return The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * <p>
     * The identifier of the message template. Can be either the ID or the ARN. It cannot contain any qualifier.
     * </p>
     * 
     * @return The identifier of the message template. Can be either the ID or the ARN. It cannot contain any qualifier.
     */
    public final String messageTemplateId() {
        return messageTemplateId;
    }

    /**
     * <p>
     * The content of the message template.
     * </p>
     * 
     * @return The content of the message template.
     */
    public final MessageTemplateContentProvider content() {
        return content;
    }

    /**
     * <p>
     * The language code value for the language in which the quick response is written. The supported language codes
     * include <code>de_DE</code>, <code>en_US</code>, <code>es_ES</code>, <code>fr_FR</code>, <code>id_ID</code>,
     * <code>it_IT</code>, <code>ja_JP</code>, <code>ko_KR</code>, <code>pt_BR</code>, <code>zh_CN</code>,
     * <code>zh_TW</code>
     * </p>
     * 
     * @return The language code value for the language in which the quick response is written. The supported language
     *         codes include <code>de_DE</code>, <code>en_US</code>, <code>es_ES</code>, <code>fr_FR</code>,
     *         <code>id_ID</code>, <code>it_IT</code>, <code>ja_JP</code>, <code>ko_KR</code>, <code>pt_BR</code>,
     *         <code>zh_CN</code>, <code>zh_TW</code>
     */
    public final String language() {
        return language;
    }

    /**
     * <p>
     * An object that specifies the default values to use for variables in the message template. This object contains
     * different categories of key-value pairs. Each key defines a variable or placeholder in the message template. The
     * corresponding value defines the default value for that variable.
     * </p>
     * 
     * @return An object that specifies the default values to use for variables in the message template. This object
     *         contains different categories of key-value pairs. Each key defines a variable or placeholder in the
     *         message template. The corresponding value defines the default value for that variable.
     */
    public final MessageTemplateAttributes defaultAttributes() {
        return defaultAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(messageTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(language());
        hashCode = 31 * hashCode + Objects.hashCode(defaultAttributes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMessageTemplateRequest)) {
            return false;
        }
        UpdateMessageTemplateRequest other = (UpdateMessageTemplateRequest) obj;
        return Objects.equals(knowledgeBaseId(), other.knowledgeBaseId())
                && Objects.equals(messageTemplateId(), other.messageTemplateId()) && Objects.equals(content(), other.content())
                && Objects.equals(language(), other.language()) && Objects.equals(defaultAttributes(), other.defaultAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateMessageTemplateRequest").add("KnowledgeBaseId", knowledgeBaseId())
                .add("MessageTemplateId", messageTemplateId()).add("Content", content()).add("Language", language())
                .add("DefaultAttributes", defaultAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        case "messageTemplateId":
            return Optional.ofNullable(clazz.cast(messageTemplateId()));
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "language":
            return Optional.ofNullable(clazz.cast(language()));
        case "defaultAttributes":
            return Optional.ofNullable(clazz.cast(defaultAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("messageTemplateId", MESSAGE_TEMPLATE_ID_FIELD);
        map.put("content", CONTENT_FIELD);
        map.put("language", LANGUAGE_FIELD);
        map.put("defaultAttributes", DEFAULT_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateMessageTemplateRequest, T> g) {
        return obj -> g.apply((UpdateMessageTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateMessageTemplateRequest> {
        /**
         * <p>
         * The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
         * </p>
         * 
         * @param knowledgeBaseId
         *        The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        /**
         * <p>
         * The identifier of the message template. Can be either the ID or the ARN. It cannot contain any qualifier.
         * </p>
         * 
         * @param messageTemplateId
         *        The identifier of the message template. Can be either the ID or the ARN. It cannot contain any
         *        qualifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageTemplateId(String messageTemplateId);

        /**
         * <p>
         * The content of the message template.
         * </p>
         * 
         * @param content
         *        The content of the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(MessageTemplateContentProvider content);

        /**
         * <p>
         * The content of the message template.
         * </p>
         * This is a convenience method that creates an instance of the {@link MessageTemplateContentProvider.Builder}
         * avoiding the need to create one manually via {@link MessageTemplateContentProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MessageTemplateContentProvider.Builder#build()} is called
         * immediately and its result is passed to {@link #content(MessageTemplateContentProvider)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link MessageTemplateContentProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(MessageTemplateContentProvider)
         */
        default Builder content(Consumer<MessageTemplateContentProvider.Builder> content) {
            return content(MessageTemplateContentProvider.builder().applyMutation(content).build());
        }

        /**
         * <p>
         * The language code value for the language in which the quick response is written. The supported language codes
         * include <code>de_DE</code>, <code>en_US</code>, <code>es_ES</code>, <code>fr_FR</code>, <code>id_ID</code>,
         * <code>it_IT</code>, <code>ja_JP</code>, <code>ko_KR</code>, <code>pt_BR</code>, <code>zh_CN</code>,
         * <code>zh_TW</code>
         * </p>
         * 
         * @param language
         *        The language code value for the language in which the quick response is written. The supported
         *        language codes include <code>de_DE</code>, <code>en_US</code>, <code>es_ES</code>, <code>fr_FR</code>,
         *        <code>id_ID</code>, <code>it_IT</code>, <code>ja_JP</code>, <code>ko_KR</code>, <code>pt_BR</code>,
         *        <code>zh_CN</code>, <code>zh_TW</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder language(String language);

        /**
         * <p>
         * An object that specifies the default values to use for variables in the message template. This object
         * contains different categories of key-value pairs. Each key defines a variable or placeholder in the message
         * template. The corresponding value defines the default value for that variable.
         * </p>
         * 
         * @param defaultAttributes
         *        An object that specifies the default values to use for variables in the message template. This object
         *        contains different categories of key-value pairs. Each key defines a variable or placeholder in the
         *        message template. The corresponding value defines the default value for that variable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultAttributes(MessageTemplateAttributes defaultAttributes);

        /**
         * <p>
         * An object that specifies the default values to use for variables in the message template. This object
         * contains different categories of key-value pairs. Each key defines a variable or placeholder in the message
         * template. The corresponding value defines the default value for that variable.
         * </p>
         * This is a convenience method that creates an instance of the {@link MessageTemplateAttributes.Builder}
         * avoiding the need to create one manually via {@link MessageTemplateAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MessageTemplateAttributes.Builder#build()} is called immediately
         * and its result is passed to {@link #defaultAttributes(MessageTemplateAttributes)}.
         * 
         * @param defaultAttributes
         *        a consumer that will call methods on {@link MessageTemplateAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultAttributes(MessageTemplateAttributes)
         */
        default Builder defaultAttributes(Consumer<MessageTemplateAttributes.Builder> defaultAttributes) {
            return defaultAttributes(MessageTemplateAttributes.builder().applyMutation(defaultAttributes).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QConnectRequest.BuilderImpl implements Builder {
        private String knowledgeBaseId;

        private String messageTemplateId;

        private MessageTemplateContentProvider content;

        private String language;

        private MessageTemplateAttributes defaultAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMessageTemplateRequest model) {
            super(model);
            knowledgeBaseId(model.knowledgeBaseId);
            messageTemplateId(model.messageTemplateId);
            content(model.content);
            language(model.language);
            defaultAttributes(model.defaultAttributes);
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getMessageTemplateId() {
            return messageTemplateId;
        }

        public final void setMessageTemplateId(String messageTemplateId) {
            this.messageTemplateId = messageTemplateId;
        }

        @Override
        public final Builder messageTemplateId(String messageTemplateId) {
            this.messageTemplateId = messageTemplateId;
            return this;
        }

        public final MessageTemplateContentProvider.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(MessageTemplateContentProvider.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(MessageTemplateContentProvider content) {
            this.content = content;
            return this;
        }

        public final String getLanguage() {
            return language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final MessageTemplateAttributes.Builder getDefaultAttributes() {
            return defaultAttributes != null ? defaultAttributes.toBuilder() : null;
        }

        public final void setDefaultAttributes(MessageTemplateAttributes.BuilderImpl defaultAttributes) {
            this.defaultAttributes = defaultAttributes != null ? defaultAttributes.build() : null;
        }

        @Override
        public final Builder defaultAttributes(MessageTemplateAttributes defaultAttributes) {
            this.defaultAttributes = defaultAttributes;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMessageTemplateRequest build() {
            return new UpdateMessageTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
