/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateQuickResponseRequest extends QConnectRequest implements
        ToCopyableBuilder<UpdateQuickResponseRequest.Builder, UpdateQuickResponseRequest> {
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(UpdateQuickResponseRequest::knowledgeBaseId))
            .setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("knowledgeBaseId").build()).build();

    private static final SdkField<String> QUICK_RESPONSE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("quickResponseId").getter(getter(UpdateQuickResponseRequest::quickResponseId))
            .setter(setter(Builder::quickResponseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("quickResponseId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateQuickResponseRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<QuickResponseDataProvider> CONTENT_FIELD = SdkField
            .<QuickResponseDataProvider> builder(MarshallingType.SDK_POJO).memberName("content")
            .getter(getter(UpdateQuickResponseRequest::content)).setter(setter(Builder::content))
            .constructor(QuickResponseDataProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentType").getter(getter(UpdateQuickResponseRequest::contentType))
            .setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentType").build()).build();

    private static final SdkField<GroupingConfiguration> GROUPING_CONFIGURATION_FIELD = SdkField
            .<GroupingConfiguration> builder(MarshallingType.SDK_POJO).memberName("groupingConfiguration")
            .getter(getter(UpdateQuickResponseRequest::groupingConfiguration)).setter(setter(Builder::groupingConfiguration))
            .constructor(GroupingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupingConfiguration").build())
            .build();

    private static final SdkField<Boolean> REMOVE_GROUPING_CONFIGURATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("removeGroupingConfiguration")
            .getter(getter(UpdateQuickResponseRequest::removeGroupingConfiguration))
            .setter(setter(Builder::removeGroupingConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("removeGroupingConfiguration")
                    .build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateQuickResponseRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Boolean> REMOVE_DESCRIPTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("removeDescription").getter(getter(UpdateQuickResponseRequest::removeDescription))
            .setter(setter(Builder::removeDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("removeDescription").build()).build();

    private static final SdkField<String> SHORTCUT_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("shortcutKey").getter(getter(UpdateQuickResponseRequest::shortcutKey))
            .setter(setter(Builder::shortcutKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shortcutKey").build()).build();

    private static final SdkField<Boolean> REMOVE_SHORTCUT_KEY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("removeShortcutKey").getter(getter(UpdateQuickResponseRequest::removeShortcutKey))
            .setter(setter(Builder::removeShortcutKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("removeShortcutKey").build()).build();

    private static final SdkField<Boolean> IS_ACTIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isActive").getter(getter(UpdateQuickResponseRequest::isActive)).setter(setter(Builder::isActive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isActive").build()).build();

    private static final SdkField<List<String>> CHANNELS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("channels")
            .getter(getter(UpdateQuickResponseRequest::channels))
            .setter(setter(Builder::channels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("language").getter(getter(UpdateQuickResponseRequest::language)).setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("language").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWLEDGE_BASE_ID_FIELD,
            QUICK_RESPONSE_ID_FIELD, NAME_FIELD, CONTENT_FIELD, CONTENT_TYPE_FIELD, GROUPING_CONFIGURATION_FIELD,
            REMOVE_GROUPING_CONFIGURATION_FIELD, DESCRIPTION_FIELD, REMOVE_DESCRIPTION_FIELD, SHORTCUT_KEY_FIELD,
            REMOVE_SHORTCUT_KEY_FIELD, IS_ACTIVE_FIELD, CHANNELS_FIELD, LANGUAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String knowledgeBaseId;

    private final String quickResponseId;

    private final String name;

    private final QuickResponseDataProvider content;

    private final String contentType;

    private final GroupingConfiguration groupingConfiguration;

    private final Boolean removeGroupingConfiguration;

    private final String description;

    private final Boolean removeDescription;

    private final String shortcutKey;

    private final Boolean removeShortcutKey;

    private final Boolean isActive;

    private final List<String> channels;

    private final String language;

    private UpdateQuickResponseRequest(BuilderImpl builder) {
        super(builder);
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.quickResponseId = builder.quickResponseId;
        this.name = builder.name;
        this.content = builder.content;
        this.contentType = builder.contentType;
        this.groupingConfiguration = builder.groupingConfiguration;
        this.removeGroupingConfiguration = builder.removeGroupingConfiguration;
        this.description = builder.description;
        this.removeDescription = builder.removeDescription;
        this.shortcutKey = builder.shortcutKey;
        this.removeShortcutKey = builder.removeShortcutKey;
        this.isActive = builder.isActive;
        this.channels = builder.channels;
        this.language = builder.language;
    }

    /**
     * <p>
     * The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
     * </p>
     * 
     * @return The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * <p>
     * The identifier of the quick response.
     * </p>
     * 
     * @return The identifier of the quick response.
     */
    public final String quickResponseId() {
        return quickResponseId;
    }

    /**
     * <p>
     * The name of the quick response.
     * </p>
     * 
     * @return The name of the quick response.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The updated content of the quick response.
     * </p>
     * 
     * @return The updated content of the quick response.
     */
    public final QuickResponseDataProvider content() {
        return content;
    }

    /**
     * <p>
     * The media type of the quick response content.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <code>application/x.quickresponse;format=plain</code> for quick response written in plain text.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>application/x.quickresponse;format=markdown</code> for quick response written in richtext.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The media type of the quick response content.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Use <code>application/x.quickresponse;format=plain</code> for quick response written in plain text.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use <code>application/x.quickresponse;format=markdown</code> for quick response written in richtext.
     *         </p>
     *         </li>
     */
    public final String contentType() {
        return contentType;
    }

    /**
     * <p>
     * The updated grouping configuration of the quick response.
     * </p>
     * 
     * @return The updated grouping configuration of the quick response.
     */
    public final GroupingConfiguration groupingConfiguration() {
        return groupingConfiguration;
    }

    /**
     * <p>
     * Whether to remove the grouping configuration of the quick response.
     * </p>
     * 
     * @return Whether to remove the grouping configuration of the quick response.
     */
    public final Boolean removeGroupingConfiguration() {
        return removeGroupingConfiguration;
    }

    /**
     * <p>
     * The updated description of the quick response.
     * </p>
     * 
     * @return The updated description of the quick response.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Whether to remove the description from the quick response.
     * </p>
     * 
     * @return Whether to remove the description from the quick response.
     */
    public final Boolean removeDescription() {
        return removeDescription;
    }

    /**
     * <p>
     * The shortcut key of the quick response. The value should be unique across the knowledge base.
     * </p>
     * 
     * @return The shortcut key of the quick response. The value should be unique across the knowledge base.
     */
    public final String shortcutKey() {
        return shortcutKey;
    }

    /**
     * <p>
     * Whether to remove the shortcut key of the quick response.
     * </p>
     * 
     * @return Whether to remove the shortcut key of the quick response.
     */
    public final Boolean removeShortcutKey() {
        return removeShortcutKey;
    }

    /**
     * <p>
     * Whether the quick response is active.
     * </p>
     * 
     * @return Whether the quick response is active.
     */
    public final Boolean isActive() {
        return isActive;
    }

    /**
     * For responses, this returns true if the service returned a value for the Channels property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasChannels() {
        return channels != null && !(channels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Connect contact channels this quick response applies to. The supported contact channel types include
     * <code>Chat</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChannels} method.
     * </p>
     * 
     * @return The Amazon Connect contact channels this quick response applies to. The supported contact channel types
     *         include <code>Chat</code>.
     */
    public final List<String> channels() {
        return channels;
    }

    /**
     * <p>
     * The language code value for the language in which the quick response is written. The supported language codes
     * include <code>de_DE</code>, <code>en_US</code>, <code>es_ES</code>, <code>fr_FR</code>, <code>id_ID</code>,
     * <code>it_IT</code>, <code>ja_JP</code>, <code>ko_KR</code>, <code>pt_BR</code>, <code>zh_CN</code>,
     * <code>zh_TW</code>
     * </p>
     * 
     * @return The language code value for the language in which the quick response is written. The supported language
     *         codes include <code>de_DE</code>, <code>en_US</code>, <code>es_ES</code>, <code>fr_FR</code>,
     *         <code>id_ID</code>, <code>it_IT</code>, <code>ja_JP</code>, <code>ko_KR</code>, <code>pt_BR</code>,
     *         <code>zh_CN</code>, <code>zh_TW</code>
     */
    public final String language() {
        return language;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(quickResponseId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(groupingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(removeGroupingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(removeDescription());
        hashCode = 31 * hashCode + Objects.hashCode(shortcutKey());
        hashCode = 31 * hashCode + Objects.hashCode(removeShortcutKey());
        hashCode = 31 * hashCode + Objects.hashCode(isActive());
        hashCode = 31 * hashCode + Objects.hashCode(hasChannels() ? channels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(language());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateQuickResponseRequest)) {
            return false;
        }
        UpdateQuickResponseRequest other = (UpdateQuickResponseRequest) obj;
        return Objects.equals(knowledgeBaseId(), other.knowledgeBaseId())
                && Objects.equals(quickResponseId(), other.quickResponseId()) && Objects.equals(name(), other.name())
                && Objects.equals(content(), other.content()) && Objects.equals(contentType(), other.contentType())
                && Objects.equals(groupingConfiguration(), other.groupingConfiguration())
                && Objects.equals(removeGroupingConfiguration(), other.removeGroupingConfiguration())
                && Objects.equals(description(), other.description())
                && Objects.equals(removeDescription(), other.removeDescription())
                && Objects.equals(shortcutKey(), other.shortcutKey())
                && Objects.equals(removeShortcutKey(), other.removeShortcutKey()) && Objects.equals(isActive(), other.isActive())
                && hasChannels() == other.hasChannels() && Objects.equals(channels(), other.channels())
                && Objects.equals(language(), other.language());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateQuickResponseRequest").add("KnowledgeBaseId", knowledgeBaseId())
                .add("QuickResponseId", quickResponseId()).add("Name", name()).add("Content", content())
                .add("ContentType", contentType()).add("GroupingConfiguration", groupingConfiguration())
                .add("RemoveGroupingConfiguration", removeGroupingConfiguration()).add("Description", description())
                .add("RemoveDescription", removeDescription()).add("ShortcutKey", shortcutKey())
                .add("RemoveShortcutKey", removeShortcutKey()).add("IsActive", isActive())
                .add("Channels", channels() == null ? null : "*** Sensitive Data Redacted ***").add("Language", language())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        case "quickResponseId":
            return Optional.ofNullable(clazz.cast(quickResponseId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "groupingConfiguration":
            return Optional.ofNullable(clazz.cast(groupingConfiguration()));
        case "removeGroupingConfiguration":
            return Optional.ofNullable(clazz.cast(removeGroupingConfiguration()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "removeDescription":
            return Optional.ofNullable(clazz.cast(removeDescription()));
        case "shortcutKey":
            return Optional.ofNullable(clazz.cast(shortcutKey()));
        case "removeShortcutKey":
            return Optional.ofNullable(clazz.cast(removeShortcutKey()));
        case "isActive":
            return Optional.ofNullable(clazz.cast(isActive()));
        case "channels":
            return Optional.ofNullable(clazz.cast(channels()));
        case "language":
            return Optional.ofNullable(clazz.cast(language()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("quickResponseId", QUICK_RESPONSE_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("content", CONTENT_FIELD);
        map.put("contentType", CONTENT_TYPE_FIELD);
        map.put("groupingConfiguration", GROUPING_CONFIGURATION_FIELD);
        map.put("removeGroupingConfiguration", REMOVE_GROUPING_CONFIGURATION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("removeDescription", REMOVE_DESCRIPTION_FIELD);
        map.put("shortcutKey", SHORTCUT_KEY_FIELD);
        map.put("removeShortcutKey", REMOVE_SHORTCUT_KEY_FIELD);
        map.put("isActive", IS_ACTIVE_FIELD);
        map.put("channels", CHANNELS_FIELD);
        map.put("language", LANGUAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateQuickResponseRequest, T> g) {
        return obj -> g.apply((UpdateQuickResponseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateQuickResponseRequest> {
        /**
         * <p>
         * The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
         * </p>
         * 
         * @param knowledgeBaseId
         *        The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        /**
         * <p>
         * The identifier of the quick response.
         * </p>
         * 
         * @param quickResponseId
         *        The identifier of the quick response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quickResponseId(String quickResponseId);

        /**
         * <p>
         * The name of the quick response.
         * </p>
         * 
         * @param name
         *        The name of the quick response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The updated content of the quick response.
         * </p>
         * 
         * @param content
         *        The updated content of the quick response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(QuickResponseDataProvider content);

        /**
         * <p>
         * The updated content of the quick response.
         * </p>
         * This is a convenience method that creates an instance of the {@link QuickResponseDataProvider.Builder}
         * avoiding the need to create one manually via {@link QuickResponseDataProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QuickResponseDataProvider.Builder#build()} is called immediately
         * and its result is passed to {@link #content(QuickResponseDataProvider)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link QuickResponseDataProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(QuickResponseDataProvider)
         */
        default Builder content(Consumer<QuickResponseDataProvider.Builder> content) {
            return content(QuickResponseDataProvider.builder().applyMutation(content).build());
        }

        /**
         * <p>
         * The media type of the quick response content.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Use <code>application/x.quickresponse;format=plain</code> for quick response written in plain text.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use <code>application/x.quickresponse;format=markdown</code> for quick response written in richtext.
         * </p>
         * </li>
         * </ul>
         * 
         * @param contentType
         *        The media type of the quick response content.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Use <code>application/x.quickresponse;format=plain</code> for quick response written in plain text.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use <code>application/x.quickresponse;format=markdown</code> for quick response written in richtext.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * The updated grouping configuration of the quick response.
         * </p>
         * 
         * @param groupingConfiguration
         *        The updated grouping configuration of the quick response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupingConfiguration(GroupingConfiguration groupingConfiguration);

        /**
         * <p>
         * The updated grouping configuration of the quick response.
         * </p>
         * This is a convenience method that creates an instance of the {@link GroupingConfiguration.Builder} avoiding
         * the need to create one manually via {@link GroupingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GroupingConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #groupingConfiguration(GroupingConfiguration)}.
         * 
         * @param groupingConfiguration
         *        a consumer that will call methods on {@link GroupingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupingConfiguration(GroupingConfiguration)
         */
        default Builder groupingConfiguration(Consumer<GroupingConfiguration.Builder> groupingConfiguration) {
            return groupingConfiguration(GroupingConfiguration.builder().applyMutation(groupingConfiguration).build());
        }

        /**
         * <p>
         * Whether to remove the grouping configuration of the quick response.
         * </p>
         * 
         * @param removeGroupingConfiguration
         *        Whether to remove the grouping configuration of the quick response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeGroupingConfiguration(Boolean removeGroupingConfiguration);

        /**
         * <p>
         * The updated description of the quick response.
         * </p>
         * 
         * @param description
         *        The updated description of the quick response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Whether to remove the description from the quick response.
         * </p>
         * 
         * @param removeDescription
         *        Whether to remove the description from the quick response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeDescription(Boolean removeDescription);

        /**
         * <p>
         * The shortcut key of the quick response. The value should be unique across the knowledge base.
         * </p>
         * 
         * @param shortcutKey
         *        The shortcut key of the quick response. The value should be unique across the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shortcutKey(String shortcutKey);

        /**
         * <p>
         * Whether to remove the shortcut key of the quick response.
         * </p>
         * 
         * @param removeShortcutKey
         *        Whether to remove the shortcut key of the quick response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeShortcutKey(Boolean removeShortcutKey);

        /**
         * <p>
         * Whether the quick response is active.
         * </p>
         * 
         * @param isActive
         *        Whether the quick response is active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isActive(Boolean isActive);

        /**
         * <p>
         * The Amazon Connect contact channels this quick response applies to. The supported contact channel types
         * include <code>Chat</code>.
         * </p>
         * 
         * @param channels
         *        The Amazon Connect contact channels this quick response applies to. The supported contact channel
         *        types include <code>Chat</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channels(Collection<String> channels);

        /**
         * <p>
         * The Amazon Connect contact channels this quick response applies to. The supported contact channel types
         * include <code>Chat</code>.
         * </p>
         * 
         * @param channels
         *        The Amazon Connect contact channels this quick response applies to. The supported contact channel
         *        types include <code>Chat</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channels(String... channels);

        /**
         * <p>
         * The language code value for the language in which the quick response is written. The supported language codes
         * include <code>de_DE</code>, <code>en_US</code>, <code>es_ES</code>, <code>fr_FR</code>, <code>id_ID</code>,
         * <code>it_IT</code>, <code>ja_JP</code>, <code>ko_KR</code>, <code>pt_BR</code>, <code>zh_CN</code>,
         * <code>zh_TW</code>
         * </p>
         * 
         * @param language
         *        The language code value for the language in which the quick response is written. The supported
         *        language codes include <code>de_DE</code>, <code>en_US</code>, <code>es_ES</code>, <code>fr_FR</code>,
         *        <code>id_ID</code>, <code>it_IT</code>, <code>ja_JP</code>, <code>ko_KR</code>, <code>pt_BR</code>,
         *        <code>zh_CN</code>, <code>zh_TW</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder language(String language);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QConnectRequest.BuilderImpl implements Builder {
        private String knowledgeBaseId;

        private String quickResponseId;

        private String name;

        private QuickResponseDataProvider content;

        private String contentType;

        private GroupingConfiguration groupingConfiguration;

        private Boolean removeGroupingConfiguration;

        private String description;

        private Boolean removeDescription;

        private String shortcutKey;

        private Boolean removeShortcutKey;

        private Boolean isActive;

        private List<String> channels = DefaultSdkAutoConstructList.getInstance();

        private String language;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateQuickResponseRequest model) {
            super(model);
            knowledgeBaseId(model.knowledgeBaseId);
            quickResponseId(model.quickResponseId);
            name(model.name);
            content(model.content);
            contentType(model.contentType);
            groupingConfiguration(model.groupingConfiguration);
            removeGroupingConfiguration(model.removeGroupingConfiguration);
            description(model.description);
            removeDescription(model.removeDescription);
            shortcutKey(model.shortcutKey);
            removeShortcutKey(model.removeShortcutKey);
            isActive(model.isActive);
            channels(model.channels);
            language(model.language);
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getQuickResponseId() {
            return quickResponseId;
        }

        public final void setQuickResponseId(String quickResponseId) {
            this.quickResponseId = quickResponseId;
        }

        @Override
        public final Builder quickResponseId(String quickResponseId) {
            this.quickResponseId = quickResponseId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final QuickResponseDataProvider.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(QuickResponseDataProvider.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(QuickResponseDataProvider content) {
            this.content = content;
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final GroupingConfiguration.Builder getGroupingConfiguration() {
            return groupingConfiguration != null ? groupingConfiguration.toBuilder() : null;
        }

        public final void setGroupingConfiguration(GroupingConfiguration.BuilderImpl groupingConfiguration) {
            this.groupingConfiguration = groupingConfiguration != null ? groupingConfiguration.build() : null;
        }

        @Override
        public final Builder groupingConfiguration(GroupingConfiguration groupingConfiguration) {
            this.groupingConfiguration = groupingConfiguration;
            return this;
        }

        public final Boolean getRemoveGroupingConfiguration() {
            return removeGroupingConfiguration;
        }

        public final void setRemoveGroupingConfiguration(Boolean removeGroupingConfiguration) {
            this.removeGroupingConfiguration = removeGroupingConfiguration;
        }

        @Override
        public final Builder removeGroupingConfiguration(Boolean removeGroupingConfiguration) {
            this.removeGroupingConfiguration = removeGroupingConfiguration;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getRemoveDescription() {
            return removeDescription;
        }

        public final void setRemoveDescription(Boolean removeDescription) {
            this.removeDescription = removeDescription;
        }

        @Override
        public final Builder removeDescription(Boolean removeDescription) {
            this.removeDescription = removeDescription;
            return this;
        }

        public final String getShortcutKey() {
            return shortcutKey;
        }

        public final void setShortcutKey(String shortcutKey) {
            this.shortcutKey = shortcutKey;
        }

        @Override
        public final Builder shortcutKey(String shortcutKey) {
            this.shortcutKey = shortcutKey;
            return this;
        }

        public final Boolean getRemoveShortcutKey() {
            return removeShortcutKey;
        }

        public final void setRemoveShortcutKey(Boolean removeShortcutKey) {
            this.removeShortcutKey = removeShortcutKey;
        }

        @Override
        public final Builder removeShortcutKey(Boolean removeShortcutKey) {
            this.removeShortcutKey = removeShortcutKey;
            return this;
        }

        public final Boolean getIsActive() {
            return isActive;
        }

        public final void setIsActive(Boolean isActive) {
            this.isActive = isActive;
        }

        @Override
        public final Builder isActive(Boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        public final Collection<String> getChannels() {
            if (channels instanceof SdkAutoConstructList) {
                return null;
            }
            return channels;
        }

        public final void setChannels(Collection<String> channels) {
            this.channels = ChannelsCopier.copy(channels);
        }

        @Override
        public final Builder channels(Collection<String> channels) {
            this.channels = ChannelsCopier.copy(channels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channels(String... channels) {
            channels(Arrays.asList(channels));
            return this;
        }

        public final String getLanguage() {
            return language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateQuickResponseRequest build() {
            return new UpdateQuickResponseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
