/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssistantAssociationInputData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssistantAssociationInputData> {
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(AssistantAssociationInputData.getter(AssistantAssociationInputData::knowledgeBaseId)).setter(AssistantAssociationInputData.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWLEDGE_BASE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssistantAssociationInputData.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String knowledgeBaseId;
    private final Type type;

    private AssistantAssociationInputData(BuilderImpl builder) {
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.type = builder.type;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssistantAssociationInputData)) {
            return false;
        }
        AssistantAssociationInputData other = (AssistantAssociationInputData)obj;
        return Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId());
    }

    public final String toString() {
        return ToString.builder((String)"AssistantAssociationInputData").add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
        }
        return Optional.empty();
    }

    public static AssistantAssociationInputData fromKnowledgeBaseId(String knowledgeBaseId) {
        return (AssistantAssociationInputData)AssistantAssociationInputData.builder().knowledgeBaseId(knowledgeBaseId).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssistantAssociationInputData, T> g) {
        return obj -> g.apply((AssistantAssociationInputData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        KNOWLEDGE_BASE_ID,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String knowledgeBaseId;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AssistantAssociationInputData model) {
            this.knowledgeBaseId(model.knowledgeBaseId);
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            String oldValue = this.knowledgeBaseId;
            this.knowledgeBaseId = knowledgeBaseId;
            this.handleUnionValueChange(Type.KNOWLEDGE_BASE_ID, oldValue, this.knowledgeBaseId);
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            String oldValue = this.knowledgeBaseId;
            this.knowledgeBaseId = knowledgeBaseId;
            this.handleUnionValueChange(Type.KNOWLEDGE_BASE_ID, oldValue, this.knowledgeBaseId);
            return this;
        }

        public AssistantAssociationInputData build() {
            return new AssistantAssociationInputData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssistantAssociationInputData> {
        public Builder knowledgeBaseId(String var1);
    }
}

