/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.qconnect.internal.QConnectServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.qconnect.internal.ServiceVersionInfo;
import software.amazon.awssdk.services.qconnect.model.AccessDeniedException;
import software.amazon.awssdk.services.qconnect.model.ActivateMessageTemplateRequest;
import software.amazon.awssdk.services.qconnect.model.ActivateMessageTemplateResponse;
import software.amazon.awssdk.services.qconnect.model.ConflictException;
import software.amazon.awssdk.services.qconnect.model.CreateAiAgentRequest;
import software.amazon.awssdk.services.qconnect.model.CreateAiAgentResponse;
import software.amazon.awssdk.services.qconnect.model.CreateAiAgentVersionRequest;
import software.amazon.awssdk.services.qconnect.model.CreateAiAgentVersionResponse;
import software.amazon.awssdk.services.qconnect.model.CreateAiGuardrailRequest;
import software.amazon.awssdk.services.qconnect.model.CreateAiGuardrailResponse;
import software.amazon.awssdk.services.qconnect.model.CreateAiGuardrailVersionRequest;
import software.amazon.awssdk.services.qconnect.model.CreateAiGuardrailVersionResponse;
import software.amazon.awssdk.services.qconnect.model.CreateAiPromptRequest;
import software.amazon.awssdk.services.qconnect.model.CreateAiPromptResponse;
import software.amazon.awssdk.services.qconnect.model.CreateAiPromptVersionRequest;
import software.amazon.awssdk.services.qconnect.model.CreateAiPromptVersionResponse;
import software.amazon.awssdk.services.qconnect.model.CreateAssistantAssociationRequest;
import software.amazon.awssdk.services.qconnect.model.CreateAssistantAssociationResponse;
import software.amazon.awssdk.services.qconnect.model.CreateAssistantRequest;
import software.amazon.awssdk.services.qconnect.model.CreateAssistantResponse;
import software.amazon.awssdk.services.qconnect.model.CreateContentAssociationRequest;
import software.amazon.awssdk.services.qconnect.model.CreateContentAssociationResponse;
import software.amazon.awssdk.services.qconnect.model.CreateContentRequest;
import software.amazon.awssdk.services.qconnect.model.CreateContentResponse;
import software.amazon.awssdk.services.qconnect.model.CreateKnowledgeBaseRequest;
import software.amazon.awssdk.services.qconnect.model.CreateKnowledgeBaseResponse;
import software.amazon.awssdk.services.qconnect.model.CreateMessageTemplateAttachmentRequest;
import software.amazon.awssdk.services.qconnect.model.CreateMessageTemplateAttachmentResponse;
import software.amazon.awssdk.services.qconnect.model.CreateMessageTemplateRequest;
import software.amazon.awssdk.services.qconnect.model.CreateMessageTemplateResponse;
import software.amazon.awssdk.services.qconnect.model.CreateMessageTemplateVersionRequest;
import software.amazon.awssdk.services.qconnect.model.CreateMessageTemplateVersionResponse;
import software.amazon.awssdk.services.qconnect.model.CreateQuickResponseRequest;
import software.amazon.awssdk.services.qconnect.model.CreateQuickResponseResponse;
import software.amazon.awssdk.services.qconnect.model.CreateSessionRequest;
import software.amazon.awssdk.services.qconnect.model.CreateSessionResponse;
import software.amazon.awssdk.services.qconnect.model.DeactivateMessageTemplateRequest;
import software.amazon.awssdk.services.qconnect.model.DeactivateMessageTemplateResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteAiAgentRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteAiAgentResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteAiAgentVersionRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteAiAgentVersionResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteAiGuardrailRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteAiGuardrailResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteAiGuardrailVersionRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteAiGuardrailVersionResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteAiPromptRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteAiPromptResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteAiPromptVersionRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteAiPromptVersionResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteAssistantAssociationRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteAssistantAssociationResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteAssistantRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteAssistantResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteContentAssociationRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteContentAssociationResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteContentRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteContentResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteImportJobRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteImportJobResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteKnowledgeBaseRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteKnowledgeBaseResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteMessageTemplateAttachmentRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteMessageTemplateAttachmentResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteMessageTemplateRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteMessageTemplateResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteQuickResponseRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteQuickResponseResponse;
import software.amazon.awssdk.services.qconnect.model.DependencyFailedException;
import software.amazon.awssdk.services.qconnect.model.GetAiAgentRequest;
import software.amazon.awssdk.services.qconnect.model.GetAiAgentResponse;
import software.amazon.awssdk.services.qconnect.model.GetAiGuardrailRequest;
import software.amazon.awssdk.services.qconnect.model.GetAiGuardrailResponse;
import software.amazon.awssdk.services.qconnect.model.GetAiPromptRequest;
import software.amazon.awssdk.services.qconnect.model.GetAiPromptResponse;
import software.amazon.awssdk.services.qconnect.model.GetAssistantAssociationRequest;
import software.amazon.awssdk.services.qconnect.model.GetAssistantAssociationResponse;
import software.amazon.awssdk.services.qconnect.model.GetAssistantRequest;
import software.amazon.awssdk.services.qconnect.model.GetAssistantResponse;
import software.amazon.awssdk.services.qconnect.model.GetContentAssociationRequest;
import software.amazon.awssdk.services.qconnect.model.GetContentAssociationResponse;
import software.amazon.awssdk.services.qconnect.model.GetContentRequest;
import software.amazon.awssdk.services.qconnect.model.GetContentResponse;
import software.amazon.awssdk.services.qconnect.model.GetContentSummaryRequest;
import software.amazon.awssdk.services.qconnect.model.GetContentSummaryResponse;
import software.amazon.awssdk.services.qconnect.model.GetImportJobRequest;
import software.amazon.awssdk.services.qconnect.model.GetImportJobResponse;
import software.amazon.awssdk.services.qconnect.model.GetKnowledgeBaseRequest;
import software.amazon.awssdk.services.qconnect.model.GetKnowledgeBaseResponse;
import software.amazon.awssdk.services.qconnect.model.GetMessageTemplateRequest;
import software.amazon.awssdk.services.qconnect.model.GetMessageTemplateResponse;
import software.amazon.awssdk.services.qconnect.model.GetNextMessageRequest;
import software.amazon.awssdk.services.qconnect.model.GetNextMessageResponse;
import software.amazon.awssdk.services.qconnect.model.GetQuickResponseRequest;
import software.amazon.awssdk.services.qconnect.model.GetQuickResponseResponse;
import software.amazon.awssdk.services.qconnect.model.GetRecommendationsRequest;
import software.amazon.awssdk.services.qconnect.model.GetRecommendationsResponse;
import software.amazon.awssdk.services.qconnect.model.GetSessionRequest;
import software.amazon.awssdk.services.qconnect.model.GetSessionResponse;
import software.amazon.awssdk.services.qconnect.model.ListAiAgentVersionsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAiAgentVersionsResponse;
import software.amazon.awssdk.services.qconnect.model.ListAiAgentsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAiAgentsResponse;
import software.amazon.awssdk.services.qconnect.model.ListAiGuardrailVersionsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAiGuardrailVersionsResponse;
import software.amazon.awssdk.services.qconnect.model.ListAiGuardrailsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAiGuardrailsResponse;
import software.amazon.awssdk.services.qconnect.model.ListAiPromptVersionsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAiPromptVersionsResponse;
import software.amazon.awssdk.services.qconnect.model.ListAiPromptsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAiPromptsResponse;
import software.amazon.awssdk.services.qconnect.model.ListAssistantAssociationsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAssistantAssociationsResponse;
import software.amazon.awssdk.services.qconnect.model.ListAssistantsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAssistantsResponse;
import software.amazon.awssdk.services.qconnect.model.ListContentAssociationsRequest;
import software.amazon.awssdk.services.qconnect.model.ListContentAssociationsResponse;
import software.amazon.awssdk.services.qconnect.model.ListContentsRequest;
import software.amazon.awssdk.services.qconnect.model.ListContentsResponse;
import software.amazon.awssdk.services.qconnect.model.ListImportJobsRequest;
import software.amazon.awssdk.services.qconnect.model.ListImportJobsResponse;
import software.amazon.awssdk.services.qconnect.model.ListKnowledgeBasesRequest;
import software.amazon.awssdk.services.qconnect.model.ListKnowledgeBasesResponse;
import software.amazon.awssdk.services.qconnect.model.ListMessageTemplateVersionsRequest;
import software.amazon.awssdk.services.qconnect.model.ListMessageTemplateVersionsResponse;
import software.amazon.awssdk.services.qconnect.model.ListMessageTemplatesRequest;
import software.amazon.awssdk.services.qconnect.model.ListMessageTemplatesResponse;
import software.amazon.awssdk.services.qconnect.model.ListMessagesRequest;
import software.amazon.awssdk.services.qconnect.model.ListMessagesResponse;
import software.amazon.awssdk.services.qconnect.model.ListQuickResponsesRequest;
import software.amazon.awssdk.services.qconnect.model.ListQuickResponsesResponse;
import software.amazon.awssdk.services.qconnect.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.qconnect.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.qconnect.model.NotifyRecommendationsReceivedRequest;
import software.amazon.awssdk.services.qconnect.model.NotifyRecommendationsReceivedResponse;
import software.amazon.awssdk.services.qconnect.model.PreconditionFailedException;
import software.amazon.awssdk.services.qconnect.model.PutFeedbackRequest;
import software.amazon.awssdk.services.qconnect.model.PutFeedbackResponse;
import software.amazon.awssdk.services.qconnect.model.QConnectException;
import software.amazon.awssdk.services.qconnect.model.QueryAssistantRequest;
import software.amazon.awssdk.services.qconnect.model.QueryAssistantResponse;
import software.amazon.awssdk.services.qconnect.model.RemoveAssistantAiAgentRequest;
import software.amazon.awssdk.services.qconnect.model.RemoveAssistantAiAgentResponse;
import software.amazon.awssdk.services.qconnect.model.RemoveKnowledgeBaseTemplateUriRequest;
import software.amazon.awssdk.services.qconnect.model.RemoveKnowledgeBaseTemplateUriResponse;
import software.amazon.awssdk.services.qconnect.model.RenderMessageTemplateRequest;
import software.amazon.awssdk.services.qconnect.model.RenderMessageTemplateResponse;
import software.amazon.awssdk.services.qconnect.model.RequestTimeoutException;
import software.amazon.awssdk.services.qconnect.model.ResourceNotFoundException;
import software.amazon.awssdk.services.qconnect.model.SearchContentRequest;
import software.amazon.awssdk.services.qconnect.model.SearchContentResponse;
import software.amazon.awssdk.services.qconnect.model.SearchMessageTemplatesRequest;
import software.amazon.awssdk.services.qconnect.model.SearchMessageTemplatesResponse;
import software.amazon.awssdk.services.qconnect.model.SearchQuickResponsesRequest;
import software.amazon.awssdk.services.qconnect.model.SearchQuickResponsesResponse;
import software.amazon.awssdk.services.qconnect.model.SearchSessionsRequest;
import software.amazon.awssdk.services.qconnect.model.SearchSessionsResponse;
import software.amazon.awssdk.services.qconnect.model.SendMessageRequest;
import software.amazon.awssdk.services.qconnect.model.SendMessageResponse;
import software.amazon.awssdk.services.qconnect.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.qconnect.model.StartContentUploadRequest;
import software.amazon.awssdk.services.qconnect.model.StartContentUploadResponse;
import software.amazon.awssdk.services.qconnect.model.StartImportJobRequest;
import software.amazon.awssdk.services.qconnect.model.StartImportJobResponse;
import software.amazon.awssdk.services.qconnect.model.TagResourceRequest;
import software.amazon.awssdk.services.qconnect.model.TagResourceResponse;
import software.amazon.awssdk.services.qconnect.model.ThrottlingException;
import software.amazon.awssdk.services.qconnect.model.TooManyTagsException;
import software.amazon.awssdk.services.qconnect.model.UnauthorizedException;
import software.amazon.awssdk.services.qconnect.model.UntagResourceRequest;
import software.amazon.awssdk.services.qconnect.model.UntagResourceResponse;
import software.amazon.awssdk.services.qconnect.model.UpdateAiAgentRequest;
import software.amazon.awssdk.services.qconnect.model.UpdateAiAgentResponse;
import software.amazon.awssdk.services.qconnect.model.UpdateAiGuardrailRequest;
import software.amazon.awssdk.services.qconnect.model.UpdateAiGuardrailResponse;
import software.amazon.awssdk.services.qconnect.model.UpdateAiPromptRequest;
import software.amazon.awssdk.services.qconnect.model.UpdateAiPromptResponse;
import software.amazon.awssdk.services.qconnect.model.UpdateAssistantAiAgentRequest;
import software.amazon.awssdk.services.qconnect.model.UpdateAssistantAiAgentResponse;
import software.amazon.awssdk.services.qconnect.model.UpdateContentRequest;
import software.amazon.awssdk.services.qconnect.model.UpdateContentResponse;
import software.amazon.awssdk.services.qconnect.model.UpdateKnowledgeBaseTemplateUriRequest;
import software.amazon.awssdk.services.qconnect.model.UpdateKnowledgeBaseTemplateUriResponse;
import software.amazon.awssdk.services.qconnect.model.UpdateMessageTemplateMetadataRequest;
import software.amazon.awssdk.services.qconnect.model.UpdateMessageTemplateMetadataResponse;
import software.amazon.awssdk.services.qconnect.model.UpdateMessageTemplateRequest;
import software.amazon.awssdk.services.qconnect.model.UpdateMessageTemplateResponse;
import software.amazon.awssdk.services.qconnect.model.UpdateQuickResponseRequest;
import software.amazon.awssdk.services.qconnect.model.UpdateQuickResponseResponse;
import software.amazon.awssdk.services.qconnect.model.UpdateSessionDataRequest;
import software.amazon.awssdk.services.qconnect.model.UpdateSessionDataResponse;
import software.amazon.awssdk.services.qconnect.model.UpdateSessionRequest;
import software.amazon.awssdk.services.qconnect.model.UpdateSessionResponse;
import software.amazon.awssdk.services.qconnect.model.ValidationException;
import software.amazon.awssdk.services.qconnect.transform.ActivateMessageTemplateRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.CreateAiAgentRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.CreateAiAgentVersionRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.CreateAiGuardrailRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.CreateAiGuardrailVersionRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.CreateAiPromptRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.CreateAiPromptVersionRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.CreateAssistantAssociationRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.CreateAssistantRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.CreateContentAssociationRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.CreateContentRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.CreateKnowledgeBaseRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.CreateMessageTemplateAttachmentRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.CreateMessageTemplateRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.CreateMessageTemplateVersionRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.CreateQuickResponseRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.CreateSessionRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.DeactivateMessageTemplateRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.DeleteAiAgentRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.DeleteAiAgentVersionRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.DeleteAiGuardrailRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.DeleteAiGuardrailVersionRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.DeleteAiPromptRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.DeleteAiPromptVersionRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.DeleteAssistantAssociationRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.DeleteAssistantRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.DeleteContentAssociationRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.DeleteContentRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.DeleteImportJobRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.DeleteKnowledgeBaseRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.DeleteMessageTemplateAttachmentRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.DeleteMessageTemplateRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.DeleteQuickResponseRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.GetAiAgentRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.GetAiGuardrailRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.GetAiPromptRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.GetAssistantAssociationRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.GetAssistantRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.GetContentAssociationRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.GetContentRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.GetContentSummaryRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.GetImportJobRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.GetKnowledgeBaseRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.GetMessageTemplateRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.GetNextMessageRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.GetQuickResponseRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.GetRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.GetSessionRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.ListAiAgentVersionsRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.ListAiAgentsRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.ListAiGuardrailVersionsRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.ListAiGuardrailsRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.ListAiPromptVersionsRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.ListAiPromptsRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.ListAssistantAssociationsRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.ListAssistantsRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.ListContentAssociationsRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.ListContentsRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.ListImportJobsRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.ListKnowledgeBasesRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.ListMessageTemplateVersionsRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.ListMessageTemplatesRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.ListMessagesRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.ListQuickResponsesRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.NotifyRecommendationsReceivedRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.PutFeedbackRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.QueryAssistantRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.RemoveAssistantAiAgentRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.RemoveKnowledgeBaseTemplateUriRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.RenderMessageTemplateRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.SearchContentRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.SearchMessageTemplatesRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.SearchQuickResponsesRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.SearchSessionsRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.SendMessageRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.StartContentUploadRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.StartImportJobRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.UpdateAiAgentRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.UpdateAiGuardrailRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.UpdateAiPromptRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.UpdateAssistantAiAgentRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.UpdateContentRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.UpdateKnowledgeBaseTemplateUriRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.UpdateMessageTemplateMetadataRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.UpdateMessageTemplateRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.UpdateQuickResponseRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.UpdateSessionDataRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.UpdateSessionRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link QConnectClient}.
 *
 * @see QConnectClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultQConnectClient implements QConnectClient {
    private static final Logger log = Logger.loggerFor(DefaultQConnectClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultQConnectClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this)
                .option(SdkClientOption.API_METADATA, "QConnect" + "#" + ServiceVersionInfo.VERSION).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Activates a specific version of the Amazon Q in Connect message template. After the version is activated, the
     * previous active version will be deactivated automatically. You can use the <code>&#36ACTIVE_VERSION</code>
     * qualifier later to reference the version that is in active status.
     * </p>
     *
     * @param activateMessageTemplateRequest
     * @return Result of the ActivateMessageTemplate operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ActivateMessageTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ActivateMessageTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ActivateMessageTemplateResponse activateMessageTemplate(ActivateMessageTemplateRequest activateMessageTemplateRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ActivateMessageTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ActivateMessageTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(activateMessageTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, activateMessageTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ActivateMessageTemplate");

            return clientHandler
                    .execute(new ClientExecutionParams<ActivateMessageTemplateRequest, ActivateMessageTemplateResponse>()
                            .withOperationName("ActivateMessageTemplate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(activateMessageTemplateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ActivateMessageTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Amazon Q in Connect AI Agent.
     * </p>
     *
     * @param createAiAgentRequest
     * @return Result of the CreateAIAgent operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ServiceQuotaExceededException
     *         You've exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use service quotas to request a service quota increase.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.CreateAIAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateAIAgent" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateAiAgentResponse createAIAgent(CreateAiAgentRequest createAiAgentRequest) throws ConflictException,
            ValidationException, ServiceQuotaExceededException, UnauthorizedException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAiAgentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateAiAgentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAiAgentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAiAgentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAIAgent");

            return clientHandler.execute(new ClientExecutionParams<CreateAiAgentRequest, CreateAiAgentResponse>()
                    .withOperationName("CreateAIAgent").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createAiAgentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAiAgentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates and Amazon Q in Connect AI Agent version.
     * </p>
     *
     * @param createAiAgentVersionRequest
     * @return Result of the CreateAIAgentVersion operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ServiceQuotaExceededException
     *         You've exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use service quotas to request a service quota increase.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.CreateAIAgentVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateAIAgentVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateAiAgentVersionResponse createAIAgentVersion(CreateAiAgentVersionRequest createAiAgentVersionRequest)
            throws ConflictException, ValidationException, ServiceQuotaExceededException, UnauthorizedException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAiAgentVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateAiAgentVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAiAgentVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAiAgentVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAIAgentVersion");

            return clientHandler.execute(new ClientExecutionParams<CreateAiAgentVersionRequest, CreateAiAgentVersionResponse>()
                    .withOperationName("CreateAIAgentVersion").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createAiAgentVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAiAgentVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Amazon Q in Connect AI Guardrail.
     * </p>
     *
     * @param createAiGuardrailRequest
     * @return Result of the CreateAIGuardrail operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ServiceQuotaExceededException
     *         You've exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use service quotas to request a service quota increase.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.CreateAIGuardrail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateAIGuardrail" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateAiGuardrailResponse createAIGuardrail(CreateAiGuardrailRequest createAiGuardrailRequest)
            throws ConflictException, ValidationException, ServiceQuotaExceededException, UnauthorizedException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAiGuardrailResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateAiGuardrailResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAiGuardrailRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAiGuardrailRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAIGuardrail");

            return clientHandler.execute(new ClientExecutionParams<CreateAiGuardrailRequest, CreateAiGuardrailResponse>()
                    .withOperationName("CreateAIGuardrail").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createAiGuardrailRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAiGuardrailRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Amazon Q in Connect AI Guardrail version.
     * </p>
     *
     * @param createAiGuardrailVersionRequest
     * @return Result of the CreateAIGuardrailVersion operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ServiceQuotaExceededException
     *         You've exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use service quotas to request a service quota increase.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.CreateAIGuardrailVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateAIGuardrailVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateAiGuardrailVersionResponse createAIGuardrailVersion(
            CreateAiGuardrailVersionRequest createAiGuardrailVersionRequest) throws ConflictException, ValidationException,
            ServiceQuotaExceededException, UnauthorizedException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAiGuardrailVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateAiGuardrailVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAiGuardrailVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAiGuardrailVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAIGuardrailVersion");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateAiGuardrailVersionRequest, CreateAiGuardrailVersionResponse>()
                            .withOperationName("CreateAIGuardrailVersion").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createAiGuardrailVersionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateAiGuardrailVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Amazon Q in Connect AI Prompt.
     * </p>
     *
     * @param createAiPromptRequest
     * @return Result of the CreateAIPrompt operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ServiceQuotaExceededException
     *         You've exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use service quotas to request a service quota increase.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.CreateAIPrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateAIPrompt" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateAiPromptResponse createAIPrompt(CreateAiPromptRequest createAiPromptRequest) throws ConflictException,
            ValidationException, ServiceQuotaExceededException, UnauthorizedException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAiPromptResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateAiPromptResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAiPromptRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAiPromptRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAIPrompt");

            return clientHandler.execute(new ClientExecutionParams<CreateAiPromptRequest, CreateAiPromptResponse>()
                    .withOperationName("CreateAIPrompt").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createAiPromptRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAiPromptRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Amazon Q in Connect AI Prompt version.
     * </p>
     *
     * @param createAiPromptVersionRequest
     * @return Result of the CreateAIPromptVersion operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ServiceQuotaExceededException
     *         You've exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use service quotas to request a service quota increase.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.CreateAIPromptVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateAIPromptVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateAiPromptVersionResponse createAIPromptVersion(CreateAiPromptVersionRequest createAiPromptVersionRequest)
            throws ConflictException, ValidationException, ServiceQuotaExceededException, UnauthorizedException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAiPromptVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateAiPromptVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAiPromptVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAiPromptVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAIPromptVersion");

            return clientHandler.execute(new ClientExecutionParams<CreateAiPromptVersionRequest, CreateAiPromptVersionResponse>()
                    .withOperationName("CreateAIPromptVersion").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createAiPromptVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAiPromptVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Amazon Q in Connect assistant.
     * </p>
     *
     * @param createAssistantRequest
     * @return Result of the CreateAssistant operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ServiceQuotaExceededException
     *         You've exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use service quotas to request a service quota increase.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.CreateAssistant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateAssistant" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateAssistantResponse createAssistant(CreateAssistantRequest createAssistantRequest) throws ConflictException,
            ValidationException, ServiceQuotaExceededException, UnauthorizedException, AccessDeniedException,
            AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAssistantResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateAssistantResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAssistantRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAssistantRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAssistant");

            return clientHandler.execute(new ClientExecutionParams<CreateAssistantRequest, CreateAssistantResponse>()
                    .withOperationName("CreateAssistant").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createAssistantRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAssistantRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an association between an Amazon Q in Connect assistant and another resource. Currently, the only
     * supported association is with a knowledge base. An assistant can have only a single association.
     * </p>
     *
     * @param createAssistantAssociationRequest
     * @return Result of the CreateAssistantAssociation operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ServiceQuotaExceededException
     *         You've exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use service quotas to request a service quota increase.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.CreateAssistantAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateAssistantAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateAssistantAssociationResponse createAssistantAssociation(
            CreateAssistantAssociationRequest createAssistantAssociationRequest) throws ConflictException, ValidationException,
            ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAssistantAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateAssistantAssociationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAssistantAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAssistantAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAssistantAssociation");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateAssistantAssociationRequest, CreateAssistantAssociationResponse>()
                            .withOperationName("CreateAssistantAssociation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createAssistantAssociationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateAssistantAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates Amazon Q in Connect content. Before to calling this API, use <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_StartContentUpload.html"
     * >StartContentUpload</a> to upload an asset.
     * </p>
     *
     * @param createContentRequest
     * @return Result of the CreateContent operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ServiceQuotaExceededException
     *         You've exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use service quotas to request a service quota increase.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.CreateContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateContent" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateContentResponse createContent(CreateContentRequest createContentRequest) throws ConflictException,
            ValidationException, ServiceQuotaExceededException, UnauthorizedException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateContentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateContentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createContentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createContentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateContent");

            return clientHandler.execute(new ClientExecutionParams<CreateContentRequest, CreateContentResponse>()
                    .withOperationName("CreateContent").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createContentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateContentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an association between a content resource in a knowledge base and <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/step-by-step-guided-experiences.html">step-by-step
     * guides</a>. Step-by-step guides offer instructions to agents for resolving common customer issues. You create a
     * content association to integrate Amazon Q in Connect and step-by-step guides.
     * </p>
     * <p>
     * After you integrate Amazon Q and step-by-step guides, when Amazon Q provides a recommendation to an agent based
     * on the intent that it's detected, it also provides them with the option to start the step-by-step guide that you
     * have associated with the content.
     * </p>
     * <p>
     * Note the following limitations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can create only one content association for each content resource in a knowledge base.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can associate a step-by-step guide with multiple content resources.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/integrate-q-with-guides.html">Integrate Amazon Q in
     * Connect with step-by-step guides</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param createContentAssociationRequest
     * @return Result of the CreateContentAssociation operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ServiceQuotaExceededException
     *         You've exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use service quotas to request a service quota increase.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.CreateContentAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateContentAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateContentAssociationResponse createContentAssociation(
            CreateContentAssociationRequest createContentAssociationRequest) throws ConflictException, ValidationException,
            ServiceQuotaExceededException, UnauthorizedException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateContentAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateContentAssociationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createContentAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createContentAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateContentAssociation");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateContentAssociationRequest, CreateContentAssociationResponse>()
                            .withOperationName("CreateContentAssociation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createContentAssociationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateContentAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a knowledge base.
     * </p>
     * <note>
     * <p>
     * When using this API, you cannot reuse <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/Welcome.html">Amazon AppIntegrations</a>
     * DataIntegrations with external knowledge bases such as Salesforce and ServiceNow. If you do, you'll get an
     * <code>InvalidRequestException</code> error.
     * </p>
     * <p>
     * For example, you're programmatically managing your external knowledge base, and you want to add or remove one of
     * the fields that is being ingested from Salesforce. Do the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Call <a href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_DeleteKnowledgeBase.html">
     * DeleteKnowledgeBase</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_DeleteDataIntegration.html">
     * DeleteDataIntegration</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html">
     * CreateDataIntegration</a> to recreate the DataIntegration or a create different one.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call CreateKnowledgeBase.
     * </p>
     * </li>
     * </ol>
     * </note>
     *
     * @param createKnowledgeBaseRequest
     * @return Result of the CreateKnowledgeBase operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ServiceQuotaExceededException
     *         You've exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use service quotas to request a service quota increase.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.CreateKnowledgeBase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateKnowledgeBase" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateKnowledgeBaseResponse createKnowledgeBase(CreateKnowledgeBaseRequest createKnowledgeBaseRequest)
            throws ConflictException, ValidationException, ServiceQuotaExceededException, UnauthorizedException,
            AccessDeniedException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateKnowledgeBaseResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateKnowledgeBaseResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createKnowledgeBaseRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createKnowledgeBaseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateKnowledgeBase");

            return clientHandler.execute(new ClientExecutionParams<CreateKnowledgeBaseRequest, CreateKnowledgeBaseResponse>()
                    .withOperationName("CreateKnowledgeBase").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createKnowledgeBaseRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateKnowledgeBaseRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Amazon Q in Connect message template. The name of the message template has to be unique for each
     * knowledge base. The channel subtype of the message template is immutable and cannot be modified after creation.
     * After the message template is created, you can use the <code>&#36LATEST</code> qualifier to reference the created
     * message template.
     * </p>
     *
     * @param createMessageTemplateRequest
     * @return Result of the CreateMessageTemplate operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ServiceQuotaExceededException
     *         You've exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use service quotas to request a service quota increase.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.CreateMessageTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateMessageTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateMessageTemplateResponse createMessageTemplate(CreateMessageTemplateRequest createMessageTemplateRequest)
            throws ConflictException, ValidationException, ServiceQuotaExceededException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateMessageTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateMessageTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMessageTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMessageTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMessageTemplate");

            return clientHandler.execute(new ClientExecutionParams<CreateMessageTemplateRequest, CreateMessageTemplateResponse>()
                    .withOperationName("CreateMessageTemplate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createMessageTemplateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateMessageTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Uploads an attachment file to the specified Amazon Q in Connect message template. The name of the message
     * template attachment has to be unique for each message template referenced by the <code>&#36LATEST</code>
     * qualifier. The body of the attachment file should be encoded using base64 encoding. After the file is uploaded,
     * you can use the pre-signed Amazon S3 URL returned in response to download the uploaded file.
     * </p>
     *
     * @param createMessageTemplateAttachmentRequest
     * @return Result of the CreateMessageTemplateAttachment operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ServiceQuotaExceededException
     *         You've exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use service quotas to request a service quota increase.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.CreateMessageTemplateAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateMessageTemplateAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateMessageTemplateAttachmentResponse createMessageTemplateAttachment(
            CreateMessageTemplateAttachmentRequest createMessageTemplateAttachmentRequest) throws ConflictException,
            ValidationException, ServiceQuotaExceededException, UnauthorizedException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateMessageTemplateAttachmentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateMessageTemplateAttachmentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMessageTemplateAttachmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createMessageTemplateAttachmentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMessageTemplateAttachment");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateMessageTemplateAttachmentRequest, CreateMessageTemplateAttachmentResponse>()
                            .withOperationName("CreateMessageTemplateAttachment").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createMessageTemplateAttachmentRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateMessageTemplateAttachmentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new Amazon Q in Connect message template version from the current content and configuration of a
     * message template. Versions are immutable and monotonically increasing. Once a version is created, you can
     * reference a specific version of the message template by passing in
     * <code>&lt;message-template-id&gt;:&lt;versionNumber&gt;</code> as the message template identifier. An error is
     * displayed if the supplied <code>messageTemplateContentSha256</code> is different from the
     * <code>messageTemplateContentSha256</code> of the message template with <code>&#36LATEST</code> qualifier. If
     * multiple <code>CreateMessageTemplateVersion</code> requests are made while the message template remains the same,
     * only the first invocation creates a new version and the succeeding requests will return the same response as the
     * first invocation.
     * </p>
     *
     * @param createMessageTemplateVersionRequest
     * @return Result of the CreateMessageTemplateVersion operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ServiceQuotaExceededException
     *         You've exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use service quotas to request a service quota increase.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.CreateMessageTemplateVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateMessageTemplateVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateMessageTemplateVersionResponse createMessageTemplateVersion(
            CreateMessageTemplateVersionRequest createMessageTemplateVersionRequest) throws ConflictException,
            ValidationException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateMessageTemplateVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateMessageTemplateVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMessageTemplateVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMessageTemplateVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMessageTemplateVersion");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateMessageTemplateVersionRequest, CreateMessageTemplateVersionResponse>()
                            .withOperationName("CreateMessageTemplateVersion").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createMessageTemplateVersionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateMessageTemplateVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Amazon Q in Connect quick response.
     * </p>
     *
     * @param createQuickResponseRequest
     * @return Result of the CreateQuickResponse operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ServiceQuotaExceededException
     *         You've exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use service quotas to request a service quota increase.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.CreateQuickResponse
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateQuickResponse" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateQuickResponseResponse createQuickResponse(CreateQuickResponseRequest createQuickResponseRequest)
            throws ConflictException, ValidationException, ServiceQuotaExceededException, UnauthorizedException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateQuickResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateQuickResponseResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createQuickResponseRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createQuickResponseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateQuickResponse");

            return clientHandler.execute(new ClientExecutionParams<CreateQuickResponseRequest, CreateQuickResponseResponse>()
                    .withOperationName("CreateQuickResponse").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createQuickResponseRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateQuickResponseRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a session. A session is a contextual container used for generating recommendations. Amazon Connect
     * creates a new Amazon Q in Connect session for each contact on which Amazon Q in Connect is enabled.
     * </p>
     *
     * @param createSessionRequest
     * @return Result of the CreateSession operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws DependencyFailedException
     *         An error occurred while calling a dependency. For example, calling <code>connect:DecribeContact</code> as
     *         part of <code>CreateSession</code> with a contactArn.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.CreateSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateSession" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateSessionResponse createSession(CreateSessionRequest createSessionRequest) throws ConflictException,
            ValidationException, UnauthorizedException, DependencyFailedException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateSessionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateSessionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSession");

            return clientHandler.execute(new ClientExecutionParams<CreateSessionRequest, CreateSessionResponse>()
                    .withOperationName("CreateSession").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createSessionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateSessionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deactivates a specific version of the Amazon Q in Connect message template . After the version is deactivated,
     * you can no longer use the <code>&#36ACTIVE_VERSION</code> qualifier to reference the version in active status.
     * </p>
     *
     * @param deactivateMessageTemplateRequest
     * @return Result of the DeactivateMessageTemplate operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.DeactivateMessageTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeactivateMessageTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeactivateMessageTemplateResponse deactivateMessageTemplate(
            DeactivateMessageTemplateRequest deactivateMessageTemplateRequest) throws ConflictException, ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeactivateMessageTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeactivateMessageTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deactivateMessageTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deactivateMessageTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeactivateMessageTemplate");

            return clientHandler
                    .execute(new ClientExecutionParams<DeactivateMessageTemplateRequest, DeactivateMessageTemplateResponse>()
                            .withOperationName("DeactivateMessageTemplate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deactivateMessageTemplateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeactivateMessageTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an Amazon Q in Connect AI Agent.
     * </p>
     *
     * @param deleteAiAgentRequest
     * @return Result of the DeleteAIAgent operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.DeleteAIAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteAIAgent" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteAiAgentResponse deleteAIAgent(DeleteAiAgentRequest deleteAiAgentRequest) throws ValidationException,
            UnauthorizedException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAiAgentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteAiAgentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAiAgentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAiAgentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAIAgent");

            return clientHandler.execute(new ClientExecutionParams<DeleteAiAgentRequest, DeleteAiAgentResponse>()
                    .withOperationName("DeleteAIAgent").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteAiAgentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAiAgentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an Amazon Q in Connect AI Agent Version.
     * </p>
     *
     * @param deleteAiAgentVersionRequest
     * @return Result of the DeleteAIAgentVersion operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.DeleteAIAgentVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteAIAgentVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteAiAgentVersionResponse deleteAIAgentVersion(DeleteAiAgentVersionRequest deleteAiAgentVersionRequest)
            throws ValidationException, ConflictException, UnauthorizedException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAiAgentVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAiAgentVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAiAgentVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAiAgentVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAIAgentVersion");

            return clientHandler.execute(new ClientExecutionParams<DeleteAiAgentVersionRequest, DeleteAiAgentVersionResponse>()
                    .withOperationName("DeleteAIAgentVersion").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteAiAgentVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAiAgentVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an Amazon Q in Connect AI Guardrail.
     * </p>
     *
     * @param deleteAiGuardrailRequest
     * @return Result of the DeleteAIGuardrail operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.DeleteAIGuardrail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteAIGuardrail" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteAiGuardrailResponse deleteAIGuardrail(DeleteAiGuardrailRequest deleteAiGuardrailRequest)
            throws ValidationException, ConflictException, UnauthorizedException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAiGuardrailResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteAiGuardrailResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAiGuardrailRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAiGuardrailRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAIGuardrail");

            return clientHandler.execute(new ClientExecutionParams<DeleteAiGuardrailRequest, DeleteAiGuardrailResponse>()
                    .withOperationName("DeleteAIGuardrail").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteAiGuardrailRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAiGuardrailRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete and Amazon Q in Connect AI Guardrail version.
     * </p>
     *
     * @param deleteAiGuardrailVersionRequest
     * @return Result of the DeleteAIGuardrailVersion operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.DeleteAIGuardrailVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteAIGuardrailVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteAiGuardrailVersionResponse deleteAIGuardrailVersion(
            DeleteAiGuardrailVersionRequest deleteAiGuardrailVersionRequest) throws ValidationException, ConflictException,
            UnauthorizedException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAiGuardrailVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAiGuardrailVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAiGuardrailVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAiGuardrailVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAIGuardrailVersion");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteAiGuardrailVersionRequest, DeleteAiGuardrailVersionResponse>()
                            .withOperationName("DeleteAIGuardrailVersion").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteAiGuardrailVersionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteAiGuardrailVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an Amazon Q in Connect AI Prompt.
     * </p>
     *
     * @param deleteAiPromptRequest
     * @return Result of the DeleteAIPrompt operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.DeleteAIPrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteAIPrompt" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteAiPromptResponse deleteAIPrompt(DeleteAiPromptRequest deleteAiPromptRequest) throws ValidationException,
            UnauthorizedException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAiPromptResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteAiPromptResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAiPromptRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAiPromptRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAIPrompt");

            return clientHandler.execute(new ClientExecutionParams<DeleteAiPromptRequest, DeleteAiPromptResponse>()
                    .withOperationName("DeleteAIPrompt").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteAiPromptRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAiPromptRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete and Amazon Q in Connect AI Prompt version.
     * </p>
     *
     * @param deleteAiPromptVersionRequest
     * @return Result of the DeleteAIPromptVersion operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.DeleteAIPromptVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteAIPromptVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteAiPromptVersionResponse deleteAIPromptVersion(DeleteAiPromptVersionRequest deleteAiPromptVersionRequest)
            throws ValidationException, ConflictException, UnauthorizedException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAiPromptVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAiPromptVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAiPromptVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAiPromptVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAIPromptVersion");

            return clientHandler.execute(new ClientExecutionParams<DeleteAiPromptVersionRequest, DeleteAiPromptVersionResponse>()
                    .withOperationName("DeleteAIPromptVersion").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteAiPromptVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAiPromptVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an assistant.
     * </p>
     *
     * @param deleteAssistantRequest
     * @return Result of the DeleteAssistant operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.DeleteAssistant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteAssistant" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteAssistantResponse deleteAssistant(DeleteAssistantRequest deleteAssistantRequest) throws ValidationException,
            UnauthorizedException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAssistantResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteAssistantResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAssistantRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAssistantRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAssistant");

            return clientHandler.execute(new ClientExecutionParams<DeleteAssistantRequest, DeleteAssistantResponse>()
                    .withOperationName("DeleteAssistant").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteAssistantRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAssistantRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an assistant association.
     * </p>
     *
     * @param deleteAssistantAssociationRequest
     * @return Result of the DeleteAssistantAssociation operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.DeleteAssistantAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteAssistantAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteAssistantAssociationResponse deleteAssistantAssociation(
            DeleteAssistantAssociationRequest deleteAssistantAssociationRequest) throws ValidationException,
            UnauthorizedException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAssistantAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAssistantAssociationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAssistantAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAssistantAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAssistantAssociation");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteAssistantAssociationRequest, DeleteAssistantAssociationResponse>()
                            .withOperationName("DeleteAssistantAssociation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteAssistantAssociationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteAssistantAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the content.
     * </p>
     *
     * @param deleteContentRequest
     * @return Result of the DeleteContent operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.DeleteContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteContent" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteContentResponse deleteContent(DeleteContentRequest deleteContentRequest) throws ValidationException,
            ConflictException, UnauthorizedException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteContentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteContentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteContentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteContentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteContent");

            return clientHandler.execute(new ClientExecutionParams<DeleteContentRequest, DeleteContentResponse>()
                    .withOperationName("DeleteContent").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteContentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteContentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the content association.
     * </p>
     * <p>
     * For more information about content associations--what they are and when they are used--see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/integrate-q-with-guides.html">Integrate Amazon Q in
     * Connect with step-by-step guides</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param deleteContentAssociationRequest
     * @return Result of the DeleteContentAssociation operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.DeleteContentAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteContentAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteContentAssociationResponse deleteContentAssociation(
            DeleteContentAssociationRequest deleteContentAssociationRequest) throws ValidationException, UnauthorizedException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteContentAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteContentAssociationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteContentAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteContentAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteContentAssociation");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteContentAssociationRequest, DeleteContentAssociationResponse>()
                            .withOperationName("DeleteContentAssociation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteContentAssociationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteContentAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the quick response import job.
     * </p>
     *
     * @param deleteImportJobRequest
     * @return Result of the DeleteImportJob operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.DeleteImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteImportJobResponse deleteImportJob(DeleteImportJobRequest deleteImportJobRequest) throws ValidationException,
            ConflictException, UnauthorizedException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteImportJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteImportJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteImportJob");

            return clientHandler.execute(new ClientExecutionParams<DeleteImportJobRequest, DeleteImportJobResponse>()
                    .withOperationName("DeleteImportJob").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteImportJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteImportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the knowledge base.
     * </p>
     * <note>
     * <p>
     * When you use this API to delete an external knowledge base such as Salesforce or ServiceNow, you must also delete
     * the <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/Welcome.html">Amazon
     * AppIntegrations</a> DataIntegration. This is because you can't reuse the DataIntegration after it's been
     * associated with an external knowledge base. However, you can delete and recreate it. See <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_DeleteDataIntegration.html"
     * >DeleteDataIntegration</a> and <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html"
     * >CreateDataIntegration</a> in the <i>Amazon AppIntegrations API Reference</i>.
     * </p>
     * </note>
     *
     * @param deleteKnowledgeBaseRequest
     * @return Result of the DeleteKnowledgeBase operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.DeleteKnowledgeBase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteKnowledgeBase" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteKnowledgeBaseResponse deleteKnowledgeBase(DeleteKnowledgeBaseRequest deleteKnowledgeBaseRequest)
            throws ConflictException, ValidationException, UnauthorizedException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteKnowledgeBaseResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteKnowledgeBaseResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteKnowledgeBaseRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteKnowledgeBaseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteKnowledgeBase");

            return clientHandler.execute(new ClientExecutionParams<DeleteKnowledgeBaseRequest, DeleteKnowledgeBaseResponse>()
                    .withOperationName("DeleteKnowledgeBase").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteKnowledgeBaseRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteKnowledgeBaseRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an Amazon Q in Connect message template entirely or a specific version of the message template if version
     * is supplied in the request. You can provide the message template identifier as
     * <code>&lt;message-template-id&gt;:&lt;versionNumber&gt;</code> to delete a specific version of the message
     * template. If it is not supplied, the message template and all available versions will be deleted.
     * </p>
     *
     * @param deleteMessageTemplateRequest
     * @return Result of the DeleteMessageTemplate operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.DeleteMessageTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteMessageTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteMessageTemplateResponse deleteMessageTemplate(DeleteMessageTemplateRequest deleteMessageTemplateRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteMessageTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteMessageTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMessageTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMessageTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMessageTemplate");

            return clientHandler.execute(new ClientExecutionParams<DeleteMessageTemplateRequest, DeleteMessageTemplateResponse>()
                    .withOperationName("DeleteMessageTemplate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteMessageTemplateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteMessageTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the attachment file from the Amazon Q in Connect message template that is referenced by
     * <code>&#36LATEST</code> qualifier. Attachments on available message template versions will remain unchanged.
     * </p>
     *
     * @param deleteMessageTemplateAttachmentRequest
     * @return Result of the DeleteMessageTemplateAttachment operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.DeleteMessageTemplateAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteMessageTemplateAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteMessageTemplateAttachmentResponse deleteMessageTemplateAttachment(
            DeleteMessageTemplateAttachmentRequest deleteMessageTemplateAttachmentRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteMessageTemplateAttachmentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteMessageTemplateAttachmentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMessageTemplateAttachmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteMessageTemplateAttachmentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMessageTemplateAttachment");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteMessageTemplateAttachmentRequest, DeleteMessageTemplateAttachmentResponse>()
                            .withOperationName("DeleteMessageTemplateAttachment").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteMessageTemplateAttachmentRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteMessageTemplateAttachmentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a quick response.
     * </p>
     *
     * @param deleteQuickResponseRequest
     * @return Result of the DeleteQuickResponse operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.DeleteQuickResponse
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteQuickResponse" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteQuickResponseResponse deleteQuickResponse(DeleteQuickResponseRequest deleteQuickResponseRequest)
            throws ValidationException, UnauthorizedException, AccessDeniedException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteQuickResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteQuickResponseResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteQuickResponseRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteQuickResponseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteQuickResponse");

            return clientHandler.execute(new ClientExecutionParams<DeleteQuickResponseRequest, DeleteQuickResponseResponse>()
                    .withOperationName("DeleteQuickResponse").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteQuickResponseRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteQuickResponseRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets an Amazon Q in Connect AI Agent.
     * </p>
     *
     * @param getAiAgentRequest
     * @return Result of the GetAIAgent operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.GetAIAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetAIAgent" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetAiAgentResponse getAIAgent(GetAiAgentRequest getAiAgentRequest) throws ValidationException, UnauthorizedException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAiAgentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetAiAgentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAiAgentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAiAgentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAIAgent");

            return clientHandler.execute(new ClientExecutionParams<GetAiAgentRequest, GetAiAgentResponse>()
                    .withOperationName("GetAIAgent").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getAiAgentRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetAiAgentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the Amazon Q in Connect AI Guardrail.
     * </p>
     *
     * @param getAiGuardrailRequest
     * @return Result of the GetAIGuardrail operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.GetAIGuardrail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetAIGuardrail" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetAiGuardrailResponse getAIGuardrail(GetAiGuardrailRequest getAiGuardrailRequest) throws ValidationException,
            UnauthorizedException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAiGuardrailResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetAiGuardrailResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAiGuardrailRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAiGuardrailRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAIGuardrail");

            return clientHandler.execute(new ClientExecutionParams<GetAiGuardrailRequest, GetAiGuardrailResponse>()
                    .withOperationName("GetAIGuardrail").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getAiGuardrailRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetAiGuardrailRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets and Amazon Q in Connect AI Prompt.
     * </p>
     *
     * @param getAiPromptRequest
     * @return Result of the GetAIPrompt operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.GetAIPrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetAIPrompt" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetAiPromptResponse getAIPrompt(GetAiPromptRequest getAiPromptRequest) throws ValidationException,
            UnauthorizedException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAiPromptResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetAiPromptResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAiPromptRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAiPromptRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAIPrompt");

            return clientHandler.execute(new ClientExecutionParams<GetAiPromptRequest, GetAiPromptResponse>()
                    .withOperationName("GetAIPrompt").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getAiPromptRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetAiPromptRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about an assistant.
     * </p>
     *
     * @param getAssistantRequest
     * @return Result of the GetAssistant operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.GetAssistant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetAssistant" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetAssistantResponse getAssistant(GetAssistantRequest getAssistantRequest) throws ValidationException,
            UnauthorizedException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAssistantResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetAssistantResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAssistantRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAssistantRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAssistant");

            return clientHandler.execute(new ClientExecutionParams<GetAssistantRequest, GetAssistantResponse>()
                    .withOperationName("GetAssistant").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getAssistantRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetAssistantRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about an assistant association.
     * </p>
     *
     * @param getAssistantAssociationRequest
     * @return Result of the GetAssistantAssociation operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.GetAssistantAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetAssistantAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetAssistantAssociationResponse getAssistantAssociation(GetAssistantAssociationRequest getAssistantAssociationRequest)
            throws ValidationException, UnauthorizedException, AccessDeniedException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAssistantAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetAssistantAssociationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAssistantAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAssistantAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAssistantAssociation");

            return clientHandler
                    .execute(new ClientExecutionParams<GetAssistantAssociationRequest, GetAssistantAssociationResponse>()
                            .withOperationName("GetAssistantAssociation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getAssistantAssociationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetAssistantAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves content, including a pre-signed URL to download the content.
     * </p>
     *
     * @param getContentRequest
     * @return Result of the GetContent operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.GetContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetContent" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetContentResponse getContent(GetContentRequest getContentRequest) throws ValidationException, UnauthorizedException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetContentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetContentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getContentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getContentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetContent");

            return clientHandler.execute(new ClientExecutionParams<GetContentRequest, GetContentResponse>()
                    .withOperationName("GetContent").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getContentRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetContentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the content association.
     * </p>
     * <p>
     * For more information about content associations--what they are and when they are used--see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/integrate-q-with-guides.html">Integrate Amazon Q in
     * Connect with step-by-step guides</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param getContentAssociationRequest
     * @return Result of the GetContentAssociation operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.GetContentAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetContentAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetContentAssociationResponse getContentAssociation(GetContentAssociationRequest getContentAssociationRequest)
            throws ValidationException, UnauthorizedException, AccessDeniedException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetContentAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetContentAssociationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getContentAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getContentAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetContentAssociation");

            return clientHandler.execute(new ClientExecutionParams<GetContentAssociationRequest, GetContentAssociationResponse>()
                    .withOperationName("GetContentAssociation").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getContentAssociationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetContentAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves summary information about the content.
     * </p>
     *
     * @param getContentSummaryRequest
     * @return Result of the GetContentSummary operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.GetContentSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetContentSummary" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetContentSummaryResponse getContentSummary(GetContentSummaryRequest getContentSummaryRequest)
            throws ValidationException, UnauthorizedException, AccessDeniedException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetContentSummaryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetContentSummaryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getContentSummaryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getContentSummaryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetContentSummary");

            return clientHandler.execute(new ClientExecutionParams<GetContentSummaryRequest, GetContentSummaryResponse>()
                    .withOperationName("GetContentSummary").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getContentSummaryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetContentSummaryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the started import job.
     * </p>
     *
     * @param getImportJobRequest
     * @return Result of the GetImportJob operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.GetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetImportJobResponse getImportJob(GetImportJobRequest getImportJobRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetImportJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetImportJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getImportJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetImportJob");

            return clientHandler.execute(new ClientExecutionParams<GetImportJobRequest, GetImportJobResponse>()
                    .withOperationName("GetImportJob").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getImportJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetImportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the knowledge base.
     * </p>
     *
     * @param getKnowledgeBaseRequest
     * @return Result of the GetKnowledgeBase operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.GetKnowledgeBase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetKnowledgeBase" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetKnowledgeBaseResponse getKnowledgeBase(GetKnowledgeBaseRequest getKnowledgeBaseRequest) throws ValidationException,
            UnauthorizedException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetKnowledgeBaseResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetKnowledgeBaseResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getKnowledgeBaseRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getKnowledgeBaseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetKnowledgeBase");

            return clientHandler.execute(new ClientExecutionParams<GetKnowledgeBaseRequest, GetKnowledgeBaseResponse>()
                    .withOperationName("GetKnowledgeBase").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getKnowledgeBaseRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetKnowledgeBaseRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the Amazon Q in Connect message template. The message template identifier can contain an optional
     * qualifier, for example, <code>&lt;message-template-id&gt;:&lt;qualifier&gt;</code>, which is either an actual
     * version number or an Amazon Q Connect managed qualifier <code>&#36ACTIVE_VERSION</code> | <code>&#36LATEST</code>
     * . If it is not supplied, then <code>&#36LATEST</code> is assumed implicitly.
     * </p>
     *
     * @param getMessageTemplateRequest
     * @return Result of the GetMessageTemplate operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.GetMessageTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetMessageTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetMessageTemplateResponse getMessageTemplate(GetMessageTemplateRequest getMessageTemplateRequest)
            throws ValidationException, UnauthorizedException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetMessageTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetMessageTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMessageTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMessageTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMessageTemplate");

            return clientHandler.execute(new ClientExecutionParams<GetMessageTemplateRequest, GetMessageTemplateResponse>()
                    .withOperationName("GetMessageTemplate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getMessageTemplateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetMessageTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves next message on an Amazon Q in Connect session.
     * </p>
     *
     * @param getNextMessageRequest
     * @return Result of the GetNextMessage operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.GetNextMessage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetNextMessage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetNextMessageResponse getNextMessage(GetNextMessageRequest getNextMessageRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetNextMessageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetNextMessageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getNextMessageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getNextMessageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetNextMessage");

            return clientHandler.execute(new ClientExecutionParams<GetNextMessageRequest, GetNextMessageResponse>()
                    .withOperationName("GetNextMessage").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getNextMessageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetNextMessageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the quick response.
     * </p>
     *
     * @param getQuickResponseRequest
     * @return Result of the GetQuickResponse operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.GetQuickResponse
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetQuickResponse" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetQuickResponseResponse getQuickResponse(GetQuickResponseRequest getQuickResponseRequest) throws ValidationException,
            UnauthorizedException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetQuickResponseResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetQuickResponseResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getQuickResponseRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getQuickResponseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetQuickResponse");

            return clientHandler.execute(new ClientExecutionParams<GetQuickResponseRequest, GetQuickResponseResponse>()
                    .withOperationName("GetQuickResponse").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getQuickResponseRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetQuickResponseRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * <important>
     * <p>
     * This API will be discontinued starting June 1, 2024. To receive generative responses after March 1, 2024, you
     * will need to create a new Assistant in the Amazon Connect console and integrate the Amazon Q in Connect
     * JavaScript library (amazon-q-connectjs) into your applications.
     * </p>
     * </important>
     * <p>
     * Retrieves recommendations for the specified session. To avoid retrieving the same recommendations in subsequent
     * calls, use <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_NotifyRecommendationsReceived.html"
     * >NotifyRecommendationsReceived</a>. This API supports long-polling behavior with the <code>waitTimeSeconds</code>
     * parameter. Short poll is the default behavior and only returns recommendations already available. To perform a
     * manual query against an assistant, use <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_QueryAssistant.html"
     * >QueryAssistant</a>.
     * </p>
     * </p>
     *
     * @param getRecommendationsRequest
     * @return Result of the GetRecommendations operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.GetRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetRecommendations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetRecommendationsResponse getRecommendations(GetRecommendationsRequest getRecommendationsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRecommendationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetRecommendationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRecommendationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRecommendationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRecommendations");

            return clientHandler.execute(new ClientExecutionParams<GetRecommendationsRequest, GetRecommendationsResponse>()
                    .withOperationName("GetRecommendations").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getRecommendationsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetRecommendationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information for a specified session.
     * </p>
     *
     * @param getSessionRequest
     * @return Result of the GetSession operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.GetSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetSession" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetSessionResponse getSession(GetSessionRequest getSessionRequest) throws ValidationException, UnauthorizedException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSessionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetSessionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSession");

            return clientHandler.execute(new ClientExecutionParams<GetSessionRequest, GetSessionResponse>()
                    .withOperationName("GetSession").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getSessionRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetSessionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List AI Agent versions.
     * </p>
     *
     * @param listAiAgentVersionsRequest
     * @return Result of the ListAIAgentVersions operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListAIAgentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIAgentVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListAiAgentVersionsResponse listAIAgentVersions(ListAiAgentVersionsRequest listAiAgentVersionsRequest)
            throws ValidationException, UnauthorizedException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAiAgentVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAiAgentVersionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAiAgentVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAiAgentVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAIAgentVersions");

            return clientHandler.execute(new ClientExecutionParams<ListAiAgentVersionsRequest, ListAiAgentVersionsResponse>()
                    .withOperationName("ListAIAgentVersions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listAiAgentVersionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAiAgentVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists AI Agents.
     * </p>
     *
     * @param listAiAgentsRequest
     * @return Result of the ListAIAgents operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListAIAgents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIAgents" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListAiAgentsResponse listAIAgents(ListAiAgentsRequest listAiAgentsRequest) throws ValidationException,
            UnauthorizedException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAiAgentsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListAiAgentsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAiAgentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAiAgentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAIAgents");

            return clientHandler.execute(new ClientExecutionParams<ListAiAgentsRequest, ListAiAgentsResponse>()
                    .withOperationName("ListAIAgents").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listAiAgentsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAiAgentsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists AI Guardrail versions.
     * </p>
     *
     * @param listAiGuardrailVersionsRequest
     * @return Result of the ListAIGuardrailVersions operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListAIGuardrailVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIGuardrailVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAiGuardrailVersionsResponse listAIGuardrailVersions(ListAiGuardrailVersionsRequest listAiGuardrailVersionsRequest)
            throws ValidationException, UnauthorizedException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAiGuardrailVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAiGuardrailVersionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAiGuardrailVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAiGuardrailVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAIGuardrailVersions");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAiGuardrailVersionsRequest, ListAiGuardrailVersionsResponse>()
                            .withOperationName("ListAIGuardrailVersions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listAiGuardrailVersionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAiGuardrailVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the AI Guardrails available on the Amazon Q in Connect assistant.
     * </p>
     *
     * @param listAiGuardrailsRequest
     * @return Result of the ListAIGuardrails operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListAIGuardrails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIGuardrails" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListAiGuardrailsResponse listAIGuardrails(ListAiGuardrailsRequest listAiGuardrailsRequest) throws ValidationException,
            UnauthorizedException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAiGuardrailsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListAiGuardrailsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAiGuardrailsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAiGuardrailsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAIGuardrails");

            return clientHandler.execute(new ClientExecutionParams<ListAiGuardrailsRequest, ListAiGuardrailsResponse>()
                    .withOperationName("ListAIGuardrails").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listAiGuardrailsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAiGuardrailsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists AI Prompt versions.
     * </p>
     *
     * @param listAiPromptVersionsRequest
     * @return Result of the ListAIPromptVersions operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListAIPromptVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIPromptVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListAiPromptVersionsResponse listAIPromptVersions(ListAiPromptVersionsRequest listAiPromptVersionsRequest)
            throws ValidationException, UnauthorizedException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAiPromptVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAiPromptVersionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAiPromptVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAiPromptVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAIPromptVersions");

            return clientHandler.execute(new ClientExecutionParams<ListAiPromptVersionsRequest, ListAiPromptVersionsResponse>()
                    .withOperationName("ListAIPromptVersions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listAiPromptVersionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAiPromptVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the AI Prompts available on the Amazon Q in Connect assistant.
     * </p>
     *
     * @param listAiPromptsRequest
     * @return Result of the ListAIPrompts operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListAIPrompts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIPrompts" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListAiPromptsResponse listAIPrompts(ListAiPromptsRequest listAiPromptsRequest) throws ValidationException,
            UnauthorizedException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAiPromptsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListAiPromptsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAiPromptsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAiPromptsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAIPrompts");

            return clientHandler.execute(new ClientExecutionParams<ListAiPromptsRequest, ListAiPromptsResponse>()
                    .withOperationName("ListAIPrompts").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listAiPromptsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAiPromptsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists information about assistant associations.
     * </p>
     *
     * @param listAssistantAssociationsRequest
     * @return Result of the ListAssistantAssociations operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListAssistantAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAssistantAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAssistantAssociationsResponse listAssistantAssociations(
            ListAssistantAssociationsRequest listAssistantAssociationsRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAssistantAssociationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAssistantAssociationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAssistantAssociationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAssistantAssociationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAssistantAssociations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAssistantAssociationsRequest, ListAssistantAssociationsResponse>()
                            .withOperationName("ListAssistantAssociations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listAssistantAssociationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAssistantAssociationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists information about assistants.
     * </p>
     *
     * @param listAssistantsRequest
     * @return Result of the ListAssistants operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListAssistants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAssistants" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListAssistantsResponse listAssistants(ListAssistantsRequest listAssistantsRequest) throws ValidationException,
            UnauthorizedException, AccessDeniedException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAssistantsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListAssistantsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAssistantsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAssistantsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAssistants");

            return clientHandler.execute(new ClientExecutionParams<ListAssistantsRequest, ListAssistantsResponse>()
                    .withOperationName("ListAssistants").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listAssistantsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAssistantsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the content associations.
     * </p>
     * <p>
     * For more information about content associations--what they are and when they are used--see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/integrate-q-with-guides.html">Integrate Amazon Q in
     * Connect with step-by-step guides</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param listContentAssociationsRequest
     * @return Result of the ListContentAssociations operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListContentAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListContentAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListContentAssociationsResponse listContentAssociations(ListContentAssociationsRequest listContentAssociationsRequest)
            throws ValidationException, UnauthorizedException, AccessDeniedException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListContentAssociationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListContentAssociationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listContentAssociationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listContentAssociationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListContentAssociations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListContentAssociationsRequest, ListContentAssociationsResponse>()
                            .withOperationName("ListContentAssociations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listContentAssociationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListContentAssociationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the content.
     * </p>
     *
     * @param listContentsRequest
     * @return Result of the ListContents operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListContents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListContents" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListContentsResponse listContents(ListContentsRequest listContentsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListContentsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListContentsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listContentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listContentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListContents");

            return clientHandler.execute(new ClientExecutionParams<ListContentsRequest, ListContentsResponse>()
                    .withOperationName("ListContents").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listContentsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListContentsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists information about import jobs.
     * </p>
     *
     * @param listImportJobsRequest
     * @return Result of the ListImportJobs operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListImportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListImportJobsResponse listImportJobs(ListImportJobsRequest listImportJobsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListImportJobsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListImportJobsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listImportJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImportJobs");

            return clientHandler.execute(new ClientExecutionParams<ListImportJobsRequest, ListImportJobsResponse>()
                    .withOperationName("ListImportJobs").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listImportJobsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListImportJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the knowledge bases.
     * </p>
     *
     * @param listKnowledgeBasesRequest
     * @return Result of the ListKnowledgeBases operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListKnowledgeBases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListKnowledgeBases" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListKnowledgeBasesResponse listKnowledgeBases(ListKnowledgeBasesRequest listKnowledgeBasesRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListKnowledgeBasesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListKnowledgeBasesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listKnowledgeBasesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listKnowledgeBasesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListKnowledgeBases");

            return clientHandler.execute(new ClientExecutionParams<ListKnowledgeBasesRequest, ListKnowledgeBasesResponse>()
                    .withOperationName("ListKnowledgeBases").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listKnowledgeBasesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListKnowledgeBasesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all the available versions for the specified Amazon Q in Connect message template.
     * </p>
     *
     * @param listMessageTemplateVersionsRequest
     * @return Result of the ListMessageTemplateVersions operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListMessageTemplateVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListMessageTemplateVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListMessageTemplateVersionsResponse listMessageTemplateVersions(
            ListMessageTemplateVersionsRequest listMessageTemplateVersionsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListMessageTemplateVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListMessageTemplateVersionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMessageTemplateVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMessageTemplateVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMessageTemplateVersions");

            return clientHandler
                    .execute(new ClientExecutionParams<ListMessageTemplateVersionsRequest, ListMessageTemplateVersionsResponse>()
                            .withOperationName("ListMessageTemplateVersions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listMessageTemplateVersionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListMessageTemplateVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all the available Amazon Q in Connect message templates for the specified knowledge base.
     * </p>
     *
     * @param listMessageTemplatesRequest
     * @return Result of the ListMessageTemplates operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListMessageTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListMessageTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListMessageTemplatesResponse listMessageTemplates(ListMessageTemplatesRequest listMessageTemplatesRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListMessageTemplatesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListMessageTemplatesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMessageTemplatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMessageTemplatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMessageTemplates");

            return clientHandler.execute(new ClientExecutionParams<ListMessageTemplatesRequest, ListMessageTemplatesResponse>()
                    .withOperationName("ListMessageTemplates").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listMessageTemplatesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListMessageTemplatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists messages on an Amazon Q in Connect session.
     * </p>
     *
     * @param listMessagesRequest
     * @return Result of the ListMessages operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListMessages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListMessages" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListMessagesResponse listMessages(ListMessagesRequest listMessagesRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListMessagesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListMessagesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMessagesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMessagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMessages");

            return clientHandler.execute(new ClientExecutionParams<ListMessagesRequest, ListMessagesResponse>()
                    .withOperationName("ListMessages").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listMessagesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListMessagesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists information about quick response.
     * </p>
     *
     * @param listQuickResponsesRequest
     * @return Result of the ListQuickResponses operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListQuickResponses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListQuickResponses" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListQuickResponsesResponse listQuickResponses(ListQuickResponsesRequest listQuickResponsesRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListQuickResponsesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListQuickResponsesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listQuickResponsesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listQuickResponsesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListQuickResponses");

            return clientHandler.execute(new ClientExecutionParams<ListQuickResponsesRequest, ListQuickResponsesResponse>()
                    .withOperationName("ListQuickResponses").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listQuickResponsesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListQuickResponsesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the specified recommendations from the specified assistant's queue of newly available recommendations.
     * You can use this API in conjunction with <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_GetRecommendations.html"
     * >GetRecommendations</a> and a <code>waitTimeSeconds</code> input for long-polling behavior and avoiding duplicate
     * recommendations.
     * </p>
     *
     * @param notifyRecommendationsReceivedRequest
     * @return Result of the NotifyRecommendationsReceived operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.NotifyRecommendationsReceived
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/NotifyRecommendationsReceived"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public NotifyRecommendationsReceivedResponse notifyRecommendationsReceived(
            NotifyRecommendationsReceivedRequest notifyRecommendationsReceivedRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<NotifyRecommendationsReceivedResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, NotifyRecommendationsReceivedResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(notifyRecommendationsReceivedRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                notifyRecommendationsReceivedRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "NotifyRecommendationsReceived");

            return clientHandler
                    .execute(new ClientExecutionParams<NotifyRecommendationsReceivedRequest, NotifyRecommendationsReceivedResponse>()
                            .withOperationName("NotifyRecommendationsReceived").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(notifyRecommendationsReceivedRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new NotifyRecommendationsReceivedRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides feedback against the specified assistant for the specified target. This API only supports generative
     * targets.
     * </p>
     *
     * @param putFeedbackRequest
     * @return Result of the PutFeedback operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.PutFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/PutFeedback" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutFeedbackResponse putFeedback(PutFeedbackRequest putFeedbackRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutFeedbackResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutFeedbackResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putFeedbackRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putFeedbackRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutFeedback");

            return clientHandler.execute(new ClientExecutionParams<PutFeedbackRequest, PutFeedbackResponse>()
                    .withOperationName("PutFeedback").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(putFeedbackRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutFeedbackRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * <important>
     * <p>
     * This API will be discontinued starting June 1, 2024. To receive generative responses after March 1, 2024, you
     * will need to create a new Assistant in the Amazon Connect console and integrate the Amazon Q in Connect
     * JavaScript library (amazon-q-connectjs) into your applications.
     * </p>
     * </important>
     * <p>
     * Performs a manual search against the specified assistant. To retrieve recommendations for an assistant, use <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_GetRecommendations.html">
     * GetRecommendations</a>.
     * </p>
     * </p>
     *
     * @param queryAssistantRequest
     * @return Result of the QueryAssistant operation returned by the service.
     * @throws RequestTimeoutException
     *         The request reached the service more than 15 minutes after the date stamp on the request or more than 15
     *         minutes after the request expiration date (such as for pre-signed URLs), or the date stamp on the request
     *         is more than 15 minutes in the future.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.QueryAssistant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/QueryAssistant" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public QueryAssistantResponse queryAssistant(QueryAssistantRequest queryAssistantRequest) throws RequestTimeoutException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<QueryAssistantResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                QueryAssistantResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(queryAssistantRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, queryAssistantRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "QueryAssistant");

            return clientHandler.execute(new ClientExecutionParams<QueryAssistantRequest, QueryAssistantResponse>()
                    .withOperationName("QueryAssistant").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(queryAssistantRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new QueryAssistantRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the AI Agent that is set for use by default on an Amazon Q in Connect Assistant.
     * </p>
     *
     * @param removeAssistantAiAgentRequest
     * @return Result of the RemoveAssistantAIAgent operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.RemoveAssistantAIAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/RemoveAssistantAIAgent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RemoveAssistantAiAgentResponse removeAssistantAIAgent(RemoveAssistantAiAgentRequest removeAssistantAiAgentRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RemoveAssistantAiAgentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RemoveAssistantAiAgentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeAssistantAiAgentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeAssistantAiAgentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveAssistantAIAgent");

            return clientHandler
                    .execute(new ClientExecutionParams<RemoveAssistantAiAgentRequest, RemoveAssistantAiAgentResponse>()
                            .withOperationName("RemoveAssistantAIAgent").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(removeAssistantAiAgentRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RemoveAssistantAiAgentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a URI template from a knowledge base.
     * </p>
     *
     * @param removeKnowledgeBaseTemplateUriRequest
     * @return Result of the RemoveKnowledgeBaseTemplateUri operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.RemoveKnowledgeBaseTemplateUri
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/RemoveKnowledgeBaseTemplateUri"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RemoveKnowledgeBaseTemplateUriResponse removeKnowledgeBaseTemplateUri(
            RemoveKnowledgeBaseTemplateUriRequest removeKnowledgeBaseTemplateUriRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RemoveKnowledgeBaseTemplateUriResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RemoveKnowledgeBaseTemplateUriResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeKnowledgeBaseTemplateUriRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                removeKnowledgeBaseTemplateUriRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveKnowledgeBaseTemplateUri");

            return clientHandler
                    .execute(new ClientExecutionParams<RemoveKnowledgeBaseTemplateUriRequest, RemoveKnowledgeBaseTemplateUriResponse>()
                            .withOperationName("RemoveKnowledgeBaseTemplateUri").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(removeKnowledgeBaseTemplateUriRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RemoveKnowledgeBaseTemplateUriRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Renders the Amazon Q in Connect message template based on the attribute values provided and generates the message
     * content. For any variable present in the message template, if the attribute value is neither provided in the
     * attribute request parameter nor the default attribute of the message template, the rendered message content will
     * keep the variable placeholder as it is and return the attribute keys that are missing.
     * </p>
     *
     * @param renderMessageTemplateRequest
     * @return Result of the RenderMessageTemplate operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.RenderMessageTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/RenderMessageTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RenderMessageTemplateResponse renderMessageTemplate(RenderMessageTemplateRequest renderMessageTemplateRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RenderMessageTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RenderMessageTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(renderMessageTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, renderMessageTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RenderMessageTemplate");

            return clientHandler.execute(new ClientExecutionParams<RenderMessageTemplateRequest, RenderMessageTemplateResponse>()
                    .withOperationName("RenderMessageTemplate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(renderMessageTemplateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RenderMessageTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Searches for content in a specified knowledge base. Can be used to get a specific content resource by its name.
     * </p>
     *
     * @param searchContentRequest
     * @return Result of the SearchContent operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.SearchContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/SearchContent" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public SearchContentResponse searchContent(SearchContentRequest searchContentRequest) throws ValidationException,
            UnauthorizedException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SearchContentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SearchContentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(searchContentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchContentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchContent");

            return clientHandler.execute(new ClientExecutionParams<SearchContentRequest, SearchContentResponse>()
                    .withOperationName("SearchContent").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(searchContentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SearchContentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Searches for Amazon Q in Connect message templates in the specified knowledge base.
     * </p>
     *
     * @param searchMessageTemplatesRequest
     * @return Result of the SearchMessageTemplates operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.SearchMessageTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/SearchMessageTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SearchMessageTemplatesResponse searchMessageTemplates(SearchMessageTemplatesRequest searchMessageTemplatesRequest)
            throws ValidationException, UnauthorizedException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SearchMessageTemplatesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, SearchMessageTemplatesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(searchMessageTemplatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchMessageTemplatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchMessageTemplates");

            return clientHandler
                    .execute(new ClientExecutionParams<SearchMessageTemplatesRequest, SearchMessageTemplatesResponse>()
                            .withOperationName("SearchMessageTemplates").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(searchMessageTemplatesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new SearchMessageTemplatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Searches existing Amazon Q in Connect quick responses in an Amazon Q in Connect knowledge base.
     * </p>
     *
     * @param searchQuickResponsesRequest
     * @return Result of the SearchQuickResponses operation returned by the service.
     * @throws RequestTimeoutException
     *         The request reached the service more than 15 minutes after the date stamp on the request or more than 15
     *         minutes after the request expiration date (such as for pre-signed URLs), or the date stamp on the request
     *         is more than 15 minutes in the future.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.SearchQuickResponses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/SearchQuickResponses" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public SearchQuickResponsesResponse searchQuickResponses(SearchQuickResponsesRequest searchQuickResponsesRequest)
            throws RequestTimeoutException, ValidationException, UnauthorizedException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SearchQuickResponsesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, SearchQuickResponsesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(searchQuickResponsesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchQuickResponsesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchQuickResponses");

            return clientHandler.execute(new ClientExecutionParams<SearchQuickResponsesRequest, SearchQuickResponsesResponse>()
                    .withOperationName("SearchQuickResponses").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(searchQuickResponsesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SearchQuickResponsesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Searches for sessions.
     * </p>
     *
     * @param searchSessionsRequest
     * @return Result of the SearchSessions operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.SearchSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/SearchSessions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public SearchSessionsResponse searchSessions(SearchSessionsRequest searchSessionsRequest) throws ValidationException,
            UnauthorizedException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SearchSessionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SearchSessionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(searchSessionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchSessionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchSessions");

            return clientHandler.execute(new ClientExecutionParams<SearchSessionsRequest, SearchSessionsResponse>()
                    .withOperationName("SearchSessions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(searchSessionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SearchSessionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Submits a message to the Amazon Q in Connect session.
     * </p>
     *
     * @param sendMessageRequest
     * @return Result of the SendMessage operation returned by the service.
     * @throws RequestTimeoutException
     *         The request reached the service more than 15 minutes after the date stamp on the request or more than 15
     *         minutes after the request expiration date (such as for pre-signed URLs), or the date stamp on the request
     *         is more than 15 minutes in the future.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.SendMessage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/SendMessage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public SendMessageResponse sendMessage(SendMessageRequest sendMessageRequest) throws RequestTimeoutException,
            ValidationException, ConflictException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SendMessageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SendMessageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(sendMessageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, sendMessageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SendMessage");

            return clientHandler.execute(new ClientExecutionParams<SendMessageRequest, SendMessageResponse>()
                    .withOperationName("SendMessage").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(sendMessageRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SendMessageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get a URL to upload content to a knowledge base. To upload content, first make a PUT request to the returned URL
     * with your file, making sure to include the required headers. Then use <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_CreateContent.html">CreateContent</a>
     * to finalize the content creation process or <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_UpdateContent.html">UpdateContent</a>
     * to modify an existing resource. You can only upload content to a knowledge base of type CUSTOM.
     * </p>
     *
     * @param startContentUploadRequest
     * @return Result of the StartContentUpload operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.StartContentUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/StartContentUpload" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public StartContentUploadResponse startContentUpload(StartContentUploadRequest startContentUploadRequest)
            throws ValidationException, UnauthorizedException, AccessDeniedException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartContentUploadResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartContentUploadResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startContentUploadRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startContentUploadRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartContentUpload");

            return clientHandler.execute(new ClientExecutionParams<StartContentUploadRequest, StartContentUploadResponse>()
                    .withOperationName("StartContentUpload").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(startContentUploadRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartContentUploadRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Start an asynchronous job to import Amazon Q in Connect resources from an uploaded source file. Before calling
     * this API, use <a
     * href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html">StartContentUpload</a>
     * to upload an asset that contains the resource data.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For importing Amazon Q in Connect quick responses, you need to upload a csv file including the quick responses.
     * For information about how to format the csv file for importing quick responses, see <a
     * href="https://docs.aws.amazon.com/console/connect/quick-responses/add-data">Import quick responses</a>.
     * </p>
     * </li>
     * </ul>
     *
     * @param startImportJobRequest
     * @return Result of the StartImportJob operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ServiceQuotaExceededException
     *         You've exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use service quotas to request a service quota increase.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.StartImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/StartImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StartImportJobResponse startImportJob(StartImportJobRequest startImportJobRequest) throws ConflictException,
            ValidationException, ServiceQuotaExceededException, UnauthorizedException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartImportJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartImportJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startImportJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartImportJob");

            return clientHandler.execute(new ClientExecutionParams<StartImportJobRequest, StartImportJobResponse>()
                    .withOperationName("StartImportJob").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(startImportJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartImportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws TooManyTagsException
     *         Amazon Q in Connect throws this exception if you have too many tags in your tag set.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws TooManyTagsException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(tagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the specified tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an AI Agent.
     * </p>
     *
     * @param updateAiAgentRequest
     * @return Result of the UpdateAIAgent operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.UpdateAIAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateAIAgent" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateAiAgentResponse updateAIAgent(UpdateAiAgentRequest updateAiAgentRequest) throws ValidationException,
            ConflictException, UnauthorizedException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAiAgentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateAiAgentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAiAgentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAiAgentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAIAgent");

            return clientHandler.execute(new ClientExecutionParams<UpdateAiAgentRequest, UpdateAiAgentResponse>()
                    .withOperationName("UpdateAIAgent").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateAiAgentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateAiAgentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an AI Guardrail.
     * </p>
     *
     * @param updateAiGuardrailRequest
     * @return Result of the UpdateAIGuardrail operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.UpdateAIGuardrail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateAIGuardrail" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateAiGuardrailResponse updateAIGuardrail(UpdateAiGuardrailRequest updateAiGuardrailRequest)
            throws ValidationException, ConflictException, UnauthorizedException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAiGuardrailResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateAiGuardrailResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAiGuardrailRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAiGuardrailRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAIGuardrail");

            return clientHandler.execute(new ClientExecutionParams<UpdateAiGuardrailRequest, UpdateAiGuardrailResponse>()
                    .withOperationName("UpdateAIGuardrail").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateAiGuardrailRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateAiGuardrailRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an AI Prompt.
     * </p>
     *
     * @param updateAiPromptRequest
     * @return Result of the UpdateAIPrompt operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.UpdateAIPrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateAIPrompt" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateAiPromptResponse updateAIPrompt(UpdateAiPromptRequest updateAiPromptRequest) throws ValidationException,
            ConflictException, UnauthorizedException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAiPromptResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateAiPromptResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAiPromptRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAiPromptRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAIPrompt");

            return clientHandler.execute(new ClientExecutionParams<UpdateAiPromptRequest, UpdateAiPromptResponse>()
                    .withOperationName("UpdateAIPrompt").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateAiPromptRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateAiPromptRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the AI Agent that is set for use by default on an Amazon Q in Connect Assistant.
     * </p>
     *
     * @param updateAssistantAiAgentRequest
     * @return Result of the UpdateAssistantAIAgent operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.UpdateAssistantAIAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateAssistantAIAgent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateAssistantAiAgentResponse updateAssistantAIAgent(UpdateAssistantAiAgentRequest updateAssistantAiAgentRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAssistantAiAgentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateAssistantAiAgentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAssistantAiAgentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAssistantAiAgentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAssistantAIAgent");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateAssistantAiAgentRequest, UpdateAssistantAiAgentResponse>()
                            .withOperationName("UpdateAssistantAIAgent").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateAssistantAiAgentRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateAssistantAiAgentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates information about the content.
     * </p>
     *
     * @param updateContentRequest
     * @return Result of the UpdateContent operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws PreconditionFailedException
     *         The provided <code>revisionId</code> does not match, indicating the content has been modified since it
     *         was last read.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.UpdateContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateContent" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateContentResponse updateContent(UpdateContentRequest updateContentRequest) throws ValidationException,
            UnauthorizedException, AccessDeniedException, PreconditionFailedException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateContentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateContentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateContentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateContentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateContent");

            return clientHandler.execute(new ClientExecutionParams<UpdateContentRequest, UpdateContentResponse>()
                    .withOperationName("UpdateContent").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateContentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateContentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the template URI of a knowledge base. This is only supported for knowledge bases of type EXTERNAL.
     * Include a single variable in <code>&#36{variable}</code> format; this interpolated by Amazon Q in Connect using
     * ingested content. For example, if you ingest a Salesforce article, it has an <code>Id</code> value, and you can
     * set the template URI to
     * <code>https://myInstanceName.lightning.force.com/lightning/r/Knowledge__kav/*&#36{Id}*&#47;view</code>.
     * </p>
     *
     * @param updateKnowledgeBaseTemplateUriRequest
     * @return Result of the UpdateKnowledgeBaseTemplateUri operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.UpdateKnowledgeBaseTemplateUri
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateKnowledgeBaseTemplateUri"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateKnowledgeBaseTemplateUriResponse updateKnowledgeBaseTemplateUri(
            UpdateKnowledgeBaseTemplateUriRequest updateKnowledgeBaseTemplateUriRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateKnowledgeBaseTemplateUriResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateKnowledgeBaseTemplateUriResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateKnowledgeBaseTemplateUriRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateKnowledgeBaseTemplateUriRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateKnowledgeBaseTemplateUri");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateKnowledgeBaseTemplateUriRequest, UpdateKnowledgeBaseTemplateUriResponse>()
                            .withOperationName("UpdateKnowledgeBaseTemplateUri").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateKnowledgeBaseTemplateUriRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateKnowledgeBaseTemplateUriRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the Amazon Q in Connect message template. Partial update is supported. If any field is not supplied, it
     * will remain unchanged for the message template that is referenced by the <code>&#36LATEST</code> qualifier. Any
     * modification will only apply to the message template that is referenced by the <code>&#36LATEST</code> qualifier.
     * The fields for all available versions will remain unchanged.
     * </p>
     *
     * @param updateMessageTemplateRequest
     * @return Result of the UpdateMessageTemplate operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.UpdateMessageTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateMessageTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateMessageTemplateResponse updateMessageTemplate(UpdateMessageTemplateRequest updateMessageTemplateRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateMessageTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateMessageTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateMessageTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateMessageTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMessageTemplate");

            return clientHandler.execute(new ClientExecutionParams<UpdateMessageTemplateRequest, UpdateMessageTemplateResponse>()
                    .withOperationName("UpdateMessageTemplate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateMessageTemplateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateMessageTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the Amazon Q in Connect message template metadata. Note that any modification to the message template’s
     * name, description and grouping configuration will applied to the message template pointed by the
     * <code>&#36LATEST</code> qualifier and all available versions. Partial update is supported. If any field is not
     * supplied, it will remain unchanged for the message template.
     * </p>
     *
     * @param updateMessageTemplateMetadataRequest
     * @return Result of the UpdateMessageTemplateMetadata operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.UpdateMessageTemplateMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateMessageTemplateMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateMessageTemplateMetadataResponse updateMessageTemplateMetadata(
            UpdateMessageTemplateMetadataRequest updateMessageTemplateMetadataRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateMessageTemplateMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateMessageTemplateMetadataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateMessageTemplateMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateMessageTemplateMetadataRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMessageTemplateMetadata");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateMessageTemplateMetadataRequest, UpdateMessageTemplateMetadataResponse>()
                            .withOperationName("UpdateMessageTemplateMetadata").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateMessageTemplateMetadataRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateMessageTemplateMetadataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing Amazon Q in Connect quick response.
     * </p>
     *
     * @param updateQuickResponseRequest
     * @return Result of the UpdateQuickResponse operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws PreconditionFailedException
     *         The provided <code>revisionId</code> does not match, indicating the content has been modified since it
     *         was last read.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.UpdateQuickResponse
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateQuickResponse" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateQuickResponseResponse updateQuickResponse(UpdateQuickResponseRequest updateQuickResponseRequest)
            throws ConflictException, ValidationException, UnauthorizedException, AccessDeniedException,
            PreconditionFailedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateQuickResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateQuickResponseResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateQuickResponseRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateQuickResponseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateQuickResponse");

            return clientHandler.execute(new ClientExecutionParams<UpdateQuickResponseRequest, UpdateQuickResponseResponse>()
                    .withOperationName("UpdateQuickResponse").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateQuickResponseRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateQuickResponseRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a session. A session is a contextual container used for generating recommendations. Amazon Connect
     * updates the existing Amazon Q in Connect session for each contact on which Amazon Q in Connect is enabled.
     * </p>
     *
     * @param updateSessionRequest
     * @return Result of the UpdateSession operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.UpdateSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateSession" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateSessionResponse updateSession(UpdateSessionRequest updateSessionRequest) throws ValidationException,
            UnauthorizedException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateSessionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateSessionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSession");

            return clientHandler.execute(new ClientExecutionParams<UpdateSessionRequest, UpdateSessionResponse>()
                    .withOperationName("UpdateSession").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateSessionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateSessionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the data stored on an Amazon Q in Connect Session.
     * </p>
     *
     * @param updateSessionDataRequest
     * @return Result of the UpdateSessionData operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.UpdateSessionData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateSessionData" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateSessionDataResponse updateSessionData(UpdateSessionDataRequest updateSessionDataRequest)
            throws ValidationException, UnauthorizedException, AccessDeniedException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, QConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateSessionDataResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateSessionDataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "DependencyFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(424)
                        .exceptionBuilderSupplier(DependencyFailedException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "PreconditionFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(412)
                        .exceptionBuilderSupplier(PreconditionFailedException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateSessionDataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSessionDataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSessionData");

            return clientHandler.execute(new ClientExecutionParams<UpdateSessionDataRequest, UpdateSessionDataResponse>()
                    .withOperationName("UpdateSessionData").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateSessionDataRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateSessionDataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        QConnectServiceClientConfigurationBuilder serviceConfigBuilder = new QConnectServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder.clientConfiguration(clientConfiguration).defaultServiceExceptionSupplier(QConnectException::builder)
                .protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    @Override
    public final QConnectServiceClientConfiguration serviceClientConfiguration() {
        return new QConnectServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
