/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A typed union that specifies the configuration based on the type of AI Agent.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AIAgentConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AIAgentConfiguration.Builder, AIAgentConfiguration> {
    private static final SdkField<ManualSearchAIAgentConfiguration> MANUAL_SEARCH_AI_AGENT_CONFIGURATION_FIELD = SdkField
            .<ManualSearchAIAgentConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("manualSearchAIAgentConfiguration")
            .getter(getter(AIAgentConfiguration::manualSearchAIAgentConfiguration))
            .setter(setter(Builder::manualSearchAIAgentConfiguration))
            .constructor(ManualSearchAIAgentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manualSearchAIAgentConfiguration")
                    .build()).build();

    private static final SdkField<AnswerRecommendationAIAgentConfiguration> ANSWER_RECOMMENDATION_AI_AGENT_CONFIGURATION_FIELD = SdkField
            .<AnswerRecommendationAIAgentConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("answerRecommendationAIAgentConfiguration")
            .getter(getter(AIAgentConfiguration::answerRecommendationAIAgentConfiguration))
            .setter(setter(Builder::answerRecommendationAIAgentConfiguration))
            .constructor(AnswerRecommendationAIAgentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("answerRecommendationAIAgentConfiguration").build()).build();

    private static final SdkField<SelfServiceAIAgentConfiguration> SELF_SERVICE_AI_AGENT_CONFIGURATION_FIELD = SdkField
            .<SelfServiceAIAgentConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("selfServiceAIAgentConfiguration")
            .getter(getter(AIAgentConfiguration::selfServiceAIAgentConfiguration))
            .setter(setter(Builder::selfServiceAIAgentConfiguration))
            .constructor(SelfServiceAIAgentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selfServiceAIAgentConfiguration")
                    .build()).build();

    private static final SdkField<EmailResponseAIAgentConfiguration> EMAIL_RESPONSE_AI_AGENT_CONFIGURATION_FIELD = SdkField
            .<EmailResponseAIAgentConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("emailResponseAIAgentConfiguration")
            .getter(getter(AIAgentConfiguration::emailResponseAIAgentConfiguration))
            .setter(setter(Builder::emailResponseAIAgentConfiguration))
            .constructor(EmailResponseAIAgentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailResponseAIAgentConfiguration")
                    .build()).build();

    private static final SdkField<EmailOverviewAIAgentConfiguration> EMAIL_OVERVIEW_AI_AGENT_CONFIGURATION_FIELD = SdkField
            .<EmailOverviewAIAgentConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("emailOverviewAIAgentConfiguration")
            .getter(getter(AIAgentConfiguration::emailOverviewAIAgentConfiguration))
            .setter(setter(Builder::emailOverviewAIAgentConfiguration))
            .constructor(EmailOverviewAIAgentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailOverviewAIAgentConfiguration")
                    .build()).build();

    private static final SdkField<EmailGenerativeAnswerAIAgentConfiguration> EMAIL_GENERATIVE_ANSWER_AI_AGENT_CONFIGURATION_FIELD = SdkField
            .<EmailGenerativeAnswerAIAgentConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("emailGenerativeAnswerAIAgentConfiguration")
            .getter(getter(AIAgentConfiguration::emailGenerativeAnswerAIAgentConfiguration))
            .setter(setter(Builder::emailGenerativeAnswerAIAgentConfiguration))
            .constructor(EmailGenerativeAnswerAIAgentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("emailGenerativeAnswerAIAgentConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MANUAL_SEARCH_AI_AGENT_CONFIGURATION_FIELD, ANSWER_RECOMMENDATION_AI_AGENT_CONFIGURATION_FIELD,
            SELF_SERVICE_AI_AGENT_CONFIGURATION_FIELD, EMAIL_RESPONSE_AI_AGENT_CONFIGURATION_FIELD,
            EMAIL_OVERVIEW_AI_AGENT_CONFIGURATION_FIELD, EMAIL_GENERATIVE_ANSWER_AI_AGENT_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ManualSearchAIAgentConfiguration manualSearchAIAgentConfiguration;

    private final AnswerRecommendationAIAgentConfiguration answerRecommendationAIAgentConfiguration;

    private final SelfServiceAIAgentConfiguration selfServiceAIAgentConfiguration;

    private final EmailResponseAIAgentConfiguration emailResponseAIAgentConfiguration;

    private final EmailOverviewAIAgentConfiguration emailOverviewAIAgentConfiguration;

    private final EmailGenerativeAnswerAIAgentConfiguration emailGenerativeAnswerAIAgentConfiguration;

    private final Type type;

    private AIAgentConfiguration(BuilderImpl builder) {
        this.manualSearchAIAgentConfiguration = builder.manualSearchAIAgentConfiguration;
        this.answerRecommendationAIAgentConfiguration = builder.answerRecommendationAIAgentConfiguration;
        this.selfServiceAIAgentConfiguration = builder.selfServiceAIAgentConfiguration;
        this.emailResponseAIAgentConfiguration = builder.emailResponseAIAgentConfiguration;
        this.emailOverviewAIAgentConfiguration = builder.emailOverviewAIAgentConfiguration;
        this.emailGenerativeAnswerAIAgentConfiguration = builder.emailGenerativeAnswerAIAgentConfiguration;
        this.type = builder.type;
    }

    /**
     * <p>
     * The configuration for AI Agents of type <code>MANUAL_SEARCH</code>.
     * </p>
     * 
     * @return The configuration for AI Agents of type <code>MANUAL_SEARCH</code>.
     */
    public final ManualSearchAIAgentConfiguration manualSearchAIAgentConfiguration() {
        return manualSearchAIAgentConfiguration;
    }

    /**
     * <p>
     * The configuration for AI Agents of type <code>ANSWER_RECOMMENDATION</code>.
     * </p>
     * 
     * @return The configuration for AI Agents of type <code>ANSWER_RECOMMENDATION</code>.
     */
    public final AnswerRecommendationAIAgentConfiguration answerRecommendationAIAgentConfiguration() {
        return answerRecommendationAIAgentConfiguration;
    }

    /**
     * <p>
     * The configuration for AI Agents of type SELF_SERVICE.
     * </p>
     * 
     * @return The configuration for AI Agents of type SELF_SERVICE.
     */
    public final SelfServiceAIAgentConfiguration selfServiceAIAgentConfiguration() {
        return selfServiceAIAgentConfiguration;
    }

    /**
     * <p>
     * Configuration for the EMAIL_RESPONSE AI agent that generates professional email responses using knowledge base
     * content.
     * </p>
     * 
     * @return Configuration for the EMAIL_RESPONSE AI agent that generates professional email responses using knowledge
     *         base content.
     */
    public final EmailResponseAIAgentConfiguration emailResponseAIAgentConfiguration() {
        return emailResponseAIAgentConfiguration;
    }

    /**
     * <p>
     * Configuration for the EMAIL_OVERVIEW AI agent that generates structured overview of email conversations.
     * </p>
     * 
     * @return Configuration for the EMAIL_OVERVIEW AI agent that generates structured overview of email conversations.
     */
    public final EmailOverviewAIAgentConfiguration emailOverviewAIAgentConfiguration() {
        return emailOverviewAIAgentConfiguration;
    }

    /**
     * <p>
     * Configuration for the EMAIL_GENERATIVE_ANSWER AI agent that provides comprehensive knowledge-based answers for
     * customer queries.
     * </p>
     * 
     * @return Configuration for the EMAIL_GENERATIVE_ANSWER AI agent that provides comprehensive knowledge-based
     *         answers for customer queries.
     */
    public final EmailGenerativeAnswerAIAgentConfiguration emailGenerativeAnswerAIAgentConfiguration() {
        return emailGenerativeAnswerAIAgentConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(manualSearchAIAgentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(answerRecommendationAIAgentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(selfServiceAIAgentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(emailResponseAIAgentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(emailOverviewAIAgentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(emailGenerativeAnswerAIAgentConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AIAgentConfiguration)) {
            return false;
        }
        AIAgentConfiguration other = (AIAgentConfiguration) obj;
        return Objects.equals(manualSearchAIAgentConfiguration(), other.manualSearchAIAgentConfiguration())
                && Objects.equals(answerRecommendationAIAgentConfiguration(), other.answerRecommendationAIAgentConfiguration())
                && Objects.equals(selfServiceAIAgentConfiguration(), other.selfServiceAIAgentConfiguration())
                && Objects.equals(emailResponseAIAgentConfiguration(), other.emailResponseAIAgentConfiguration())
                && Objects.equals(emailOverviewAIAgentConfiguration(), other.emailOverviewAIAgentConfiguration())
                && Objects.equals(emailGenerativeAnswerAIAgentConfiguration(), other.emailGenerativeAnswerAIAgentConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AIAgentConfiguration")
                .add("ManualSearchAIAgentConfiguration", manualSearchAIAgentConfiguration())
                .add("AnswerRecommendationAIAgentConfiguration", answerRecommendationAIAgentConfiguration())
                .add("SelfServiceAIAgentConfiguration", selfServiceAIAgentConfiguration())
                .add("EmailResponseAIAgentConfiguration", emailResponseAIAgentConfiguration())
                .add("EmailOverviewAIAgentConfiguration", emailOverviewAIAgentConfiguration())
                .add("EmailGenerativeAnswerAIAgentConfiguration", emailGenerativeAnswerAIAgentConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "manualSearchAIAgentConfiguration":
            return Optional.ofNullable(clazz.cast(manualSearchAIAgentConfiguration()));
        case "answerRecommendationAIAgentConfiguration":
            return Optional.ofNullable(clazz.cast(answerRecommendationAIAgentConfiguration()));
        case "selfServiceAIAgentConfiguration":
            return Optional.ofNullable(clazz.cast(selfServiceAIAgentConfiguration()));
        case "emailResponseAIAgentConfiguration":
            return Optional.ofNullable(clazz.cast(emailResponseAIAgentConfiguration()));
        case "emailOverviewAIAgentConfiguration":
            return Optional.ofNullable(clazz.cast(emailOverviewAIAgentConfiguration()));
        case "emailGenerativeAnswerAIAgentConfiguration":
            return Optional.ofNullable(clazz.cast(emailGenerativeAnswerAIAgentConfiguration()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #manualSearchAIAgentConfiguration()} initialized to the given value.
     *
     * <p>
     * The configuration for AI Agents of type <code>MANUAL_SEARCH</code>.
     * </p>
     * 
     * @param manualSearchAIAgentConfiguration
     *        The configuration for AI Agents of type <code>MANUAL_SEARCH</code>.
     */
    public static AIAgentConfiguration fromManualSearchAIAgentConfiguration(
            ManualSearchAIAgentConfiguration manualSearchAIAgentConfiguration) {
        return builder().manualSearchAIAgentConfiguration(manualSearchAIAgentConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #manualSearchAIAgentConfiguration()} initialized to the given value.
     *
     * <p>
     * The configuration for AI Agents of type <code>MANUAL_SEARCH</code>.
     * </p>
     * 
     * @param manualSearchAIAgentConfiguration
     *        The configuration for AI Agents of type <code>MANUAL_SEARCH</code>.
     */
    public static AIAgentConfiguration fromManualSearchAIAgentConfiguration(
            Consumer<ManualSearchAIAgentConfiguration.Builder> manualSearchAIAgentConfiguration) {
        ManualSearchAIAgentConfiguration.Builder builder = ManualSearchAIAgentConfiguration.builder();
        manualSearchAIAgentConfiguration.accept(builder);
        return fromManualSearchAIAgentConfiguration(builder.build());
    }

    /**
     * Create an instance of this class with {@link #answerRecommendationAIAgentConfiguration()} initialized to the
     * given value.
     *
     * <p>
     * The configuration for AI Agents of type <code>ANSWER_RECOMMENDATION</code>.
     * </p>
     * 
     * @param answerRecommendationAIAgentConfiguration
     *        The configuration for AI Agents of type <code>ANSWER_RECOMMENDATION</code>.
     */
    public static AIAgentConfiguration fromAnswerRecommendationAIAgentConfiguration(
            AnswerRecommendationAIAgentConfiguration answerRecommendationAIAgentConfiguration) {
        return builder().answerRecommendationAIAgentConfiguration(answerRecommendationAIAgentConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #answerRecommendationAIAgentConfiguration()} initialized to the
     * given value.
     *
     * <p>
     * The configuration for AI Agents of type <code>ANSWER_RECOMMENDATION</code>.
     * </p>
     * 
     * @param answerRecommendationAIAgentConfiguration
     *        The configuration for AI Agents of type <code>ANSWER_RECOMMENDATION</code>.
     */
    public static AIAgentConfiguration fromAnswerRecommendationAIAgentConfiguration(
            Consumer<AnswerRecommendationAIAgentConfiguration.Builder> answerRecommendationAIAgentConfiguration) {
        AnswerRecommendationAIAgentConfiguration.Builder builder = AnswerRecommendationAIAgentConfiguration.builder();
        answerRecommendationAIAgentConfiguration.accept(builder);
        return fromAnswerRecommendationAIAgentConfiguration(builder.build());
    }

    /**
     * Create an instance of this class with {@link #selfServiceAIAgentConfiguration()} initialized to the given value.
     *
     * <p>
     * The configuration for AI Agents of type SELF_SERVICE.
     * </p>
     * 
     * @param selfServiceAIAgentConfiguration
     *        The configuration for AI Agents of type SELF_SERVICE.
     */
    public static AIAgentConfiguration fromSelfServiceAIAgentConfiguration(
            SelfServiceAIAgentConfiguration selfServiceAIAgentConfiguration) {
        return builder().selfServiceAIAgentConfiguration(selfServiceAIAgentConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #selfServiceAIAgentConfiguration()} initialized to the given value.
     *
     * <p>
     * The configuration for AI Agents of type SELF_SERVICE.
     * </p>
     * 
     * @param selfServiceAIAgentConfiguration
     *        The configuration for AI Agents of type SELF_SERVICE.
     */
    public static AIAgentConfiguration fromSelfServiceAIAgentConfiguration(
            Consumer<SelfServiceAIAgentConfiguration.Builder> selfServiceAIAgentConfiguration) {
        SelfServiceAIAgentConfiguration.Builder builder = SelfServiceAIAgentConfiguration.builder();
        selfServiceAIAgentConfiguration.accept(builder);
        return fromSelfServiceAIAgentConfiguration(builder.build());
    }

    /**
     * Create an instance of this class with {@link #emailResponseAIAgentConfiguration()} initialized to the given
     * value.
     *
     * <p>
     * Configuration for the EMAIL_RESPONSE AI agent that generates professional email responses using knowledge base
     * content.
     * </p>
     * 
     * @param emailResponseAIAgentConfiguration
     *        Configuration for the EMAIL_RESPONSE AI agent that generates professional email responses using knowledge
     *        base content.
     */
    public static AIAgentConfiguration fromEmailResponseAIAgentConfiguration(
            EmailResponseAIAgentConfiguration emailResponseAIAgentConfiguration) {
        return builder().emailResponseAIAgentConfiguration(emailResponseAIAgentConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #emailResponseAIAgentConfiguration()} initialized to the given
     * value.
     *
     * <p>
     * Configuration for the EMAIL_RESPONSE AI agent that generates professional email responses using knowledge base
     * content.
     * </p>
     * 
     * @param emailResponseAIAgentConfiguration
     *        Configuration for the EMAIL_RESPONSE AI agent that generates professional email responses using knowledge
     *        base content.
     */
    public static AIAgentConfiguration fromEmailResponseAIAgentConfiguration(
            Consumer<EmailResponseAIAgentConfiguration.Builder> emailResponseAIAgentConfiguration) {
        EmailResponseAIAgentConfiguration.Builder builder = EmailResponseAIAgentConfiguration.builder();
        emailResponseAIAgentConfiguration.accept(builder);
        return fromEmailResponseAIAgentConfiguration(builder.build());
    }

    /**
     * Create an instance of this class with {@link #emailOverviewAIAgentConfiguration()} initialized to the given
     * value.
     *
     * <p>
     * Configuration for the EMAIL_OVERVIEW AI agent that generates structured overview of email conversations.
     * </p>
     * 
     * @param emailOverviewAIAgentConfiguration
     *        Configuration for the EMAIL_OVERVIEW AI agent that generates structured overview of email conversations.
     */
    public static AIAgentConfiguration fromEmailOverviewAIAgentConfiguration(
            EmailOverviewAIAgentConfiguration emailOverviewAIAgentConfiguration) {
        return builder().emailOverviewAIAgentConfiguration(emailOverviewAIAgentConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #emailOverviewAIAgentConfiguration()} initialized to the given
     * value.
     *
     * <p>
     * Configuration for the EMAIL_OVERVIEW AI agent that generates structured overview of email conversations.
     * </p>
     * 
     * @param emailOverviewAIAgentConfiguration
     *        Configuration for the EMAIL_OVERVIEW AI agent that generates structured overview of email conversations.
     */
    public static AIAgentConfiguration fromEmailOverviewAIAgentConfiguration(
            Consumer<EmailOverviewAIAgentConfiguration.Builder> emailOverviewAIAgentConfiguration) {
        EmailOverviewAIAgentConfiguration.Builder builder = EmailOverviewAIAgentConfiguration.builder();
        emailOverviewAIAgentConfiguration.accept(builder);
        return fromEmailOverviewAIAgentConfiguration(builder.build());
    }

    /**
     * Create an instance of this class with {@link #emailGenerativeAnswerAIAgentConfiguration()} initialized to the
     * given value.
     *
     * <p>
     * Configuration for the EMAIL_GENERATIVE_ANSWER AI agent that provides comprehensive knowledge-based answers for
     * customer queries.
     * </p>
     * 
     * @param emailGenerativeAnswerAIAgentConfiguration
     *        Configuration for the EMAIL_GENERATIVE_ANSWER AI agent that provides comprehensive knowledge-based answers
     *        for customer queries.
     */
    public static AIAgentConfiguration fromEmailGenerativeAnswerAIAgentConfiguration(
            EmailGenerativeAnswerAIAgentConfiguration emailGenerativeAnswerAIAgentConfiguration) {
        return builder().emailGenerativeAnswerAIAgentConfiguration(emailGenerativeAnswerAIAgentConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #emailGenerativeAnswerAIAgentConfiguration()} initialized to the
     * given value.
     *
     * <p>
     * Configuration for the EMAIL_GENERATIVE_ANSWER AI agent that provides comprehensive knowledge-based answers for
     * customer queries.
     * </p>
     * 
     * @param emailGenerativeAnswerAIAgentConfiguration
     *        Configuration for the EMAIL_GENERATIVE_ANSWER AI agent that provides comprehensive knowledge-based answers
     *        for customer queries.
     */
    public static AIAgentConfiguration fromEmailGenerativeAnswerAIAgentConfiguration(
            Consumer<EmailGenerativeAnswerAIAgentConfiguration.Builder> emailGenerativeAnswerAIAgentConfiguration) {
        EmailGenerativeAnswerAIAgentConfiguration.Builder builder = EmailGenerativeAnswerAIAgentConfiguration.builder();
        emailGenerativeAnswerAIAgentConfiguration.accept(builder);
        return fromEmailGenerativeAnswerAIAgentConfiguration(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("manualSearchAIAgentConfiguration", MANUAL_SEARCH_AI_AGENT_CONFIGURATION_FIELD);
        map.put("answerRecommendationAIAgentConfiguration", ANSWER_RECOMMENDATION_AI_AGENT_CONFIGURATION_FIELD);
        map.put("selfServiceAIAgentConfiguration", SELF_SERVICE_AI_AGENT_CONFIGURATION_FIELD);
        map.put("emailResponseAIAgentConfiguration", EMAIL_RESPONSE_AI_AGENT_CONFIGURATION_FIELD);
        map.put("emailOverviewAIAgentConfiguration", EMAIL_OVERVIEW_AI_AGENT_CONFIGURATION_FIELD);
        map.put("emailGenerativeAnswerAIAgentConfiguration", EMAIL_GENERATIVE_ANSWER_AI_AGENT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AIAgentConfiguration, T> g) {
        return obj -> g.apply((AIAgentConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AIAgentConfiguration> {
        /**
         * <p>
         * The configuration for AI Agents of type <code>MANUAL_SEARCH</code>.
         * </p>
         * 
         * @param manualSearchAIAgentConfiguration
         *        The configuration for AI Agents of type <code>MANUAL_SEARCH</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manualSearchAIAgentConfiguration(ManualSearchAIAgentConfiguration manualSearchAIAgentConfiguration);

        /**
         * <p>
         * The configuration for AI Agents of type <code>MANUAL_SEARCH</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ManualSearchAIAgentConfiguration.Builder}
         * avoiding the need to create one manually via {@link ManualSearchAIAgentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ManualSearchAIAgentConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #manualSearchAIAgentConfiguration(ManualSearchAIAgentConfiguration)}.
         * 
         * @param manualSearchAIAgentConfiguration
         *        a consumer that will call methods on {@link ManualSearchAIAgentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #manualSearchAIAgentConfiguration(ManualSearchAIAgentConfiguration)
         */
        default Builder manualSearchAIAgentConfiguration(
                Consumer<ManualSearchAIAgentConfiguration.Builder> manualSearchAIAgentConfiguration) {
            return manualSearchAIAgentConfiguration(ManualSearchAIAgentConfiguration.builder()
                    .applyMutation(manualSearchAIAgentConfiguration).build());
        }

        /**
         * <p>
         * The configuration for AI Agents of type <code>ANSWER_RECOMMENDATION</code>.
         * </p>
         * 
         * @param answerRecommendationAIAgentConfiguration
         *        The configuration for AI Agents of type <code>ANSWER_RECOMMENDATION</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder answerRecommendationAIAgentConfiguration(
                AnswerRecommendationAIAgentConfiguration answerRecommendationAIAgentConfiguration);

        /**
         * <p>
         * The configuration for AI Agents of type <code>ANSWER_RECOMMENDATION</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AnswerRecommendationAIAgentConfiguration.Builder} avoiding the need to create one manually via
         * {@link AnswerRecommendationAIAgentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnswerRecommendationAIAgentConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #answerRecommendationAIAgentConfiguration(AnswerRecommendationAIAgentConfiguration)}.
         * 
         * @param answerRecommendationAIAgentConfiguration
         *        a consumer that will call methods on {@link AnswerRecommendationAIAgentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #answerRecommendationAIAgentConfiguration(AnswerRecommendationAIAgentConfiguration)
         */
        default Builder answerRecommendationAIAgentConfiguration(
                Consumer<AnswerRecommendationAIAgentConfiguration.Builder> answerRecommendationAIAgentConfiguration) {
            return answerRecommendationAIAgentConfiguration(AnswerRecommendationAIAgentConfiguration.builder()
                    .applyMutation(answerRecommendationAIAgentConfiguration).build());
        }

        /**
         * <p>
         * The configuration for AI Agents of type SELF_SERVICE.
         * </p>
         * 
         * @param selfServiceAIAgentConfiguration
         *        The configuration for AI Agents of type SELF_SERVICE.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selfServiceAIAgentConfiguration(SelfServiceAIAgentConfiguration selfServiceAIAgentConfiguration);

        /**
         * <p>
         * The configuration for AI Agents of type SELF_SERVICE.
         * </p>
         * This is a convenience method that creates an instance of the {@link SelfServiceAIAgentConfiguration.Builder}
         * avoiding the need to create one manually via {@link SelfServiceAIAgentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SelfServiceAIAgentConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #selfServiceAIAgentConfiguration(SelfServiceAIAgentConfiguration)}.
         * 
         * @param selfServiceAIAgentConfiguration
         *        a consumer that will call methods on {@link SelfServiceAIAgentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selfServiceAIAgentConfiguration(SelfServiceAIAgentConfiguration)
         */
        default Builder selfServiceAIAgentConfiguration(
                Consumer<SelfServiceAIAgentConfiguration.Builder> selfServiceAIAgentConfiguration) {
            return selfServiceAIAgentConfiguration(SelfServiceAIAgentConfiguration.builder()
                    .applyMutation(selfServiceAIAgentConfiguration).build());
        }

        /**
         * <p>
         * Configuration for the EMAIL_RESPONSE AI agent that generates professional email responses using knowledge
         * base content.
         * </p>
         * 
         * @param emailResponseAIAgentConfiguration
         *        Configuration for the EMAIL_RESPONSE AI agent that generates professional email responses using
         *        knowledge base content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailResponseAIAgentConfiguration(EmailResponseAIAgentConfiguration emailResponseAIAgentConfiguration);

        /**
         * <p>
         * Configuration for the EMAIL_RESPONSE AI agent that generates professional email responses using knowledge
         * base content.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link EmailResponseAIAgentConfiguration.Builder} avoiding the need to create one manually via
         * {@link EmailResponseAIAgentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmailResponseAIAgentConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #emailResponseAIAgentConfiguration(EmailResponseAIAgentConfiguration)}.
         * 
         * @param emailResponseAIAgentConfiguration
         *        a consumer that will call methods on {@link EmailResponseAIAgentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emailResponseAIAgentConfiguration(EmailResponseAIAgentConfiguration)
         */
        default Builder emailResponseAIAgentConfiguration(
                Consumer<EmailResponseAIAgentConfiguration.Builder> emailResponseAIAgentConfiguration) {
            return emailResponseAIAgentConfiguration(EmailResponseAIAgentConfiguration.builder()
                    .applyMutation(emailResponseAIAgentConfiguration).build());
        }

        /**
         * <p>
         * Configuration for the EMAIL_OVERVIEW AI agent that generates structured overview of email conversations.
         * </p>
         * 
         * @param emailOverviewAIAgentConfiguration
         *        Configuration for the EMAIL_OVERVIEW AI agent that generates structured overview of email
         *        conversations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailOverviewAIAgentConfiguration(EmailOverviewAIAgentConfiguration emailOverviewAIAgentConfiguration);

        /**
         * <p>
         * Configuration for the EMAIL_OVERVIEW AI agent that generates structured overview of email conversations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link EmailOverviewAIAgentConfiguration.Builder} avoiding the need to create one manually via
         * {@link EmailOverviewAIAgentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmailOverviewAIAgentConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #emailOverviewAIAgentConfiguration(EmailOverviewAIAgentConfiguration)}.
         * 
         * @param emailOverviewAIAgentConfiguration
         *        a consumer that will call methods on {@link EmailOverviewAIAgentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emailOverviewAIAgentConfiguration(EmailOverviewAIAgentConfiguration)
         */
        default Builder emailOverviewAIAgentConfiguration(
                Consumer<EmailOverviewAIAgentConfiguration.Builder> emailOverviewAIAgentConfiguration) {
            return emailOverviewAIAgentConfiguration(EmailOverviewAIAgentConfiguration.builder()
                    .applyMutation(emailOverviewAIAgentConfiguration).build());
        }

        /**
         * <p>
         * Configuration for the EMAIL_GENERATIVE_ANSWER AI agent that provides comprehensive knowledge-based answers
         * for customer queries.
         * </p>
         * 
         * @param emailGenerativeAnswerAIAgentConfiguration
         *        Configuration for the EMAIL_GENERATIVE_ANSWER AI agent that provides comprehensive knowledge-based
         *        answers for customer queries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailGenerativeAnswerAIAgentConfiguration(
                EmailGenerativeAnswerAIAgentConfiguration emailGenerativeAnswerAIAgentConfiguration);

        /**
         * <p>
         * Configuration for the EMAIL_GENERATIVE_ANSWER AI agent that provides comprehensive knowledge-based answers
         * for customer queries.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link EmailGenerativeAnswerAIAgentConfiguration.Builder} avoiding the need to create one manually via
         * {@link EmailGenerativeAnswerAIAgentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmailGenerativeAnswerAIAgentConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #emailGenerativeAnswerAIAgentConfiguration(EmailGenerativeAnswerAIAgentConfiguration)}.
         * 
         * @param emailGenerativeAnswerAIAgentConfiguration
         *        a consumer that will call methods on {@link EmailGenerativeAnswerAIAgentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emailGenerativeAnswerAIAgentConfiguration(EmailGenerativeAnswerAIAgentConfiguration)
         */
        default Builder emailGenerativeAnswerAIAgentConfiguration(
                Consumer<EmailGenerativeAnswerAIAgentConfiguration.Builder> emailGenerativeAnswerAIAgentConfiguration) {
            return emailGenerativeAnswerAIAgentConfiguration(EmailGenerativeAnswerAIAgentConfiguration.builder()
                    .applyMutation(emailGenerativeAnswerAIAgentConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ManualSearchAIAgentConfiguration manualSearchAIAgentConfiguration;

        private AnswerRecommendationAIAgentConfiguration answerRecommendationAIAgentConfiguration;

        private SelfServiceAIAgentConfiguration selfServiceAIAgentConfiguration;

        private EmailResponseAIAgentConfiguration emailResponseAIAgentConfiguration;

        private EmailOverviewAIAgentConfiguration emailOverviewAIAgentConfiguration;

        private EmailGenerativeAnswerAIAgentConfiguration emailGenerativeAnswerAIAgentConfiguration;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AIAgentConfiguration model) {
            manualSearchAIAgentConfiguration(model.manualSearchAIAgentConfiguration);
            answerRecommendationAIAgentConfiguration(model.answerRecommendationAIAgentConfiguration);
            selfServiceAIAgentConfiguration(model.selfServiceAIAgentConfiguration);
            emailResponseAIAgentConfiguration(model.emailResponseAIAgentConfiguration);
            emailOverviewAIAgentConfiguration(model.emailOverviewAIAgentConfiguration);
            emailGenerativeAnswerAIAgentConfiguration(model.emailGenerativeAnswerAIAgentConfiguration);
        }

        public final ManualSearchAIAgentConfiguration.Builder getManualSearchAIAgentConfiguration() {
            return manualSearchAIAgentConfiguration != null ? manualSearchAIAgentConfiguration.toBuilder() : null;
        }

        public final void setManualSearchAIAgentConfiguration(
                ManualSearchAIAgentConfiguration.BuilderImpl manualSearchAIAgentConfiguration) {
            Object oldValue = this.manualSearchAIAgentConfiguration;
            this.manualSearchAIAgentConfiguration = manualSearchAIAgentConfiguration != null ? manualSearchAIAgentConfiguration
                    .build() : null;
            handleUnionValueChange(Type.MANUAL_SEARCH_AI_AGENT_CONFIGURATION, oldValue, this.manualSearchAIAgentConfiguration);
        }

        @Override
        public final Builder manualSearchAIAgentConfiguration(ManualSearchAIAgentConfiguration manualSearchAIAgentConfiguration) {
            Object oldValue = this.manualSearchAIAgentConfiguration;
            this.manualSearchAIAgentConfiguration = manualSearchAIAgentConfiguration;
            handleUnionValueChange(Type.MANUAL_SEARCH_AI_AGENT_CONFIGURATION, oldValue, this.manualSearchAIAgentConfiguration);
            return this;
        }

        public final AnswerRecommendationAIAgentConfiguration.Builder getAnswerRecommendationAIAgentConfiguration() {
            return answerRecommendationAIAgentConfiguration != null ? answerRecommendationAIAgentConfiguration.toBuilder() : null;
        }

        public final void setAnswerRecommendationAIAgentConfiguration(
                AnswerRecommendationAIAgentConfiguration.BuilderImpl answerRecommendationAIAgentConfiguration) {
            Object oldValue = this.answerRecommendationAIAgentConfiguration;
            this.answerRecommendationAIAgentConfiguration = answerRecommendationAIAgentConfiguration != null ? answerRecommendationAIAgentConfiguration
                    .build() : null;
            handleUnionValueChange(Type.ANSWER_RECOMMENDATION_AI_AGENT_CONFIGURATION, oldValue,
                    this.answerRecommendationAIAgentConfiguration);
        }

        @Override
        public final Builder answerRecommendationAIAgentConfiguration(
                AnswerRecommendationAIAgentConfiguration answerRecommendationAIAgentConfiguration) {
            Object oldValue = this.answerRecommendationAIAgentConfiguration;
            this.answerRecommendationAIAgentConfiguration = answerRecommendationAIAgentConfiguration;
            handleUnionValueChange(Type.ANSWER_RECOMMENDATION_AI_AGENT_CONFIGURATION, oldValue,
                    this.answerRecommendationAIAgentConfiguration);
            return this;
        }

        public final SelfServiceAIAgentConfiguration.Builder getSelfServiceAIAgentConfiguration() {
            return selfServiceAIAgentConfiguration != null ? selfServiceAIAgentConfiguration.toBuilder() : null;
        }

        public final void setSelfServiceAIAgentConfiguration(
                SelfServiceAIAgentConfiguration.BuilderImpl selfServiceAIAgentConfiguration) {
            Object oldValue = this.selfServiceAIAgentConfiguration;
            this.selfServiceAIAgentConfiguration = selfServiceAIAgentConfiguration != null ? selfServiceAIAgentConfiguration
                    .build() : null;
            handleUnionValueChange(Type.SELF_SERVICE_AI_AGENT_CONFIGURATION, oldValue, this.selfServiceAIAgentConfiguration);
        }

        @Override
        public final Builder selfServiceAIAgentConfiguration(SelfServiceAIAgentConfiguration selfServiceAIAgentConfiguration) {
            Object oldValue = this.selfServiceAIAgentConfiguration;
            this.selfServiceAIAgentConfiguration = selfServiceAIAgentConfiguration;
            handleUnionValueChange(Type.SELF_SERVICE_AI_AGENT_CONFIGURATION, oldValue, this.selfServiceAIAgentConfiguration);
            return this;
        }

        public final EmailResponseAIAgentConfiguration.Builder getEmailResponseAIAgentConfiguration() {
            return emailResponseAIAgentConfiguration != null ? emailResponseAIAgentConfiguration.toBuilder() : null;
        }

        public final void setEmailResponseAIAgentConfiguration(
                EmailResponseAIAgentConfiguration.BuilderImpl emailResponseAIAgentConfiguration) {
            Object oldValue = this.emailResponseAIAgentConfiguration;
            this.emailResponseAIAgentConfiguration = emailResponseAIAgentConfiguration != null ? emailResponseAIAgentConfiguration
                    .build() : null;
            handleUnionValueChange(Type.EMAIL_RESPONSE_AI_AGENT_CONFIGURATION, oldValue, this.emailResponseAIAgentConfiguration);
        }

        @Override
        public final Builder emailResponseAIAgentConfiguration(EmailResponseAIAgentConfiguration emailResponseAIAgentConfiguration) {
            Object oldValue = this.emailResponseAIAgentConfiguration;
            this.emailResponseAIAgentConfiguration = emailResponseAIAgentConfiguration;
            handleUnionValueChange(Type.EMAIL_RESPONSE_AI_AGENT_CONFIGURATION, oldValue, this.emailResponseAIAgentConfiguration);
            return this;
        }

        public final EmailOverviewAIAgentConfiguration.Builder getEmailOverviewAIAgentConfiguration() {
            return emailOverviewAIAgentConfiguration != null ? emailOverviewAIAgentConfiguration.toBuilder() : null;
        }

        public final void setEmailOverviewAIAgentConfiguration(
                EmailOverviewAIAgentConfiguration.BuilderImpl emailOverviewAIAgentConfiguration) {
            Object oldValue = this.emailOverviewAIAgentConfiguration;
            this.emailOverviewAIAgentConfiguration = emailOverviewAIAgentConfiguration != null ? emailOverviewAIAgentConfiguration
                    .build() : null;
            handleUnionValueChange(Type.EMAIL_OVERVIEW_AI_AGENT_CONFIGURATION, oldValue, this.emailOverviewAIAgentConfiguration);
        }

        @Override
        public final Builder emailOverviewAIAgentConfiguration(EmailOverviewAIAgentConfiguration emailOverviewAIAgentConfiguration) {
            Object oldValue = this.emailOverviewAIAgentConfiguration;
            this.emailOverviewAIAgentConfiguration = emailOverviewAIAgentConfiguration;
            handleUnionValueChange(Type.EMAIL_OVERVIEW_AI_AGENT_CONFIGURATION, oldValue, this.emailOverviewAIAgentConfiguration);
            return this;
        }

        public final EmailGenerativeAnswerAIAgentConfiguration.Builder getEmailGenerativeAnswerAIAgentConfiguration() {
            return emailGenerativeAnswerAIAgentConfiguration != null ? emailGenerativeAnswerAIAgentConfiguration.toBuilder()
                    : null;
        }

        public final void setEmailGenerativeAnswerAIAgentConfiguration(
                EmailGenerativeAnswerAIAgentConfiguration.BuilderImpl emailGenerativeAnswerAIAgentConfiguration) {
            Object oldValue = this.emailGenerativeAnswerAIAgentConfiguration;
            this.emailGenerativeAnswerAIAgentConfiguration = emailGenerativeAnswerAIAgentConfiguration != null ? emailGenerativeAnswerAIAgentConfiguration
                    .build() : null;
            handleUnionValueChange(Type.EMAIL_GENERATIVE_ANSWER_AI_AGENT_CONFIGURATION, oldValue,
                    this.emailGenerativeAnswerAIAgentConfiguration);
        }

        @Override
        public final Builder emailGenerativeAnswerAIAgentConfiguration(
                EmailGenerativeAnswerAIAgentConfiguration emailGenerativeAnswerAIAgentConfiguration) {
            Object oldValue = this.emailGenerativeAnswerAIAgentConfiguration;
            this.emailGenerativeAnswerAIAgentConfiguration = emailGenerativeAnswerAIAgentConfiguration;
            handleUnionValueChange(Type.EMAIL_GENERATIVE_ANSWER_AI_AGENT_CONFIGURATION, oldValue,
                    this.emailGenerativeAnswerAIAgentConfiguration);
            return this;
        }

        @Override
        public AIAgentConfiguration build() {
            return new AIAgentConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AIAgentConfiguration#type()
     */
    public enum Type {
        MANUAL_SEARCH_AI_AGENT_CONFIGURATION,

        ANSWER_RECOMMENDATION_AI_AGENT_CONFIGURATION,

        SELF_SERVICE_AI_AGENT_CONFIGURATION,

        EMAIL_RESPONSE_AI_AGENT_CONFIGURATION,

        EMAIL_OVERVIEW_AI_AGENT_CONFIGURATION,

        EMAIL_GENERATIVE_ANSWER_AI_AGENT_CONFIGURATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
