/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the content association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContentAssociationData implements SdkPojo, Serializable,
        ToCopyableBuilder<ContentAssociationData.Builder, ContentAssociationData> {
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(ContentAssociationData::knowledgeBaseId))
            .setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()).build();

    private static final SdkField<String> KNOWLEDGE_BASE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseArn").getter(getter(ContentAssociationData::knowledgeBaseArn))
            .setter(setter(Builder::knowledgeBaseArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseArn").build()).build();

    private static final SdkField<String> CONTENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentId").getter(getter(ContentAssociationData::contentId)).setter(setter(Builder::contentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentId").build()).build();

    private static final SdkField<String> CONTENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentArn").getter(getter(ContentAssociationData::contentArn)).setter(setter(Builder::contentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentArn").build()).build();

    private static final SdkField<String> CONTENT_ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentAssociationId").getter(getter(ContentAssociationData::contentAssociationId))
            .setter(setter(Builder::contentAssociationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentAssociationId").build())
            .build();

    private static final SdkField<String> CONTENT_ASSOCIATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentAssociationArn").getter(getter(ContentAssociationData::contentAssociationArn))
            .setter(setter(Builder::contentAssociationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentAssociationArn").build())
            .build();

    private static final SdkField<String> ASSOCIATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("associationType").getter(getter(ContentAssociationData::associationTypeAsString))
            .setter(setter(Builder::associationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationType").build()).build();

    private static final SdkField<ContentAssociationContents> ASSOCIATION_DATA_FIELD = SdkField
            .<ContentAssociationContents> builder(MarshallingType.SDK_POJO).memberName("associationData")
            .getter(getter(ContentAssociationData::associationData)).setter(setter(Builder::associationData))
            .constructor(ContentAssociationContents::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationData").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(ContentAssociationData::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWLEDGE_BASE_ID_FIELD,
            KNOWLEDGE_BASE_ARN_FIELD, CONTENT_ID_FIELD, CONTENT_ARN_FIELD, CONTENT_ASSOCIATION_ID_FIELD,
            CONTENT_ASSOCIATION_ARN_FIELD, ASSOCIATION_TYPE_FIELD, ASSOCIATION_DATA_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String knowledgeBaseId;

    private final String knowledgeBaseArn;

    private final String contentId;

    private final String contentArn;

    private final String contentAssociationId;

    private final String contentAssociationArn;

    private final String associationType;

    private final ContentAssociationContents associationData;

    private final Map<String, String> tags;

    private ContentAssociationData(BuilderImpl builder) {
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.knowledgeBaseArn = builder.knowledgeBaseArn;
        this.contentId = builder.contentId;
        this.contentArn = builder.contentArn;
        this.contentAssociationId = builder.contentAssociationId;
        this.contentAssociationArn = builder.contentAssociationArn;
        this.associationType = builder.associationType;
        this.associationData = builder.associationData;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The identifier of the knowledge base.
     * </p>
     * 
     * @return The identifier of the knowledge base.
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the knowledge base.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the knowledge base.
     */
    public final String knowledgeBaseArn() {
        return knowledgeBaseArn;
    }

    /**
     * <p>
     * The identifier of the content.
     * </p>
     * 
     * @return The identifier of the content.
     */
    public final String contentId() {
        return contentId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the content.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the content.
     */
    public final String contentArn() {
        return contentArn;
    }

    /**
     * <p>
     * The identifier of the content association. Can be either the ID or the ARN. URLs cannot contain the ARN.
     * </p>
     * 
     * @return The identifier of the content association. Can be either the ID or the ARN. URLs cannot contain the ARN.
     */
    public final String contentAssociationId() {
        return contentAssociationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the content association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the content association.
     */
    public final String contentAssociationArn() {
        return contentAssociationArn;
    }

    /**
     * <p>
     * The type of association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationType}
     * will return {@link ContentAssociationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #associationTypeAsString}.
     * </p>
     * 
     * @return The type of association.
     * @see ContentAssociationType
     */
    public final ContentAssociationType associationType() {
        return ContentAssociationType.fromValue(associationType);
    }

    /**
     * <p>
     * The type of association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationType}
     * will return {@link ContentAssociationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #associationTypeAsString}.
     * </p>
     * 
     * @return The type of association.
     * @see ContentAssociationType
     */
    public final String associationTypeAsString() {
        return associationType;
    }

    /**
     * <p>
     * The content association.
     * </p>
     * 
     * @return The content association.
     */
    public final ContentAssociationContents associationData() {
        return associationData;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseArn());
        hashCode = 31 * hashCode + Objects.hashCode(contentId());
        hashCode = 31 * hashCode + Objects.hashCode(contentArn());
        hashCode = 31 * hashCode + Objects.hashCode(contentAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(contentAssociationArn());
        hashCode = 31 * hashCode + Objects.hashCode(associationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(associationData());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentAssociationData)) {
            return false;
        }
        ContentAssociationData other = (ContentAssociationData) obj;
        return Objects.equals(knowledgeBaseId(), other.knowledgeBaseId())
                && Objects.equals(knowledgeBaseArn(), other.knowledgeBaseArn()) && Objects.equals(contentId(), other.contentId())
                && Objects.equals(contentArn(), other.contentArn())
                && Objects.equals(contentAssociationId(), other.contentAssociationId())
                && Objects.equals(contentAssociationArn(), other.contentAssociationArn())
                && Objects.equals(associationTypeAsString(), other.associationTypeAsString())
                && Objects.equals(associationData(), other.associationData()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContentAssociationData").add("KnowledgeBaseId", knowledgeBaseId())
                .add("KnowledgeBaseArn", knowledgeBaseArn()).add("ContentId", contentId()).add("ContentArn", contentArn())
                .add("ContentAssociationId", contentAssociationId()).add("ContentAssociationArn", contentAssociationArn())
                .add("AssociationType", associationTypeAsString()).add("AssociationData", associationData())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        case "knowledgeBaseArn":
            return Optional.ofNullable(clazz.cast(knowledgeBaseArn()));
        case "contentId":
            return Optional.ofNullable(clazz.cast(contentId()));
        case "contentArn":
            return Optional.ofNullable(clazz.cast(contentArn()));
        case "contentAssociationId":
            return Optional.ofNullable(clazz.cast(contentAssociationId()));
        case "contentAssociationArn":
            return Optional.ofNullable(clazz.cast(contentAssociationArn()));
        case "associationType":
            return Optional.ofNullable(clazz.cast(associationTypeAsString()));
        case "associationData":
            return Optional.ofNullable(clazz.cast(associationData()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("knowledgeBaseArn", KNOWLEDGE_BASE_ARN_FIELD);
        map.put("contentId", CONTENT_ID_FIELD);
        map.put("contentArn", CONTENT_ARN_FIELD);
        map.put("contentAssociationId", CONTENT_ASSOCIATION_ID_FIELD);
        map.put("contentAssociationArn", CONTENT_ASSOCIATION_ARN_FIELD);
        map.put("associationType", ASSOCIATION_TYPE_FIELD);
        map.put("associationData", ASSOCIATION_DATA_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContentAssociationData, T> g) {
        return obj -> g.apply((ContentAssociationData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContentAssociationData> {
        /**
         * <p>
         * The identifier of the knowledge base.
         * </p>
         * 
         * @param knowledgeBaseId
         *        The identifier of the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the knowledge base.
         * </p>
         * 
         * @param knowledgeBaseArn
         *        The Amazon Resource Name (ARN) of the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseArn(String knowledgeBaseArn);

        /**
         * <p>
         * The identifier of the content.
         * </p>
         * 
         * @param contentId
         *        The identifier of the content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentId(String contentId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the content.
         * </p>
         * 
         * @param contentArn
         *        The Amazon Resource Name (ARN) of the content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentArn(String contentArn);

        /**
         * <p>
         * The identifier of the content association. Can be either the ID or the ARN. URLs cannot contain the ARN.
         * </p>
         * 
         * @param contentAssociationId
         *        The identifier of the content association. Can be either the ID or the ARN. URLs cannot contain the
         *        ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentAssociationId(String contentAssociationId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the content association.
         * </p>
         * 
         * @param contentAssociationArn
         *        The Amazon Resource Name (ARN) of the content association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentAssociationArn(String contentAssociationArn);

        /**
         * <p>
         * The type of association.
         * </p>
         * 
         * @param associationType
         *        The type of association.
         * @see ContentAssociationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentAssociationType
         */
        Builder associationType(String associationType);

        /**
         * <p>
         * The type of association.
         * </p>
         * 
         * @param associationType
         *        The type of association.
         * @see ContentAssociationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentAssociationType
         */
        Builder associationType(ContentAssociationType associationType);

        /**
         * <p>
         * The content association.
         * </p>
         * 
         * @param associationData
         *        The content association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationData(ContentAssociationContents associationData);

        /**
         * <p>
         * The content association.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContentAssociationContents.Builder}
         * avoiding the need to create one manually via {@link ContentAssociationContents#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContentAssociationContents.Builder#build()} is called immediately
         * and its result is passed to {@link #associationData(ContentAssociationContents)}.
         * 
         * @param associationData
         *        a consumer that will call methods on {@link ContentAssociationContents.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associationData(ContentAssociationContents)
         */
        default Builder associationData(Consumer<ContentAssociationContents.Builder> associationData) {
            return associationData(ContentAssociationContents.builder().applyMutation(associationData).build());
        }

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String knowledgeBaseId;

        private String knowledgeBaseArn;

        private String contentId;

        private String contentArn;

        private String contentAssociationId;

        private String contentAssociationArn;

        private String associationType;

        private ContentAssociationContents associationData;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContentAssociationData model) {
            knowledgeBaseId(model.knowledgeBaseId);
            knowledgeBaseArn(model.knowledgeBaseArn);
            contentId(model.contentId);
            contentArn(model.contentArn);
            contentAssociationId(model.contentAssociationId);
            contentAssociationArn(model.contentAssociationArn);
            associationType(model.associationType);
            associationData(model.associationData);
            tags(model.tags);
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getKnowledgeBaseArn() {
            return knowledgeBaseArn;
        }

        public final void setKnowledgeBaseArn(String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
        }

        @Override
        public final Builder knowledgeBaseArn(String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
            return this;
        }

        public final String getContentId() {
            return contentId;
        }

        public final void setContentId(String contentId) {
            this.contentId = contentId;
        }

        @Override
        public final Builder contentId(String contentId) {
            this.contentId = contentId;
            return this;
        }

        public final String getContentArn() {
            return contentArn;
        }

        public final void setContentArn(String contentArn) {
            this.contentArn = contentArn;
        }

        @Override
        public final Builder contentArn(String contentArn) {
            this.contentArn = contentArn;
            return this;
        }

        public final String getContentAssociationId() {
            return contentAssociationId;
        }

        public final void setContentAssociationId(String contentAssociationId) {
            this.contentAssociationId = contentAssociationId;
        }

        @Override
        public final Builder contentAssociationId(String contentAssociationId) {
            this.contentAssociationId = contentAssociationId;
            return this;
        }

        public final String getContentAssociationArn() {
            return contentAssociationArn;
        }

        public final void setContentAssociationArn(String contentAssociationArn) {
            this.contentAssociationArn = contentAssociationArn;
        }

        @Override
        public final Builder contentAssociationArn(String contentAssociationArn) {
            this.contentAssociationArn = contentAssociationArn;
            return this;
        }

        public final String getAssociationType() {
            return associationType;
        }

        public final void setAssociationType(String associationType) {
            this.associationType = associationType;
        }

        @Override
        public final Builder associationType(String associationType) {
            this.associationType = associationType;
            return this;
        }

        @Override
        public final Builder associationType(ContentAssociationType associationType) {
            this.associationType(associationType == null ? null : associationType.toString());
            return this;
        }

        public final ContentAssociationContents.Builder getAssociationData() {
            return associationData != null ? associationData.toBuilder() : null;
        }

        public final void setAssociationData(ContentAssociationContents.BuilderImpl associationData) {
            this.associationData = associationData != null ? associationData.build() : null;
        }

        @Override
        public final Builder associationData(ContentAssociationContents associationData) {
            this.associationData = associationData;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public ContentAssociationData build() {
            return new ContentAssociationData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
