/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAiAgentRequest extends QConnectRequest implements
        ToCopyableBuilder<CreateAiAgentRequest.Builder, CreateAiAgentRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateAiAgentRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistantId").getter(getter(CreateAiAgentRequest::assistantId)).setter(setter(Builder::assistantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assistantId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateAiAgentRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(CreateAiAgentRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<AIAgentConfiguration> CONFIGURATION_FIELD = SdkField
            .<AIAgentConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(CreateAiAgentRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(AIAgentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<String> VISIBILITY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("visibilityStatus").getter(getter(CreateAiAgentRequest::visibilityStatusAsString))
            .setter(setter(Builder::visibilityStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("visibilityStatus").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateAiAgentRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateAiAgentRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            ASSISTANT_ID_FIELD, NAME_FIELD, TYPE_FIELD, CONFIGURATION_FIELD, VISIBILITY_STATUS_FIELD, TAGS_FIELD,
            DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String assistantId;

    private final String name;

    private final String type;

    private final AIAgentConfiguration configuration;

    private final String visibilityStatus;

    private final Map<String, String> tags;

    private final String description;

    private CreateAiAgentRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.assistantId = builder.assistantId;
        this.name = builder.name;
        this.type = builder.type;
        this.configuration = builder.configuration;
        this.visibilityStatus = builder.visibilityStatus;
        this.tags = builder.tags;
        this.description = builder.description;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     * href="http://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>..
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see
     *         <a href="http://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries
     *         safe with idempotent APIs</a>..
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the
     * ARN.
     * </p>
     * 
     * @return The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain
     *         the ARN.
     */
    public final String assistantId() {
        return assistantId;
    }

    /**
     * <p>
     * The name of the AI Agent.
     * </p>
     * 
     * @return The name of the AI Agent.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of the AI Agent.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AIAgentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the AI Agent.
     * @see AIAgentType
     */
    public final AIAgentType type() {
        return AIAgentType.fromValue(type);
    }

    /**
     * <p>
     * The type of the AI Agent.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AIAgentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the AI Agent.
     * @see AIAgentType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The configuration of the AI Agent.
     * </p>
     * 
     * @return The configuration of the AI Agent.
     */
    public final AIAgentConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * The visibility status of the AI Agent.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibilityStatus}
     * will return {@link VisibilityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #visibilityStatusAsString}.
     * </p>
     * 
     * @return The visibility status of the AI Agent.
     * @see VisibilityStatus
     */
    public final VisibilityStatus visibilityStatus() {
        return VisibilityStatus.fromValue(visibilityStatus);
    }

    /**
     * <p>
     * The visibility status of the AI Agent.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibilityStatus}
     * will return {@link VisibilityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #visibilityStatusAsString}.
     * </p>
     * 
     * @return The visibility status of the AI Agent.
     * @see VisibilityStatus
     */
    public final String visibilityStatusAsString() {
        return visibilityStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The description of the AI Agent.
     * </p>
     * 
     * @return The description of the AI Agent.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(visibilityStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAiAgentRequest)) {
            return false;
        }
        CreateAiAgentRequest other = (CreateAiAgentRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(assistantId(), other.assistantId())
                && Objects.equals(name(), other.name()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(configuration(), other.configuration())
                && Objects.equals(visibilityStatusAsString(), other.visibilityStatusAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAiAgentRequest").add("ClientToken", clientToken()).add("AssistantId", assistantId())
                .add("Name", name()).add("Type", typeAsString()).add("Configuration", configuration())
                .add("VisibilityStatus", visibilityStatusAsString()).add("Tags", hasTags() ? tags() : null)
                .add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "assistantId":
            return Optional.ofNullable(clazz.cast(assistantId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "visibilityStatus":
            return Optional.ofNullable(clazz.cast(visibilityStatusAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("visibilityStatus", VISIBILITY_STATUS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAiAgentRequest, T> g) {
        return obj -> g.apply((CreateAiAgentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAiAgentRequest> {
        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         * provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
         * href="http://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe
         * with idempotent APIs</a>..
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         *        provided, the Amazon Web Services SDK populates this field. For more information about idempotency,
         *        see <a href="http://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
         *        retries safe with idempotent APIs</a>..
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the
         * ARN.
         * </p>
         * 
         * @param assistantId
         *        The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot
         *        contain the ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantId(String assistantId);

        /**
         * <p>
         * The name of the AI Agent.
         * </p>
         * 
         * @param name
         *        The name of the AI Agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of the AI Agent.
         * </p>
         * 
         * @param type
         *        The type of the AI Agent.
         * @see AIAgentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AIAgentType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the AI Agent.
         * </p>
         * 
         * @param type
         *        The type of the AI Agent.
         * @see AIAgentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AIAgentType
         */
        Builder type(AIAgentType type);

        /**
         * <p>
         * The configuration of the AI Agent.
         * </p>
         * 
         * @param configuration
         *        The configuration of the AI Agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(AIAgentConfiguration configuration);

        /**
         * <p>
         * The configuration of the AI Agent.
         * </p>
         * This is a convenience method that creates an instance of the {@link AIAgentConfiguration.Builder} avoiding
         * the need to create one manually via {@link AIAgentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AIAgentConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #configuration(AIAgentConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link AIAgentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(AIAgentConfiguration)
         */
        default Builder configuration(Consumer<AIAgentConfiguration.Builder> configuration) {
            return configuration(AIAgentConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * The visibility status of the AI Agent.
         * </p>
         * 
         * @param visibilityStatus
         *        The visibility status of the AI Agent.
         * @see VisibilityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VisibilityStatus
         */
        Builder visibilityStatus(String visibilityStatus);

        /**
         * <p>
         * The visibility status of the AI Agent.
         * </p>
         * 
         * @param visibilityStatus
         *        The visibility status of the AI Agent.
         * @see VisibilityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VisibilityStatus
         */
        Builder visibilityStatus(VisibilityStatus visibilityStatus);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The description of the AI Agent.
         * </p>
         * 
         * @param description
         *        The description of the AI Agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QConnectRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String assistantId;

        private String name;

        private String type;

        private AIAgentConfiguration configuration;

        private String visibilityStatus;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAiAgentRequest model) {
            super(model);
            clientToken(model.clientToken);
            assistantId(model.assistantId);
            name(model.name);
            type(model.type);
            configuration(model.configuration);
            visibilityStatus(model.visibilityStatus);
            tags(model.tags);
            description(model.description);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getAssistantId() {
            return assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AIAgentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final AIAgentConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(AIAgentConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(AIAgentConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getVisibilityStatus() {
            return visibilityStatus;
        }

        public final void setVisibilityStatus(String visibilityStatus) {
            this.visibilityStatus = visibilityStatus;
        }

        @Override
        public final Builder visibilityStatus(String visibilityStatus) {
            this.visibilityStatus = visibilityStatus;
            return this;
        }

        @Override
        public final Builder visibilityStatus(VisibilityStatus visibilityStatus) {
            this.visibilityStatus(visibilityStatus == null ? null : visibilityStatus.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAiAgentRequest build() {
            return new CreateAiAgentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
