/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Reference data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataReference implements SdkPojo, Serializable, ToCopyableBuilder<DataReference.Builder, DataReference> {
    private static final SdkField<ContentReference> CONTENT_REFERENCE_FIELD = SdkField
            .<ContentReference> builder(MarshallingType.SDK_POJO).memberName("contentReference")
            .getter(getter(DataReference::contentReference)).setter(setter(Builder::contentReference))
            .constructor(ContentReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentReference").build()).build();

    private static final SdkField<GenerativeReference> GENERATIVE_REFERENCE_FIELD = SdkField
            .<GenerativeReference> builder(MarshallingType.SDK_POJO).memberName("generativeReference")
            .getter(getter(DataReference::generativeReference)).setter(setter(Builder::generativeReference))
            .constructor(GenerativeReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generativeReference").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_REFERENCE_FIELD,
            GENERATIVE_REFERENCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ContentReference contentReference;

    private final GenerativeReference generativeReference;

    private final Type type;

    private DataReference(BuilderImpl builder) {
        this.contentReference = builder.contentReference;
        this.generativeReference = builder.generativeReference;
        this.type = builder.type;
    }

    /**
     * Returns the value of the ContentReference property for this object.
     * 
     * @return The value of the ContentReference property for this object.
     */
    public final ContentReference contentReference() {
        return contentReference;
    }

    /**
     * <p>
     * Reference information about the generative content.
     * </p>
     * 
     * @return Reference information about the generative content.
     */
    public final GenerativeReference generativeReference() {
        return generativeReference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contentReference());
        hashCode = 31 * hashCode + Objects.hashCode(generativeReference());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataReference)) {
            return false;
        }
        DataReference other = (DataReference) obj;
        return Objects.equals(contentReference(), other.contentReference())
                && Objects.equals(generativeReference(), other.generativeReference());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataReference").add("ContentReference", contentReference())
                .add("GenerativeReference", generativeReference()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contentReference":
            return Optional.ofNullable(clazz.cast(contentReference()));
        case "generativeReference":
            return Optional.ofNullable(clazz.cast(generativeReference()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #contentReference()} initialized to the given value.
     *
     * Sets the value of the ContentReference property for this object.
     *
     * @param contentReference
     *        The new value for the ContentReference property for this object.
     */
    public static DataReference fromContentReference(ContentReference contentReference) {
        return builder().contentReference(contentReference).build();
    }

    /**
     * Create an instance of this class with {@link #contentReference()} initialized to the given value.
     *
     * Sets the value of the ContentReference property for this object.
     *
     * @param contentReference
     *        The new value for the ContentReference property for this object.
     */
    public static DataReference fromContentReference(Consumer<ContentReference.Builder> contentReference) {
        ContentReference.Builder builder = ContentReference.builder();
        contentReference.accept(builder);
        return fromContentReference(builder.build());
    }

    /**
     * Create an instance of this class with {@link #generativeReference()} initialized to the given value.
     *
     * <p>
     * Reference information about the generative content.
     * </p>
     * 
     * @param generativeReference
     *        Reference information about the generative content.
     */
    public static DataReference fromGenerativeReference(GenerativeReference generativeReference) {
        return builder().generativeReference(generativeReference).build();
    }

    /**
     * Create an instance of this class with {@link #generativeReference()} initialized to the given value.
     *
     * <p>
     * Reference information about the generative content.
     * </p>
     * 
     * @param generativeReference
     *        Reference information about the generative content.
     */
    public static DataReference fromGenerativeReference(Consumer<GenerativeReference.Builder> generativeReference) {
        GenerativeReference.Builder builder = GenerativeReference.builder();
        generativeReference.accept(builder);
        return fromGenerativeReference(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("contentReference", CONTENT_REFERENCE_FIELD);
        map.put("generativeReference", GENERATIVE_REFERENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataReference, T> g) {
        return obj -> g.apply((DataReference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataReference> {
        /**
         * Sets the value of the ContentReference property for this object.
         *
         * @param contentReference
         *        The new value for the ContentReference property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentReference(ContentReference contentReference);

        /**
         * Sets the value of the ContentReference property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ContentReference.Builder} avoiding the
         * need to create one manually via {@link ContentReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContentReference.Builder#build()} is called immediately and its
         * result is passed to {@link #contentReference(ContentReference)}.
         * 
         * @param contentReference
         *        a consumer that will call methods on {@link ContentReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contentReference(ContentReference)
         */
        default Builder contentReference(Consumer<ContentReference.Builder> contentReference) {
            return contentReference(ContentReference.builder().applyMutation(contentReference).build());
        }

        /**
         * <p>
         * Reference information about the generative content.
         * </p>
         * 
         * @param generativeReference
         *        Reference information about the generative content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generativeReference(GenerativeReference generativeReference);

        /**
         * <p>
         * Reference information about the generative content.
         * </p>
         * This is a convenience method that creates an instance of the {@link GenerativeReference.Builder} avoiding the
         * need to create one manually via {@link GenerativeReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GenerativeReference.Builder#build()} is called immediately and
         * its result is passed to {@link #generativeReference(GenerativeReference)}.
         * 
         * @param generativeReference
         *        a consumer that will call methods on {@link GenerativeReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #generativeReference(GenerativeReference)
         */
        default Builder generativeReference(Consumer<GenerativeReference.Builder> generativeReference) {
            return generativeReference(GenerativeReference.builder().applyMutation(generativeReference).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ContentReference contentReference;

        private GenerativeReference generativeReference;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DataReference model) {
            contentReference(model.contentReference);
            generativeReference(model.generativeReference);
        }

        public final ContentReference.Builder getContentReference() {
            return contentReference != null ? contentReference.toBuilder() : null;
        }

        public final void setContentReference(ContentReference.BuilderImpl contentReference) {
            Object oldValue = this.contentReference;
            this.contentReference = contentReference != null ? contentReference.build() : null;
            handleUnionValueChange(Type.CONTENT_REFERENCE, oldValue, this.contentReference);
        }

        @Override
        public final Builder contentReference(ContentReference contentReference) {
            Object oldValue = this.contentReference;
            this.contentReference = contentReference;
            handleUnionValueChange(Type.CONTENT_REFERENCE, oldValue, this.contentReference);
            return this;
        }

        public final GenerativeReference.Builder getGenerativeReference() {
            return generativeReference != null ? generativeReference.toBuilder() : null;
        }

        public final void setGenerativeReference(GenerativeReference.BuilderImpl generativeReference) {
            Object oldValue = this.generativeReference;
            this.generativeReference = generativeReference != null ? generativeReference.build() : null;
            handleUnionValueChange(Type.GENERATIVE_REFERENCE, oldValue, this.generativeReference);
        }

        @Override
        public final Builder generativeReference(GenerativeReference generativeReference) {
            Object oldValue = this.generativeReference;
            this.generativeReference = generativeReference;
            handleUnionValueChange(Type.GENERATIVE_REFERENCE, oldValue, this.generativeReference);
            return this;
        }

        @Override
        public DataReference build() {
            return new DataReference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see DataReference#type()
     */
    public enum Type {
        CONTENT_REFERENCE,

        GENERATIVE_REFERENCE,

        UNKNOWN_TO_SDK_VERSION
    }
}
