/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetNextMessageResponse extends QConnectResponse implements
        ToCopyableBuilder<GetNextMessageResponse.Builder, GetNextMessageResponse> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(GetNextMessageResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<MessageOutput> RESPONSE_FIELD = SdkField.<MessageOutput> builder(MarshallingType.SDK_POJO)
            .memberName("response").getter(getter(GetNextMessageResponse::response)).setter(setter(Builder::response))
            .constructor(MessageOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("response").build()).build();

    private static final SdkField<String> REQUEST_MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("requestMessageId").getter(getter(GetNextMessageResponse::requestMessageId))
            .setter(setter(Builder::requestMessageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestMessageId").build()).build();

    private static final SdkField<ConversationState> CONVERSATION_STATE_FIELD = SdkField
            .<ConversationState> builder(MarshallingType.SDK_POJO).memberName("conversationState")
            .getter(getter(GetNextMessageResponse::conversationState)).setter(setter(Builder::conversationState))
            .constructor(ConversationState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationState").build()).build();

    private static final SdkField<String> NEXT_MESSAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextMessageToken").getter(getter(GetNextMessageResponse::nextMessageToken))
            .setter(setter(Builder::nextMessageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextMessageToken").build()).build();

    private static final SdkField<List<RuntimeSessionData>> CONVERSATION_SESSION_DATA_FIELD = SdkField
            .<List<RuntimeSessionData>> builder(MarshallingType.LIST)
            .memberName("conversationSessionData")
            .getter(getter(GetNextMessageResponse::conversationSessionData))
            .setter(setter(Builder::conversationSessionData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationSessionData").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RuntimeSessionData> builder(MarshallingType.SDK_POJO)
                                            .constructor(RuntimeSessionData::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, RESPONSE_FIELD,
            REQUEST_MESSAGE_ID_FIELD, CONVERSATION_STATE_FIELD, NEXT_MESSAGE_TOKEN_FIELD, CONVERSATION_SESSION_DATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String type;

    private final MessageOutput response;

    private final String requestMessageId;

    private final ConversationState conversationState;

    private final String nextMessageToken;

    private final List<RuntimeSessionData> conversationSessionData;

    private GetNextMessageResponse(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
        this.response = builder.response;
        this.requestMessageId = builder.requestMessageId;
        this.conversationState = builder.conversationState;
        this.nextMessageToken = builder.nextMessageToken;
        this.conversationSessionData = builder.conversationSessionData;
    }

    /**
     * <p>
     * The type of message response.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of message response.
     * @see MessageType
     */
    public final MessageType type() {
        return MessageType.fromValue(type);
    }

    /**
     * <p>
     * The type of message response.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of message response.
     * @see MessageType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The message response to the requested message.
     * </p>
     * 
     * @return The message response to the requested message.
     */
    public final MessageOutput response() {
        return response;
    }

    /**
     * <p>
     * The identifier of the submitted message.
     * </p>
     * 
     * @return The identifier of the submitted message.
     */
    public final String requestMessageId() {
        return requestMessageId;
    }

    /**
     * <p>
     * The state of current conversation.
     * </p>
     * 
     * @return The state of current conversation.
     */
    public final ConversationState conversationState() {
        return conversationState;
    }

    /**
     * <p>
     * The token for the next message.
     * </p>
     * 
     * @return The token for the next message.
     */
    public final String nextMessageToken() {
        return nextMessageToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConversationSessionData property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasConversationSessionData() {
        return conversationSessionData != null && !(conversationSessionData instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The conversation data stored on an Amazon Q in Connect Session.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConversationSessionData} method.
     * </p>
     * 
     * @return The conversation data stored on an Amazon Q in Connect Session.
     */
    public final List<RuntimeSessionData> conversationSessionData() {
        return conversationSessionData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(response());
        hashCode = 31 * hashCode + Objects.hashCode(requestMessageId());
        hashCode = 31 * hashCode + Objects.hashCode(conversationState());
        hashCode = 31 * hashCode + Objects.hashCode(nextMessageToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasConversationSessionData() ? conversationSessionData() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetNextMessageResponse)) {
            return false;
        }
        GetNextMessageResponse other = (GetNextMessageResponse) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(response(), other.response())
                && Objects.equals(requestMessageId(), other.requestMessageId())
                && Objects.equals(conversationState(), other.conversationState())
                && Objects.equals(nextMessageToken(), other.nextMessageToken())
                && hasConversationSessionData() == other.hasConversationSessionData()
                && Objects.equals(conversationSessionData(), other.conversationSessionData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetNextMessageResponse").add("Type", typeAsString()).add("Response", response())
                .add("RequestMessageId", requestMessageId()).add("ConversationState", conversationState())
                .add("NextMessageToken", nextMessageToken())
                .add("ConversationSessionData", hasConversationSessionData() ? conversationSessionData() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "response":
            return Optional.ofNullable(clazz.cast(response()));
        case "requestMessageId":
            return Optional.ofNullable(clazz.cast(requestMessageId()));
        case "conversationState":
            return Optional.ofNullable(clazz.cast(conversationState()));
        case "nextMessageToken":
            return Optional.ofNullable(clazz.cast(nextMessageToken()));
        case "conversationSessionData":
            return Optional.ofNullable(clazz.cast(conversationSessionData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("response", RESPONSE_FIELD);
        map.put("requestMessageId", REQUEST_MESSAGE_ID_FIELD);
        map.put("conversationState", CONVERSATION_STATE_FIELD);
        map.put("nextMessageToken", NEXT_MESSAGE_TOKEN_FIELD);
        map.put("conversationSessionData", CONVERSATION_SESSION_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetNextMessageResponse, T> g) {
        return obj -> g.apply((GetNextMessageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetNextMessageResponse> {
        /**
         * <p>
         * The type of message response.
         * </p>
         * 
         * @param type
         *        The type of message response.
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of message response.
         * </p>
         * 
         * @param type
         *        The type of message response.
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder type(MessageType type);

        /**
         * <p>
         * The message response to the requested message.
         * </p>
         * 
         * @param response
         *        The message response to the requested message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder response(MessageOutput response);

        /**
         * <p>
         * The message response to the requested message.
         * </p>
         * This is a convenience method that creates an instance of the {@link MessageOutput.Builder} avoiding the need
         * to create one manually via {@link MessageOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MessageOutput.Builder#build()} is called immediately and its
         * result is passed to {@link #response(MessageOutput)}.
         * 
         * @param response
         *        a consumer that will call methods on {@link MessageOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #response(MessageOutput)
         */
        default Builder response(Consumer<MessageOutput.Builder> response) {
            return response(MessageOutput.builder().applyMutation(response).build());
        }

        /**
         * <p>
         * The identifier of the submitted message.
         * </p>
         * 
         * @param requestMessageId
         *        The identifier of the submitted message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestMessageId(String requestMessageId);

        /**
         * <p>
         * The state of current conversation.
         * </p>
         * 
         * @param conversationState
         *        The state of current conversation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversationState(ConversationState conversationState);

        /**
         * <p>
         * The state of current conversation.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConversationState.Builder} avoiding the
         * need to create one manually via {@link ConversationState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConversationState.Builder#build()} is called immediately and its
         * result is passed to {@link #conversationState(ConversationState)}.
         * 
         * @param conversationState
         *        a consumer that will call methods on {@link ConversationState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conversationState(ConversationState)
         */
        default Builder conversationState(Consumer<ConversationState.Builder> conversationState) {
            return conversationState(ConversationState.builder().applyMutation(conversationState).build());
        }

        /**
         * <p>
         * The token for the next message.
         * </p>
         * 
         * @param nextMessageToken
         *        The token for the next message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMessageToken(String nextMessageToken);

        /**
         * <p>
         * The conversation data stored on an Amazon Q in Connect Session.
         * </p>
         * 
         * @param conversationSessionData
         *        The conversation data stored on an Amazon Q in Connect Session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversationSessionData(Collection<RuntimeSessionData> conversationSessionData);

        /**
         * <p>
         * The conversation data stored on an Amazon Q in Connect Session.
         * </p>
         * 
         * @param conversationSessionData
         *        The conversation data stored on an Amazon Q in Connect Session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversationSessionData(RuntimeSessionData... conversationSessionData);

        /**
         * <p>
         * The conversation data stored on an Amazon Q in Connect Session.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.RuntimeSessionData.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.qconnect.model.RuntimeSessionData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.RuntimeSessionData.Builder#build()} is called
         * immediately and its result is passed to {@link #conversationSessionData(List<RuntimeSessionData>)}.
         * 
         * @param conversationSessionData
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.RuntimeSessionData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conversationSessionData(java.util.Collection<RuntimeSessionData>)
         */
        Builder conversationSessionData(Consumer<RuntimeSessionData.Builder>... conversationSessionData);
    }

    static final class BuilderImpl extends QConnectResponse.BuilderImpl implements Builder {
        private String type;

        private MessageOutput response;

        private String requestMessageId;

        private ConversationState conversationState;

        private String nextMessageToken;

        private List<RuntimeSessionData> conversationSessionData = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetNextMessageResponse model) {
            super(model);
            type(model.type);
            response(model.response);
            requestMessageId(model.requestMessageId);
            conversationState(model.conversationState);
            nextMessageToken(model.nextMessageToken);
            conversationSessionData(model.conversationSessionData);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MessageType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final MessageOutput.Builder getResponse() {
            return response != null ? response.toBuilder() : null;
        }

        public final void setResponse(MessageOutput.BuilderImpl response) {
            this.response = response != null ? response.build() : null;
        }

        @Override
        public final Builder response(MessageOutput response) {
            this.response = response;
            return this;
        }

        public final String getRequestMessageId() {
            return requestMessageId;
        }

        public final void setRequestMessageId(String requestMessageId) {
            this.requestMessageId = requestMessageId;
        }

        @Override
        public final Builder requestMessageId(String requestMessageId) {
            this.requestMessageId = requestMessageId;
            return this;
        }

        public final ConversationState.Builder getConversationState() {
            return conversationState != null ? conversationState.toBuilder() : null;
        }

        public final void setConversationState(ConversationState.BuilderImpl conversationState) {
            this.conversationState = conversationState != null ? conversationState.build() : null;
        }

        @Override
        public final Builder conversationState(ConversationState conversationState) {
            this.conversationState = conversationState;
            return this;
        }

        public final String getNextMessageToken() {
            return nextMessageToken;
        }

        public final void setNextMessageToken(String nextMessageToken) {
            this.nextMessageToken = nextMessageToken;
        }

        @Override
        public final Builder nextMessageToken(String nextMessageToken) {
            this.nextMessageToken = nextMessageToken;
            return this;
        }

        public final List<RuntimeSessionData.Builder> getConversationSessionData() {
            List<RuntimeSessionData.Builder> result = RuntimeSessionDataListCopier.copyToBuilder(this.conversationSessionData);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConversationSessionData(Collection<RuntimeSessionData.BuilderImpl> conversationSessionData) {
            this.conversationSessionData = RuntimeSessionDataListCopier.copyFromBuilder(conversationSessionData);
        }

        @Override
        public final Builder conversationSessionData(Collection<RuntimeSessionData> conversationSessionData) {
            this.conversationSessionData = RuntimeSessionDataListCopier.copy(conversationSessionData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conversationSessionData(RuntimeSessionData... conversationSessionData) {
            conversationSessionData(Arrays.asList(conversationSessionData));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conversationSessionData(Consumer<RuntimeSessionData.Builder>... conversationSessionData) {
            conversationSessionData(Stream.of(conversationSessionData)
                    .map(c -> RuntimeSessionData.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetNextMessageResponse build() {
            return new GetNextMessageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
