/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRecommendationsRequest extends QConnectRequest implements
        ToCopyableBuilder<GetRecommendationsRequest.Builder, GetRecommendationsRequest> {
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistantId").getter(getter(GetRecommendationsRequest::assistantId))
            .setter(setter(Builder::assistantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assistantId").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(GetRecommendationsRequest::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sessionId").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(GetRecommendationsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<Integer> WAIT_TIME_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("waitTimeSeconds").getter(getter(GetRecommendationsRequest::waitTimeSeconds))
            .setter(setter(Builder::waitTimeSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("waitTimeSeconds").build())
            .build();

    private static final SdkField<String> NEXT_CHUNK_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextChunkToken").getter(getter(GetRecommendationsRequest::nextChunkToken))
            .setter(setter(Builder::nextChunkToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextChunkToken").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSISTANT_ID_FIELD,
            SESSION_ID_FIELD, MAX_RESULTS_FIELD, WAIT_TIME_SECONDS_FIELD, NEXT_CHUNK_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String assistantId;

    private final String sessionId;

    private final Integer maxResults;

    private final Integer waitTimeSeconds;

    private final String nextChunkToken;

    private GetRecommendationsRequest(BuilderImpl builder) {
        super(builder);
        this.assistantId = builder.assistantId;
        this.sessionId = builder.sessionId;
        this.maxResults = builder.maxResults;
        this.waitTimeSeconds = builder.waitTimeSeconds;
        this.nextChunkToken = builder.nextChunkToken;
    }

    /**
     * <p>
     * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the
     * ARN.
     * </p>
     * 
     * @return The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain
     *         the ARN.
     */
    public final String assistantId() {
        return assistantId;
    }

    /**
     * <p>
     * The identifier of the session. Can be either the ID or the ARN. URLs cannot contain the ARN.
     * </p>
     * 
     * @return The identifier of the session. Can be either the ID or the ARN. URLs cannot contain the ARN.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The maximum number of results to return per page.
     * </p>
     * 
     * @return The maximum number of results to return per page.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The duration (in seconds) for which the call waits for a recommendation to be made available before returning. If
     * a recommendation is available, the call returns sooner than <code>WaitTimeSeconds</code>. If no messages are
     * available and the wait time expires, the call returns successfully with an empty list.
     * </p>
     * 
     * @return The duration (in seconds) for which the call waits for a recommendation to be made available before
     *         returning. If a recommendation is available, the call returns sooner than <code>WaitTimeSeconds</code>.
     *         If no messages are available and the wait time expires, the call returns successfully with an empty list.
     */
    public final Integer waitTimeSeconds() {
        return waitTimeSeconds;
    }

    /**
     * <p>
     * The token for the next set of chunks. Use the value returned in the previous response in the next request to
     * retrieve the next set of chunks.
     * </p>
     * 
     * @return The token for the next set of chunks. Use the value returned in the previous response in the next request
     *         to retrieve the next set of chunks.
     */
    public final String nextChunkToken() {
        return nextChunkToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(waitTimeSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(nextChunkToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecommendationsRequest)) {
            return false;
        }
        GetRecommendationsRequest other = (GetRecommendationsRequest) obj;
        return Objects.equals(assistantId(), other.assistantId()) && Objects.equals(sessionId(), other.sessionId())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(waitTimeSeconds(), other.waitTimeSeconds())
                && Objects.equals(nextChunkToken(), other.nextChunkToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRecommendationsRequest").add("AssistantId", assistantId()).add("SessionId", sessionId())
                .add("MaxResults", maxResults()).add("WaitTimeSeconds", waitTimeSeconds())
                .add("NextChunkToken", nextChunkToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assistantId":
            return Optional.ofNullable(clazz.cast(assistantId()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "waitTimeSeconds":
            return Optional.ofNullable(clazz.cast(waitTimeSeconds()));
        case "nextChunkToken":
            return Optional.ofNullable(clazz.cast(nextChunkToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("waitTimeSeconds", WAIT_TIME_SECONDS_FIELD);
        map.put("nextChunkToken", NEXT_CHUNK_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRecommendationsRequest, T> g) {
        return obj -> g.apply((GetRecommendationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetRecommendationsRequest> {
        /**
         * <p>
         * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the
         * ARN.
         * </p>
         * 
         * @param assistantId
         *        The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot
         *        contain the ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantId(String assistantId);

        /**
         * <p>
         * The identifier of the session. Can be either the ID or the ARN. URLs cannot contain the ARN.
         * </p>
         * 
         * @param sessionId
         *        The identifier of the session. Can be either the ID or the ARN. URLs cannot contain the ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The maximum number of results to return per page.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return per page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The duration (in seconds) for which the call waits for a recommendation to be made available before
         * returning. If a recommendation is available, the call returns sooner than <code>WaitTimeSeconds</code>. If no
         * messages are available and the wait time expires, the call returns successfully with an empty list.
         * </p>
         * 
         * @param waitTimeSeconds
         *        The duration (in seconds) for which the call waits for a recommendation to be made available before
         *        returning. If a recommendation is available, the call returns sooner than <code>WaitTimeSeconds</code>
         *        . If no messages are available and the wait time expires, the call returns successfully with an empty
         *        list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waitTimeSeconds(Integer waitTimeSeconds);

        /**
         * <p>
         * The token for the next set of chunks. Use the value returned in the previous response in the next request to
         * retrieve the next set of chunks.
         * </p>
         * 
         * @param nextChunkToken
         *        The token for the next set of chunks. Use the value returned in the previous response in the next
         *        request to retrieve the next set of chunks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextChunkToken(String nextChunkToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QConnectRequest.BuilderImpl implements Builder {
        private String assistantId;

        private String sessionId;

        private Integer maxResults;

        private Integer waitTimeSeconds;

        private String nextChunkToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecommendationsRequest model) {
            super(model);
            assistantId(model.assistantId);
            sessionId(model.sessionId);
            maxResults(model.maxResults);
            waitTimeSeconds(model.waitTimeSeconds);
            nextChunkToken(model.nextChunkToken);
        }

        public final String getAssistantId() {
            return assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Integer getWaitTimeSeconds() {
            return waitTimeSeconds;
        }

        public final void setWaitTimeSeconds(Integer waitTimeSeconds) {
            this.waitTimeSeconds = waitTimeSeconds;
        }

        @Override
        public final Builder waitTimeSeconds(Integer waitTimeSeconds) {
            this.waitTimeSeconds = waitTimeSeconds;
            return this;
        }

        public final String getNextChunkToken() {
            return nextChunkToken;
        }

        public final void setNextChunkToken(String nextChunkToken) {
            this.nextChunkToken = nextChunkToken;
        }

        @Override
        public final Builder nextChunkToken(String nextChunkToken) {
            this.nextChunkToken = nextChunkToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRecommendationsRequest build() {
            return new GetRecommendationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
