/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the detected intent.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IntentDetectedDataDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<IntentDetectedDataDetails.Builder, IntentDetectedDataDetails> {
    private static final SdkField<String> INTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("intent")
            .getter(getter(IntentDetectedDataDetails::intent)).setter(setter(Builder::intent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intent").build()).build();

    private static final SdkField<String> INTENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("intentId").getter(getter(IntentDetectedDataDetails::intentId)).setter(setter(Builder::intentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(INTENT_FIELD, INTENT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String intent;

    private final String intentId;

    private IntentDetectedDataDetails(BuilderImpl builder) {
        this.intent = builder.intent;
        this.intentId = builder.intentId;
    }

    /**
     * <p>
     * The detected intent.
     * </p>
     * 
     * @return The detected intent.
     */
    public final String intent() {
        return intent;
    }

    /**
     * <p>
     * The identifier of the detected intent.
     * </p>
     * 
     * @return The identifier of the detected intent.
     */
    public final String intentId() {
        return intentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(intent());
        hashCode = 31 * hashCode + Objects.hashCode(intentId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntentDetectedDataDetails)) {
            return false;
        }
        IntentDetectedDataDetails other = (IntentDetectedDataDetails) obj;
        return Objects.equals(intent(), other.intent()) && Objects.equals(intentId(), other.intentId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IntentDetectedDataDetails")
                .add("Intent", intent() == null ? null : "*** Sensitive Data Redacted ***").add("IntentId", intentId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "intent":
            return Optional.ofNullable(clazz.cast(intent()));
        case "intentId":
            return Optional.ofNullable(clazz.cast(intentId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("intent", INTENT_FIELD);
        map.put("intentId", INTENT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IntentDetectedDataDetails, T> g) {
        return obj -> g.apply((IntentDetectedDataDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IntentDetectedDataDetails> {
        /**
         * <p>
         * The detected intent.
         * </p>
         * 
         * @param intent
         *        The detected intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intent(String intent);

        /**
         * <p>
         * The identifier of the detected intent.
         * </p>
         * 
         * @param intentId
         *        The identifier of the detected intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentId(String intentId);
    }

    static final class BuilderImpl implements Builder {
        private String intent;

        private String intentId;

        private BuilderImpl() {
        }

        private BuilderImpl(IntentDetectedDataDetails model) {
            intent(model.intent);
            intentId(model.intentId);
        }

        public final String getIntent() {
            return intent;
        }

        public final void setIntent(String intent) {
            this.intent = intent;
        }

        @Override
        public final Builder intent(String intent) {
            this.intent = intent;
            return this;
        }

        public final String getIntentId() {
            return intentId;
        }

        public final void setIntentId(String intentId) {
            this.intentId = intentId;
        }

        @Override
        public final Builder intentId(String intentId) {
            this.intentId = intentId;
            return this;
        }

        @Override
        public IntentDetectedDataDetails build() {
            return new IntentDetectedDataDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
